# Name :          Spiral Stair 1.0
# Description :   self-explanatory
# Author :        RW
# Usage :         select 2 curves - stairs will be
#                 created between them
# Date :          02.Aug.2004
# Type :		tool
# History:
#			1.0 (02.Aug.2004) - first version

require 'sketchup.rb'

def spiral_stair
#	CHECK THE SELECTIONS
	model = Sketchup.active_model
	entities = model.active_entities
	ss = model.selection
	cv=[]
	0.upto(ss.length-1) do |e|
		if ss[e].curve
			 cv.push(ss[e].curve)
		end
	end
	cv.uniq!
	if (not cv.length == 2)
		UI.messagebox("Please select only 2 curves")
		return nil
	end
	curve1=cv[0]
	curve2=cv[1]

	curve1q = curve1.vertices.length
	curve2q = curve2.vertices.length
	lines = []
	hlines = []

	model.start_operation "Stitcher"
	0.upto(curve1q-2) do |a|
		# c = (a * b).to_i
		pt1=curve1.vertices[0].position
		pt2=curve2.vertices[0].position
		pt3=curve1.vertices[1].position
		pt4=curve2.vertices[1].position
		pt5=Geom::Point3d.new(pt1[0],pt1[1],pt3[2])
		pt6=Geom::Point3d.new(pt2[0],pt2[1],pt3[2])
		line1=entities.add_line(pt1,pt2)
		line2=entities.add_line(pt2,pt3)
		line3=entities.add_line(pt3,pt4)
		line4=entities.add_line(pt1,pt5)
		line5=entities.add_line(pt2,pt6)
		line6=entities.add_line(pt5,pt6)
		line7=entities.add_line(pt5,pt3)
		line8=entities.add_line(pt6,pt4)
		hlines[lines.length] = line1
		lines[lines.length] = line2
		hlines[lines.length] = line3
		hlines[lines.length] = line4
		hlines[lines.length] = line5
		line7.find_faces
		line8.find_faces
	end
	0.upto(lines.length-1) do |a|
		lines[a].find_faces
		lines[a].smooth=true
		lines[a].soft=true
	end
	0.upto(hlines.length-1) do |a|
		hlines[a].find_faces
	end
		
	model.commit_operation
end

#if( not file_loaded?("spiralstair.rb") )
#    add_separator_to_menu("Plugins")
    
    # To add an item to a menu, you identify the menu, and then
    # provide a title to display and a block to execute.  In this case,
    # the block just calls the create_box function
#    UI.menu("Plugins").add_item("Spiral Stair") { spiral_stair }

#end

#-----------------------------------------------------------------------------
file_loaded("spiralstair.rb")
