# Name:           StairConcTool
# Author :        Tim
# Description:    Create a Concrete Straight stair or a U shaped Concrete Stair with landing 
# Usage:          Change dialog box settings or accept defaults, click OK
#                 enter Next Floor Height to create new sets of stairs 
# Type:           Tool
# Date:           2004,11,07
# Revised:        2004,12,07 added 90 direction change left and right after landing,
#                 finally found out how to reverse the handrail for the straight stair
#--------------------------------------------------------------------------
require 'sketchup.rb'

def stairconc

    #Set default stair settings
    @ccwidth = 90.cm if not @ccwidth
    @ccheight = 270.cm if not @ccheight
    @ccriser = 16 if not @ccriser
    @cctread = 30.cm if not @cctread
    @ccn = 3.cm if not @ccn
    @ccxh = 0.cm if not @ccxh 
    #Handrail height
    @cchand = 100.cm
    #Handrail spacing from edge
    @cchands = 7.cm
       
    # Dialog box
    prompts = ["Stair Width", "Floor/Floor Height ", "No. Risers", "Tread Width", "Nosing", "Next Floor Height"]
    values = [@ccwidth, @ccheight, @ccriser, @cctread, @ccn, @ccxh]
    results = inputbox prompts, values, "Stair Properties"
    
    return if not results
    @ccwidth, @ccheight, @ccriser, @cctread, @ccn, @ccxh = results
    
    @ccincrt=@ccheight/@ccriser
 #--------------------------------------------------------------------------
    model=Sketchup.active_model
    
    i=0
    j=0
    @pt=[]
    @pt[j]=[0, 0, @ccxh]
    xx=0
    yy=0
    zz=@ccxh

    while i < @ccriser
       i=i+1
       j=j+1
       xx=xx-@ccn  
       zz=zz+@ccincrt 
       @pt[j]=[xx, yy, zz]
       j=j+1
       xx=xx+@ccn+@cctread
       @pt[j]=[xx, yy, zz]
    end
    j=j+1
    @pt[j]=[xx, yy, zz-@ccincrt]
    j=j+1
    @pt[j]=[@cctread, 0, @ccxh]
    
    entities=model.active_entities
    group=entities.add_group
    entities=group.entities
    base=entities.add_face @pt
    base.pushpull @ccwidth
    
    #----Points required for Handrail 
    @ptw=Geom::Point3d.new(@pt[0])
    @ptu=Geom::Point3d.new(@ptw[0]+@cchands,@ptw[1]+@cchands,@ptw[2]+@ccincrt)
    @ptx=Geom::Point3d.new(@ptw[0]+@cchands,@ptw[1]+@cchands,@ptw[2]+@cchand)
    @pty=Geom::Point3d.new(@ptw[0]-@cchands+@cctread*@ccriser,@ptw[1]+@cchands,@ptw[2]+@ccincrt*@ccriser+@cchand)
    @ptz=Geom::Point3d.new(@ptw[0]-@cchands+@cctread*@ccriser,@ptw[1]+@cchands,@ptw[2]+@ccincrt*@ccriser)
    #----Do handrail
    entities=model.active_entities  
    group=entities.add_group
    entities=group.entities
    edges = entities.add_edges(@ptu, @ptx, @pty, @ptz)
    circle = entities.add_circle(@ptz, Z_AXIS, 1.cm, 16)
    base = entities.add_face(circle).reverse!
    base.followme(edges)  
    #Copy Handrail to new location @ccwidth-@cchands*2
    t=Geom::Vector3d.new(0, @ccwidth-@cchands*2, 0)
    new_group = group.copy
    new_group.move!(t)
        
#---------------------------------------------------------------------------
    view=model.active_view
    view.zoom_extents
#---------------------------------------------------------------------------    
    model.commit_operation
end
#---------------------------------------------------------------------------
def stairconcu

    Sketchup::set_status_text("<<<<<< This Program creates a Scissor Stair with a Landing >>>>>", SB_PROMPT)
    #Set default stair settings
    @suwidth= 90.cm if not @suwidth
    @suheight = 270.cm if not @suheight
    @suriser = 16 if not @suriser
    @suriserl = 8 if not @suriserl
    @sutread = 30.cm if not @sutread
    @sun = 3.cm if not @sun
    @sunxh = 0.cm if not @sunxh 
    #Handrail height
    @suhand = 100.cm
    #Handrail spacing from wall
    @suhands = 7.cm

    # Dialog box
    prompts = ["Stair Width", "Floor/Floor Height ", "No. Risers Total","No. Risers to Landing ", "Tread Width", "Nosing", "Next Floor Height"]
    values = [@suwidth, @suheight, @suriser, @suriserl, @sutread, @sun, @sunxh]
    results = inputbox prompts, values, "U shaped Stair Properties"
        
    return if not results
    @suwidth, @suheight, @suriser, @suriserl, @sutread, @sun, @sunxh = results
    
    if (@suriserl < 2)
       UI.messagebox( "Less than 2 risers is not allowed ")
    return nil
    end
    
    if (@suriserl >@suriser-2)
       UI.messagebox( "Less than 2 risers after Landing is not allowed ")
    return nil
    end
    
    @suup=@suriser-@suriserl 
    @suincr=@suheight/@suriser
#--------------------------------------------------------------------------
    model=Sketchup.active_model
    model.start_operation "Create Concrete Stair"
       
    #----Do lower stair drawing routine
    i=0
    j=0
    @all=[]
    @all[j]=[0, 0, @sunxh]
    @xx=0
    @yy=0
    @zz=@sunxh

    while i < @suriserl
       i=i+1
       j=j+1
       @xx=@xx-@sun  
       @zz=@zz+@suincr 
       @all[j]=[@xx, @yy, @zz]
       j=j+1
       @xx=@xx+@sun+@sutread
       @all[j]=[@xx, @yy, @zz]
    end
    j=j+1
    @all[j]=[@xx, @yy, @zz-@suincr]
    j=j+1
    @all[j]=[@sutread, 0, @sunxh]
    
    #----Points required for Stairto Do Landing 
    @pt1=Geom::Point3d.new(@all[0])
    @pt2=Geom::Point3d.new(@pt1[0]+@sutread,@pt1[1],@pt1[2])
    @pt3=Geom::Point3d.new(@pt1[0]+@sutread*@suriserl,@pt1[1],@pt1[2])
    @pt4=Geom::Point3d.new(@pt1[0]+@sutread*@suriserl,@pt1[1],@pt1[2]+(@suincr*@suriserl)-@suincr)
    @pt5=Geom::Point3d.new(@pt1[0]+@sutread*@suriserl,@pt1[1],@pt1[2]+@suincr*@suriserl)
    @pt5a=Geom::Point3d.new(@pt1[0]+@sutread*@suriserl,@pt1[1]-@suwidth,@pt1[2]+@suincr*@suriserl)
    #----Points required to Do Landing
    @pt6=Geom::Point3d.new(@pt1[0]+@sutread*@suriserl-@sutread,@pt1[1],@pt1[2]+@suincr*@suriserl)
    @pt7=Geom::Point3d.new(@pt1[0]+@sutread*@suriserl+@suwidth,@pt1[1]+@suwidth,@pt1[2]+@suincr*@suriserl)
    @pt8=Geom::Point3d.new(@pt1[0]+@sutread*@suriserl,@pt1[1]+@suwidth,@pt1[2]+@suincr*@suriserl)
    @pt9=Geom::Point3d.new(@pt1[0]+@sutread*@suriserl+@suwidth,@pt1[1]-@suwidth,@pt1[2]+@suincr*@suriserl)
    @pt0=Geom::Point3d.new(@pt1[0]+@sutread*@suriserl-@sutread,@pt1[1]-@suwidth,@pt1[2]+@suincr*@suriserl)
    #----Points required to Do Landing opposing options 
    @pta=Geom::Point3d.new(@pt1[0]+@sutread*@suriserl-@sutread,@pt1[1]+@suwidth,@pt1[2]+@suincr*@suriserl)
    @ptb=Geom::Point3d.new(@pt1[0]+@sutread*@suriserl+@suwidth,@pt1[1],@pt1[2]+@suincr*@suriserl)
    @ptc=Geom::Point3d.new(@pt1[0]+@sutread*@suriserl+@suwidth-@sutread,@pt1[1],@pt1[2]+@suincr*@suriserl)
    @ptd=Geom::Point3d.new(@pt1[0]+@sutread*@suriserl+@suwidth-@sutread,@pt1[1]-@suwidth,@pt1[2]+@suincr*@suriserl)
    @pte=Geom::Point3d.new(@pt1[0]-@suwidth+@sutread-(@suup*@sutread),@pt1[1],@pt1[2]+@suup*@suincr)
    @ptf=Geom::Point3d.new(@pt1[0]-@suwidth+@sutread-(@suup*@sutread),@pt1[1],@pt1[2]-@suriserl*@suincr)
    #----Points required to Do Railing
    @ptg=Geom::Point3d.new(@pt1[0],@pt1[1]-@suhands+@suwidth,@pt1[2]+@suhand)
    @pth=Geom::Point3d.new(@pt5[0],@pt5[1]-@suhands+@suwidth,@pt5[2]+@suhand) 
    @ptj=Geom::Point3d.new(@pt7[0]-@suhands,@pt7[1]-@suhands,@pt7[2]+@suhand)
    @ptk=Geom::Point3d.new(@pt9[0]-@suhands,@pt9[1]+@suhands,@pt9[2]+@suhand)
    @ptl=Geom::Point3d.new(@pt5a[0],@pt5a[1]+@suhands,@pt5a[2]+@suhand)
    @ptm=Geom::Point3d.new(@pt5a[0]-(@suup*@sutread),@pt5a[1]+@suhands,@pt5a[2]+@suup*@suincr+@suhand)
    
    entities=model.active_entities
    group=entities.add_group
    entities=group.entities
    lower_base=entities.add_face @all
    lower_base.pushpull @suwidth
   
    #----Do handrail
    entities=model.active_entities  
    group=entities.add_group
    entities=group.entities
    edges = entities.add_edges(@ptg, @pth, @ptj, @ptk, @ptl, @ptm)
    circle = entities.add_circle(@ptm, Z_AXIS, 3.cm, 16)
    base = entities.add_face(circle)
    base.followme(edges)    
                
    #----Do intermediate landing 
    entities=model.active_entities
    group=entities.add_group
    entities=group.entities
    land_base=entities.add_face(@pt0, @pt6, @pt5, @pt8, @pt7, @pt9)
    land_base.pushpull @suincr
           
    #----Do upper stair drawing routine
    i=0
    j=0
    @all=[]
    @all[j]=[0, 0, 0]
    @xx=0
    @yy=0
    @zz=0

    while i < @suriser-@suriserl
       i=i+1
       j=j+1
       @xx=@xx-@sun  
       @zz=@zz+@suincr 
       @all[j]=[@xx, @yy, @zz]
       j=j+1
       @xx=@xx+@sun+@sutread
       @all[j]=[@xx, @yy, @zz]
    end
    j=j+1
    @all[j]=[@xx, @yy, @zz-@suincr]
    j=j+1
    @all[j]=[@sutread, 0, 0]
           
    entities=model.active_entities
    group=entities.add_group
    entities=group.entities
    upper_base=entities.add_face @all
    upper_base.pushpull @suwidth
    
    #----move upper stair drawing routine from [0,0,0] to input point @pt5
    t=Geom::Transformation.new(@pt5)
    group.transform!(t)
    
    pi = 3.141592653589793   # 180 degree angle = pi radians
    pi2 = 1.5707963267948965 #  90 degree angle = pi/2 radians
    pi3 = 4.7123889803846895 # 270 degree angle = 3*pi/2
    #----rotate upper stair drawing routine about @pt5 180 degress
    tr=Geom::Transformation.rotation(@pt5, Geom::Vector3d.new(0, 0 ,1), pi)
    group.transform!(tr)
#---------------------------------------------------------------------------
    view=model.active_view
    view.zoom_extents
#---------------------------------------------------------------------------     
    #----Do landing routine for Upper or Lower floors 
    #----Dialog box
    @choice = "UP one Floor" if not @choice
    choice_options = ["UP one Floor","DN one Floor"]
    prompts = ["Landing                "]
    values = [@choice]
    enums = [choice_options.join("|")]
    results = inputbox prompts, values, enums,"Create opposite Landing? "
    return if not results
    @choice = results[0]
      
    if @choice == "UP one Floor"  # Do Landing
    entities=model.active_entities  
    group=entities.add_group
    entities=group.entities
                  
    #----move landing from its original position to top of stair @pte
    t=Geom::Transformation.new(@pte)
    group.transform!(t)
    base=entities.add_face(@pt0, @pta, @pt7, @ptb, @ptc, @ptd)
    base.pushpull @suincr
        
    else 
    entities=model.active_entities  
    group=entities.add_group
    entities=group.entities
                    
    #----move landing from its original position to btm of stair @ptf
    t=Geom::Transformation.new(@ptf)
    group.transform!(t)
    base=entities.add_face(@pt0, @pta, @pt7, @ptb, @ptc, @ptd)
    base.pushpull @suincr
    
    end  #end if 
#---------------------------------------------------------------------------
    view=model.active_view
    view.zoom_extents
#---------------------------------------------------------------------------    
    model.commit_operation
end
#---------------------------------------------------------------------------
 def stairconcl
 
    Sketchup::set_status_text("<<<<<< Create a Stair with a Landing, then turns 90, Left  >>>>>", SB_PROMPT)
    #Set default stair settings
    $slwidth= 90.cm if not $slwidth
    $slheight = 250.cm if not $slheight
    $slriser = 16 if not $slriser
    $slriserl = 8 if not $slriserl
    $sltread = 30.cm if not $sltread
    $sln = 3.cm if not $sln
    $slnxh = 0.cm if not $slnxh 
    #Handrail height
    $slhand = 100.cm
    #Handrail spacing from wall
    $slhands = 7.cm

    # Dialog box
    prompts = ["Stair Width", "Floor/Floor Height ", "No. Risers Total","No. Risers to Landing ", "Tread Width", "Nosing", "Next Floor Height"]
    values = [$slwidth, $slheight, $slriser, $slriserl, $sltread, $sln, $slnxh]
    results = inputbox prompts, values, "Stair Properties 90 Left"
        
    return if not results
    $slwidth, $slheight, $slriser, $slriserl, $sltread, $sln, $slnxh = results
    
    if ($slriserl < 2)
       UI.messagebox( "Less than 2 risers is not allowed ")
    return nil
    end
    
    if ($slriserl >$slriser-2)
       UI.messagebox( "Less than 2 risers after Landing is not allowed ")
    return nil
    end
    
    $slup=$slriser-$slriserl 
    $slincr=$slheight/$slriser
#--------------------------------------------------------------------------
    model=Sketchup.active_model
    model.start_operation "Create Concrete Stair"
       
    #----Do lower stair drawing routine
    i=0
    j=0
    $all=[]
    $all[j]=[0, 0, $slnxh]
    $xx=0
    $yy=0
    $zz=$slnxh

    while i < $slriserl
       i=i+1
       j=j+1
       $xx=$xx-$sln  
       $zz=$zz+$slincr 
       $all[j]=[$xx, $yy, $zz]
       j=j+1
       $xx=$xx+$sln+$sltread
       $all[j]=[$xx, $yy, $zz]
    end
    j=j+1
    $all[j]=[$xx, $yy, $zz-$slincr]
    j=j+1
    $all[j]=[$sltread, 0, $slnxh]
    
    #----Points required for Stairto Do Landing 
    $pt1=Geom::Point3d.new($all[0])
    $pt2=Geom::Point3d.new($pt1[0]+$sltread,$pt1[1],$pt1[2])
    $pt3=Geom::Point3d.new($pt1[0]+$sltread*$slriserl,$pt1[1],$pt1[2])
    $pt4=Geom::Point3d.new($pt1[0]+$sltread*$slriserl,$pt1[1],$pt1[2]+($slincr*$slriserl)-$slincr)
    $pt5=Geom::Point3d.new($pt1[0]+$sltread*$slriserl,$pt1[1],$pt1[2]+$slincr*$slriserl)
    $pt5a=Geom::Point3d.new($pt1[0]+$sltread*$slriserl,$pt1[1]-$slwidth,$pt1[2]+$slincr*$slriserl)
    #----Points required to Do Landing
    $pt6=Geom::Point3d.new($pt1[0]+$sltread*$slriserl+$slwidth,$pt1[1],$pt1[2]+$slincr*$slriserl)
    $pt7=Geom::Point3d.new($pt1[0]+$sltread*$slriserl+$slwidth,$pt1[1]+$sltread+$slwidth,$pt1[2]+$slincr*$slriserl)
    $pt7a=Geom::Point3d.new($pt1[0]+$sltread*$slriserl+$slwidth,$pt1[1]+$slwidth,$pt1[2]+$slincr*$slriserl)
    $pt8=Geom::Point3d.new($pt1[0]+$sltread*$slriserl,$pt1[1]+$sltread+$slwidth,$pt1[2]+$slincr*$slriserl)
    $pt9=Geom::Point3d.new($pt1[0]+$sltread*$slriserl+$slwidth,$pt1[1],$pt1[2]+$slincr*$slriserl)
    $pt0=Geom::Point3d.new($pt1[0]+$sltread*$slriserl,$pt1[1],$pt1[2]+$slincr*$slriserl)
    #----Points required to Do Railing
    $ptg=Geom::Point3d.new($pt1[0],$pt1[1]+$slhands,$pt1[2]+$slhand)
    $pth=Geom::Point3d.new($pt5[0],$pt5[1]+$slhands,$pt5[2]+$slhand) 
    $ptj=Geom::Point3d.new($pt9[0]-$slhands,$pt9[1]+$slhands,$pt9[2]+$slhand)
    $ptk=Geom::Point3d.new($pt7a[0]-$slhands,$pt7a[1],$pt7a[2]+$slhand)
    $ptm=Geom::Point3d.new($pt7[0]-$slhands,$pt7[1]+($slup*$sltread)-$sltread,$pt7[2]+$slup*$slincr+$slhand)
    
    entities=model.active_entities
    group=entities.add_group
    entities=group.entities
    lower_base=entities.add_face $all
    lower_base.pushpull $slwidth
   
    #----Do handrail
    entities=model.active_entities  
    group=entities.add_group
    entities=group.entities
    edges = entities.add_edges($ptg, $pth, $ptj, $ptk, $ptm )
    circle = entities.add_circle($ptm, Z_AXIS, 3.cm, 16)
    base = entities.add_face(circle)
    base.followme(edges)    
                
    #----Do intermediate landing 
    entities=model.active_entities
    group=entities.add_group
    entities=group.entities
    land_base=entities.add_face($pt8, $pt7, $pt9, $pt0)
    land_base.pushpull $slincr
           
    #----Do upper stair drawing routine
    i=0
    j=0
    $all=[]
    $all[j]=[0, 0, 0]
    $xx=0
    $yy=0
    $zz=0

    while i < $slriser-$slriserl
       i=i+1
       j=j+1
       $xx=$xx-$sln  
       $zz=$zz+$slincr 
       $all[j]=[$xx, $yy, $zz]
       j=j+1
       $xx=$xx+$sln+$sltread
       $all[j]=[$xx, $yy, $zz]
    end
    j=j+1
    $all[j]=[$xx, $yy, $zz-$slincr]
    j=j+1
    $all[j]=[$sltread, 0, 0]
           
    entities=model.active_entities
    group=entities.add_group
    entities=group.entities
    upper_base=entities.add_face $all
    upper_base.pushpull $slwidth
    
    #----move upper stair drawing routine from [0,0,0] to input point $pt7a
    t=Geom::Transformation.new($pt7a)
    group.transform!(t)
    
    pi2 = 1.5707963267948965 #  90 degree angle = pi/2 radians
    #----rotate upper stair drawing routine about $pt5 180 degress
    tr=Geom::Transformation.rotation($pt7a, Geom::Vector3d.new(0, 0 ,1), pi2)
    group.transform!(tr)

#---------------------------------------------------------------------------
    view=model.active_view
    view.zoom_extents
#---------------------------------------------------------------------------    
    model.commit_operation
end
#--------------------------------------------------------------------------- 
def stairconcr

    Sketchup::set_status_text("<<<<<< Create a Stair with a Landing, then turns 90, Right  >>>>>", SB_PROMPT)
    #Set default stair settings
    $srwidth= 90.cm if not $srwidth
    $srheight = 250.cm if not $srheight
    $srriser = 16 if not $srriser
    $srriserl = 8 if not $srriserl
    $srtread = 30.cm if not $srtread
    $srn = 3.cm if not $srn
    $srnxh = 0.cm if not $srnxh 
    #Handrail height
    $srhand = 100.cm
    #Handrail spacing from wall
    $srhands = 7.cm

    # Dialog box
    prompts = ["Stair Width", "Floor/Floor Height ", "No. Risers Total","No. Risers to Landing ", "Tread Width", "Nosing", "Next Floor Height"]
    values = [$srwidth, $srheight, $srriser, $srriserl, $srtread, $srn, $srnxh]
    results = inputbox prompts, values, "Stair Properties 90 Right"
        
    return if not results
    $srwidth, $srheight, $srriser, $srriserl, $srtread, $srn, $srnxh = results
    
    if ($srriserl < 2)
       UI.messagebox( "Less than 2 risers is not allowed ")
    return nil
    end
    
    if ($srriserl >$srriser-2)
       UI.messagebox( "Less than 2 risers after Landing is not allowed ")
    return nil
    end
    
    $srup=$srriser-$srriserl 
    $srincr=$srheight/$srriser
#--------------------------------------------------------------------------
    model=Sketchup.active_model
    model.start_operation "Create Concrete Stair"
       
    #----Do lower stair drawing routine
    i=0
    j=0
    $all=[]
    $all[j]=[0, 0, $srnxh]
    $xx=0
    $yy=0
    $zz=$srnxh

    while i < $srriserl
       i=i+1
       j=j+1
       $xx=$xx-$srn  
       $zz=$zz+$srincr 
       $all[j]=[$xx, $yy, $zz]
       j=j+1
       $xx=$xx+$srn+$srtread
       $all[j]=[$xx, $yy, $zz]
    end
    j=j+1
    $all[j]=[$xx, $yy, $zz-$srincr]
    j=j+1
    $all[j]=[$srtread, 0, $srnxh]
    
    #----Points required for Stairto Do Landing 
    $pt1=Geom::Point3d.new($all[0])
    $pt2=Geom::Point3d.new($pt1[0]+$srtread,$pt1[1],$pt1[2])
    $pt3=Geom::Point3d.new($pt1[0]+$srtread*$srriserl,$pt1[1],$pt1[2])
    $pt4=Geom::Point3d.new($pt1[0]+$srtread*$srriserl,$pt1[1],$pt1[2]+($srincr*$srriserl)-$srincr)
    $pt5=Geom::Point3d.new($pt1[0]+$srtread*$srriserl,$pt1[1],$pt1[2]+$srincr*$srriserl)
    $pt5a=Geom::Point3d.new($pt1[0]+$srtread*$srriserl,$pt1[1]-$srwidth,$pt1[2]+$srincr*$srriserl)
    #----Points required to Do Landing
    $pt6=Geom::Point3d.new($pt1[0]+$srtread*$srriserl+$srwidth,$pt1[1],$pt1[2]+$srincr*$srriserl)
    $pt7=Geom::Point3d.new($pt1[0]+$srtread*$srriserl+$srwidth,$pt1[1]+$srwidth,$pt1[2]+$srincr*$srriserl)
    $pt8=Geom::Point3d.new($pt1[0]+$srtread*$srriserl,$pt1[1]+$srwidth,$pt1[2]+$srincr*$srriserl)
    $pt9=Geom::Point3d.new($pt1[0]+$srtread*$srriserl+$srwidth,$pt1[1]-$srtread,$pt1[2]+$srincr*$srriserl)
    $pt0=Geom::Point3d.new($pt1[0]+$srtread*$srriserl,$pt1[1]-$srtread,$pt1[2]+$srincr*$srriserl)
    #----Points required to Do Railing
    $ptg=Geom::Point3d.new($pt1[0],$pt1[1]-$srhands+$srwidth,$pt1[2]+$srhand)
    $pth=Geom::Point3d.new($pt5[0],$pt5[1]-$srhands+$srwidth,$pt5[2]+$srhand) 
    $ptj=Geom::Point3d.new($pt7[0]-$srhands,$pt7[1]-$srhands,$pt7[2]+$srhand)
    $ptk=Geom::Point3d.new($pt6[0]-$srhands,$pt1[1]+$srhands,$pt9[2]+$srhand)
    $ptm=Geom::Point3d.new($pt9[0]-$srhands,$pt9[1]-($srup*$srtread)+$srtread,$pt9[2]+$srup*$srincr+$srhand)
    
    entities=model.active_entities
    group=entities.add_group
    entities=group.entities
    lower_base=entities.add_face $all
    lower_base.pushpull $srwidth
   
    #----Do handrail
    entities=model.active_entities  
    group=entities.add_group
    entities=group.entities
    edges = entities.add_edges($ptg, $pth, $ptj, $ptk, $ptm)
    circle = entities.add_circle($ptm, Z_AXIS, 1.cm, 16)
    base = entities.add_face(circle)
    base.followme(edges)    
                
    #----Do intermediate landing 
    entities=model.active_entities
    group=entities.add_group
    entities=group.entities
    land_base=entities.add_face($pt8, $pt7, $pt9, $pt0)
    land_base.pushpull $srincr
           
    #----Do upper stair drawing routine
    i=0
    j=0
    $all=[]
    $all[j]=[0, 0, 0]
    $xx=0
    $yy=0
    $zz=0

    while i < $srriser-$srriserl
       i=i+1
       j=j+1
       $xx=$xx-$srn  
       $zz=$zz+$srincr 
       $all[j]=[$xx, $yy, $zz]
       j=j+1
       $xx=$xx+$srn+$srtread
       $all[j]=[$xx, $yy, $zz]
    end
    j=j+1
    $all[j]=[$xx, $yy, $zz-$srincr]
    j=j+1
    $all[j]=[$srtread, 0, 0]
           
    entities=model.active_entities
    group=entities.add_group
    entities=group.entities
    upper_base=entities.add_face $all
    upper_base.pushpull $srwidth
    
    #----move upper stair drawing routine from [0,0,0] to input point $pt5
    t=Geom::Transformation.new($pt5)
    group.transform!(t)
    
    pi2 = 1.5707963267948965 #  90 degree angle = pi/2 radians
    #----rotate upper stair drawing routine about $pt5 180 degress
    tr=Geom::Transformation.rotation($pt5, Geom::Vector3d.new(0, 0 ,1), -pi2)
    group.transform!(tr)

#---------------------------------------------------------------------------
    view=model.active_view
    view.zoom_extents
#---------------------------------------------------------------------------    
    model.commit_operation
end
#---------------------------------------------------------------------------
#if( not file_loaded?("stairconctool3.rb") )
#    utilities_menu = UI.menu("Plugins").add_submenu("Stair Concrete")
#        utilities_menu.add_item("Straight") { stairconc }
#        utilities_menu.add_item("Scissor ") { stairconcu }
#        utilities_menu.add_item("90 Left") { stairconcl }
#        utilities_menu.add_item("90 Right") { stairconcr }
#end
#---------------------------------------------------------------------------
file_loaded("stairconctool3.rb")

