require 'sketchup.rb'
# objective: to make a parametric straight stair 
# coding includes 2 Transformation routines
# Plus handrail & glass guard option
#-----------------------------------------------------------------------------
def create_stair
    Sketchup::set_status_text("<<<<<< This Program creates a Straight Stair ----- Enter 0 if no Nosing is req'd ----- Enter 0 if no Riser Infill is req'd >>>>>", SB_PROMPT)
    prompts = ["Stair Width", "Stair Height", "Riser Height", "Tread Width", "Tread Thickness", "Nosing", "Riser Infill", "Stringer Thickness "]
    values = [3.feet, 9.feet, 7.5.inch, 10.inch, 4.inch, 1.inch, 1.inch, 3.inch]
    results = inputbox prompts, values, "Stair Properties"
    width, height, riser, tread, tt, nosing, ri, st = results
    increment = height/riser
    riser = height/increment.round
    #if (ri <= 0.0.inch)
    #   then ri = 0
    #end

#--------------------------------------------------------------------------
    model = Sketchup.active_model
    model.start_operation "Create Stair "
#--------------------------------------------------------------------------
    # Do the first tread at 0,0,0
    definitions = model.definitions
    step = definitions.add
    entities = step.entities

    tread_base = entities.add_face([0, 0, 0], [0, 0, tt], [tread + nosing*2, 0, tt], [tread + nosing*2, 0, 0])
    tread_base.material = Sketchup::Color.new(210, 180, 140) #change color here, or use # to comment out
    tread_base.pushpull width
#--------------------------------------------------------------------------
    # Move or transform the location of the first tread from 0,0,0 to 0,0,riser-tt
    t = Geom::Transformation.translation(Geom::Vector3d.new(0, 0, riser-tt))

    entities = model.active_entities
    
    # Locate the first tread
    entities.add_instance(step, t)

    # Copy the treads to their new locations
    i = 1
    while i < increment
       # Transformation
       i = i + 1
       t = Geom::Transformation.translation(Geom::Vector3d.new(tread*(i-1), 0, (riser*i)-tt))
       entities.add_instance(step, t)
    end
#---------------------------------------------------------------------------
    entities = model.active_entities
    group = entities.add_group
    entities = group.entities

    # Do stringer right
    z = 0
    stringr_base = entities.add_face([0, z, 0], [tread+tread/2, z, 0], [increment*tread+tread, z, increment*riser-(riser/2+(riser-tt))], [increment*tread+tread, z, increment*riser+riser+(riser-tt)], [increment*tread, z, increment*riser+riser+(riser-tt)], [0, z, riser+(riser-tt)])
    #stringr_base.material = Sketchup::Color.new(224, 246, 211) #change color here, 
    stringr_base.pushpull st

    entities = model.active_entities
    group = entities.add_group
    entities = group.entities

    # Do stringer left
    z = width+st
    stringr_base = entities.add_face([0, z, 0], [tread+tread/2, z, 0], [increment*tread+tread, z, increment*riser-(riser/2+(riser-tt))], [increment*tread+tread, z, increment*riser+riser+(riser-tt)], [increment*tread, z, increment*riser+riser+(riser-tt)], [0, z, riser+(riser-tt)])
    #stringr_base.material = Sketchup::Color.new(224, 246, 211) #change color here, 
    stringr_base.pushpull st
#--------------------------------------------------------------------------
    # Do the first riser infill at 0,0,0
    definitions = model.definitions
    step = definitions.add
    entities = step.entities

    riser_base = entities.add_face([0, 0, 0], [0, 0, riser-tt], [ri, 0, riser-tt], [ri, 0, 0])
    riser_base.material = Sketchup::Color.new(210, 180, 140) #change color here,
    riser_base.pushpull width
#----------------------------------------------------------------------------
    # Move or transform the location of the first riser infill panel from 0,0,0 to ri,0,0
    t = Geom::Transformation.translation(Geom::Vector3d.new(ri, 0, 0))
    
    entities = model.active_entities
    
    # Locate the first riser infill panel 
    entities.add_instance(step, t)

    # Copy the riser infill panel their new locations
    i = 1
    while i < increment
       # Transformation
       i = i + 1
       t = Geom::Transformation.translation(Geom::Vector3d.new(tread*(i-1)+ nosing, 0, (riser*i)-riser))
       entities.add_instance(step, t)
    end
#-----------------------------------------------------------------------------
    view = model.active_view
    view.zoom_extents
#-----------------------------------------------------------------------------
    Sketchup::set_status_text("<<<<<< If you dont require Guards or Handrails just Hit Cancel >>>>>", SB_PROMPT)
    prompts = ["Guard Height", "Guard Thickness", "Rail Height", "Rail Width"]
    values = [2.feet, 0.25.inch, 6.inch, 2.inch]
    results = inputbox prompts, values, "Railing Properties"
    gh, gt, rh, rw = results
    
    entities = model.active_entities
    group = entities.add_group
    entities = group.entities

    # Do Guard right
    z = -((st/2)-(gt/2))
    guardr_base = entities.add_face([0, z, riser*2-tt], [increment*tread, z, increment*riser+riser*2-tt], [increment*tread+tread, z, increment*riser+riser*2-tt], [increment*tread+tread, z, increment*riser+riser*2-tt+gh], [increment*tread, z, increment*riser+riser*2-tt+gh], [0, z, riser*2-tt+gh]) 
    guardr_base.material = Sketchup::Color.new(170, 225, 200) #change color here
    guardr_base.material.alpha = 0.5 
    guardr_base.pushpull gt  

    entities = model.active_entities
    group = entities.add_group
    entities = group.entities

    # Do Guard left
    z = (width+st)-((st/2)-(gt/2))
    guardl_base =  entities.add_face([0, z, riser*2-tt], [increment*tread, z, increment*riser+riser*2-tt], [increment*tread+tread, z, increment*riser+riser*2-tt], [increment*tread+tread, z, increment*riser+riser*2-tt+gh], [increment*tread, z, increment*riser+riser*2-tt+gh], [0, z, riser*2-tt+gh]) 
    guardl_base.material = Sketchup::Color.new(170, 225, 200) #change color here,
    guardl_base.material.alpha = 0.7 
    guardl_base.pushpull gt  

    entities = model.active_entities
    group = entities.add_group
    entities = group.entities

    # Do Handrail right
    z = 0
    handr_base = entities.add_face([0, z, riser*2-tt+gh], [increment*tread, z, increment*riser+riser*2-tt+gh], [increment*tread+tread, z, increment*riser+riser*2-tt+gh], [increment*tread+tread, z, increment*riser+riser*2-tt+gh+rh], [increment*tread, z, increment*riser+riser*2-tt+gh+rh], [0, z, riser*2-tt+gh+rh]) 
    handr_base.material = Sketchup::Color.new(224, 246, 211) #change color here,
    handr_base.pushpull rw  

    entities = model.active_entities
    group = entities.add_group
    entities = group.entities

    # Do Handrail left
    z = width
    handr_base = entities.add_face([0, z, riser*2-tt+gh], [increment*tread, z, increment*riser+riser*2-tt+gh], [increment*tread+tread, z, increment*riser+riser*2-tt+gh], [increment*tread+tread, z, increment*riser+riser*2-tt+gh+rh], [increment*tread, z, increment*riser+riser*2-tt+gh+rh], [0, z, riser*2-tt+gh+rh]) 
    handr_base.material = Sketchup::Color.new(224, 246, 211) #change color here,
    handr_base.pushpull -rw  

#-----------------------------------------------------------------------------
    #Set values for the Circular rail
    #center = [0,0,0] # Center of Base of Cone 
    #vector = [0,0,1] # Normal Vector 
    #radius = 3.feet # Radius of rail base
    #segments = 24 # Default number of segments
    #rail_base = entities.add_circle(center, vector, radius,segments) 

#-----------------------------------------------------------------------------
    model.commit_operation
end
#-----------------------------------------------------------------------------
#if( not file_loaded?("Stair.rb") )
   # add_separator_to_menu("Plugins")
    #UI.menu("Plugins").add_item("Stair") { create_stair }
#end
#-----------------------------------------------------------------------------
file_loaded("Stair.rb")

