# Name :          Terol 1.0
# Description :   get terrain information from file
# Author :        TBD
# Usage :         select Plugins|[TBD] Terol
# Date :          20.Aug.2oo4
# Type :          tool
# History:        1.0 (20.Aug.2oo4) - first version

require 'sketchup.rb'

def import_terrain
   panel_value = UI.openpanel "select terrain file" 
   if panel_value
      terrain_file = File.new( panel_value.to_s, "r" )

      # read file contents
      val_read = terrain_file.read
      
      # remove carriage returns from file
      values = val_read.delete "\n"
      
      val = values.split( pattern=",")
      
      # get size of terrain data
      size = val.first.to_i
      
      # remove size information from terrain data
      val.delete_at 0
      
      @mesh = Geom::PolygonMesh.new(val.length)
      
      x = y = 0
      val.length.times do |i|
         if x == size 
            x = 0
            y = y + 1
         end
         x = x + 1
         pt = Geom::Point3d.new(x,y,val[i].to_f) 
         @mesh.add_point pt
      end

      # add polygons
      val.length.times do |i|
         mod = i.divmod size
         if ((i>0) && (i<val.length-size) && (mod[1]!=0)) 
            @mesh.add_polygon [i+1,i+size,i+size+1] 
            @mesh.add_polygon [i,i+1,i+size]
         end
      end

      # create group
      group = Sketchup.active_model.active_entities.add_group
      
      entities = group.entities
      entities.add_faces_from_mesh @mesh

      # correct orientation of faces
      entities.each do |e| 
         if e.class == Sketchup::Face
            e.reverse! if e.normal[2]<0
         end
      end
      
      terrain_file.close
   else
      UI.messagebox "No file selected."
   end
end

# -----------------------------------------------------------------------------

if( not file_loaded?("terol.rb") )

    # Add a separator to the menu, but only once
    add_separator_to_menu("Plugins")
    UI.menu("Plugins").add_item("Terol") { import_terrain }

end

file_loaded("terol.rb")