# Copyright 2004, Rick Wilson 

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

# Name :          Weld 1.0
# Description :   weld edges into curve
# Author :        RW
# Usage :         select 2 faces - edges & faces will be
#                 created between them
# Date :          4.Aug.2004
# Type :		tool
# History:
#			1.0 (4.Aug.2004) - first version

require 'sketchup.rb'

def join_edges 
	model=Sketchup.active_model
	ents=model.entities
	ss=model.selection
	sl=ss.length
	v=[]
	vp=[]
	sp=nil
	cl=false

#CHECK FOR A VALID SELECTION

	return UI.messagebox("Please select at least 2 edges") if ss.length < 2
	if ss.first.curve
		return UI.messagebox("Please select at least 2 non-joined edges") if ss.length == ss.first.curve.count_edges
	end

#DELETE NON-EDGES, GET THE VERTICES

	0.upto(ss.length-1) do |x|
		if ss[x].class != Sketchup::Edge
			ss.slice!(x)
		else
			v.push(ss[x].vertices)
		end
	end
	v.flatten!

#FIND THE FIRST VERTEX THAT HAS ONLY ONE ASSOCIATED EDGE

	0.upto(v.length-1) do |x|
		if ((v[x].edges.length == 1) && (sp == nil))
			sp=v[x]
		end
	end

#IF THERE IS NO FIRST VERTEX BECAUSE OF CLOSED SELECTION,
#THEN MAKE ONE

	model.start_operation "weld"
	if sp==nil
		cl=true
		sp=v.first
		sp.edges.first.erase!
	else
		cl=true if UI.messagebox("Close the curve?", MB_YESNO) == 6
	end

	v.clear
	v.push(sp)
	vp.push(v.last.position)
	cEdge=v.last.edges.first
	v.push(cEdge.other_vertex(v.last))
	vp.push(v.last.position)
	count = 0


#ONE BY ONE DELETE THE EDGES TO BE REPLACED WITH THE CURVE
#WHILE GATHERING THE POINT DATA TO CREATE THE CURVE

	cEdge.erase!

	while ((v.last.valid?) && (count <= sl))
		if v.last.valid?
			cEdge=v.last.edges.first
			v.push(cEdge.other_vertex(v.last))
			vp.push(v.last.position)
			#cEdge.erase!
		end
		count += 1
		cEdge.erase!
	end
	ss.clear
	vp.push(vp.first) if cl==true
#	puts vp

#CREATE THE CURVE

	if cl
		ents.add_curve(vp).first.find_faces
	else
		ents.add_curve(vp)
	end

	model.commit_operation
end

#ALL DONE!

#-----------------------------------------------------------------------------
#if( not file_loaded?("weld.rb") )
#    add_separator_to_menu("Plugins")
#    UI.menu("Plugins").add_item("weld") { join_edges }
#end
#-----------------------------------------------------------------------------
file_loaded("weld.rb")
