# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
# Name :          xline.rb 1.0
# Description :   Convert selected edges to construction lines
# Author :        Rick Wilson
# Usage :         1.	Install into the plugins directory or into the 
#				Plugins/examples directory and manually load from the
#				ruby console "load 'examples/xlines.rb'" 
#                 2.	Select "Convert to xLines" from the context menu after
#				selecting an edge.
# Date :          Feb 04 05
# Type :          Tool
# History:

require 'sketchup.rb'

def xLine
	model=Sketchup.active_model
	ents=model.entities
	sel=model.selection
	lines=[]
	points=[]
	model.start_operation "xLine"
	for e in sel
		if e.class == Sketchup::Edge
			lstart=e.start.position
			lend=e.end.position
			ents.add_cline(lstart,lend)
			points.push(e.start)
			points.push(e.end)
			lines.push(e)
		end
	end
	if not points.empty?
		points.uniq!
		for e in points
			ents.add_cpoint(e.position)
		end
	end
	if not lines.empty?
		for e in lines
			e.erase! if e.valid? #if e.faces.empty?
 		end
	end
	model.commit_operation
end

def xLine_validate_selection
	Sketchup.active_model.selection.each {|e| return true if e.class == Sketchup::Edge}
	return nil
end


if( not file_loaded?("xLine.rb") )
	UI.add_context_menu_handler do |menu|
		if xLine_validate_selection
			menu.add_separator
			menu.add_item("תɸ") { xLine }
		end
	end
end

#-----------------------------------------------------------------------------
file_loaded("xLine.rb")
