# Copyright 2004, Rick Wilson 

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

# Name :          bomb.rb 1.0
# Description :   Sample method calls to the UI class.  Demonstration/Documentation purposes only.
# Author :        Rick Wilson
# Usage :         1. Install into the plugins directory or into the 
#                    Plugins/examples directory and manually load from the ruby console "load 'examples/bomb.rb'" 
#                 2. Run "Bomb" from the Plugins menu.
# Date :          27.Jul.2004
# Type :          Tool
# History:        1.0 (20.Jul.2004) - first version
# 
require 'sketchup.rb'

def bomb_groups
	model=Sketchup.active_model
	ents=model.active_entities
	comgrp = []

	model.start_operation "Bomb"

	0.upto(ents.length) do |a|
#		FIND GROUPS AND COMPONENTS
		comgrp[comgrp.length] =ents[a] if ((ents[a].class == Sketchup::Group) || (ents[a].class == Sketchup::ComponentInstance))
	end
#		EXPLODE GROUP OR COMPONENT
	0.upto(ents.length-1) do |a|
		comgrp[a].explode
	end
	model.commit_operation

end

if( not file_loaded?("bomb.rb") )

    # This will add a separator to the menu, but only once
    add_separator_to_menu("Plugins")
    
    # To add an item to a menu, you identify the menu, and then
    # provide a title to display and a block to execute.  In this case,
    # the block just calls the create_box function
    UI.menu("Plugins").add_item("ըе鼰") { bomb_groups }

end

#-----------------------------------------------------------------------------
file_loaded("bomb.rb")

