# Name :          layers_show_hide_all.rb
# Description :   Activate and/or desactivate all layers, except current
# Author :        Madcello
# Usage :         Select itel from the lugins menu
# Type :          tool
# History:        2004,10,21
#-----------------------------------------------------------------------------def show_all_layers
def show_all_layers
    ss = Sketchup.active_model

    for layer in ss.layers
        if not layer.visible?
	layer.visible = true
        end
    end
end

#########################################
def hide_all_layers
    ss = Sketchup.active_model
    layer_activa = ss.active_layer

    for layer in ss.layers
        if layer.visible? and layer.name != layer_activa.name
	layer.visible = false
        end
    end
end

####################

if( not file_loaded?("layers_show_hide_all.rb") )
    plugins_menu = UI.menu("Plugins")
        plugins_menu.add_item("ʾͼ  ") { show_all_layers }
        plugins_menu.add_item("ͼ  ") { hide_all_layers }
end
    
file_loaded("layers_show_hide_all.rb")
