# Name :          Materials
# Description :   list the materials in a sketchup 4.0 file Mac version 
# Author :        MarkHorner
# Usage :         Place this ruby script in your Plugins directory - Application Support/SketchUp4/Plugins
#                 Open SketchUp and select the Materials sub-menu item on the View menu.
# Date :          14.march.2005
# Type :          tool
# History:        1.0 (14.march.2005) - first mac version

#-----------------------------------------------------------------------------

require 'sketchup.rb'

#-----------------------------------------------------------------------------

def export_materials
#tell application "SketchUp 4.0"
#	activate
#	tell application "System Events"
#		tell process "SketchUp"
#			click button 1 of group 0 of window "Colors"
#			click menu button 2 of group 1 of window "Colors"
#			click menu item 2 of menu 1 of menu button 2 of group 1 of window "Colors"
#			delay 0.2
#			keystroke return
#		end tell
#	end tell
#end tell

#osascript -e 'tell application "System Events"'
#		 -e 'tell process "SketchUp"'
#			 -e 'click button 1 of group 0 of window "Colors"'
#			 -e 'click menu button 2 of group 1 of window "Colors"'
#			 -e 'click menu item 2 of menu 1 of menu button 2 of group 1 of window "Colors"'
#			 -e 'delay 0.2'
#			 -e 'keystroke return'
#		 -e 'end tell'
#	 -e 'end tell'

Sketchup.send_action("orderFrontColorPanel:") #this will  work
#Sketchup.send_action("onShowColorsInModel:") #this should  work

system("osascript -e 'tell application \"System Events\"' -e 'tell process \"SketchUp\"' -e 'click button 1 of group 0 of window \"Colors\"' -e 'end tell'  -e 'end tell'")

system("osascript -e 'tell application \"System Events\"' -e 'tell process \"SketchUp\"' -e 'click menu button 2 of group 1 of window \"Colors\"' -e 'click menu item 2 of menu 1 of menu button 2 of group 1 of window \"Colors\"'  -e 'delay 0.2'  -e 'keystroke return'  -e 'end tell'  -e 'end tell'")
#system("osascript -e 'tell application \"System Events\"' -e 'tell process \"MegaPOV Mach-O\"' -e 'click menu item \"Start Rendering\" of menu \"Render\" of menu bar item \"Render\" of menu bar 1' -e 'end tell' -e 'end tell'") #jMH

end #def

def show_materials
#Sketchup.send_action("ShowColorPanel:") #this ought to work
Sketchup.send_action("orderFrontColorPanel:") #this will  work
#Sketchup.send_action("onShowColorsInModel:") #this should  work

# osascript -e 'tell application "Sketchup"'  -e 'activate' -e 'tell application "System Events"' -e 'tell process "SketchUp"' -e 'click button 1 of group 0 of window "Colors"' -e 'end tell'  -e 'end tell' -e 'end tell'

system("osascript -e 'tell application \"System Events\"' -e 'tell process \"SketchUp\"' -e 'click button 1 of group 0 of window \"Colors\"' -e 'end tell' -e 'end tell'")
system("osascript -e 'tell application \"System Events\"' -e 'tell process \"SketchUp\"' -e 'click button 1 of group 0 of window 1' -e 'end tell' -e 'end tell'")

end #def


def materials_dialog
model=Sketchup.active_model
# materials
materials = model.materials
$mat_name_array = []
$mat_colours_array = []
$mat_on_disk_array = []
$mat_missing_array = []

#Sketchup.active_model.materials[3].texture.size=100
    materials.each do |mat|
    name = mat.display_name
    col = mat.color
    #p col
    #   p col.name
    alpha = mat.alpha
    #p alpha
    tex = mat.texture
    if tex != nil
        filename = tex.filename
        tex_average_color = tex.average_color
      #  tex_size = tex.size #default is (100%) we cant get size even though we can set it!!!
        tex_height = tex.height 
        tex_width = tex.width 
        tex_image_height = tex.image_height.to_m
        tex_image_width = tex.image_width.to_m
        #p tex_height,tex_width,tex_image_height,tex_image_width

        display_name = name + " File: " + filename
        if alpha != 1
            display_name = display_name + " Alpha: " + alpha.to_s
        end
 
        if FileTest.exist?(filename)
            #p "file: exists"
            #p filename
            $mat_on_disk_array.push( display_name )
        else
            #p "file: does not exist"
            #p filename
            $mat_missing_array.push( display_name )
        end #if
        #   if tex_size != 100
        #        display_name = display_name + " Size: " + tex_size + "%"
        #    end
    else
        display_name = name + " Colour: " + col.to_s
        if alpha != 1
            alph_disp = alpha*100
            #p alph_disp
            display_name = display_name + " Alpha: " + alpha.to_s
        end #if
        $mat_colours_array.push( display_name ) 
    end #if
    $mat_name_array.push( name )
end #do
#p "names"
#p $mat_name_array
#p "file names"
#p $mat_file_array

# remove duplicates and nil's ($mat_array.compact doesn't work)
if $mat_name_array #!= nil
    $mat_name_array.uniq!
    $mat_name_array.delete_if {|x| x == nil }
end

if $mat_colours_array #!= nil
    $mat_colours_array.uniq!
    $mat_colours_array.delete_if {|x| x == nil }
end

if $mat_on_disk_array  #!= nil
    $mat_on_disk_array.uniq!
    $mat_on_disk_array.delete_if {|x| x == nil }
end 

if $mat_missing_array  #!= nil
    $mat_missing_array.uniq!
    $mat_missing_array.delete_if {|x| x == nil }
end 

    #p "names"
    #p $mat_name_array
    #p "filenames"
    #p $mat_file_array

    # current values

    mat_name_list = $mat_name_array.join("|") 
    mat_colours_list = $mat_colours_array.join("|") 
    mat_on_disk_list = $mat_on_disk_array.join("|") 
    mat_missing_list = $mat_missing_array.join("|") 
 
    if !$mat_name_array
        mat_name_list=%w[No_Materials].join("|")
    end
    if !$mat_colours_array
        mat_colours_list=%w[No_Colours].join("|")
    end
    if !$mat_on_disk_array
        mat_on_disk_list=%w[No_Texture_files_on_Disk].join("|")
    end
    if !$mat_missing_array
        mat_missing_list=%w[No_Missing_Texture_Files].join("|")
    end
    
    dropdowns = [mat_name_list, mat_colours_list, mat_on_disk_list, mat_missing_list ]
    # Dialog box
    prompts = ["Materials", "Colours", "Textures", "Missing Textures"]
    values = [nil,nil,nil,nil]

    results = inputbox prompts, values, dropdowns, "Materials in File"

    #return nil if not results
end #def materials_dialog

def rename_materials
    Sketchup.send_action("orderFrontColorPanel:") #this will  work
    Sketchup.send_action("onShowColorsInModel:") #this should  work
    Sketchup.send_action("onPurgeUnused:") #this should  work

    model=Sketchup.active_model
    # materials
    materials = model.materials
    $mat_missing_array = []

    #Sketchup.active_model.materials[3].texture.size=100
    #Sketchup.active_model.materials[3].texture.methods
    Sketchup.active_model.materials[6].get_attribute("skpp","Filename")
    Sketchup.active_model.materials[6].attribute_dictionary
    #Sketchup.active_model.materials[6].set_attribute("Filename","/Users/MarkHorner/texture3.tif")

    #Sketchup.attribute_dictionaries
    #Sketchup.active_model.attribute_dictionaries
    #Sketchup.active_model.materials.attribute_dictionaries
    #Sketchup.active_model.materials[6].attribute_dictionaries

    #("skp").each {| x | print x, "\n"}

    materials.each do |mat|
        tex = mat.texture
        if tex != nil
            name = mat.display_name
            filename = tex.filename
            if !FileTest.exist?(filename)
                names = filename.gsub("/", "\\").split("\\") #jMH
                base_name = names[names.length-1]
                #p base_name
                base_name = base_name.split(".")[0]
                #p base_name
                true_name = File.expand_path("~") +"/Library/Application Support/Textures/" + base_name + ".tif"
                #p true_name
                # tex.filename =true_name -- would be too easy
                # tex.set_attribute("Filename",true_name) -- nothing to see here
            end #if
        end #if
    end #do
end #def rename_materials

def remove_materials
    model=Sketchup.active_model
    # materials
    materials = model.materials
    $mat_to_delete_array = []
    $mat_to_replace_array = []
    $mat_textures_array = []
    $mat_colours_array = []

    #Sketchup.active_model.materials[3].texture.size=100

# get all the textures and colours into their respective arrays
    materials.each do |mat|
        name = mat.display_name
        col = mat.color
        alpha = mat.alpha
        tex = mat.texture
        if tex != nil
            filename = tex.filename
            names = filename.gsub("/", "\\").split("\\") #jMH
            base_name = names[names.length-1]
            #p base_name
            base_name = base_name.split(".")[0]
            tex_average_color = tex.average_color
            tex_height = tex.height 
            tex_width = tex.width 
            tex_image_height = tex.image_height.to_m
            tex_image_width = tex.image_width.to_m
            $mat_textures_array.push( [base_name,col.to_s,alpha,tex_height,tex_height,name,filename] )
        else
            $mat_colours_array.push( [col.to_s,alpha,name] )
        end #if
    end #do
          
    #p "names"
    #p $mat_name_array
    #p "file names"
    #p $mat_file_array
    # Sketchup.send_action("showRubyPanel:") # useful for debugging
    #puts  "\n"

    # remove duplicates and nil's ($mat_array.compact doesn't work)
    last_base = ""
    last_alpha = ""
    last_line = ""
    if $mat_textures_array #!= nil
        $mat_textures_array.uniq!
        $mat_textures_array.delete_if {|x| x == nil }
        $mat_textures_array.sort!
        #    puts $mat_textures_array.size, " Size \n"
        for ind in (0..$mat_textures_array.size - 1)
            this_line = $mat_textures_array[ind] 
            #puts this_line," \n"
        end #for
        # puts  " \n"
        for ind in (0..$mat_textures_array.size - 1)
            this_line = $mat_textures_array[ind] 
            # puts this_line
            if this_line[0] == last_base
                if this_line[2] == last_alpha
                    #puts "Same Texture Same Alpha: ", this_line, last_line
                    $mat_to_delete_array.push (last_line[5])
                    $mat_to_delete_array.push (this_line[5])
                    $mat_to_replace_array.push ([this_line[5],last_line[5]])
                    $mat_to_replace_array.push ([last_line[5],this_line[5]])
                else
                    #puts "Same Texture Different Alpha: ", this_line, last_line
                end #if
            end #if
            last_base = this_line[0]
            last_col = this_line[1]
            last_alpha = this_line[2]
            last_line = this_line
            # puts  " \n"
        end #for
    end #if
    # puts "\n"

    last_col = ""
    last_alpha = ""
    last_line = ""
    if $mat_colours_array # != nil
        $mat_colours_array.uniq!
        $mat_colours_array.delete_if {|x| x == nil }
        $mat_colours_array.sort!
        #    puts $mat_colours_array.size, " Size \n"
        for ind in (0..$mat_colours_array.size - 1)
            this_line = $mat_colours_array[ind] 
            #     puts this_line, " \n"
        end #for
        for ind in (0..$mat_colours_array.size - 1)
            this_line = $mat_colours_array[ind] 
            # puts "This Line: ", this_line
            if this_line[0] == last_col
                if this_line[1] == last_alpha
                    #puts "Same Colour Same Alpha: ", this_line, last_line
                    $mat_to_delete_array.push (last_line[2])
                    $mat_to_delete_array.push (this_line[2])
                    $mat_to_replace_array.push ([this_line[2],last_line[2]])
                    $mat_to_replace_array.push ([last_line[2],this_line[2]])
                else
                    #  puts "Same Colour Different Alpha: ", this_line, last_line
                end #if
            else
                last_col = this_line[0]
            end #if
            last_alpha = this_line[1]
            last_line = this_line
            #puts " \n"
        end #for
    
    end #if
    if $mat_to_delete_array != []
        $mat_to_delete_array.uniq!
        $mat_to_delete_array.delete_if {|x| x == nil }
        mat_name_list = $mat_to_delete_array.join("|") 
        dropdowns = [mat_name_list ]
        # Dialog box
        prompts = ["Delete: "]
        values = [nil]
        results = inputbox prompts, values, dropdowns, "Duplicate Materials in File"
        if results
            $replace_what = results[0].to_s
            # UI.messagebox "Remove: " + $replace_what
            $replace_with = ""
            for ind in (0..$mat_to_replace_array.size - 1)
                if $replace_what == $mat_to_replace_array[ind][0].to_s
                    $replace_with = $mat_to_replace_array[ind][1].to_s
                else
                    #puts $replace_what + $mat_to_replace_array[ind][0].to_s
                end #if
            end #for
            #UI.messagebox "Replace: " + $replace_what + " with: " + $replace_with
            #Sketchup.send_action("showRubyPanel:") # useful for debugging
            $replaced_count = 0
            process_entities(Sketchup.active_model.entities)
             process_entities(Sketchup.active_model.definitions)
            UI.messagebox "Replaced: " + $replaced_count.to_s + " copies of: " + $replace_what + " with: " + $replace_with
        end #if
    else
        UI.messagebox "No duplicate textures to replace"
 
    end #if
end #def remove_materials

def replace_any_material
    model=Sketchup.active_model
    # materials
    materials = model.materials
    $mat_array = []
    # get all the textures and colours into their respective arrays
    materials.each do |mat|
        name = mat.display_name
        $mat_array.push( name )
    end #do
          
    if $mat_array != []
        $mat_array.uniq!
        $mat_array.delete_if {|x| x == nil }
        mat_name_list = $mat_array.join("|") 
        dropdowns = [mat_name_list ]
        # Dialog box
        prompts = ["Replace: "]
        values = [nil]
        results = inputbox prompts, values, dropdowns, "Materials in File"
        if results
            $replace_what = results[0].to_s
            # UI.messagebox "Remove: " + $replace_what
            $replace_with = ""
            $mat_array.delete_if {|x| x ==  $replace_what }
            mat_name_list = $mat_array.join("|") 
            dropdowns = [mat_name_list ]
            # Dialog box
            prompts = ["Replace: "]
            values = [nil]
            results = inputbox prompts, values, dropdowns, "Replace: " + $replace_what
            if results
                $replace_with = results[0].to_s
                if $replace_with == $replace_what
                    UI.messagebox "With: " + $replace_what + " with: " + $replace_with
                else
                    $replaced_count = 0
                    process_entities(Sketchup.active_model.entities)
                    process_entities(Sketchup.active_model.definitions)
                    UI.messagebox "Replaced: " + $replaced_count.to_s + " copies of: " + $replace_what + " with: " + $replace_with
                end #if
            end #if
            #UI.messagebox "Replace: " + $replace_what + " with: " + $replace_with
            #Sketchup.send_action("showRubyPanel:") # useful for debugging
                 end #if
    else
        UI.messagebox "No textures to replace"
 
    end #if
end #def replace_any_material

def rename_any_material
    model=Sketchup.active_model
    # materials
    materials = model.materials
    $mat_array = []
    # get all the textures and colours into their respective arrays
    materials.each do |mat|
        name = mat.display_name
        $mat_array.push( name )
    end #do
          
    if $mat_array != []
        $mat_array.uniq!
        $mat_array.delete_if {|x| x == nil }
        mat_name_list = $mat_array.join("|") 
        dropdowns = [mat_name_list ]
        # Dialog box
        prompts = ["Rename: "]
        values = [nil]
        results = inputbox prompts, values, dropdowns, "Materials in File"
        if results
            $replace_what = results[0].to_s
            # UI.messagebox "Remove: " + $replace_what
            $replace_with = ""
            $mat_array.delete_if {|x| x ==  $replace_what }
            mat_name_list = $mat_array.join("|") 
            dropdowns = [mat_name_list ]
            # Dialog box
            prompts = ["Rename As: "]
            values = [$replace_what]
            results = inputbox prompts, values, "Rename Material As"
            if results
                $replace_with = results[0].to_s
                if $replace_with == $replace_what
                    UI.messagebox "Rename: " + $replace_what + " as: " + $replace_with
                else
                    UI.messagebox "Rename: " + $replace_what + " with: " + $replace_with
                end #if
            end #if
            #UI.messagebox "Replace: " + $replace_what + " with: " + $replace_with
            #Sketchup.send_action("showRubyPanel:") # useful for debugging
                 end #if
    else
        UI.messagebox "No textures to rename"
 
    end #if
end #def rename_any_material



def process_entities(ents)
    #puts "Process :" + ents.count.to_s + "entities"
    #UI.messagebox "Replace: " + $replace_what + " with: " + $replace_with
    #puts "Replace: " + $replace_what + " with: " + $replace_with
    ents.each do |ee|
        # FIND GROUPS AND COMPONENTS
        if ee.kind_of? Sketchup::Group
            #puts "Class: Group"
            process_entities(ee.entities)
        elsif ee.kind_of? Sketchup::ComponentDefinition
             puts "Class: ComponentDefinition"
             process_entities(ee.entities)
        elsif ee.kind_of? Sketchup::Face
            #puts "Class: Face"
            if ee.material
                 if ee.material.name == $replace_what #.to_s
                    #puts "Replace" + $replace_what + " with: " + $replace_with
                     $replaced_count =  $replaced_count +1
                    ee.material = $replace_with
                #else
                    #puts "Class: Face with material: " +ee.material.name.to_s
                end #if ee.material.name
            end #if ee.material
       end #if ee.kind_of?
    end #do
end #def process_entities

#def test(ents)
    #ents.each do |ee|
        #my_class = ee.kind_of?
        #case my_class
        #when Sketchup::Group then
            #puts "Class: Group"
        #end#case
    #end #do
#end #def

def validate_menu_any_materials
    #p Sketchup.active_model.materials.count
    return MF_GRAYED if Sketchup.active_model.materials.count<1
end #def

def validate_menu_show_materials
    #p Sketchup.active_model.materials.count
    return MF_GRAYED  # if Sketchup.active_model.materials.count<1
end #def

def validate_menu_export_materials
    #p Sketchup.active_model.materials.count
    return MF_GRAYED # if Sketchup.active_model.materials.count<1
end #def

def validate_menu_rename_any_materials
    #p Sketchup.active_model.materials.count
    return MF_GRAYED # if Sketchup.active_model.materials.count<1
end #def

def validate_menu_rename_filenames
    #p Sketchup.active_model.materials.count
    return MF_GRAYED # if Sketchup.active_model.materials.count<1
end #def

if( not file_loaded? "materials.rb" )

    add_separator_to_menu("View")
    materials_menu = UI.menu("View").add_submenu("Materials")

    menu_show_materials = materials_menu.add_item("Show Materials In Model") {show_materials} 
    materials_menu.set_validation_proc(menu_show_materials) { validate_menu_show_materials }

    menu_export_materials = materials_menu.add_item("Export Materials...") {export_materials} 
    materials_menu.set_validation_proc(menu_export_materials) { validate_menu_export_materials }
 
    menu_materials_dialog = materials_menu.add_item("List Materials...") {materials_dialog} 
    materials_menu.set_validation_proc(menu_materials_dialog) { validate_menu_any_materials }

    menu_remove_materials = materials_menu.add_item("Rename Any Material...") {rename_any_material} 
    materials_menu.set_validation_proc(menu_remove_materials) { validate_menu_rename_any_materials}

    menu_remove_materials = materials_menu.add_item("Replace Any Material...") {replace_any_material} 
    materials_menu.set_validation_proc(menu_remove_materials) { validate_menu_any_materials}
 
    menu_remove_materials = materials_menu.add_item("Replace Duplicate Material...") {remove_materials} 
    materials_menu.set_validation_proc(menu_remove_materials) { validate_menu_any_materials}
    
    menu_rename_materials = materials_menu.add_item("Rename FileNames") {rename_materials} 
    materials_menu.set_validation_proc(menu_rename_materials) { validate_menu_rename_filenames }
 

    file_loaded "materials.rb"
end # if( not file_loaded? "materials.rb" )

