# Copyright 2004, ODM
# Author : ODM 
# email: odm@aitop.com
# http://www.aitop.com
# Name : Page 1.0 
# Menu Item : Tool-> AITOP Pages Tools
# Date : 11/28/2004

require 'sketchup.rb'

def odm_save_pages
  model=Sketchup.active_model
  pages=model.pages
  num_pages=pages.count
  odm_page_file= File.new("odm.aitop", "w")
  names=[] 
  camera=[] 
  cam_eye=[] 
  cam_target=[] 
  cam_up=[] 
  cam_fov=[]
  cam_asp_r=[] 
  cam_fo_l=[]
  page_des=[]
  odm_page_file.write ((num_pages*14).to_s+"\n")
  0.upto(num_pages-1) do |x|
      names[x]=pages[x].name
      camera[x]=pages[x].camera
      cam_eye[x] = camera[x].eye 
      cam_target[x] = camera[x].target 
      cam_up[x] = camera[x].up 
      cam_fov[x]= camera[x].fov
      cam_asp_r[x]= camera[x].aspect_ratio 
      cam_fo_l[x]= camera[x].focal_length
      page_des[x]=pages[x].description
      odm_page_file.write (names[x]+"\n")
      odm_page_file.write (cam_eye[x].to_a.x.to_s+"\n")
      odm_page_file.write (cam_eye[x].to_a.y.to_s+"\n")
      odm_page_file.write (cam_eye[x].to_a.z.to_s+"\n")
      odm_page_file.write (cam_target[x].to_a.x.to_s+"\n")
      odm_page_file.write (cam_target[x].to_a.y.to_s+"\n")
      odm_page_file.write (cam_target[x].to_a.z.to_s+"\n")
      odm_page_file.write (cam_up[x].x.to_s+"\n")
      odm_page_file.write (cam_up[x].x.to_s+"\n")
      odm_page_file.write (cam_up[x].x.to_s+"\n")
      odm_page_file.write (cam_fov[x].to_s+"\n")
      odm_page_file.write (cam_asp_r[x].to_s+"\n")
      odm_page_file.write (cam_fo_l[x].to_s+"\n")
      odm_page_file.write (page_des[x].to_s+"\n")
   end
   odm_page_file.close
end
def odm_open_pages
  model=Sketchup.active_model
  view=model.active_view
  camera=view.camera
  pages=model.pages
  num_pages=pages.count
  odm_open_page_file= File.new("odm.aitop")
  names=[] 
  files=[]
  camera_name=[]
  cam_eye=[]
  cam_eye_x=[]
  cam_eye_y=[]
  cam_eye_z=[]
  cam_target=[]
  cam_target_x=[]
  cam_target_y=[]
  cam_target_z=[]
  cam_up=[]
  cam_up_x=[]
  cam_up_y=[]
  cam_up_z=[]
  cam_fov=[]
  cam_asp_r=[] 
  cam_fo_l=[]
  page_name=[]
  page_des=[]
  num_pages=odm_open_page_file.gets
  0.upto(num_pages.to_i-1) do |x|
     files[x]=odm_open_page_file.gets
  end 
  1.upto(num_pages.to_i/14) do |x|
     names[x-1]=files[14*x-14].to_s
     cam_eye_x[x-1]=files[14*x-13].to_f
     cam_eye_y[x-1]=files[14*x-12].to_f
     cam_eye_z[x-1]=files[14*x-12].to_f
     cam_target_x[x-1]=files[14*x-10].to_f
     cam_target_y[x-1]=files[14*x-9].to_f
     cam_target_z[x-1]=files[14*x-8].to_f
     cam_up_x[x-1]=files[14*x-7].to_f
     cam_up_y[x-1]=files[14*x-6].to_f
     cam_up_z[x-1]=files[14*x-5].to_f
     cam_fov[x-1]=files[14*x-4].to_f
     cam_asp_r[x-1]=files[14*x-3].to_f
     cam_fo_l[x-1]=files[14*x-2].to_f
     page_des[x-1]=files[14*x-1].to_f
     cam_eye[x-1]= Geom::Point3d.new(cam_eye_x[x-1],cam_eye_y[x-1],cam_eye_z[x-1])
     cam_target[x-1]=Geom::Point3d.new(cam_target_x[x-1],cam_target_y[x-1],cam_target_z[x-1])
     cam_up[x-1]= Geom::Vector3d.new(cam_up_x[x-1], cam_up_y[x-1], cam_up_z[x-1])
     page_name[x-1]=pages.add names[x-1]
     page_name[x-1].camera.fov=cam_fov[x-1].to_i
     page_name[x-1].camera.aspect_ratio=cam_asp_r[x-1]
     page_name[x-1].camera.focal_length=cam_fo_l[x-1]
     page_name[x-1].description=page_des[x-1].to_s
     page_name[x-1].camera.set cam_eye[x-1],cam_target[x-1],cam_up[x-1]
  end
end
if( not file_loaded?("page.rb") )
    odm_menu=UI.menu("Tool").add_submenu("ҳ湤 ")
    odm_menu.add_item("ҳ ") { odm_save_pages }
    odm_menu.add_item("ҳ ") { odm_open_pages }
end

#-----------------------------------------------------------------------------
file_loaded("page.rb")