#        Name : Pushpull_z
# Description : Extrudes a face along Z axis, not along the face normal
#      Author : Didier Bur
#       Usage : select a face, select from the Plugins menu, enter height and here you go
#        Date : 03.Jul.2oo4
#        Type : tool

require 'sketchup.rb'

def push_pull_z_set

model = Sketchup.active_model
model.start_operation "Push Pull Z"
entities = model.active_entities
ss = model.selection

if ss.empty? 
  UI.messagebox("No selection.")
  return nil
end
if not ss.first.kind_of? Sketchup::Face
  UI.messagebox("Please select face(s).")
  return nil
end

prompts = ["Height"]
value = [100.cm]
results = inputbox prompts, value, "Height"

return if not results # This means that the user canceld the operation
    height = results

# process each face
current_face = 0

0.upto(ss.length - 1) do |pts| 
  pts = ss[current_face].vertices
  length_pts = pts.length

  # copy the selected face
  i = 0
  pts2 = []

  pts.each do |pt|
    pts2[i] = pt.position + [0 , 0 , results[0]]
    i = i +1
  end
  face_copy = entities.add_face pts2

  pts_copy = face_copy.vertices

  # create faces between pairs of vertices of each face
  i = 0
  j = 0

  0.upto(pts.length - 2) do |new_face| 
    new_face = entities.add_face(pts[i], pts_copy[i], pts_copy[i + 1], pts[i + 1])
    i = i + 1
  end    # of upto
  # close the shape
  new_face = entities.add_face(pts[pts.length - 1], pts_copy[pts.length - 1], pts_copy[0], pts[0])

current_face = current_face + 1
end     #end of upto faces

#That's all folks
model.commit_operation
end    # of def


if( not file_loaded?("push_pull_z_set.rb") )

    # This will add a separator to the menu, but only once
    add_separator_to_menu("Plugins")
    
    # To add an item to a menu, you identify the menu, and then
    # provide a title to display and a block to execute.  In this case,
    # the block just calls the create_box function
    UI.menu("Plugins").add_item("Z") { push_pull_z_set }

end

#-----------------------------------------------------------------------------
file_loaded("push_pull_z_set.rb")
