#        Name : lines2walls
# Description : Creates walls starting from a selection of lines, an arc, a circle, a curve
#      Author : Didier Bur
#       Usage : select lines, an arc, a circle, a curve, select from the Plugins menu, enter height and width and here you go
#        Date : 10.Aug.2oo4
#        Type : tool

require 'sketchup.rb'

def line_to_wall

model = Sketchup.active_model
model.start_operation "Line2wall"
entities = model.active_entities
ss = model.selection

if ss.empty? 
  UI.messagebox("No selection.")
  return nil
end

#ss.each |element|
# if not element.kind_of? Sketchup::Edge
#    UI.messagebox("Please select only lines.")
#    return nil
#  end
#end

prompts = ["ǽ  ", "ǽ  "]
value = [200.mm,3000.mm]
results = inputbox prompts, value, "Walls parameters"

return if not results # This means that the user canceld the operation
width, height = results


pis2 = 1.5707963267948965

# construct the wall profile
pts = ss[0].vertices
pt1 = pts[0].position
pt2 = pts[1].position
vec = pt1.vector_to pt2
rotated_vec = vec.transform(Geom::Transformation.rotation(pt1, [0,0,1], pis2))
pt1_left = pt1.offset(rotated_vec, width / 2)
rotated_vec = vec.transform(Geom::Transformation.rotation(pt1, [0,0,1], (0 - pis2)))
pt1_right = pt1.offset(rotated_vec, width / 2)
pt2_left = pt1_left.offset([0,0,1], height)
pt2_right = pt1_right.offset([0,0,1], height)
face = Sketchup.active_model.active_entities.add_face(pt1_left, pt2_left, pt2_right, pt1_right)

i = 0
path = []

0.upto(ss.length - 1) do |something|
  path[i] = ss[i]
  i = i + 1
end

# follow me along lines
face.reverse!.followme path

model.commit_operation
end    # of def


#if( not file_loaded?("lines2walls.rb") )

     add_separator_to_menu("Tools")
     utilities_menu = UI.menu("Tools").add_item("ΪĽǽ") { line_to_wall }

#end

#-----------------------------------------------------------------------------
file_loaded("lines2walls.rb")