#include <amxmodx> 
#include <hamsandwich> 
#include <zombieplague>

static const PLUGIN_NAME[] = "[ZP] Drowned Zombie";
static const PLUGIN_VERSION[] = "1.2";
static const PLUGIN_AUTHOR[] = "tuty/CHyC";

/* UTF-8 func by www.DT-Club.net */
#define DMG_DROWN (1<<14)
new cvar_enabled;
new g_zclass_drowned;

new const zclass_name[] = { "淹死僵尸" } // name
new const zclass_info[] = { "能游泳" } // description
new const zclass_model[] = { "zombie_drowned" } // model
new const zclass_clawmodel[] = { "v_knife_zombie_drowned.mdl" } // claw model
const zclass_health = 2300 // health
const zclass_speed = 235 // speed
const Float:zclass_gravity = 1.0 // gravity
const Float:zclass_knockback = 1.7 // knockback

public plugin_init()
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR); 
	RegisterHam(Ham_TakeDamage, "player", "FwdTakeDamage");     
	cvar_enabled = register_cvar("zp_drowned", "1"); 
}

public plugin_precache()
{
	g_zclass_drowned = zp_register_zombie_class(zclass_name, zclass_info, zclass_model, zclass_clawmodel, zclass_health, zclass_speed, zclass_gravity, zclass_knockback)
}

public FwdTakeDamage(id, inflictor, attacker, Float:damage, damagebits)
{
	if(get_pcvar_num(cvar_enabled) != 1)
		return HAM_IGNORED;

	if(!is_user_alive(id) || !zp_get_user_zombie(id)) 
		return HAM_IGNORED;

	if(zp_get_user_zombie_class(id) != g_zclass_drowned) 
		return HAM_IGNORED;
	
	if(damagebits & DMG_DROWN)
	{
		return HAM_SUPERCEDE;
	}
	return HAM_IGNORED;
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil\\ fcharset134 Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang2052\\ f0\\ fs16 \n\\ par }
*/
