/*================================================================================
* Please don't change plugin register information.
================================================================================*/

#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>
#include <zombieplague>

#define PLUGIN_NAME "【CS插件专区提醒你】 Extra:Antidote Bomb"
#define PLUGIN_VERSION "1.0"
#define PLUGIN_AUTHOR "Jim"

//#define FIRST_ZOMBIE_EXCEPTION 	//解毒炸弹的效用对第一隻丧尸无效.(在最前面加上 // 即是取消这项设定)

#define Nade_Trail_RGB_Red 200		//炸弹拖尾颜色的RGB (Red) 设定值
#define Nade_Trail_RGB_Green 200	//炸弹拖尾颜色的RGB (Green) 设定值
#define Nade_Trail_RGB_Blue 0		//炸弹拖尾颜色的RGB (Blue) 设定值

#define Nade_Blast_RGB_Red 200		//炸弹爆炸效果颜色的RGB (Red) 设定值
#define Nade_Blast_RGB_Green 200	//炸弹爆炸效果颜色的RGB (Green) 设定值
#define Nade_Blast_RGB_Blue 0		//炸弹爆炸效果颜色的RGB (Blue) 设定值

const Float:NADE_EXPLOSION_RADIUS = 240.0 //解毒炸弹的有效作用范围

new const model_grenade_fire[] = { "models/zombie_plague/v_grenade_fire.mdl" } //持火焰弹的手部 v_ 模型
new const model_grenade_adbomb[] = { "models/zombie_plague/v_grenade_antidote.mdl" } //持解毒炸弹的手部 v_ 模型
new const sound_buyammo[] = { "items/9mmclip1.wav" } //购买了解毒炸弹时的声音
new const sound_weap_select[] = { "common/wpn_select.wav" } //选择切换解毒炸弹和火焰弹时的声音
new const sound_adbomb_explo[] = { "zombie_plague/grenade_antidote.wav" } //解毒炸弹爆炸时的音效

new const g_item_name[] = { "T-病毒.解毒炸弹" }; //特殊道具名称
new const g_item_cost = 1; //购买解毒炸弹一次要花多少子弹包

// CS Offsets (win32)
const OFFSET_AWM_AMMO  = 377 
const OFFSET_SCOUT_AMMO = 378
const OFFSET_PARA_AMMO = 379
const OFFSET_FAMAS_AMMO = 380
const OFFSET_M3_AMMO = 381
const OFFSET_USP_AMMO = 382
const OFFSET_FIVESEVEN_AMMO = 383
const OFFSET_DEAGLE_AMMO = 384
const OFFSET_P228_AMMO = 385
const OFFSET_GLOCK_AMMO = 386
const OFFSET_FLASH_AMMO = 387
const OFFSET_HE_AMMO = 388
const OFFSET_SMOKE_AMMO = 389
const OFFSET_C4_AMMO = 390

// Ammo Offsets for weapons
new const AMMOOFFSET[] = { -1, OFFSET_P228_AMMO, -1, OFFSET_SCOUT_AMMO, OFFSET_HE_AMMO, OFFSET_M3_AMMO, OFFSET_C4_AMMO,
			OFFSET_USP_AMMO, OFFSET_FAMAS_AMMO, OFFSET_SMOKE_AMMO, OFFSET_GLOCK_AMMO, OFFSET_FIVESEVEN_AMMO,
			OFFSET_USP_AMMO, OFFSET_FAMAS_AMMO, OFFSET_FAMAS_AMMO, OFFSET_FAMAS_AMMO, OFFSET_USP_AMMO,
			OFFSET_GLOCK_AMMO, OFFSET_AWM_AMMO, OFFSET_GLOCK_AMMO, OFFSET_PARA_AMMO, OFFSET_M3_AMMO,
			OFFSET_FAMAS_AMMO, OFFSET_GLOCK_AMMO, OFFSET_SCOUT_AMMO, OFFSET_FLASH_AMMO, OFFSET_DEAGLE_AMMO,
			OFFSET_FAMAS_AMMO, OFFSET_SCOUT_AMMO, -1, OFFSET_FIVESEVEN_AMMO }

const OFFSET_LINUX = 5 // offsets 5 higher in Linux builds
const PEV_NADE_TYPE = pev_flTimeStepSound
const NADE_TYPE_ADBOMB = 5555

new g_itemid_adbomb
new g_take_adbomb_num
new have_adbomb_num[33]
new bool:hit_key[33]
new bool:hegrenade_is_adbomb[33], bool:use_hegrenade[33]
new bool:set_adbomb_num[33]
new g_trailSpr, g_shokewaveSpr

public plugin_precache()
{
	engfunc(EngFunc_PrecacheModel, model_grenade_fire)
	engfunc(EngFunc_PrecacheModel, model_grenade_adbomb)
	engfunc(EngFunc_PrecacheSound, sound_buyammo)
	engfunc(EngFunc_PrecacheSound, sound_weap_select)
	engfunc(EngFunc_PrecacheSound, sound_adbomb_explo)
	g_trailSpr = engfunc(EngFunc_PrecacheModel, "sprites/laserbeam.spr")
	g_shokewaveSpr = engfunc(EngFunc_PrecacheModel, "sprites/shockwave.spr")
}

public plugin_init()
{
        register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	
	g_take_adbomb_num = register_cvar("zp_take_adbomb_num", "10") //最多一次能携带多少颗解毒炸弹
	
	register_clcmd("say /adbomb", "buy_adbomb")
	register_clcmd("say_team /adbomb", "buy_adbomb")
	
	RegisterHam(Ham_Think, "grenade", "fw_ThinkGrenade")
	register_forward(FM_SetModel, "fw_SetModel")
	register_event("CurWeapon", "event_curweapon", "be", "1=1")
	register_event("DeathMsg", "Death", "a")
	register_event("HLTV", "event_round_start", "a", "1=0", "2=0")
	
	g_itemid_adbomb = zp_register_extra_item(g_item_name, g_item_cost, ZP_TEAM_HUMAN)
}

public zp_extra_item_selected(id, itemid)
{
	if (itemid == g_itemid_adbomb)
	{
		if (!zp_has_round_started())
		{
			zp_set_user_ammo_packs(id, zp_get_user_ammo_packs(id) + g_item_cost)
			client_print(id, print_chat, "【CS插件专区提醒你】 必须在丧尸出现之后才能购买.")
			return PLUGIN_CONTINUE
		}
		
		if (zp_is_nemesis_round() || zp_is_survivor_round() || zp_is_swarm_round() || zp_is_plague_round())
		{
			zp_set_user_ammo_packs(id, zp_get_user_ammo_packs(id) + g_item_cost)
			client_print(id, print_chat, "【CS插件专区提醒你】 只有在感染模式的回合中才能购买.")
			return PLUGIN_CONTINUE
		}
		
		if (have_adbomb_num[id] >= get_pcvar_num(g_take_adbomb_num))
		{
			zp_set_user_ammo_packs(id, zp_get_user_ammo_packs(id) + g_item_cost)
			client_print(id, print_chat, "【CS插件专区提醒你】 你不能携带更多的解毒炸弹! 最多只能携带%d颗.", get_pcvar_num(g_take_adbomb_num))
			return PLUGIN_CONTINUE
		}
		
		have_adbomb_num[id]++
		new hegrenade_num = fm_get_user_bpammo(id, CSW_HEGRENADE)
		
		if (hegrenade_num <= 0)
		{
			fm_give_item(id, "weapon_hegrenade")
		}
		else
		{
			fm_set_user_bpammo(id, CSW_HEGRENADE, hegrenade_num + 1)
			engfunc(EngFunc_EmitSound, id, CHAN_ITEM, sound_buyammo, 1.0, ATTN_NORM, 0, PITCH_NORM)
		}
		
		show_adbomb_num_message(id, have_adbomb_num[id])
		client_print(id, print_chat, "【CS插件专区提醒你】 你已购买了解毒炸弹.")
	}
	
	return PLUGIN_CONTINUE
}

public buy_adbomb(id)
{
	if (!zp_has_round_started())
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 必须在丧尸出现之后才能购买.")
		return PLUGIN_HANDLED
	}
	
	if (zp_is_nemesis_round() || zp_is_survivor_round() || zp_is_swarm_round() || zp_is_plague_round())
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 只有在感染模式的回合中才能购买.")
		return PLUGIN_HANDLED
	}
	
	if (!is_user_alive(id))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 你已经死掉了,不能购买解毒炸弹.")
		return PLUGIN_HANDLED
	}
	
	if (zp_get_user_zombie(id))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 你不是人类,不能购买解毒炸弹.")
		return PLUGIN_HANDLED
	}
	
	if (zp_get_user_survivor(id))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 你是倖存者,不能购买解毒炸弹.")
		return PLUGIN_HANDLED
	}
	
	if (have_adbomb_num[id] >= get_pcvar_num(g_take_adbomb_num))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 你不能携带更多的解毒炸弹! 最多只能携带%d颗.", get_pcvar_num(g_take_adbomb_num))
		return PLUGIN_HANDLED
	}
	
	new money = zp_get_user_ammo_packs(id)
	
	if (money < g_item_cost)
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 你没有足够的子弹包来购买解毒炸弹.")
		return PLUGIN_HANDLED
	}
	
	zp_set_user_ammo_packs(id, money - g_item_cost)
	have_adbomb_num[id]++
	new hegrenade_num = fm_get_user_bpammo(id, CSW_HEGRENADE)
	
	if (hegrenade_num <= 0)
	{
		fm_give_item(id, "weapon_hegrenade")
	}
	else
	{
		fm_set_user_bpammo(id, CSW_HEGRENADE, hegrenade_num + 1)
		engfunc(EngFunc_EmitSound, id, CHAN_ITEM, sound_buyammo, 1.0, ATTN_NORM, 0, PITCH_NORM)
	}
	
	show_adbomb_num_message(id, have_adbomb_num[id])
	client_print(id, print_chat, "【CS插件专区提醒你】 你已购买了解毒炸弹.")
	
	return PLUGIN_CONTINUE
}

public fw_SetModel(entity, const model[])
{
	// Get damage time of grenade
	static Float:dmgtime
	pev(entity, pev_dmgtime, dmgtime)
	
	// Grenade not yet thrown
	if (dmgtime == 0.0)
		return;
	
	new owner = pev(entity, pev_owner)
	
	if (equal(model[7], "w_he", 4)) // Use hegrenade
	{
		use_hegrenade[owner] = true
		set_adbomb_num[owner] = false
		
		if (hegrenade_is_adbomb[owner])
		{
			// Give it a glow
			fm_set_rendering(entity, kRenderFxGlowShell, Nade_Trail_RGB_Red, Nade_Trail_RGB_Green, Nade_Trail_RGB_Blue, kRenderNormal, 16);
			
			// And a colored trail
			message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
			write_byte(TE_BEAMFOLLOW) // TE id
			write_short(entity) // entity
			write_short(g_trailSpr) // sprite
			write_byte(10) // life
			write_byte(10) // width
			write_byte(Nade_Trail_RGB_Red) // r
			write_byte(Nade_Trail_RGB_Green) // g
			write_byte(Nade_Trail_RGB_Blue) // b
			write_byte(200) // brightness
			message_end()
		}
	}
	else
	{
		use_hegrenade[owner] = false
	}
}

// Ham Grenade Think Forward
public fw_ThinkGrenade(entity)
{
	//Invalid entity
	if (!pev_valid(entity)) 
		return FMRES_IGNORED;
	
	new owner = pev(entity, pev_owner)
	
	if (use_hegrenade[owner] && !set_adbomb_num[owner])
	{
		set_adbomb_num[owner] = true
		new hegrenade_num = fm_get_user_bpammo(owner, CSW_HEGRENADE)
		
		if (hegrenade_is_adbomb[owner])
		{
			have_adbomb_num[owner]--
			
			if ((have_adbomb_num[owner] <= 0) && (hegrenade_num > 0))
			{
				hegrenade_is_adbomb[owner] = false
				set_pev(owner, pev_viewmodel2, model_grenade_fire)
			}
			
			// Set grenade type on the thrown grenade entity
			set_pev(entity, PEV_NADE_TYPE, NADE_TYPE_ADBOMB)
		}
		else
		{
			//检查是否拥有的解毒炸弹数量刚好和手榴弹数量相同,是的话则剩下的手榴弹都是解毒炸弹
			if (have_adbomb_num[owner] == hegrenade_num)
			{
				engfunc(EngFunc_EmitSound, owner, CHAN_ITEM, sound_weap_select, 1.0, ATTN_NORM, 0, PITCH_NORM)
				hegrenade_is_adbomb[owner] = true
				set_pev(owner, pev_viewmodel2, model_grenade_adbomb)
				show_adbomb_num_message(owner, have_adbomb_num[owner])
			}
		}
	}
	
	// Get damage time of grenade
	static Float:damage_time
	pev(entity, pev_dmgtime, damage_time)
	
	// Check if it's time to go off
	if (damage_time > get_gametime())
		return HAM_IGNORED;
	
	// Check if it's antidote bomb
	if (pev(entity, PEV_NADE_TYPE) == NADE_TYPE_ADBOMB)
	{
		adbomb_explode(entity)
		return HAM_SUPERCEDE;
	}
	
	return HAM_IGNORED;
}

public event_curweapon(id)
{
	if (!is_user_alive(id))
		return PLUGIN_CONTINUE
	
	if (have_adbomb_num[id] <= 0)
		return PLUGIN_CONTINUE
	
	// Get user current weapon id
	static weapon_id, clip, ammo
	weapon_id = get_user_weapon(id, clip, ammo)
	
	if (weapon_id == CSW_HEGRENADE)
	{
		//检查是否拥有的解毒炸弹数量刚好和手榴弹数量相同,是的话则剩下的手榴弹都是解毒炸弹
		if (have_adbomb_num[id] == ammo)
			hegrenade_is_adbomb[id] = true
		
		//检查是否是设定成使用解毒炸弹
		if (hegrenade_is_adbomb[id])
		{
			set_pev(id, pev_viewmodel2, model_grenade_adbomb)
			show_adbomb_num_message(id, have_adbomb_num[id])
		}
		else
		{
			set_pev(id, pev_viewmodel2, model_grenade_fire)
		}
	}
	
	return PLUGIN_CONTINUE
}


adbomb_explode(ent)
{
	// Get origin
	static Float:originF[3]
	pev(ent, pev_origin, originF)
	
	// Make the explosion
	create_blast(originF, Nade_Blast_RGB_Red, Nade_Blast_RGB_Green, Nade_Blast_RGB_Blue, 200)
	
	// Antidote bomb explode sound
	engfunc(EngFunc_EmitSound, ent, CHAN_WEAPON, sound_adbomb_explo, 1.0, ATTN_NORM, 0, PITCH_NORM)
	
	// Collisions
	static target
	target = -1
	
	while ((target = engfunc(EngFunc_FindEntityInSphere, target, originF, NADE_EXPLOSION_RADIUS)) != 0)
	{
		// Only effect alive zombies, but not nemesis.
		if (!is_user_alive(target) || !zp_get_user_zombie(target) || zp_get_user_nemesis(target))
			continue;
		
		#if defined FIRST_ZOMBIE_EXCEPTION
		if (zp_get_user_first_zombie(target))
			continue;
		#endif
		
		zp_disinfect_user(target)
	}
	
	// Get rid of the grenade
	engfunc(EngFunc_RemoveEntity, ent)
}

show_adbomb_num_message(id, num)
{
	set_hudmessage(0, 200, 0, 0.01, 0.72, 0, 0.0, 3.0, 0.1, 0.2, -1)
	show_hudmessage(id, "解毒炸弹:%d颗", num)
}

public client_PreThink(id)
{
	if (!is_user_alive(id) || zp_get_user_zombie(id))
		return PLUGIN_CONTINUE
	
	if (have_adbomb_num[id] <= 0)
		return PLUGIN_CONTINUE
	
	static button, oldbutton
	button = pev(id, pev_button)
	oldbutton = pev(id, pev_oldbuttons)
	
	if ((button & IN_RELOAD) && (oldbutton & IN_RELOAD))
	{
		if (!hit_key[id])
		{
			hit_key[id] = true
			
			// Get user current weapon id
			static weapon_id, clip, ammo
			weapon_id = get_user_weapon(id, clip, ammo)
			
			if (weapon_id == CSW_HEGRENADE)
			{
				//检查是否拥有的解毒炸弹数量刚好和手榴弹数量相同,是的话则剩下的手榴弹都是解毒炸弹
				if (have_adbomb_num[id] == ammo)
				{
					if (!hegrenade_is_adbomb[id])
						engfunc(EngFunc_EmitSound, id, CHAN_ITEM, sound_weap_select, 1.0, ATTN_NORM, 0, PITCH_NORM)
					
					hegrenade_is_adbomb[id] = true
				}
				else
				{
					engfunc(EngFunc_EmitSound, id, CHAN_ITEM, sound_weap_select, 1.0, ATTN_NORM, 0, PITCH_NORM)
					
					hegrenade_is_adbomb[id] = !hegrenade_is_adbomb[id]
				}
				
				//检查是否是设定成使用解毒炸弹
				if (hegrenade_is_adbomb[id])
				{
					set_pev(id, pev_viewmodel2, model_grenade_adbomb)
					show_adbomb_num_message(id, have_adbomb_num[id])
				}
				else
				{
					set_pev(id, pev_viewmodel2, model_grenade_fire)
				}
			}
		}
	}
	else
	{
		hit_key[id] = false
	}
	
	return PLUGIN_CONTINUE
}

public zp_user_infected_post(id, infector)
{
	have_adbomb_num[id] = 0
	hegrenade_is_adbomb[id] = false
}

public client_connect(id)
{
	have_adbomb_num[id] = 0
	hegrenade_is_adbomb[id] = false
	return PLUGIN_CONTINUE
}

public client_disconnect(id)
{
	have_adbomb_num[id] = 0
	hegrenade_is_adbomb[id] = false
	return PLUGIN_CONTINUE
}

public Death()
{
	new player = read_data(2)
	have_adbomb_num[player] = 0
	hegrenade_is_adbomb[player] = false
}

public event_round_start()
{
	for (new i = 1; i <= 32; i++)
	{
		have_adbomb_num[i] = 0
		hegrenade_is_adbomb[i] = false
	}
}

create_blast(const Float:originF[3], red, green, blue, brightness)
{
	// Smallest ring ##小的光环
	engfunc(EngFunc_MessageBegin, MSG_PVS, SVC_TEMPENTITY, originF, 0)
	write_byte(TE_BEAMCYLINDER) // TE id: 21
	engfunc(EngFunc_WriteCoord, originF[0]) // x
	engfunc(EngFunc_WriteCoord, originF[1]) // y
	engfunc(EngFunc_WriteCoord, originF[2]) // z
	engfunc(EngFunc_WriteCoord, originF[0]) // x axis
	engfunc(EngFunc_WriteCoord, originF[1]) // y axis
	engfunc(EngFunc_WriteCoord, originF[2]+385.0) // z axis
	write_short(g_shokewaveSpr) // sprite
	write_byte(0) // startframe
	write_byte(0) // framerate
	write_byte(4) // life
	write_byte(60) // width
	write_byte(0) // noise
	write_byte(red) // red
	write_byte(green) // green
	write_byte(blue) // blue
	write_byte(brightness) // brightness
	write_byte(0) // speed
	message_end()
	
	// Medium ring ##中的光环
	engfunc(EngFunc_MessageBegin, MSG_PVS, SVC_TEMPENTITY, originF, 0)
	write_byte(TE_BEAMCYLINDER) // TE id: 21
	engfunc(EngFunc_WriteCoord, originF[0]) // x
	engfunc(EngFunc_WriteCoord, originF[1]) // y
	engfunc(EngFunc_WriteCoord, originF[2]) // z
	engfunc(EngFunc_WriteCoord, originF[0]) // x axis
	engfunc(EngFunc_WriteCoord, originF[1]) // y axis
	engfunc(EngFunc_WriteCoord, originF[2]+470.0) // z axis
	write_short(g_shokewaveSpr) // sprite
	write_byte(0) // startframe
	write_byte(0) // framerate
	write_byte(4) // life
	write_byte(60) // width
	write_byte(0) // noise
	write_byte(red) // red
	write_byte(green) // green
	write_byte(blue) // blue
	write_byte(brightness) // brightness
	write_byte(0) // speed
	message_end()
	
	// Largest ring ##大的光环
	engfunc(EngFunc_MessageBegin, MSG_PVS, SVC_TEMPENTITY, originF, 0)
	write_byte(TE_BEAMCYLINDER) // TE id: 21
	engfunc(EngFunc_WriteCoord, originF[0]) // x
	engfunc(EngFunc_WriteCoord, originF[1]) // y
	engfunc(EngFunc_WriteCoord, originF[2]) // z
	engfunc(EngFunc_WriteCoord, originF[0]) // x axis
	engfunc(EngFunc_WriteCoord, originF[1]) // y axis
	engfunc(EngFunc_WriteCoord, originF[2]+555.0) // z axis
	write_short(g_shokewaveSpr) // sprite
	write_byte(0) // startframe
	write_byte(0) // framerate
	write_byte(4) // life
	write_byte(60) // width
	write_byte(0) // noise
	write_byte(red) // red
	write_byte(green) // green
	write_byte(blue) // blue
	write_byte(brightness) // brightness
	write_byte(0) // speed
	message_end()
}

stock fm_give_item(id, const item[])
{
	static ent
	ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, item))
	if (!pev_valid(ent)) return;
	
	static Float:originF[3]
	pev(id, pev_origin, originF)
	set_pev(ent, pev_origin, originF)
	set_pev(ent, pev_spawnflags, pev(ent, pev_spawnflags) | SF_NORESPAWN)
	dllfunc(DLLFunc_Spawn, ent)
	
	static save
	save = pev(ent, pev_solid)
	dllfunc(DLLFunc_Touch, ent, id)
	if (pev(ent, pev_solid) != save)
		return;
	
	engfunc(EngFunc_RemoveEntity, ent)
}

stock fm_get_user_bpammo(id, weaponid)
{
	return get_pdata_int(id, AMMOOFFSET[weaponid], OFFSET_LINUX);
}

stock fm_set_user_bpammo(id, weaponid, amount)
{
	set_pdata_int(id, AMMOOFFSET[weaponid], amount, OFFSET_LINUX)
}

stock fm_set_rendering(entity, fx = kRenderFxNone, r = 255, g = 255, b = 255, render = kRenderNormal, amount = 16) 
{
	new Float:RenderColor[3];
	RenderColor[0] = float(r);
	RenderColor[1] = float(g);
	RenderColor[2] = float(b);
	
	set_pev(entity, pev_renderfx, fx);
	set_pev(entity, pev_rendercolor, RenderColor);
	set_pev(entity, pev_rendermode, render);
	set_pev(entity, pev_renderamt, float(amount));
	
	return 1;
}

