/*================================================================================
	
	--------------------------------------
	-*- [zsy314提醒您] 自定义道具:电池 1.0 -*-
	--------------------------------------
	
	~~~~~~~~~~~~~~~
	- Description -
	~~~~~~~~~~~~~~~
	
	This upgrade gives humans fully charged flashlight's batteries. It's
	meant to be used with zp_flash_charge 0 (so that they aren't refilled
	automatically). It brings more realism to the game and makes it
	challenging especially in dark maps.
	
	~~~~~~~~~~~~~~
	- Known bugs -
	~~~~~~~~~~~~~~
	
	* Currently only works with the custom flashlight
	
	~~~~~~~~~~~~~~
	- Credits to -
	~~~~~~~~~~~~~~
	
	* Stixsmaster: for the idea
	* soccdood: for how to go about coding it
	
================================================================================*/

#include <amxmodx>
#include <hamsandwich>
#include <zombieplague>

/*================================================================================
 [Plugin Customization]
=================================================================================*/

new const g_item_name[] = { "电池" }
const g_item_cost = 7

new const g_buy_message[] = { "[CS插件专区提醒您]你更换了手电的电池." }

/*============================================================================*/

new g_itemid_batteries, g_batterystatus[33], g_msgFlashBat

public plugin_init()
{
	register_plugin("[CS插件专区提醒您] Extra: Batteries", "1.0", "soccdood/MeRcyLeZZ")
	
	g_itemid_batteries = zp_register_extra_item(g_item_name, g_item_cost, ZP_TEAM_HUMAN)
	
	RegisterHam(Ham_Spawn, "player", "fw_PlayerSpawn")
	
	g_msgFlashBat = get_user_msgid("FlashBat")
}

// Ham Player Spawn Forward
public fw_PlayerSpawn(id)
{
	// Retrieve battery status before player spawns
	g_batterystatus[id] = zp_get_user_batteries(id)
	
	// Set a task to restore it some time after
	set_task(0.5, "set_batteries", id)
	
	// Note: this should get around ZP refilling
	// our batteries on every respawn
}
public set_batteries(id)
{
	zp_set_user_batteries(id, g_batterystatus[id])
}

// Human buys batteries
public zp_extra_item_selected(player, itemid)
{
	if (itemid == g_itemid_batteries)
	{		
		// Give him the batteries
		client_print(player, print_chat, g_buy_message)
		zp_set_user_batteries(player, 100)
		g_batterystatus[player] = 100
		
		// Update his HUD
		message_begin(MSG_ONE, g_msgFlashBat, _, player)
		write_byte(100) // battery
		message_end()
	}
}
