/*======================================================================================
/
/					[提醒你] Extra Item : Flamethrower
/					   ( weapon for HUMANS )
/				
/						by The_Thing
/
/
/
/	Description :
/
/		Now on Zombie mod has appeared new weapon, that is Flamethrower.
/		You can burn zombies alive, but don't forget that this weapon will cost to You some ammo packs.
/
/
/
/	Cvars :
/
/		zp_ft_enable <1|0> 		- 打开或关闭，默认值为1.
/		zp_ft_admin_can_buy <1|0> 	- 只有管理员可以买喷火器，默认为0
/		zp_ft_client_buy <1|0> 		- 这意味着，你可以购买这种武器，默认值是1.
/		zp_ft_obey_buyzone <1|0> 	- 这意味着，您必须购买它只有当您的buyzone ，默认为0.
/		zp_ft_obey_buytime <1|0> 	- 这就是说，你只能买buyzone秒，如果没有通过，预设值为0.
/		zp_ft_cost "25" 		- 这意味着多少喷火器费用。.
/		zp_ft_fuelcost "5" 		- 多少燃料的火焰喷射器将成本.
/		zp_ft_fueltank "55" 		- 多少燃料弹药将在剪辑.
/		zp_ft_damage "250" 		- 多少会损害到僵尸 .
/		zp_ft_xplode_dmg "90" 		- 多少损害将是是否会发生爆炸.
/		zp_ft_damage_dis "120" 		- 有多远，您可以拍摄火焰.
/		zp_ft_splash_dis "40" 		- 有多远消防将启动.
/		zp_ft_ammo_after_kill "15"	- 多少弹药包，您会收到当你杀僵尸
/		zp_ft_frags_after_kill "5"	- 多少frags你可以当你杀僵尸
/	
/	
/
/	Admin Commands :
/
/		Need BAN access.
/
/		ft_give <@all/ct> - gives flamethrower
/
/
/
/	Commands :
/
/		To buy flamethrower You can use chat messages too.
/		say /bft to buy flamethrower 
/	or	say_team /bft
/
/
/
/	Credits :
/
/		Cheap_Suit - For his flamethrower plugin. :)
/
/
/
/	Changelog :
/
/		29/10/2008 - v0.1 - First release
/		31/10/2008 - v0.3 - rewrited all plugin, fixed some of my mistakes
/		01/11/2008 - v0.4 - completely fixed bug due zombies could use flamethrower to kill humans.
/		03/11/2008 - v0.4.1 - removed one annoying code line due players after dropcan't pick up it again.
/		06/11/2008 - v0.5 - added feature that admins can buy this weapon only, added after you kill somebody you can get some ammo packs, added you can change by cvar how much frags you will gain after you kill zombie, added how much ammo packs you will lose when you kill a team mate and how much frags you will lose when kill a team mate.
/		12/11/2008 - v0.7 - fixed index of bounds, and posibility that zombie sometimes still has a flamethrower, fixed that zombie can't drop flamethrower all the time, fixed friendly fire work too, so you can't kill team mate anymore, so I removed lose frags and ammo packs if kill team mate.
/		22/11/2008 - v0.8 - after infection your flamethrower will be removed now and removed cstrike and fun module.
/
*/


#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <engine>
#include <csx>
#include <xs>
#include <zombieplague>

#define FLAMETHROWER_LEVEL ADMIN_LEVEL_A

new wpn_ft
new sprite_fire, sprite_burn, sprite_xplo
new g_freezetime, g_restarted
new Float:g_starttime
new g_enabled, g_client_buy, g_damage, g_xplode_dmg
new g_cost, g_fuelcost, g_fueltank, g_ft_buyzone, g_buytime, g_damage_dis, g_splash_dis
new g_buyzone[33], g_FuelTank[33], g_Activated[33]
new Float:g_Delay[33]
new g_hasFlamethrower[33], g_FireFlamethrower[33], g_BuyFuel[33]

new g_item_name[] = { "火焰喷射器" }
new g_itemid_flamethrower, g_admin_can_buy, g_ammo_after_kill, g_frags_after_kill

static PLUGIN_NAME[] 	= "[提醒你] Extra : 火焰喷射器"
static PLUGIN_AUTHOR[] 	= "The_Thing"
static PLUGIN_VERSION[] = "0.8"

public plugin_init()
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	register_cvar("ft_version", PLUGIN_VERSION, FCVAR_SERVER)
	
	g_enabled = register_cvar("zp_ft_enable", 			"1")
	g_admin_can_buy = register_cvar("zp_ft_admin_can_buy",		"0")
	g_client_buy = register_cvar("zp_ft_client_buy", 		"1")
	g_ft_buyzone = register_cvar("zp_ft_obey_buyzone", 		"0")
	g_buytime = register_cvar("zp_ft_obey_buytime", 			"0")
	g_cost = register_cvar("zp_ft_cost", 				"25")
	g_fuelcost = register_cvar("zp_ft_fuelcost", 			"5")
	g_fueltank = register_cvar("zp_ft_fueltank", 			"55")
	g_damage = register_cvar("zp_ft_damage", 			"250")
	g_xplode_dmg = register_cvar("zp_ft_xplode_dmg", 		"90")
	g_damage_dis = register_cvar("zp_ft_damage_dis", 		"120")
	g_splash_dis = register_cvar("zp_ft_splash_dis", 		"40")
	g_ammo_after_kill = register_cvar("zp_ft_ammo_after_kill", 	"15")
	g_frags_after_kill = register_cvar("zp_ft_frags_after_kill", 	"5")

	g_itemid_flamethrower = zp_register_extra_item(g_item_name, get_pcvar_num(g_cost), ZP_TEAM_HUMAN)
	
	register_concmd("bft", 		"cmd_BuyFlamethrower", 	ADMIN_USER, "- Buys a flamethrower")
	register_clcmd("say /bft", 	"cmd_BuyFlamethrower", 	ADMIN_USER, "- Buys a flamethrower")
	register_clcmd("say_team /bft", "cmd_BuyFlamethrower", 	ADMIN_USER, "- Buys a flamethrower")
	register_clcmd("ft_give",	"cmd_GiveFlamethrowers",ADMIN_BAN,  "<@all/ct>/userid - Gives free flamethrowers")
		
	register_event("DeathMsg",  	"Event_DeathMsg", 	"a")
	register_event("CurWeapon", 	"Event_CurWeapon", 	"be", 	"1=1")
	register_event("StatusIcon", 	"Event_BuyZone",  	"b", 	"2=buyzone")
	register_event("HLTV", 		"Event_NewRound", 	"a", 	"1=0", "2=0")
	register_event("TextMsg", 	"Event_WeaponDrop", 	"be", 	"2=#Weapon_Cannot_Be_Dropped")
	register_event("TextMsg", 	"Event_GameRestart", 	"a", 	"2=#Game_Commencing", 	"2=#Game_will_restart_in")
	register_logevent("LogEvent_RoundStart", 		 2, 	"0=World triggered",	"1=Round_Start")
	
	register_forward(FM_CmdStart,		"fw_CmdStart")
	register_forward(FM_PlayerPostThink, 	"fw_PlayerPostThink")
	register_forward(FM_UpdateClientData, 	"fw_UpdateClientData_Post", 1)
	
	register_think("flamethrower", "think_Flamethrower")
	register_touch("flamethrower", "player", "touch_Flamethrower")
	wpn_ft = custom_weapon_add("weapon_flamethrower", 0, "flamethrower")
	
	if(!get_pcvar_num(g_enabled)) pause("ad", PLUGIN_NAME)
}

public plugin_precache()
{
	precache_sound("flamethrower.wav")
	precache_sound("items/ammopickup2.wav")
	
	sprite_xplo = precache_model("sprites/zerogxplode.spr")
	sprite_fire = precache_model("sprites/explode1.spr")
	sprite_burn = precache_model("sprites/xfire.spr")
	
	precache_model("models/v_knife.mdl")
	precache_model("models/p_knife.mdl")
	precache_model("models/shield/v_shield_knife.mdl")
	precache_model("models/shield/p_shield_knife.mdl")
	precache_model("models/w_flamethrower.mdl")
	precache_model("models/v_flamethrower.mdl")
	precache_model("models/p_flamethrower.mdl")
}

public cmd_GiveFlamethrowers(id, level, cid) 
{
	if(!cmd_access(id, level, cid, 2))
		return PLUGIN_HANDLED

	new Arg1[64], target
	read_argv(1, Arg1, 63)
	
	new adminName[32]
	get_user_name(id, adminName, 31)
	
	new targetTeam
	new Players[32], iNum
	if(Arg1[0] == '@') 
	{
		if(equali(Arg1[1], "all")) 
		{
			targetTeam = 0
			get_players(Players, iNum, "a")
		} 
		
		else if(equali(Arg1[1], "ct")) 
		{
			targetTeam = 2
			get_players(Players, iNum, "ae" , "ct")
		}
		
		for(new i = 0; i < iNum; ++i)
		{
			target = Players[i]
			
			g_hasFlamethrower[target] = 1
			g_FuelTank[target] = get_pcvar_num(g_fueltank)
			
			new temp[2], weaponID = get_user_weapon(target, temp[0], temp[1])
			if(weaponID == CSW_KNIFE) 
			{
				g_Activated[target] = true
				set_flamethrower_model(target)
			}
			
			client_cmd(target, "spk items/ammopickup2")
			client_print(target, print_chat, "[提醒你] 您已经给喷火器 (记者3日至使用)")
		}
		
		switch(targetTeam)
		{
			case 0: client_print(0, print_chat, "Admin: %s has given everyone a flamethrower", adminName)
			case 2: client_print(0, print_chat, "Admin: %s has given all ct's a flamethrower", adminName)
		}
	}
	else
	{
		target = cmd_target(id, Arg1, 0)
		if(!is_user_connected(target) || !is_user_alive(target) || !zp_get_user_zombie(target))
			return PLUGIN_HANDLED
	
		new targetName[32]
		get_user_name(target, targetName, 31)
		
		g_hasFlamethrower[target] = 1
		g_FuelTank[target] = get_pcvar_num(g_fueltank)
		
		new temp[2], weaponID = get_user_weapon(target, temp[0], temp[1])
		if(weaponID == CSW_KNIFE) 
		{
			g_Activated[target] = true
			set_flamethrower_model(target)
			entity_set_int(id, EV_INT_weaponanim, 9)
		}
			
		client_cmd(target, "spk items/ammopickup2")
		client_print(target, print_chat, "[提醒你] 您已经给喷火器（按3至使用）")
		client_print(target, print_chat, "[提醒你] 管理: %s 给你一个喷火器", adminName)
	}
	return PLUGIN_HANDLED
}

public cmd_BuyFlamethrower(id)
{
	if(!get_pcvar_num(g_client_buy))
		return PLUGIN_CONTINUE
		
	if (!get_pcvar_num(g_admin_can_buy) && (!access(id, ADMIN_LEVEL_A)))
		return PLUGIN_HANDLED
		
	if(get_pcvar_num(g_ft_buyzone))
	{
		if(!g_buyzone[id])
		{
			client_print(id, print_center, "[提醒你] 你需要在buyzone")
			return PLUGIN_HANDLED
		} 
	}
	
	if(get_pcvar_num(g_buytime))
	{
		new Float:fBuyTime = get_cvar_float("mp_buytime") * 60
		if(!g_freezetime && (get_gametime() - g_starttime) > fBuyTime) 
		{
			client_print(id, print_center, "[提醒你] %d 秒已经过去了.^n您可以不买任何东西现在!", floatround(fBuyTime))
			return PLUGIN_HANDLED
		}
	}
	
	new iMoney = zp_get_user_ammo_packs(id)
	new iCost = get_pcvar_num(g_cost)
	
	if(!is_user_alive(id) && !zp_get_user_zombie(id)) 
		client_print(id, print_center, "[提醒你] 你不能当你买死!")
	else if(g_hasFlamethrower[id])
		client_print(id, print_center, "[提醒你] 你已经拥有的核武器.")
	else if(iMoney < iCost)
		client_print(id, print_center, "[提醒你] 您没有足够的弹药包 (%d)", iCost)
	else
	{
		g_hasFlamethrower[id] = 1
		g_FuelTank[id] = get_pcvar_num(g_fueltank)
		
		new temp[2], weaponID = get_user_weapon(id, temp[0], temp[1])
		if(weaponID == CSW_KNIFE) 
		{
			g_Activated[id] = true
			set_flamethrower_model(id)
		}
		
    		zp_set_user_ammo_packs(id, iMoney - iCost)
		client_cmd(id, "spk items/ammopickup2")
		client_print(id, print_chat, "[提醒你] 您买了喷火器（按3至使用）")
  	}
	
	if (zp_get_user_zombie(id) || g_hasFlamethrower[id])
	{
		new temp[2], weaponID = get_user_weapon(id, temp[0], temp[1])
		if(weaponID == CSW_KNIFE) 
		{
			g_Activated[id] = false
			set_knife_model(id)
		}
	}
	return PLUGIN_HANDLED
}

public zp_extra_item_selected(player, itemid)
{
	if (itemid == g_itemid_flamethrower)
	{
		if (!get_pcvar_num(g_admin_can_buy) && (!access(player, ADMIN_LEVEL_A)))
			return PLUGIN_HANDLED

		if ( is_user_alive(player) && !zp_get_user_zombie(player) )
		{
			g_hasFlamethrower[player] = 1
			g_FuelTank[player] = get_pcvar_num(g_fueltank)
		}
		
		client_cmd(player, "spk items/ammopickup2")
		client_print(player, print_chat, "[提醒你] 您买了喷火器（按3至使用） ")
		
  	}
	
	return PLUGIN_CONTINUE
}

public Event_BuyZone(id) 
{
	g_buyzone[id] = read_data(1)
}

public Event_GameRestart() 
{
	g_restarted = 1
}

public Event_NewRound() 
{
	if(g_restarted)
	{
		new Players[32], iNum = 0
		get_players(Players, iNum)
		for(new i = 0; i < iNum; i++) 
		{
			new id = Players[i]
			
			g_FuelTank[id] = 0
			g_Activated[id] = 0
			g_hasFlamethrower[id] = 0
	
			new temp[2], weaponID = get_user_weapon(id, temp[0], temp[1])
			if(weaponID == CSW_KNIFE) set_knife_model(id)
			
			g_restarted = 0
		}
	}
	
	new flamethrowers = -1
	while((flamethrowers = find_ent_by_class(flamethrowers, "flamethrower")))
		remove_entity(flamethrowers)
	
	g_freezetime = 1
}

public LogEvent_RoundStart()
{
	g_freezetime = 0
	g_starttime = get_gametime()
}

public Event_WeaponDrop(id)
{
	if(!is_user_alive(id) || !g_Activated[id] && zp_get_user_zombie(id))
		return PLUGIN_CONTINUE
	
	drop_flamethrower(id)
	client_print(id, print_center, "")
	
	new flamethrowers = -1
	while((flamethrowers = find_ent_by_class(flamethrowers, "flamethrower")))
		remove_entity(flamethrowers)
	
	return PLUGIN_HANDLED
}

public Event_DeathMsg() 
{ 
	new id = read_data(2)
	if(!is_user_connected(id) || !g_hasFlamethrower[id] && zp_get_user_zombie(id)) 
	{
		return PLUGIN_CONTINUE
	}
	
	drop_flamethrower(id)
	
	new flamethrowers = -1
	while((flamethrowers = find_ent_by_class(flamethrowers, "flamethrower")))
		remove_entity(flamethrowers)
		
	return PLUGIN_CONTINUE
}

public Event_CurWeapon(id)
{
	if(!is_user_alive(id) || zp_get_user_zombie(id) || !g_hasFlamethrower[id])
		return PLUGIN_CONTINUE
		
	if (!get_pcvar_num(g_admin_can_buy) && (!access(id, ADMIN_LEVEL_A)))
		return PLUGIN_HANDLED
	
	new WeaponID = read_data(2)
	switch(WeaponID) 
	{
		case CSW_KNIFE:
		{
			set_task(0.3, "task_ActivateFlamethrower", id)
			set_flamethrower_model(id)
			entity_set_int(id, EV_INT_weaponanim, 9)
		}
		default: g_Activated[id] = 0
	}
	return PLUGIN_CONTINUE
}

public touch_Flamethrower(ent, id)
{
	if(!is_valid_ent(ent) || !is_user_alive(id) || zp_get_user_zombie(id)) 
		return PLUGIN_CONTINUE
		
	if (!get_pcvar_num(g_admin_can_buy) && (!access(id, ADMIN_LEVEL_A)))
		return PLUGIN_HANDLED
	
	if(g_hasFlamethrower[id])
		return PLUGIN_CONTINUE
	
	if(has_shield(id))
		return PLUGIN_CONTINUE
	
	g_hasFlamethrower[id] = 1
	client_cmd(id, "spk items/ammopickup2")
	g_FuelTank[id] = entity_get_int(ent, EV_INT_iuser4)
	show_fuel_percentage(id)
	
	new temp[2], weaponID = get_user_weapon(id, temp[0], temp[1])
	if(weaponID == CSW_KNIFE) 
	{
		g_Activated[id] = true
		set_flamethrower_model(id)
		entity_set_int(id, EV_INT_weaponanim, 9)
	}
	remove_entity(ent)
	
	return PLUGIN_CONTINUE
}

public fw_UpdateClientData_Post(id, sendweapons, cd_handle) 
{
	if(!g_hasFlamethrower[id] || !g_Activated[id])
		return FMRES_IGNORED
		
	set_cd(cd_handle, CD_ID, 0)
	return FMRES_HANDLED
}

public fw_CmdStart(id, uc_handle, seed) 
{
	if(!g_hasFlamethrower[id] || !g_Activated[id])
		return FMRES_IGNORED
	
	new buttons = get_uc(uc_handle, UC_Buttons)
	if(buttons & IN_ATTACK)
	{
		g_FireFlamethrower[id] = 1
	
		buttons &= ~IN_ATTACK
		set_uc(uc_handle, UC_Buttons, buttons)
	} else 
		g_FireFlamethrower[id] = 0
		
	if(buttons & IN_ATTACK2) 
	{
		g_BuyFuel[id] = 1
		
		buttons &= ~IN_ATTACK2
		set_uc(uc_handle, UC_Buttons, buttons)
	} else 
		g_BuyFuel[id] = 0
	return FMRES_HANDLED
}

public fw_PlayerPostThink(id)
{
	if(!is_user_connected(id) || !is_user_alive(id) || zp_get_user_zombie(id) && !zp_get_user_zombie(id)) 
		return FMRES_IGNORED
		
	if(!get_pcvar_num(g_admin_can_buy) && (!access(id, ADMIN_LEVEL_A)))
		return FMRES_IGNORED
		
	if(!g_hasFlamethrower[id] || !g_Activated[id])
		return FMRES_IGNORED
		
	if(entity_get_int(id, EV_INT_waterlevel) > 1)
		return FMRES_IGNORED

	if(has_shield(id))
	{
		drop_flamethrower(id)
		return FMRES_IGNORED
	}
		
	if(g_BuyFuel[id])
	{
		if((g_Delay[id] + 0.2) < get_gametime())
		{
			buy_fuel(id)
			g_Delay[id] = get_gametime()
		}
	}
	
	if(g_FireFlamethrower[id])
	{
		if(g_FuelTank[id] > 0)
		{
			if((g_Delay[id] + 0.2) < get_gametime())
			{
				g_FuelTank[id] -= 1
				g_Delay[id] = get_gametime()
			}
			
			new Float:fOrigin[3], Float:fVelocity[3]
			entity_get_vector(id,EV_VEC_origin, fOrigin)
			VelocityByAim(id, 35, fVelocity)
		
			new Float:fTemp[3], iFireOrigin[3]
			xs_vec_add(fOrigin, fVelocity, fTemp)
			FVecIVec(fTemp, iFireOrigin)
			
			new Float:fFireVelocity[3], iFireVelocity[3]
			VelocityByAim(id, get_pcvar_num(g_damage_dis), fFireVelocity)
			FVecIVec(fFireVelocity, iFireVelocity)
			
			create_flames_n_sounds(id, iFireOrigin, iFireVelocity)
			
			new doDamage
			switch(get_cvar_num("mp_friendlyfire"))
			{
				case 0: doDamage = 0
				case 1: doDamage = 1
			}
			
			show_fuel_percentage(id)
			direct_damage(id, doDamage)
			indirect_damage(id, doDamage)
			custom_weapon_shot(wpn_ft, id)
		} else
			client_print(id, print_center, "Sorry, Out of Fuel")
	}
	return FMRES_IGNORED
}

public think_Flamethrower(ent)
{
	if(is_valid_ent(ent) && entity_get_float(ent, EV_FL_health) < 950.0) 
	{
		new Float:fOrigin[3], iOrigin[3]
		entity_get_vector(ent, EV_VEC_origin, fOrigin)
		FVecIVec(fOrigin, iOrigin)
	
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(99)
		write_short(ent)
		message_end()
	
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(3)
		write_coord(iOrigin[0])
		write_coord(iOrigin[1])
		write_coord(iOrigin[2])
		write_short(sprite_xplo)
		write_byte(50)
		write_byte(15)
		write_byte(0)
		message_end()
		
		RadiusDamage(fOrigin, get_pcvar_num(g_xplode_dmg), entity_get_int(ent, EV_INT_iuser4))
		remove_entity(ent)
	}
	if(is_valid_ent(ent)) entity_set_float(ent, EV_FL_nextthink, halflife_time() + 0.01)
}

public create_flames_n_sounds(id, origin[3], velocity[3])
{
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(120)
	write_coord(origin[0])
	write_coord(origin[1])
	write_coord(origin[2])
	write_coord(velocity[0])
	write_coord(velocity[1])
	write_coord(velocity[2] + 5)
	write_short(sprite_fire)
	write_byte(1)
	write_byte(10)
	write_byte(1)
	write_byte(5)
	message_end()
	
	emit_sound(id, CHAN_WEAPON, "flamethrower.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
}

public direct_damage(id, doDamage)
{
	new ent, body
	get_user_aiming(id, ent, body, get_pcvar_num(g_damage_dis) + 500)
	
	if(ent > 0 && is_user_alive(ent) && !zp_get_user_zombie(ent) || zp_get_user_zombie(id)) 
	{
		if(!doDamage)
		{
			if(zp_get_user_zombie(id) != zp_get_user_zombie(ent)) 
			{
				damage_user(id, ent, get_pcvar_num(g_damage))
				custom_weapon_dmg(wpn_ft, id, ent, get_pcvar_num(g_damage))
			}
		}
		else
		{
			damage_user(id, ent, get_pcvar_num(g_damage))	
			custom_weapon_dmg(wpn_ft, id, ent, get_pcvar_num(g_damage))
		}
	}
}

public indirect_damage(id, doDamage)
{
	new Players[32], iNum
	get_players(Players, iNum, "a")
	for(new i = 0; i < iNum; ++i) if(id != Players[i])
	{
		new target = Players[i]
	
		new Float:fOrigin[3], Float:fOrigin2[3]
		entity_get_vector(id,EV_VEC_origin, fOrigin)
		entity_get_vector(target, EV_VEC_origin, fOrigin2)
			
		new temp[3], Float:fAim[3]
		get_user_origin(id, temp, 3)
		IVecFVec(temp, fAim)
		
		new Float:fDistance = get_pcvar_num(g_damage_dis) + 500.0
		if(get_distance_f(fOrigin, fOrigin2) > fDistance)
			continue 
		
		new iDistance = get_distance_to_line(fOrigin, fOrigin2, fAim)
		if(iDistance > get_pcvar_num(g_splash_dis) || iDistance < 0 || !fm_is_ent_visible(id, target))
			continue 
			
		if(!doDamage)
		{
			if(zp_get_user_zombie(id) != zp_get_user_zombie(target))
			{
				damage_user(id, target, get_pcvar_num(g_damage))
				custom_weapon_dmg(wpn_ft, id, target, get_pcvar_num(g_damage))
			}
		}
		else 
		{
			damage_user(id, target, get_pcvar_num(g_damage) / 2)
			custom_weapon_dmg(wpn_ft, id, target, get_pcvar_num(g_damage) / 2)
		}
	}
}

public buy_fuel(id)
{
	if(get_pcvar_num(g_ft_buyzone) && !g_buyzone[id])
		return PLUGIN_CONTINUE
		
	new Float:fBuyTime = get_cvar_float("mp_buytime") * 60
	if(get_pcvar_num(g_buytime) && !g_freezetime 
	&& (get_gametime() - g_starttime) > fBuyTime)
		return PLUGIN_CONTINUE

	if(g_FuelTank[id] >= get_pcvar_num(g_fueltank))
		return PLUGIN_CONTINUE
				
	new iMoney = zp_get_user_ammo_packs(id)
	new iCost = get_pcvar_num(g_fuelcost)
	if(iMoney >= iCost)
	{
		g_FuelTank[id] += 1
		show_fuel_percentage(id)
		zp_set_user_ammo_packs(id, iMoney - iCost)

		return PLUGIN_CONTINUE
	}	
	return PLUGIN_CONTINUE
}

public drop_flamethrower(id)
{
	new Float:fVelocity[3], Float:fOrigin[3]
	entity_get_vector(id, EV_VEC_origin, fOrigin)
	VelocityByAim(id, 34, fVelocity)
	
	fOrigin[0] += fVelocity[0]
	fOrigin[1] += fVelocity[1]

	VelocityByAim(id, 300, fVelocity)
	
	new ent = create_entity("info_target")
	if(is_valid_ent(ent))
	{
		entity_set_string(ent, EV_SZ_classname, "flamethrower")
		entity_set_model(ent, "models/w_flamethrower.mdl")
		entity_set_int(ent, EV_INT_movetype, MOVETYPE_TOSS)
		entity_set_int(ent, EV_INT_solid, SOLID_TRIGGER)
		entity_set_vector(ent, EV_VEC_origin, fOrigin)
		entity_set_vector(ent, EV_VEC_velocity, fVelocity)
		entity_set_int(ent, EV_INT_iuser4, g_FuelTank[id])
		entity_set_float(ent, EV_FL_takedamage, 1.0)
		entity_set_float(ent, EV_FL_health, 1000.0)
		entity_set_size(ent, Float:{-2.5, -2.5, -1.5}, Float:{2.5, 2.5, 1.5})
		entity_set_float(ent, EV_FL_nextthink, halflife_time() + 0.01)
	}
	
	g_FuelTank[id] = 0
	g_Activated[id] = 0
	g_hasFlamethrower[id] = 0
	
	if(has_shield(id))
		set_shield_model(id)
	else 
		set_knife_model(id)
		
	return PLUGIN_CONTINUE
}

public task_ActivateFlamethrower(id) 
{
	if(!is_user_connected(id) || !is_user_alive(id) && !zp_get_user_zombie(id) )
		return PLUGIN_CONTINUE
	
	new temp[2], weaponID = get_user_weapon(id, temp[0], temp[1])
	if(weaponID == CSW_KNIFE) g_Activated[id] = 1
		
	return PLUGIN_CONTINUE
}

public show_fuel_percentage(id)
{
	set_hudmessage(255, 170, 0, 0.91, 0.95, _, _, 1.0, _, _, 4)
	show_hudmessage(id, "Fuel Tank: %d%%", get_percent(g_FuelTank[id], get_pcvar_num(g_fueltank)))
}

public set_flamethrower_model(id)
{
	entity_set_string(id, EV_SZ_viewmodel, "models/v_flamethrower.mdl")
	entity_set_string(id, EV_SZ_weaponmodel, "models/p_flamethrower.mdl")
}

public set_knife_model(id)
{
	entity_set_string(id, EV_SZ_viewmodel, "models/v_knife.mdl")
	entity_set_string(id, EV_SZ_weaponmodel, "models/p_knife.mdl")	
}

public set_shield_model(id)
{
	entity_set_string(id, EV_SZ_viewmodel, "models/shield/v_shield_knife.mdl")
	entity_set_string(id, EV_SZ_weaponmodel, "models/shield/p_shield_knife.mdl")
}

stock damage_user(id, victim, damage)
{
	new iHealth = get_user_health(victim)
	if(iHealth > damage) 
		fakedamage(victim, "weapon_flamethrower", float(damage), DMG_BURN)
	else
	{
		user_silentkill(victim)
		make_deathmsg(id, victim, 0, "flamethrower")
		
		new iOrigin[3]
		get_user_origin(victim, iOrigin, 0)
		
		message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
		write_byte(17)
		write_coord(iOrigin[0])
		write_coord(iOrigin[1])
		write_coord(iOrigin[2] + 10)
		write_short(sprite_burn)
		write_byte(30)
		write_byte(40)
		message_end()
			
		if(zp_get_user_zombie(id) != zp_get_user_zombie(victim))
		{
			fm_set_user_frags(id, get_user_frags(id) + get_pcvar_num(g_frags_after_kill))
			
			new oldammo = zp_get_user_ammo_packs(id)
			zp_set_user_ammo_packs(id, oldammo + get_pcvar_num(g_ammo_after_kill))
		}
		
		message_begin(MSG_ALL, get_user_msgid("ScoreInfo")) 
		write_byte(id) 
		write_short(get_user_frags(id)) 
		write_short(get_user_deaths(id)) 
		write_short(0) 
		write_short(get_user_team(id)) 
		message_end() 
		
		message_begin(MSG_ALL, get_user_msgid("ScoreInfo")) 
		write_byte(victim) 
		write_short(get_user_frags(victim))
		write_short(get_user_deaths(victim))
		write_short(0)
		write_short(get_user_team(victim))
		message_end()
	}
}

stock get_percent(value, tvalue) 
{       
	return floatround(floatmul(float(value) / float(tvalue) , 100.0))  
}

stock get_distance_to_line(Float:pos_start[3], Float:pos_end[3], Float:pos_object[3])  
{  
	new Float:vec_start_end[3], Float:vec_start_object[3], Float:vec_end_object[3], Float:vec_end_start[3]
	xs_vec_sub(pos_end, pos_start, vec_start_end) 		// vector from start to end 
	xs_vec_sub(pos_object, pos_start, vec_start_object) 	// vector from end to object 
	xs_vec_sub(pos_start, pos_end, vec_end_start) 		// vector from end to start 
	xs_vec_sub(pos_end, pos_object, vec_end_object) 		// vector object to end 
	
	new Float:len_start_object = getVecLen(vec_start_object) 
	new Float:angle_start = floatacos(xs_vec_dot(vec_start_end, vec_start_object) / (getVecLen(vec_start_end) * len_start_object), degrees)  
	new Float:angle_end = floatacos(xs_vec_dot(vec_end_start, vec_end_object) / (getVecLen(vec_end_start) * getVecLen(vec_end_object)), degrees)  

	if(angle_start <= 90.0 && angle_end <= 90.0) 
		return floatround(len_start_object * floatsin(angle_start, degrees)) 
	return -1  
}

stock Float:getVecLen(Float:Vec[3])
{ 
	new Float:VecNull[3] = {0.0, 0.0, 0.0}
	new Float:len = get_distance_f(Vec, VecNull)
	return len
}

stock bool:fm_is_ent_visible(index, entity) 
{
	new Float:origin[3], Float:view_ofs[3], Float:eyespos[3]
	pev(index, pev_origin, origin)
	pev(index, pev_view_ofs, view_ofs)
	xs_vec_add(origin, view_ofs, eyespos)

	new Float:entpos[3]
	pev(entity, pev_origin, entpos)
	engfunc(EngFunc_TraceLine, eyespos, entpos, 0, index)

	switch(pev(entity, pev_solid)) {
		case SOLID_BBOX..SOLID_BSP: return global_get(glb_trace_ent) == entity
	}
	
	new Float:fraction
	global_get(glb_trace_fraction, fraction)
	if(fraction == 1.0)
		return true
		
	return false
}

stock bool:has_shield(id)
{
	new modelName[32]
	entity_get_string(id, EV_SZ_viewmodel, modelName, 31)

	if(containi(modelName, "v_shield_") != -1)
		return true
		
	return false
}

stock fm_set_user_frags(index, frags) 
{
	set_pev(index, pev_frags, float(frags));

	return 1;
}
/* UTF-8 func by www.DT-Club.net */
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil\\ fcharset134 Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang2052\\ f0\\ fs16 \n\\ par }
*/
