/*================================================================================
 
 -----------------------------------
 -*- [ZP] Extra Item : Player Aura -*-
 -----------------------------------
 
 ~~~~~~~~~~~~~~~
 - Description -
 ~~~~~~~~~~~~~~~
 
 This is just an extra item which gives the player a player aura. The player
 aura helps players to navigate and find zombies throughout the map. 

 ~~~~~~~~~~~~~~~
 - CVARS -
 ~~~~~~~~~~~~~~~
 ("zp_aura_radius", "20.0")
 这是半径的亮度. 
 ("zp_aura_red", "150")
 这是为红色. 
 ("zp_aura_green", "150")
 这是为绿色. 
 ("zp_aura_blue", "150")
 这是为蓝色. 
 
 ~~~~~~~~~~~~~~~
 - Change Logs -
 ~~~~~~~~~~~~~~~
 Version : 1.0
 First Release. 

 Version : 1.1
 Added some codes, removed hamsandwich module which wasnt required. 

 Version : 1.2
 Changed almost all of the codes, thanks to alan_el_more for his help. 

================================================================================*/

#include <amxmodx>
#include <fakemeta>
#include <zombieplague>

#define TASK_AURA 5000
#define ID_AURA (taskid - TASK_AURA)

/*================================================================================
 [Plugin Customization]
=================================================================================*/

new const g_item_name[] = { "手电筒" }
const g_item_cost = 10
new const g_sound_buyaura[] = { "items/nvg_on.wav" }

/*============================================================================*/

new g_itemid_playeraura, g_hasaura[33], radius, aura_rgb

public plugin_precache()
{
    precache_sound(g_sound_buyaura)
}

public plugin_init()
{
    register_plugin("[ZP] Extra Item: Player Aura", "1.2", "Zombie Lurker")
    
    g_itemid_playeraura = zp_register_extra_item(g_item_name, g_item_cost, ZP_TEAM_HUMAN)

    radius = register_cvar("zp_aura_radius", "20.0")
    aura_rgb = register_cvar("zp_aura_r g b", "150 150 150")
}

public zp_extra_item_selected(player, itemid)
{
    if (itemid == g_itemid_playeraura)
    {
        engfunc(EngFunc_EmitSound, player, CHAN_BODY, g_sound_buyaura, 1.0, ATTN_NORM, 0, PITCH_NORM)
        new r, g, b
        new Color[10], rgb[3][4]
        get_pcvar_string(aura_rgb, Color, charsmax(Color));
        parse(Color, rgb[0], 3, rgb[1], 3, rgb[2], 3)
        r = clamp(str_to_num(rgb[0]), 0, 255)
        g = clamp(str_to_num(rgb[1]), 0, 255)
        b = clamp(str_to_num(rgb[2]), 0, 255)
        PLAYERAURA(player+TASK_AURA, r, g ,b)
        g_hasaura[player] = true
    }
}

public PLAYERAURA(taskid, r, g, b)
{
    static Float:originF[3]
    pev(taskid, pev_origin, originF)
    
    engfunc(EngFunc_MessageBegin, MSG_PVS, SVC_TEMPENTITY, originF, 0)
    write_byte(TE_DLIGHT)
    engfunc(EngFunc_WriteCoord, originF[0]) // x
    engfunc(EngFunc_WriteCoord, originF[1]) // y
    engfunc(EngFunc_WriteCoord, originF[2]) // z
    write_byte(get_pcvar_num(radius)) // radius
    write_byte(r) // red
    write_byte(g) // green
    write_byte(b) // blue
    write_byte(2) // life
    write_byte(0) // decay rate
    message_end()
}

public zp_user_infected_post(id)
{
    if (g_hasaura[id])
        remove_task(id+TASK_AURA)
}
public zp_user_humanized_post(id)
{
    if (zp_get_user_survivor(id) && g_hasaura[id])
        remove_task(id+TASK_AURA)
}  
