
/*
/			
/
/				[ZP] Mega Jumper Zombie
/				   (new zombie class)
/
/				      by The_Thing
/
/
/	Description :
/		
/		This new zombie class but this zombie can Jump very high even on the highest building however jumps are limited use them wisely.
/	
/
/	Cvars :
/
/		zp_adminonly "1" // This means that admins already can jump with this ability. 1 is on, 0 is off
/		zp_maxjumps "50" // How much can jump per round. 
/
/
/
/	Credits :
/
/		twistedeuphoria - for his Multi Jump plugin
/
/			
/	
/	Changelog : 
/
/		10/10/2008 - v1.0 - First test 
/		17/10/2008 - v1.1 - fixed that jumps worked only once in round, rewrited half of code, removed unnecessary code/lines, changed plugin and zombie name. ^^
/
/
/
/
/
/
*/

#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <zombieplague>

/*=============================================*/
/*					       */
/*=============================================*/

#define ADMINACCESS ADMIN_LEVEL_A

new Jumpnum[33] = false 
new bool:canJump[33] = false


/*=============================================*/
/*		     Cvars		       */
/*=============================================*/

new g_adminonly, g_maxjumps

/*=============================================*/
/*		Zombie Attributes	       */	
/*=============================================*/

new const zclass7_name[] = { "跳跃僵尸" }
new const zclass7_info[] = { "甚至可以跳上最高建筑物" }
new const zclass7_model[] = { "zombie_source" }
new const zclass7_clawmodel[] = { "v_knife_zombie.mdl" }
const zclass7_health = 2000
const zclass7_speed = 250
const Float:zclass7_gravity = 1.0
const Float:zclass7_knockback = 0.5

new g_zclass7_mega

public plugin_precache()
{
	register_plugin("[ZP] Zombie Mega Jumper","1.1","The_Thing")
	
	g_adminonly = register_cvar("zp_adminonly", "1")
	g_maxjumps = register_cvar("zp_maxjumps", "50")
	
	g_zclass7_mega = zp_register_zombie_class(zclass7_name,zclass7_info,zclass7_model,zclass7_clawmodel,zclass7_health,zclass7_speed,zclass7_gravity,zclass7_knockback)
}

public client_putinserver(id)
{
	Jumpnum[id] = 0
	canJump[id] = false
}

public client_disconnect(id)
{
	Jumpnum[id] = 0
	canJump[id] = false
}

public zp_user_infected_post(id, infector)
{
	if (zp_get_user_zombie_class(id) == g_zclass7_mega)
		client_print(id,print_chat,"[CS插件专区提醒你] 您已经选择了一个强大的僵尸，好运气")
	{
		canJump[id] = true
		Jumpnum[id]++
	}
}

public client_PreThink(id)
{
	if (!is_user_alive(id) && !is_user_bot(id) || !zp_get_user_zombie(id))
	return PLUGIN_CONTINUE
	
	if (get_pcvar_num(g_adminonly) && (!access(id,ADMIN_LEVEL_A)))
	return PLUGIN_CONTINUE
	
	new nbut = get_user_button(id)
	new obut = get_user_oldbutton(id)
	
	if (( nbut & IN_JUMP) && !(get_entity_flags(id) & FL_ONGROUND) && !(obut & IN_JUMP))
	{
		if (Jumpnum[id] < get_pcvar_num(g_maxjumps))
		{
			canJump[id] = true 
			Jumpnum[id]++
			return PLUGIN_CONTINUE
		}
		
	}
	if ((nbut & IN_JUMP) && (get_entity_flags(id) & FL_ONGROUND))
	{
		Jumpnum[id] = 0
		return PLUGIN_CONTINUE
	}
	return PLUGIN_CONTINUE
}

public client_PostThink(id)
{
	if (!is_user_alive(id) && !is_user_bot(id) || !zp_get_user_zombie(id)) 
		return PLUGIN_CONTINUE
	
	if (get_pcvar_num(g_adminonly) && (!access(id,ADMINACCESS))) 
		return PLUGIN_CONTINUE
	
	if (canJump[id] == true)
	{
		new Float:velocity[3]	
		entity_get_vector(id,EV_VEC_velocity,velocity)
		velocity[2] = random_float(265.0,285.0)
		entity_set_vector(id,EV_VEC_velocity,velocity)
		canJump[id] = false
		return PLUGIN_CONTINUE
	}
	return PLUGIN_CONTINUE
}	
