/*

			    [ZP] Extra Items : Traps!                 
				By anggara_nothing				  
				( for both team )
				
/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
The name of traps and that fuctions :
- Bury Trap	- Player will be buried (they won't lose their weapons).
- Slap Trap	- Player will be slapped with their health cut in half.
- Death Trap	- Player will be instantly killed.
- Blind Trap	- Player will become blind.
- Slow Trap	- Player will lose all of their weapons (except knife).
- Math		- Player will become unable to move until they answer a math
		problem (they type the answer into chat).
- Drug		- Player overdoses on drugs.
- Hiccup	- Player gets the hiccups (jumps at random times).
- Trap goggles	- Buyer can see enemy's trap.
- Trap Immunity - Buyer can't affect with trap in one round.
//\\//\\//\\//\\//\\//\\// Console Commands  (ADMIN_KICK) \\//\\//\\//\\//\\//\\//\\
- amx_traps		- Changes the cvar traps_enable - <0|1 = OFF/ON>
//\\//\\//\\//\\//\\//\\//\\// Cvars <1|0 - on/off> //\\//\\//\\//\\//\\//\\//\\//\\
- zp_bury		- Enables/Disables usage of Bury Traps (Default = 1)
- zp_slap		- Enables/Disables usage of Slap Traps (Default = 1)
- zp_death		- Enables/Disables usage of Death Traps (Default = 1) 
- zp_blind		- Enables/Disabled usage of Blind Traps (Default = 1)
- zp_slow		- Enables/Disables usage of Slow Traps (Default = 1)
- zp_math		- Enables/Disabled usage of Math Traps (Default = 1)
- zp_drug		- Enables/Disables usage of Death Traps (Default = 1)
- zp_hiccup		- Enables/Disabled usage of Blind Traps (Default = 1)
- zp_goggle		- Enables/Disables usage of Trap Goggles (Default = 1)
- zp_immunity		- Enables/Disables usage of Trap Immunity (Default = 1)
- zp_price_bury		- Price of the Bury Trap in ammo pack.
- zp_price_slap		- Price of the Slap Trap in ammo pack.
- zp_price_death	- Price of the Death Trap in ammo pack.
- zp_price_blind	- Price of the Blind Trap in ammo pack.
- zp_price_slow		- Price of the Slow Trap in ammo pack.
- zp_price_math		- Price of the Math Trap in ammo pack.
- zp_price_drug		- Price of the Drug Trap in ammo pack.
- zp_price_hiccup	- Price of the Hiccup Trap in ammo pack.
- zp_price_goggle	- Price of the Trap Goggles in ammo pack.
- zp_price_immunity	- Price of the Trap Immunity in ammo pack.
- zp_max		- Amount of traps that can be bought per round per player.
- zp_radius		- How big the traps actually are
- traps_enable		- Enable/Disable usage of Traps.

New in version 1.2 :
- zp_give_ammo		- How much give ammo pack for kill enemy.
- (+settrap)		- For plant the trap easily.
- (-settrap)		- For cancel plant the trap.
----------------------------------------------------------------------------------
- Credit :	- xx_sirhc_xx (for original plugin.)
		- T(+)rget/f117bomb and Gangien(for help xx_sirhc_xx.)
		
- Changelogs :	- 1.0 ( First release. )
		- 1.2 ( some bug fixed, add +settrap to plant the trap easily, -settrap to cancel plant the trap, add new cvar.)
*/

#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <engine>
#include <fun>
#include <fakemeta>
#include <zombieplague>

//#define DEBUGGING 1

//
//DON'T EDIT THESE
//
#define T_BUY       0
#define T_PICK      1
#define T_PLANT     3
#define T_GOGGLES   5
#define T_IMMUNITY  6
#define T_BACK      8
#define T_EXIT      9

#define T_BURY      0
#define T_SLAP      1
#define T_DEATH     2
#define T_BLIND     3
#define T_SLOW      4
#define T_MATH      5
#define T_DRUG      6
#define T_HICCUP    7

#define NUMBER_OF_TRAPS 8

#define TASK_PLANT   16000
#define TASK_MOVE    16100
#define TASK_NOTICE  16200
#define TASK_BURY    500
#define TASK_SLOW    600
#define TASK_DRUG    700
#define TASK_MATH    800
#define TASK_HICCUP  900
#define TASK_PLAYHIC 1000

#define WAIT_TIME   30.0

#define T_MAX_ROUND 256

#define OP_ADD      0
#define OP_SUBTRACT 1
#define OP_MULTIPLY 2
#define OP_DIVIDE   3

new operators[4][2] = {
	"+", 
	"-", 
	"*", 
	"/"
}

//
// Message to be printed into chat when a trap is bought and when it is used.
//
#define BUY_MESS "【CS插件专区提醒你】 你现在有 %d %s 个陷阱 ,一共 %d 个陷阱"

//
// REM THIS OUT IF YOU DON'T WANT IT TO SHOW ON THE SCREEN WHEN SOMEONE JOINS
//
#define T_NOTICE "【CS插件专区提醒你】 打开陷阱菜单, 请输入 /traps"

//
// Global declarations...
//
new MenuKeys = (1 << 0) + (1 << 1) + (1 << 2) + (1 << 3) + (1 << 4) + (1 << 5) + (1 << 6) + (1 << 7) + (1 << 8) + (1 << 9)
new MainMenuKeys = (1 << 0) + (1 << 1) + (1 << 3) + (1 << 5) + (1 << 6) + (1 << 9)
new BuyMenuBodyText[256]
new PickMenuBodyText[256]
new MainMenuBodyText[256]

new pTraps[32]
new pTrapsRound[32]
new pTrapTypes[32][NUMBER_OF_TRAPS]
new pPickedTrap[32]
new pPickedTrapString[32][32]
new pTotalTrapsPlanted
new pTrapOrigins[T_MAX_ROUND][3]
new pTrapOwner[T_MAX_ROUND]
new pTrapType[T_MAX_ROUND]

new spriteTrap[8]
new spriteQMark

new bool:pTrapActive[T_MAX_ROUND]
new bool:is_blind[32] = false
new bool:is_slow[32] = false
new bool:is_bury[32] = false
new bool:is_planting[32] = false
new bool:is_drugged[32] = false
new bool:is_math[32] = false
new bool:is_hiccup[32] = false
new bool:is_goggle[32] = false
new bool:is_immunity[32] = false
new mathAnswer[32]
new mathEquations[32][128]
new mathLastGuess[32] = -1
new mathLastGuess2[32] = -1

new buryOrigins[32]
new Float:user_speed[32] = 250.0
new CsTeams:pTrapOwnerTeam[T_MAX_ROUND]

new soundPlant[] = "weapons/c4_plant.wav"
new soundJeopardy[] = "traps/jeopardy.wav"

new soundHiccups[3][19] = {
	"traps/hiccup.wav",
	"traps/hiccup2.wav",
	"traps/hiccup3.wav"
}

new spriteTraps[8][29] = {
	"sprites/traps/trap1.spr",
	"sprites/traps/trap2.spr",
	"sprites/traps/trap3.spr",
	"sprites/traps/trap4.spr",
	"sprites/traps/trap5.spr",
	"sprites/traps/trap6.spr",
	"sprites/traps/trap7.spr",
	"sprites/traps/trap8.spr"
}

new buy_menu, buy_traps, pick_traps;
//
// FUNCTIONS AND EVENTS START HERE!!!!!!!!!
//
public plugin_init()
{
	buy_menu = zp_register_extra_item("陷阱菜单", 0, 0);
	buy_traps = zp_register_extra_item("购买陷阱", 0, 0);
	pick_traps = zp_register_extra_item("选择陷阱菜单", 0, 0);
	
	register_plugin("[ZP] Extra Items : Traps!", "v1.2", "Anggara_nothing")

	register_concmd("amx_traps", "ConCmdTraps", ADMIN_KICK, "- <0|1 = OFF/ON>")

	register_clcmd("say", "ClCmdSay", -1, "- Say")

        register_clcmd("say /traps", "ClCmdTraps", -1, "- Traps Menu")
	register_clcmd("+settrap","ClCmdSetTrap")
	register_clcmd("-settrap","ClCmdEndSetTrap")

	register_event("DeathMsg", "Event_Death", "a")
	register_event("HLTV", "Event_Restart", "a", "1=0", "2=0") 
	register_event("ScreenFade", "Event_ScreenFade", "b")
	register_event("CurWeapon", "eventCurWeapon", "be");

	register_cvar("zp_bury", "1")
	register_cvar("zp_slap", "1")
	register_cvar("zp_death", "1")
	register_cvar("zp_blind", "1")
	register_cvar("zp_hiccup", "1")
	register_cvar("zp_slow", "1")
	register_cvar("zp_drug", "1")
	register_cvar("zp_math", "1")
	register_cvar("traps_enable", "1")
	register_cvar("zp_goggle", "1")
	register_cvar("zp_immunity", "1")
	register_cvar("zp_max", "9999")             //max traps that can be bought per round
	register_cvar("zp_radius", "80")
	register_cvar("zp_price_bury", "8")
	register_cvar("zp_price_slap", "2")
	register_cvar("zp_price_death", "25")
	register_cvar("zp_price_blind", "10")
	register_cvar("zp_price_slow", "5")
	register_cvar("zp_price_drug", "10")
	register_cvar("zp_price_math", "7")
	register_cvar("zp_price_hiccup", "5")
	register_cvar("zp_price_goggle", "15")
	register_cvar("zp_price_immunity", "20")
	register_cvar("zp_give_ammo", "2")

	SetupBuyMenu()
	SetupMainMenu()
	
	register_menucmd(register_menuid("\r陷阱!"), MainMenuKeys, "Traps")
	register_menucmd(register_menuid("\r挑选陷阱"), MenuKeys, "PickIt")
	register_menucmd(register_menuid("\r购买陷阱"), MenuKeys, "BuyIt")
}

public zp_extra_item_selected(player, itemid)
{
	if(itemid == buy_menu)
	{
		ClCmdTraps(player);
	}
	if(itemid == buy_traps)
	{
		ClCmdBuyTrap(player);
	}
	if(itemid == pick_traps)
	{
		ClCmdPickTrap(player);
	}
}

public ConCmdTraps(id, level, cid)
{
	if (!cmd_access(id, level, cid, 2))
		return PLUGIN_HANDLED

	new pArg[32]
	read_argv(1, pArg, 31)

	new OnOff = str_to_num(pArg)

	if (!OnOff)
	{
		set_cvar_num("traps_enable", 0)
		console_print(id, "【CS插件专区提醒你】 陷阱插件已停用")
		client_print(0, print_chat, "【CS插件专区提醒你】 管理员已停用陷阱插件")
	}
	else
	{
		set_cvar_num("traps_enable", 1)
		console_print(id, "【CS插件专区提醒你】 陷阱插件已启用")
		client_print(0, print_chat, "【CS插件专区提醒你】 管理员已启用陷阱插件")
	}

	return PLUGIN_HANDLED
}

public plugin_precache()
{
	precache_sound(soundPlant)
	precache_sound(soundJeopardy)

	for (new i = 0; i < 3; i++)
		precache_sound(soundHiccups[i])

	for (new i = 0; i < 8; i++)
		spriteTrap[i] = precache_model(spriteTraps[i])

	spriteQMark = precache_model("sprites/traps/QMark.spr")
}

public client_putinserver(id)
{
	new pArgs[2]
	pArgs[0] = id

	#if defined T_NOTICE
		set_task(15.0, "ShowNotice", (TASK_NOTICE + id), pArgs, 1)
	#endif

	ResetPlayerVariables(id)
}

public client_disconnect(id)
	ResetPlayerVariables(id)

public ShowNotice(pArgs[])
{
	new id = pArgs[0]

	set_hudmessage(200, 155, 0, -1.0, 0.50, 0, 6.0, 8.0, 0.3, 0.5, 3)
	show_hudmessage(id, T_NOTICE)
}

public Event_Restart()
{
	pTotalTrapsPlanted = 0

	for (new z = 1; z < 33; z++)
		ResetMostPlayerVariables(z)
	
	// Give free goggle if player to be a nemesis or survivor.
	for(new i = 0; i < 32; i++)
	{
		if (zp_get_user_nemesis(i) || zp_get_user_survivor(i))
		{
			is_goggle[i - 1] = true
		}
	}
	
	return PLUGIN_CONTINUE
}

public eventCurWeapon(id)
{

	if (is_slow[id - 1] || is_math[id - 1])
	{
		new Float:speed = user_speed[id - 1]
		set_user_maxspeed(id, speed)
	}
}

public ResetPlayerVariables(id)
{

	pTraps[id - 1] = 0

	ResetMostPlayerVariables(id)

	for (new i = 0; i < NUMBER_OF_TRAPS; i++)
		pTrapTypes[id - 1][i] = 0

	for (new i = 0; i < 5; i++)
		pTrapTypes[id - 1][i] = 0

	pPickedTrap[id - 1] = -1

}

public ResetMostPlayerVariables(id)
{

	pTrapsRound[id - 1] = 0

	is_blind[id - 1] = false
        is_slow[id - 1] = false
	is_bury[id - 1] = false
        is_planting[id - 1] = false
	is_math[id - 1] = false
	is_drugged[id - 1] = false
	is_hiccup[id - 1] = false
	is_goggle[id - 1] = false
	is_immunity[id - 1] = false

	mathLastGuess[id - 1] = -1
	mathLastGuess2[id - 1] = -1

	user_speed[id - 1] = 250.0

        buryOrigins[id - 1] = 0

}

public Event_Death()
{
	if (!get_cvar_num("traps_enable"))
		return PLUGIN_CONTINUE

	new id = read_data(2)

	if (task_exists(id))
		remove_task(id)

        if (task_exists(id + TASK_DRUG))
                remove_task(id + TASK_DRUG)

        if (task_exists(id + TASK_MATH))
                remove_task(id + TASK_MATH)

        if (task_exists(id + TASK_SLOW))
                remove_task(id + TASK_SLOW)

        if (task_exists(id + TASK_BURY))
                remove_task(id + TASK_BURY)

        if (task_exists(id + TASK_PLANT))
                remove_task(id + TASK_PLANT)

        if (task_exists(id + TASK_MOVE))
                remove_task(id + TASK_MOVE)

	if (task_exists(id + TASK_HICCUP))
		remove_task(id + TASK_HICCUP)

	if (task_exists(id + TASK_PLAYHIC))
		remove_task(id + TASK_PLAYHIC)


	ResetPlayerVariables(id)

	return PLUGIN_CONTINUE
}




/*\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
\\//\\  BUYING TRAPS    \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\*/

//
// This is called when the user types "/buytrap" into chat
//
public ClCmdBuyTrap(id)
{
	SetupBuyMenu()
	show_menu(id, MenuKeys, BuyMenuBodyText)

	return PLUGIN_HANDLED
}

//
// This is called when the user types "/traps" into chat
//
public ClCmdTraps(id)
{
	SetupMainMenu()
	show_menu(id, MainMenuKeys, MainMenuBodyText)

	return PLUGIN_HANDLED
}

//
// This is called when the user tries to buy a trap from the menu
//
public BuyIt(id, key)
{
	switch (key)
	{
		case T_BURY:
			if (canBuy(id, "bury"))
				BuyTrap(id, T_BURY, "埋葬", get_cvar_num("zp_price_bury"))

		case T_SLAP:
			if (canBuy(id, "slap"))
				BuyTrap(id, T_SLAP, "扇嘴", get_cvar_num("zp_price_slap"))

		case T_DEATH:
			if (canBuy(id, "death"))
				BuyTrap(id, T_DEATH, "死亡", get_cvar_num("zp_price_death"))

		case T_BLIND:
			if (canBuy(id, "blind"))
				BuyTrap(id, T_BLIND, "盲目", get_cvar_num("zp_price_blind"))

		case T_HICCUP:
			if (canBuy(id, "hiccup"))
				BuyTrap(id, T_HICCUP, "打嗝", get_cvar_num("zp_price_hiccup"))

		case T_SLOW:
			if (canBuy(id, "slow"))
				BuyTrap(id, T_SLOW, "缓慢", get_cvar_num("zp_price_slow"))

		case T_MATH:
			if (canBuy(id, "math"))
				BuyTrap(id, T_MATH, "数学", get_cvar_num("zp_price_math"))

		case T_DRUG:
			if (canBuy(id, "drug"))
				BuyTrap(id, T_DRUG, "毒药", get_cvar_num("zp_price_drug"))

                case T_BACK:
		{
                      	ClCmdTraps(id)
			return PLUGIN_HANDLED
		}
	
		case T_EXIT:
			return PLUGIN_HANDLED
	}

	ClCmdBuyTrap(id)
	return PLUGIN_HANDLED
}

public ClCmdBuyGoggles(id)
{

	if (!get_cvar_num("traps_enable"))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 管理员已停用陷阱插件!")
		ClCmdTraps(id)
		return PLUGIN_HANDLED
	}

	if (!get_cvar_num("zp_goggle"))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 陷阱探测镜已关闭!")
		ClCmdTraps(id)
		return PLUGIN_HANDLED
	}

	if (!is_user_alive(id))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 死亡的人不能买陷阱探测镜!")
		ClCmdTraps(id)
		return PLUGIN_HANDLED
	}

	if (is_goggle[id - 1])
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 你已经买了陷阱探测镜!")
		ClCmdTraps(id)
		return PLUGIN_HANDLED
	}

	if ((zp_get_user_ammo_packs(id)) < (get_cvar_num("zp_price_goggle")))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 你没有足够的弹药包去购买陷阱探测镜!")
		ClCmdTraps(id)
		return PLUGIN_HANDLED
	}
	
	is_goggle[id - 1] = true

	new Money = zp_get_user_ammo_packs(id)
	zp_set_user_ammo_packs(id, Money - get_cvar_num("zp_price_goggle"))

	client_print(id, print_chat, "【CS插件专区提醒你】 你现在已经有了陷阱探测镜在这局!")
	ClCmdTraps(id)

	return PLUGIN_HANDLED
}

public ClCmdBuyImmunity(id)
{

	if (!get_cvar_num("traps_enable"))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 管理员已停用陷阱插件!")
		ClCmdTraps(id)
		return PLUGIN_HANDLED
	}

	if (!get_cvar_num("zp_immunity"))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 陷阱免疫已关闭!")
		ClCmdTraps(id)
		return PLUGIN_HANDLED
	}

	if (!is_user_alive(id))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 死亡的人不能买陷阱免疫!")
		ClCmdTraps(id)
		return PLUGIN_HANDLED
	}

	if (is_immunity[id - 1])
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 你已经有了陷阱免疫!")
		ClCmdTraps(id)
		return PLUGIN_HANDLED
	}

	if ((zp_get_user_ammo_packs(id)) < (get_cvar_num("zp_price_immunity")))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 你没有足够的弹药包去购买陷阱免疫!")
		ClCmdTraps(id)
		return PLUGIN_HANDLED
	}

	is_immunity[id - 1] = true

	new Money = zp_get_user_ammo_packs(id)
	zp_set_user_ammo_packs(id, Money - get_cvar_num("zp_price_immunity"))

	client_print(id, print_chat, "【CS插件专区提醒你】 你现在有陷阱免疫在这局!")
	ClCmdTraps(id)

	return PLUGIN_HANDLED
}

public Traps(id, key)
{
	switch (key)
	{
		case T_BUY:
			ClCmdBuyTrap(id)

		case T_PICK:
			ClCmdPickTrap(id)

		case T_GOGGLES:
			ClCmdBuyGoggles(id)

		case T_IMMUNITY:
			ClCmdBuyImmunity(id)

		case T_PLANT:
		{
			ClCmdSetTrap(id)
                      	SetupMainMenu()
	                show_menu(id, MainMenuKeys, MainMenuBodyText)
		}
	}

	return PLUGIN_HANDLED
}

//
// This buys the trap
//
public BuyTrap(id, tType, tName[], tPrice)
{
	pTraps[id - 1]++
	pTrapsRound[id - 1]++
	pTrapTypes[id - 1][tType]++

	new Money = zp_get_user_ammo_packs(id)
	zp_set_user_ammo_packs(id, Money - tPrice)

	if (pPickedTrap[id - 1] == -1)
	{
		pPickedTrap[id - 1] = tType
		format(pPickedTrapString[id - 1], 31, "%s", tName)
	}

	client_print(id, print_chat, BUY_MESS, pTrapTypes[id - 1][tType], tName, pTraps[id - 1])

	SetupBuyMenu()
	show_menu(id, MenuKeys, BuyMenuBodyText)

	return 1
}

//
// This boolean is used to check if a user can buy the trap
//
public bool:canBuy(id, cvarName[])
{
	new cvarNameEnable[32]
	new cvarPriceCheck[32]

	format(cvarNameEnable, 31, "zp_%s", cvarName)
	format(cvarPriceCheck, 31, "zp_price_%s", cvarName)

	if (!get_cvar_num("traps_enable"))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 管理员已停用陷阱插件!")
		return false
	}

	if (!get_cvar_num(cvarNameEnable))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 这个陷阱已被停用!")
		return false
	}

	if (!is_user_alive(id))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 已经死亡的人不能购买陷阱!")
		return false
	}

	if (pTrapsRound[id - 1] >= get_cvar_num("zp_max"))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 你拥有的陷阱已达到上限!")
		return false
	}

	if ((zp_get_user_ammo_packs(id)) < (get_cvar_num(cvarPriceCheck)))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 你没有足够的钱去购买这个陷阱!")
		return false
	}

	return true
}

/*\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
\\//\\  PICKING TRAPS   \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\*/

//
// This is called when a player types "/picktrap" into chat
//
public ClCmdPickTrap(id)
{
	SetupPickMenu(id)
	show_menu(id, MenuKeys, PickMenuBodyText)

	return PLUGIN_HANDLED
}

//
// This is called when a user tries to pick a Trap to be planted
//
public PickIt(id, key)
{
	switch (key)
	{
		case T_BURY:
			if (canPick(id, "bury", T_BURY))
			{
				pPickedTrap[id - 1] = T_BURY
				pPickedTrapString[id - 1] = "Bury"
				client_print(id, print_chat, "【CS插件专区提醒你】 你现在捡起了埋葬陷阱!");
			}

		case T_SLAP:
			if (canPick(id, "slap", T_SLAP))
			{
				pPickedTrap[id - 1] = T_SLAP
				pPickedTrapString[id - 1] = "Slap"
				client_print(id, print_chat, "【CS插件专区提醒你】 你现在捡起了扇嘴陷阱!");
			}

		case T_DEATH:
			if (canPick(id, "death", T_DEATH))
			{
				pPickedTrap[id - 1] = T_DEATH
				pPickedTrapString[id - 1] = "Death"
				client_print(id, print_chat, "【CS插件专区提醒你】 你陷阱捡起了死亡陷阱!");
			}

		case T_BLIND:
			if (canPick(id, "blind", T_BLIND))
			{
				pPickedTrap[id - 1] = T_BLIND
				pPickedTrapString[id - 1] = "Blind"
				client_print(id, print_chat, "【CS插件专区提醒你】你现在捡起了盲目陷阱!");
			}

		case T_HICCUP:
			if (canPick(id, "hiccup", T_HICCUP))
			{
				pPickedTrap[id - 1] = T_HICCUP
				pPickedTrapString[id - 1] = "Hiccup"
				client_print(id, print_chat, "【CS插件专区提醒你】 你现在捡起了打嗝陷阱!");
			}

		case T_SLOW:
			if (canPick(id, "slow", T_SLOW))
			{
				pPickedTrap[id - 1] = T_SLOW
				pPickedTrapString[id - 1] = "Slow"
				client_print(id, print_chat, "【CS插件专区提醒你】 你现在捡起了缓慢陷阱!");
			}

		case T_MATH:
			if (canPick(id, "math", T_MATH))
			{
				pPickedTrap[id - 1] = T_MATH
				pPickedTrapString[id - 1] = "Math"
				client_print(id, print_chat, "【CS插件专区提醒你】 你现在捡起了数学陷阱!");
			}

		case T_DRUG:
			if (canPick(id, "drug", T_DRUG))
			{
				pPickedTrap[id - 1] = T_DRUG
				pPickedTrapString[id - 1] = "Drug"
				client_print(id, print_chat, "【CS插件专区提醒你】 你现在捡起了毒药陷阱!");
			}

		case T_BACK:
		{
			ClCmdTraps(id)
			return PLUGIN_HANDLED
		}

		case T_EXIT:
			return PLUGIN_HANDLED
	}

        ClCmdPickTrap(id)
	return PLUGIN_HANDLED
}

//
// This boolean checks to see if the player can Pick the selected Trap
//
public bool:canPick(id, tName[], pType)
{
	new cvarNameEnable[32]

	format(cvarNameEnable, 31, "zp_%s", tName)

	if (!get_cvar_num("traps_enable"))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 管理员已停用陷阱插件!")
		return false
	}

	if (!get_cvar_num(cvarNameEnable))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 这个陷阱已被停用!")
		return false
	}

	if (!pTrapTypes[id - 1][pType])
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 你没有 %s 个陷阱!", tName)
		return false
	}

	return true
}







/*\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
\\//\\  PLANTING TRAPS  \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\*/

//
// This is called when a user pushes a key bound to "+settrap"
//
public ClCmdSetTrap(id)
{
	if (!canPlant(id))
	{
		ClCmdTraps(id)
		return PLUGIN_HANDLED
	}

	//
	// Progress Bar (Activate) -- This was taken almost directly from xeroblood!
	//
	message_begin( MSG_ONE, 108, {0,0,0}, id )
	write_byte(1)   // duration
	write_byte(0)   // duration
	message_end()

	new pID[2]
	pID[0] = id

        is_planting[id - 1] = true
	set_task(0.1, "CheckUserMoving", (TASK_MOVE + id), pID, 1)
	set_task(1.0, "PlantTrap", (TASK_PLANT + id), pID, 1)

	return PLUGIN_HANDLED;

}

//
// This is called when a user executes -settrap (let's go of the key bound to +settrap)
//
public ClCmdEndSetTrap(id)
{
	if (task_exists((TASK_PLANT + id)))
	{
		remove_task((TASK_PLANT + id))
		remove_task((TASK_MOVE + id))
	}

	//
	// Progress Bar (Terminate)
	//
	message_begin(MSG_ONE, 108, {0,0,0}, id)
	write_byte(0) // duration
	write_byte(0) // duration
	message_end()

	is_planting[id - 1] = false

	return PLUGIN_HANDLED
}

//
// This plants the Trap
//
public PlantTrap(pArgs[])
{
	new id = pArgs[0]

	if (task_exists((TASK_MOVE + id)))
		remove_task((TASK_MOVE + id))

	new pTot = pTotalTrapsPlanted
	new pTyp = pPickedTrap[id - 1]

	get_user_origin(id, pTrapOrigins[pTot], 0)
	pTrapOwner[pTot] = id
	pTrapOwnerTeam[pTot] = cs_get_user_team(id)
	pTrapActive[pTot] = true
	pTrapType[pTot] = pTyp
	
	pTraps[id - 1]--
	pTrapTypes[id - 1][pTyp]--
	pTotalTrapsPlanted++

	if (pTrapTypes[id - 1][pTyp] <= 0)
	{
		pPickedTrap[id - 1] = -1
		for (new n = 0; n < NUMBER_OF_TRAPS; n++)
		{
			if (pTrapTypes[id - 1][n] > 0)
			{
				pPickedTrap[id - 1] = n
				break;
			}
		}
	}

	emit_sound(id, CHAN_WEAPON, soundPlant, 1.0, ATTN_NORM, 0, PITCH_NORM)

        //set_user_maxspeed(id, user_speed[id - 1])
        is_planting[id - 1] = false

	client_print(id, print_chat, "【CS插件专区提醒你】 你的陷阱成功安置!")
	client_print(id, print_chat, BUY_MESS, pTrapTypes[id - 1][pTyp], pPickedTrapString[id - 1], pTraps[id - 1])

	//new origin[3]
	//new Float:vOrigin[3]

	//entity_get_vector(id, EV_VEC_origin, vOrigin)

	//get_user_origin(id, origin, 3);
	//IVecFVec(origin, vOrigin);

	//new ent = create_entity("info_target");
	//new Float:gfDefaultBlockAngles[3] = { 0.0, 0.0, 0.0 };
	//new Float:gfBlockSizeMinForZ[3] = {-16.0,-16.0,-2.0};
	//new Float:gfBlockSizeMaxForZ[3] = { 16.0, 16.0, 2.0};

	//if (is_valid_ent(ent))
	//{
	//	//set block properties
	//	entity_set_string(ent, EV_SZ_classname, "trap_flag");
	//	entity_set_int(ent, EV_INT_solid, SOLID_BBOX);
	//	entity_set_int(ent, EV_INT_movetype, MOVETYPE_NONE);
	//	entity_set_model(ent, tehModel);
	//	entity_set_vector(ent, EV_VEC_angles, gfDefaultBlockAngles);
	//	entity_set_size(ent, gfBlockSizeMinForZ, gfBlockSizeMaxForZ);
	//	entity_set_origin(ent, vOrigin);
	//	set_rendering(ent, kRenderFxNone, 255, 255, 255, kRenderTransColor, 255)
	//	entity_set_int(ent, EV_INT_solid, SOLID_NOT);

	//	pTrapEntity[pTot] = ent
	//	pTrapEntityFlag[pTot] = true
	//	pTrapEntityTeam[pTot] = pev(id,pev_team)


	//}
	return PLUGIN_HANDLED
}

//
// Makes sure the player isn't moving while planting the Trap
//
public CheckUserMoving(pArgs[])
{
	new id = pArgs[0]
	
	if (!is_user_standing_still(id))
		ClCmdEndSetTrap(id)
	else
		set_task(0.1, "CheckUserMoving", (TASK_MOVE + id), pArgs, 1)

	return PLUGIN_HANDLED
}

//
// This boolean checks if a player is able to plant a Trap
//
public bool:canPlant(id)
{

	if (!get_cvar_num("traps_enable"))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 管理员已停用陷阱插件!")
		return false
	}

	if (!is_user_alive(id))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 死亡的人不能安置陷阱!")
		return false
	}

	if (!pTraps[id - 1])
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 你没有陷阱去安置!")
		return false
	}

	if (pPickedTrap[id - 1] == -1)
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 你没有陷阱可以捡!")
		ClCmdPickTrap(id)
		return false
	}

	if (!is_user_standing_still(id))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 你必须站着不动安置陷阱!")
		return false
	}

	if (is_planting[id - 1] == true)
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 你已经安置了陷阱!")
		return false
	}

	return true

}

//
// This boolean makes sure a player is standing still (not jumping or moving!)
//
public bool:is_user_standing_still(id)
{
	if (get_user_button(id) & (IN_JUMP|IN_FORWARD|IN_BACK|IN_MOVELEFT|IN_MOVERIGHT))
		return false

	if (!(get_entity_flags(id) & FL_ONGROUND))
		return false

	return true
}

/*\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
\\//\\  CATCHING PLAYERS IN TRAPS   \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\*/

//
// Checks if the person is in a trap
//
public client_PostThink(id)
{
	new pOrigin[3];

	if (!is_user_alive(id))
		return PLUGIN_CONTINUE

	if (!get_cvar_num("traps_enable"))
		return PLUGIN_CONTINUE

	if (is_slow[id - 1])
	{
		new Float:speed = get_user_maxspeed(id)
		if (speed != user_speed[id - 1])
			set_user_maxspeed(id, user_speed[id - 1])

	}

	get_user_origin(id, pOrigin, 0);

	for (new i = 0; i < pTotalTrapsPlanted; i++)
	{
		if (pTrapActive[i])
		{
			#if !defined DEBUGGING

				new CsTeams:pTheTeam = cs_get_user_team(id)

				if ((pTrapOwner[i] == id) || (pTrapOwnerTeam[i] == pTheTeam))
				{
					DrawSprite(id, i)
				} else if (is_goggle[id - 1]) {
					DrawSpriteQ(id, i)
				}

				if ((pTrapOwner[i] != id) && (pTrapOwnerTeam[i] != pTheTeam) && (get_entity_flags(id) & FL_ONGROUND))
				{
					new pDistance = get_distance(pOrigin, pTrapOrigins[i])

					if (pDistance <= get_cvar_num("zp_radius"))
					{
						if (!is_immunity[id - 1])
							PunishUser(id, i)
					}
				}
			#else
				if ((get_entity_flags(id) & FL_ONGROUND))
				{
					new pDistance = get_distance(pOrigin, pTrapOrigins[i])

					if (pDistance <= get_cvar_num("zp_radius"))
					{
						PunishUser(id, i)
					}
				}
			#endif
		}
	}

	return PLUGIN_CONTINUE
}

//
// Handle's the punishing of users
//

public DrawSprite(id, tNum)
{

	message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, {0, 0, 0}, id)
	write_byte(TE_SPRITE) // additive sprite, plays 1 cycle
	write_coord(pTrapOrigins[tNum][0]) // xpos
	write_coord(pTrapOrigins[tNum][1]) // ypos
	write_coord(pTrapOrigins[tNum][2]) // zpos
	write_short(spriteTrap[pTrapType[tNum]]) // spr index
	write_byte(1) // (scale in 0.1's)
	write_byte(50) //brightness
	message_end()

}
public DrawSpriteQ(id, tNum)
{

	message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, {0, 0, 0}, id)
	write_byte(TE_SPRITE) // additive sprite, plays 1 cycle
	write_coord(pTrapOrigins[tNum][0]) // xpos
	write_coord(pTrapOrigins[tNum][1]) // ypos
	write_coord(pTrapOrigins[tNum][2]) // zpos
	write_short(spriteQMark) // spr index
	write_byte(2) // (scale in 0.1's)
	write_byte(50) //brightness
	message_end()

}

public PunishUser(id, tNum)
{
	pTrapActive[tNum] = false

	switch (pTrapType[tNum])
	{
		case T_BURY:
                {
                        is_bury[id - 1] = true
			BuryUser(id, tNum)
                }

		case T_SLAP:
		{
			HalfDamageUser(id, tNum)
			return PLUGIN_HANDLED
		}
		case T_DEATH:
		{
			KillUser(id, tNum)
			return PLUGIN_HANDLED
		}

		case T_BLIND:
		{	
			new pName[32], aName[32]

			get_user_name(id, pName, 31)
			get_user_name(pTrapOwner[tNum], aName, 31)

			client_print(id, print_chat, "【CS插件专区提醒你】 哦不!你陷入了盲目陷阱!现在已经失明啦!")
			client_print(0, print_chat, "【CS插件专区提醒你】 %s 陷入了 %s 的盲目陷阱!", pName, aName)

			is_blind[id - 1] = true

			BlindUser(id)
		}

		case T_HICCUP:
		{
			HiccupUser(id, tNum)
			return PLUGIN_HANDLED
		}

		case T_SLOW:
                {
                        is_slow[id - 1] = true
			SlowUser(id, tNum)
                }

		case T_DRUG:
                {
                        is_drugged[id - 1] = true
			DrugUser(id, tNum)
                }

		case T_MATH:
                {
			if (is_math[id - 1] == false)
				MathUser(id, tNum)
                }
	}
	set_user_rendering(id,kRenderFxGlowShell, 200,0,0, kRenderNormal,16);

	return PLUGIN_HANDLED
}

//
// Burys the user
//
public BuryUser(id, id2)
{
	new pOrigin[3], pName[32], aName[32]

	get_user_origin(id, pOrigin, 0)

        buryOrigins[id - 1] += 30

        is_bury[id - 1] = true

	pOrigin[2] -= 30;
	set_user_origin(id, pOrigin)

	get_user_name(id, pName, 31)
	get_user_name(pTrapOwner[id2], aName, 31)

	client_print(id, print_chat, "【CS插件专区提醒你】 哦不! 你陷入了埋葬陷阱! 你已经被埋葬!")
	client_print(0, print_chat, "【CS插件专区提醒你】 %s 陷入了 %s 的埋葬陷阱!", pName, aName)

	set_task(WAIT_TIME, "UnBuryUser", id + TASK_BURY)

	return 1
}

//
// Slaps the user's health in half
//
public HalfDamageUser(id, id2)
{
	new pName[32], aName[32]

	new Health = get_user_health(id)

	user_slap(id, (Health / 2), 1)

	get_user_name(id, pName, 31)
	get_user_name(pTrapOwner[id2], aName, 31)

	client_print(id, print_chat, "【CS插件专区提醒你】 哦不! 你陷入了扇嘴陷阱!  你的健康衰减!")
	client_print(0, print_chat, "【CS插件专区提醒你】 %s 陷入了 %s 的扇嘴陷阱!", pName, aName)

	return 1
}

//
// Slow the user down
//
public SlowUser(id, id2)
{
	new pName[32], aName[32]

	new Float:speed = get_user_maxspeed(id) / 2

	set_user_maxspeed(id, speed)

        user_speed[id - 1] = speed
        is_slow[id - 1] = true

	get_user_name(id, pName, 31)
	get_user_name(pTrapOwner[id2], aName, 31)

	client_print(id, print_chat, "【CS插件专区提醒你】 哦不! 你陷入了缓慢陷阱! 你的速度减了一半!")
	client_print(0, print_chat, "【CS插件专区提醒你】 %s 陷入了 %s 的缓慢陷阱!", pName, aName)

	set_task(WAIT_TIME, "UnSlowUser", id + TASK_SLOW)

	return 1
}

//
// Drug the user
//
public DrugUser(id, id2)
{
	new pName[32], aName[32]

        is_drugged[id - 1] = true

	message_begin(MSG_ONE, get_user_msgid("SetFOV"), {0,0,0}, id)
	write_byte(170)
	message_end()

	get_user_name(id, pName, 31)
	get_user_name(pTrapOwner[id2], aName, 31)

	client_print(id, print_chat, "【CS插件专区提醒你】 哦不! 你陷入了毒药陷阱! 你是一个吸毒者!")
	client_print(0, print_chat, "【CS插件专区提醒你】 %s 陷入了 %s 的毒药陷阱!", pName, aName)

	set_task(WAIT_TIME, "UnDrugUser", id + TASK_DRUG)

	return 1
}

//
// "Math" the user
//
public MathUser(id, id2)
{
	new pName[32], aName[32], pOrigin[3]

        is_math[id - 1] = true

	set_user_maxspeed(id, 0.1)
	user_speed[id - 1] = 0.1

	get_user_origin(id, pOrigin, 0)
	pOrigin[2] -= 30;
	set_user_origin(id, pOrigin)

	get_user_name(id, pName, 31)
	get_user_name(pTrapOwner[id2], aName, 31)

	client_cmd(id, "spk %s", soundJeopardy)
	client_print(0, print_chat, "【CS插件专区提醒你】 %s 陷入了 %s 的数学陷阱!", pName, aName)
	client_print(id, print_chat, "【CS插件专区提醒你】 哦不! 你陷入了数学陷阱!  请回答问题!")
	client_print(id, print_chat, "【CS插件专区提醒你】 你必须回答问题.  按Y打出你的答案!")

	cmdMath(id)

	return 1
}

//
// Kill's the user
//
public KillUser(id, id2)
{
	new gap = zp_get_user_ammo_packs(id2)
	zp_set_user_ammo_packs(id2, gap + get_cvar_num("zp_give_ammo"))
	
	new pName[32], aName[32]

	user_kill(id)

	new aFrags = get_user_frags(id2 + 1)
	aFrags += 1
	set_user_frags(id2 + 1, aFrags)

	get_user_name(id, pName, 31)
	get_user_name(pTrapOwner[id2], aName, 31)

	client_print(id, print_chat, "【CS插件专区提醒你】 哦不! 你陷入了死亡陷阱! 你被杀了!")
	client_print((id2 + 1), print_chat, "【CS插件专区提醒你】 你的死亡陷阱把 %s 杀死了!", aName)
	client_print(0, print_chat, "【CS插件专区提醒你】 %s 陷入了 %s 的死亡陷阱!", pName, aName)

	return 1
}

//
// Blinds the user and initializes BlindTask to keep them blind
//
public BlindUser(id)
{
	message_begin(MSG_ONE, get_user_msgid("ScreenFade"), {0,0,0}, id)
	write_short(1<<12)
	write_short(1<<8)
	write_short(1<<0)
	write_byte(0)
	write_byte(0)
	write_byte(0)
	write_byte(255)
	message_end()
	set_task(1.0, "BlindTask", id)
	set_task(WAIT_TIME, "UnBlindUser", id)
	return PLUGIN_CONTINUE
}

//
// Blinds the user
//
public BlindTask(id)
{
	if (is_blind[id - 1])
	{
		message_begin(MSG_ONE, get_user_msgid("ScreenFade"), {0,0,0}, id)
		write_short(1<<0)
		write_short(1<<0)
		write_short(1<<2)
		write_byte(0)
		write_byte(0)
		write_byte(0)
		write_byte(255)
		message_end()
	}
}

public UnBlindUser(id)
{
	if (is_blind[id - 1])
	{
		new pName[32]

		message_begin(MSG_ONE, get_user_msgid("ScreenFade"), {0,0,0}, id); 	// use the magic #1 for "one client"  
		write_short( 1<<12 ); 	// fade lasts this long duration  
		write_short( 1<<8 ); 	// fade lasts this long hold time  
		write_short( 1<<1 ); 	// fade type
		write_byte( 0 ); 	// fade red  
		write_byte( 0 ); 	// fade green  
		write_byte( 0 ); 	// fade blue
		write_byte( 128 ); 	// fade alpha  
		message_end( );

		is_blind[id - 1] = false

		get_user_name(id, pName, 31)
		client_print(0, print_chat, "【CS插件专区提醒你】 %s 已经不盲目了!", pName)

		set_user_rendering(id,kRenderFxNone,255,255,255, kRenderNormal,16);
	}
}

public UnSlowUser(id)
{
	new pName[32]

        set_user_maxspeed(id - TASK_SLOW, 250.0)

        is_slow[(id - TASK_SLOW) - 1] = false
	user_speed[(id - TASK_SLOW) - 1] = 250.0
	set_user_rendering(id - TASK_SLOW,kRenderFxNone,255,255,255, kRenderNormal,16);

	get_user_name(id - TASK_SLOW, pName, 31)
	client_print(0, print_chat, "【CS插件专区提醒你】 %s 的速度已经回复正常!", pName)

        if (task_exists(id))
                remove_task(id)
}

public UnDrugUser(id)
{
	new pName[32]

        set_user_maxspeed(id - TASK_DRUG, 250.0)

        is_drugged[(id - TASK_DRUG) - 1] = false
	set_user_rendering(id - TASK_DRUG,kRenderFxNone,255,255,255, kRenderNormal,16);

	message_begin(MSG_ONE, get_user_msgid("SetFOV"), {0,0,0}, id - TASK_DRUG)
	write_byte(90)
	message_end()

	get_user_name(id - TASK_DRUG, pName, 31)
	client_print(0, print_chat, "【CS插件专区提醒你】 %s 毒性已消失!", pName)

        if (task_exists(id))
                remove_task(id)
}

public UnBuryUser(id, id2)
{
	new pOrigin[3], pName[32]

	get_user_origin(id - TASK_BURY, pOrigin, 0)
        pOrigin[2] += buryOrigins[(id - TASK_BURY) - 1]

	set_user_origin(id - TASK_BURY, pOrigin)
        buryOrigins[(id - TASK_BURY) - 1] = 0

        is_bury[(id - TASK_BURY) - 1] = false
        set_user_rendering(id - TASK_BURY,kRenderFxNone,255,255,255, kRenderNormal,16);

	get_user_name(id - TASK_BURY, pName, 31)
	client_print(0, print_chat, "【CS插件专区提醒你】 %s 已经不被埋葬了!", pName)

        if (task_exists(id))
                remove_task(id)
}
//
// This event is called on a ScreenFade
//
public Event_ScreenFade(id)
{
	set_task(0.6, "BlindTask", id)
	return PLUGIN_CONTINUE
}

//
// Hiccups the user
//
public HiccupUser(id, id2)
{
	new aName[32], pName[32]
	new r = random(5) + 1

	set_task(float(r), "PlayHic", TASK_PLAYHIC + id)
	set_task(WAIT_TIME * 1.5, "UnHiccupUser", TASK_HICCUP + id)

	get_user_name(id, pName, 31)
	get_user_name(pTrapOwner[id2], aName, 31)

	client_print(id, print_chat, "【CS插件专区提醒你】 哦不! 你陷入了打嗝陷阱!  你正在打嗝!")
	client_print(0, print_chat, "【CS插件专区提醒你】 %s 陷入了 %s 的打嗝陷阱!", pName, aName)

	return 1
}

public PlayHic(id)
{
	new mid = id - TASK_PLAYHIC

	new Float:velocity[3]
		
	//set player Z velocity to make player bounce
	entity_get_vector(mid, EV_VEC_velocity, velocity)
	velocity[2] = 250.0					//jump velocity
	entity_set_vector(mid, EV_VEC_velocity, velocity)
		
	entity_set_int(mid, EV_INT_gaitsequence, 6)		//play the Jump Animation

	new h = random(3)

	emit_sound(mid, CHAN_WEAPON, soundHiccups[h], 1.0, ATTN_NORM, 0, PITCH_NORM)

	new r = random(5) + 1
	set_task(float(r), "PlayHic", id)
	
	return 1
}

public UnHiccupUser(id)
{
	new pName[32]

	is_hiccup[(id - TASK_HICCUP) - 1] = false

	get_user_name(id - TASK_HICCUP, pName, 31)
	client_print(0, print_chat, "【CS插件专区提醒你】 %s 已经不再打嗝!", pName)

        if (task_exists(id))
                remove_task(id)

	if(task_exists(id + 100))
		remove_task(id + 100)
}

public cmdMath(id) {
	new count = random_num(3, 6)
	new values[10]
	new operations[10]
	
	for(new i = 0; i < count; i++) {

		if(i < count - 1)
			operations[i] = random_num(0, 3)

		do {
			values[i] = random_num(1, 20)
		} while ((i > 0) && (values[i] == 0) && (operations[i - 1] == OP_DIVIDE))

	}
	
	new solved = values[random_num(0, count - 1)]
	
	new str[256]
	new fl[16]
	
	for(new i = 0; i < count - 1; i++) {
		add(str, sizeof(str), "(")
	}
	for(new i = 0; i < count; i++) {
		if(values[i] == solved) {
			add(str, sizeof(str), "x");
		} else {
			num_to_str(values[i], fl, sizeof(fl))
			add(str, sizeof(str), fl)
		}
		if(i > 0) {
			add(str, sizeof(str), ")")
		}
		
		if(i < count - 1) {
			add(str, sizeof(str), operators[operations[i]])
		}
		
	}
	
	new Float:fValue = float(values[0])
	for(new i = 1; i < count; i++) {
		switch(operations[i - 1]) {
			case OP_ADD: fValue = floatadd(fValue, float(values[i]))
			case OP_SUBTRACT: fValue = floatsub(fValue, float(values[i]))
			case OP_MULTIPLY: fValue = floatmul(fValue, float(values[i]))
			case OP_DIVIDE: fValue = floatdiv(fValue, float(values[i]))
		}

	}
	
	if (solved == mathLastGuess[id - 1])
	{
		cmdMath(id)
		return PLUGIN_HANDLED
	}
	if (solved == mathLastGuess2[id - 1])
	{
		cmdMath(id)
		return PLUGIN_HANDLED
	}

	format(mathEquations[id - 1], 127, "问题: %s = %f", str, fValue)

	mathAnswer[id - 1] = solved

	set_hudmessage(200, 155, 0, -1.0, 0.50, 0, 6.0, 1.0, 0.3, 0.5, 3)
	show_hudmessage(id, mathEquations[id - 1])

	set_task(1.0, "MathTask", TASK_MATH + id, "", 0, "b")

	return PLUGIN_HANDLED
}

public MathTask(id)
{
	new mid = id - TASK_MATH

	if (is_math[mid - 1])
	{
		set_hudmessage(200, 155, 0, -1.0, 0.50, 0, 6.0, 1.1, 0.3, 0.5, 3)
		show_hudmessage(mid, mathEquations[mid - 1])
	}


}
/*\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
\\//\\  MENU SETUPS     \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\*/

//
// Sets up the Buy Menu (for picking which Trap to buy)
//

public SetupBuyMenu()
{
	new menuLen = format(BuyMenuBodyText, 255, "\r购买陷阱^n^n")
	menuLen += format(BuyMenuBodyText[menuLen], 255 - menuLen, "\w1. 埋葬 \y(%d弹药包)^n", get_cvar_num("zp_price_bury"))
	menuLen += format(BuyMenuBodyText[menuLen], 255 - menuLen, "\w2. 扇嘴 \y(%d弹药包)^n", get_cvar_num("zp_price_slap"))
	menuLen += format(BuyMenuBodyText[menuLen], 255 - menuLen, "\w3. 死亡 \y(%d弹药包)^n", get_cvar_num("zp_price_death"))
	menuLen += format(BuyMenuBodyText[menuLen], 255 - menuLen, "\w4. 盲目 \y(%d弹药包)^n", get_cvar_num("zp_price_blind"))
	menuLen += format(BuyMenuBodyText[menuLen], 255 - menuLen, "\w5. 缓慢 \y(%d弹药包)^n", get_cvar_num("zp_price_slow"))
	menuLen += format(BuyMenuBodyText[menuLen], 255 - menuLen, "\w6. 数学 \y(%d弹药包)^n", get_cvar_num("zp_price_math"))
	menuLen += format(BuyMenuBodyText[menuLen], 255 - menuLen, "\w7. 毒药 \y(%d弹药包)^n", get_cvar_num("zp_price_drug"))
	menuLen += format(BuyMenuBodyText[menuLen], 255 - menuLen, "\w8. 打嗝 \y(%d弹药包)^n^n9.后退^n0.退出", get_cvar_num("zp_price_hiccup"))
	
	return 1
}

//
// Sets up the main menu
//

public SetupMainMenu()
{
	new menuLen = format(MainMenuBodyText, 255, "\r陷阱!^n^n")
	menuLen += format(MainMenuBodyText[menuLen], 255 - menuLen, "\w1. 购买陷阱^n")
	menuLen += format(MainMenuBodyText[menuLen], 255 - menuLen, "\w2. 选择陷阱^n^n")
	menuLen += format(MainMenuBodyText[menuLen], 255 - menuLen, "\w4. 安置陷阱^n^n")
	menuLen += format(MainMenuBodyText[menuLen], 255 - menuLen, "\w6. 购买陷阱探测镜 \y(%d 弹药包)^n", get_cvar_num("zp_price_goggle"))
	menuLen += format(MainMenuBodyText[menuLen], 255 - menuLen, "\w7. 购买陷阱免疫 \y(%d 弹药包)^n^n", get_cvar_num("zp_price_immunity"))

	menuLen += format(MainMenuBodyText[menuLen], 255 - menuLen, "\w0. 退出")

	return 1
}

//
// Sets up the Pick Menu (for picking which Trap to plant)
//
public SetupPickMenu(id)
{
	new menuLen = format(PickMenuBodyText, 255, "\r挑选陷阱^n^n")
	menuLen += format(PickMenuBodyText[menuLen], 255 - menuLen, "\w1. 埋葬陷阱 \y(%d)^n", pTrapTypes[id - 1][T_BURY])
	menuLen += format(PickMenuBodyText[menuLen], 255 - menuLen, "\w2. 扇嘴陷阱 \y(%d)^n", pTrapTypes[id - 1][T_SLAP])
	menuLen += format(PickMenuBodyText[menuLen], 255 - menuLen, "\w3. 死亡陷阱  \y(%d)^n", pTrapTypes[id - 1][T_DEATH])
	menuLen += format(PickMenuBodyText[menuLen], 255 - menuLen, "\w4. 盲目陷阱 \y(%d)^n", pTrapTypes[id - 1][T_BLIND])
	menuLen += format(PickMenuBodyText[menuLen], 255 - menuLen, "\w5. 缓慢陷阱 \y(%d)^n", pTrapTypes[id - 1][T_SLOW])
	menuLen += format(PickMenuBodyText[menuLen], 255 - menuLen, "\w6. 数学陷阱 \y(%d)^n", pTrapTypes[id - 1][T_MATH])
	menuLen += format(PickMenuBodyText[menuLen], 255 - menuLen, "\w7. 毒药陷阱 \y(%d)^n", pTrapTypes[id - 1][T_DRUG])
	menuLen += format(PickMenuBodyText[menuLen], 255 - menuLen, "\w8. 打嗝陷阱 \y(%d)^n^n9.后退^n0.退出", pTrapTypes[id - 1][T_HICCUP])

	return 1
}


/*\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
\\//\\  HELP    \\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\*/

public ClCmdSay(id)
{
	new Message[128], pName[32]

	read_argv(1, Message, 127)
	remove_quotes(Message)

	new myAns[128], pOrigin[3]
	num_to_str(mathAnswer[id - 1], myAns, 127)

	if (is_math[id - 1] && is_str_num(Message))
	{
		if (!equali(Message, mathLastGuess[id - 1]))
		{
			if (!equali(Message, mathLastGuess2[id - 1]))
			{
				mathLastGuess2[id - 1] = mathLastGuess[id - 1]
				mathLastGuess[id - 1] = str_to_num(Message)
			}
		}
				
			

		if (equali(Message, myAns))
		{
			client_print(id, print_chat, "【CS插件专区提醒你】 正确答案!!!")

			user_speed[id - 1] = 250.0
			set_user_maxspeed(id, 250.0)
			get_user_origin(id, pOrigin, 0)
			pOrigin[2] += 30;
			set_user_origin(id, pOrigin)
			is_math[id - 1] = false

        		if (task_exists(id + TASK_MATH))
                		remove_task(id + TASK_MATH)

			get_user_name(id, pName, 31)

			client_print(0, print_chat, "【CS插件专区提醒你】 %s 已解决他的问题，难题解除!", pName)
			set_user_rendering(id,kRenderFxNone,255,255,255, kRenderNormal,16);
			mathLastGuess[id - 1] = -1
		}
		else
		{
			new Health = get_user_health(id)
			new hp

			if (Health <= 10)
			{
				if (Health == 1)
				{
					user_kill(id)
					client_print(id, print_chat, "【CS插件专区提醒你】 不好!!!!! 你被杀了!! 哈哈哈!!")
					return PLUGIN_HANDLED
				} else {
					hp = 1
				}
			} else {
				hp = Health - 10
			}
			
			set_user_health(id, hp)

			client_print(id, print_chat, "【CS插件专区提醒你】 不好!!!!! 你失去 %d 生命值!", Health - hp)
			cmdMath(id)
		}

		return PLUGIN_HANDLED
	}

	if ((containi(Message, "trap") != -1) && (containi(Message, "how") != -1))
	{
		client_print(id, print_chat, "【CS插件专区提醒你】 输入 /traps 打开陷阱菜单")
	}

	return PLUGIN_CONTINUE
}
