#include <amxmodx>
#include <fakemeta>
#include <zombieplague>

#define PLUGIN "[ZP] Class : Chinese Zombie"
#define VERSION "1.2.2"
#define AUTHOR "YKH =]"

new const zclass6_name[] = { "中国僵尸" }
new const zclass6_info[] = { "按——E  能飞" }
new const zclass6_model[] = { "china" }
new const zclass6_clawmodel[] = { "zombie_drowned.mdl" }
const zclass6_health = 100
const zclass6_speed = 180
const Float:zclass6_gravity = 0.5
const Float:zclass6_knockback = 3.0

new g_zclass6_LongJump, g_LongJump_force, g_LongJump_height, cvar_cooldown
new Float:g_lastleaptime[33] // time leap was last used

public plugin_init()
{
	register_cvar("zp_zclass_leap_zombie",VERSION,FCVAR_SERVER|FCVAR_EXTDLL|FCVAR_UNLOGGED|FCVAR_SPONLY)
	
	g_LongJump_force = register_cvar("zp_zclass_leap_force", "400")
	g_LongJump_height = register_cvar("zp_zclass_leap_height", "275")
	cvar_cooldown = register_cvar("zp_leap_cooldown", "2.0")
	
	register_forward(FM_PlayerPreThink, "fw_PlayerPreThink")
}

public plugin_precache()
{
	g_zclass6_LongJump = zp_register_zombie_class(zclass6_name, zclass6_info, zclass6_model, zclass6_clawmodel, zclass6_health, zclass6_speed, zclass6_gravity, zclass6_knockback)
}

public zp_user_infected_post(player, infector)
{
	if (zp_get_user_zombie_class(player) == g_zclass6_LongJump)
	{
		client_print(player, print_chat, "[CS插件专区提醒你] 你选择中国僵尸 按E 就能飞o(∩_∩)o...哈哈 !")	
	}
	return PLUGIN_CONTINUE
}

public fw_PlayerPreThink(id)
{
	if (!is_user_alive(id))
		return
		
	if (allowed_LongJump(id))
	{
		static Float:velocity[3]
		velocity_by_aim(id, get_pcvar_num(g_LongJump_force), velocity)
		
		velocity[2] = get_pcvar_float(g_LongJump_height)
		
		set_pev(id, pev_velocity, velocity)

		// Set the current leap time
		g_lastleaptime[id] = get_gametime()
	}
}

allowed_LongJump(id)
{	
	if (!zp_get_user_zombie(id) && !zp_get_user_nemesis(id))
		return false

	if (zp_get_user_zombie_class(id) != g_zclass6_LongJump)
		return false
		 
	if (!((pev(id, pev_flags) & FL_ONGROUND) && (pev(id, pev_flags) & FL_DUCKING)) || fm_get_speed(id) < 10)
		return false
	
	static buttons
	buttons = pev(id, pev_button)
	
	// Not doing a longjump (added bot support)
	if (!(buttons & IN_USE) && !is_user_bot(id))
		return false

	// Get cooldown cvar
	static Float:cooldown
	cooldown = get_pcvar_float(cvar_cooldown)

	// Cooldown not over yet
	if (get_gametime() - g_lastleaptime[id] < cooldown)
		return false
		
	return true
}

stock fm_get_speed(entity)
{
	static Float:velocity[3]
	pev(entity, pev_velocity, velocity)
	
	return floatround(vector_length(velocity));
}

