/*
*	-----------------------------------
*	-----【CS插件专区提醒你】 Zombie Class: Smoker-----
*	-----------------------------------
*	------Author: 4eRT (aka pff)-------
*	-----------------------------------
*		About:
*	When Left4Dead came out i immediately thought about Zombie Class Smoker plugin.
*	More later(few days ago) I was playing on Superhero Server when i found Scorpion hero.
*	So it was the way to create this plugin.
*	-----------------------------------
*		Discription:
*	Smoker is another zombie class for zombie plague like Smoker in L4D.
*	He can drags humans by holding "V" like /\...yeah, like Smoker. If Smoker receives
*	300 damage by human drag ends. If he falls or hurts more 25 dmg drag ends to.
*	Drag speed, max drags, cooldown, autobind, drag teammates & damage to stop
*	may be customized by Cvars.
*	-----------------------------------
*		Credits:
*	yang - great thanks for his Scorpion superhero plugin where I borrow harpoon&drag code.
*	5c0r-|3i0 - for his converted Smoker sounds.
*	-----------------------------------
*		Cvars:
*	zp_smoker_maxdrags 10 // 可以拖拽多少次? def=10
*	zp_smoker_dragspeed 160 // 僵尸拖拽速度 def=160
*	zp_smoker_cooldown 5 // 冷却时间,再次拖动. def=5
*	zp_smoker_mates 0 // 僵尸可以拖动队友? 1=yes 0=no def=0
*	zp_smoker_bind 1 // 关键绑定 V 和 +drag. 0=no autobind 1=autobind (v) def=1
*	zp_smoker_dmg2stop 300 // 损害停止拖动 def=300
*	-----------------------------------
 * 历史（测试版） ： 
* 0.0 (14.04.09) * 0.0 （ 14.04.09 ） 
* Most of code converted from sh_scorpion. *大部分的代码转换sh_scorpion 。 Added 3 cvars.时间3 cvars 。 
* 0.1 (15.04.09) * 0.1 （ 15.04.09 ） 
* Added cooldown, autobind, damage to stop and its cvars. *时间冷却， autobind ，损坏停止及其cvars 。 
* 0.1 (16.04.09) * 0.1 （ 16.04.09 ） 
* Beta testing. *测试。 First view works perfectly...第一期工程完全... 

*	-----------------------------------
*		PS:
*	It's my second useful plugin for amxx so...
*/

#include <amxmodx>
#include <zombieplague>
#include <fakemeta>
#include <hamsandwich>
#include <Vexd_Utilities> //因此它主要包括的插件。没有这个能力将吸烟者只有梁，不拖

#define PLUGIN "【CS插件专区提醒你】 Class Smoker"
#define VERSION "0.1"
#define AUTHOR "4eRT"

//Main Class & Sprite Beam
new g_zclass_smoker, g_Line
//Sounds
new g_sndMiss[] = "zombie_plague/Smoker_TongueHit_miss.wav"
new g_sndDrag[] = "zombie_plague/Smoker_TongueHit_drag.wav"
//Some vars
new g_hooked[33], g_hooksLeft[33]
new Float:g_lastHook[33]
//Cvars
new cvar_maxdrags, cvar_dragspeed, cvar_cooldown, cvar_dmg2stop, cvar_mates, cvar_bind
//Smoker Atributes
new const zclass_name[] = { "吸烟者" }
new const zclass_info[] = { "V拽动玩家过来" }
new const zclass_model[] = { "zombie_source" }
new const zclass_clawmodel[] = { "v_knife_zombie.mdl" }
const zclass_health = 1400
const zclass_speed = 190
const Float:zclass_gravity = 1.0
const Float:zclass_knockback = 1.0

public plugin_init()
{
	cvar_dragspeed = register_cvar("zp_smoker_dragspeed", "160")
	cvar_maxdrags = register_cvar("zp_smoker_maxdrags", "10")
	cvar_cooldown = register_cvar("zp_smoker_cooldown", "5")
	cvar_dmg2stop = register_cvar("zp_smoker_dmg2stop", "300")
	cvar_mates = register_cvar("zp_smoker_mates", "0")
	cvar_bind = register_cvar("zp_smoker_bind", "1")
	register_event("ResetHUD", "newSpawn", "b")
	register_event("DeathMsg", "smoker_death", "a")
	RegisterHam(Ham_TakeDamage, "player", "fw_TakeDamage")
	register_clcmd("+drag","drag_start", ADMIN_USER, "bind ^"key^" ^"+drag^"")
	register_clcmd("-drag","drag_end")
}
public plugin_precache()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	g_zclass_smoker = zp_register_zombie_class(zclass_name, zclass_info, zclass_model, zclass_clawmodel, zclass_health, zclass_speed, zclass_gravity, zclass_knockback)
	precache_sound(g_sndDrag)
	precache_sound(g_sndMiss)
	g_Line = precache_model("sprites/zbeam4.spr")
}

public zp_user_infected_post(id, infector)
{
	if (zp_get_user_zombie_class(id) == g_zclass_smoker) {
		
		new mode = get_pcvar_num(cvar_bind)
		
		if (mode == 1) {
			client_cmd(id, "bind v ^"+drag^"")
			client_print(id, print_chat, "【CS插件专区提醒你】 拖动玩家到自己面前 ^'^'V^'^'")
		} else {
			client_print(id, print_chat, "【CS插件专区提醒你】 拖动玩家给自己 (bind ^'^'key^'^' ^'^'+drag^'^') 使用绑定V键")
		}
	}
}

public newSpawn(id)
{
	g_hooksLeft[id] = get_pcvar_num(cvar_maxdrags)
	g_lastHook[id] = get_gametime()
	
	if (g_hooked[id])
		drag_end(id)
}

public drag_start(id) // starts drag, checks if player is Smoker, checks cvars
{
	if (zp_get_user_zombie(id) && zp_get_user_zombie_class(id) == g_zclass_smoker) {
		
		static Float:cdown
		cdown = get_pcvar_float(cvar_cooldown)
			
		if (!is_user_alive(id)) {
			client_print(id, print_chat, "【CS插件专区提醒你】 你不能拖动如果您死掉了!")
			return
		}

		if (g_hooksLeft[id] <= 0) {
			client_print(id, print_chat, "【CS插件专区提醒你】 你不能拖了!")
			return
		}
			
		if (get_gametime() - g_lastHook[id] < cdown) {
			client_print(id, print_chat, "【CS插件专区提醒你】 等待 %d 第二次拖动!", get_pcvar_num(cvar_cooldown))
			return
		}

		if (g_hooksLeft[id] > 0) {
			g_hooksLeft[id]--
			client_print(id, print_chat, "【CS插件专区提醒你】 You can drag player to youself %d time%s", g_hooksLeft[id], (g_hooksLeft[id] < 2) ? "" : "s")
		}

		new hooktarget, body

		get_user_aiming(id, hooktarget, body)

		if (is_user_alive(hooktarget)) {
			if (get_user_team(hooktarget) != get_user_team(id)) {
				g_hooked[id] = hooktarget
				emit_sound(hooktarget, CHAN_BODY, g_sndDrag, 1.0, ATTN_NORM, 0, PITCH_HIGH)
			}
			else if (get_pcvar_num(cvar_mates) == 1) {
				g_hooked[id] = hooktarget
				emit_sound(hooktarget, CHAN_BODY, g_sndDrag, 1.0, ATTN_NORM, 0, PITCH_HIGH)
			} else {
				g_hooked[id] = 33
				noTarget(id)
				emit_sound(hooktarget, CHAN_BODY, g_sndMiss, 1.0, ATTN_NORM, 0, PITCH_HIGH)
				return
			}

			new parm[2]
			parm[0] = id
			parm[1] = hooktarget
			
			set_task(0.1, "smoker_reelin", id, parm, 2, "b")
			harpoon_target(parm)
		} else {
			g_hooked[id] = 33
			noTarget(id)
			emit_sound(hooktarget, CHAN_BODY, g_sndMiss, 1.0, ATTN_NORM, 0, PITCH_HIGH)
		}
	} else {
		return
	}
}

public smoker_reelin(parm[]) // dragging player to smoker
{
	new id = parm[0]
	new victim = parm[1]

	if (!g_hooked[id])
		return

	if (!is_user_alive(victim)) {
		drag_end(id)
		return
	}

	new Float:fl_Velocity[3]
	new idOrigin[3], vicOrigin[3]

	get_user_origin(victim, vicOrigin)
	get_user_origin(id, idOrigin)

	new distance = get_distance(idOrigin, vicOrigin)

	if (distance > 5) {
		new Float:fl_Time = distance / get_pcvar_float(cvar_dragspeed)

		fl_Velocity[0] = (idOrigin[0] - vicOrigin[0]) / fl_Time
		fl_Velocity[1] = (idOrigin[1] - vicOrigin[1]) / fl_Time
		fl_Velocity[2] = (idOrigin[2] - vicOrigin[2]) / fl_Time
	} else {
		fl_Velocity[0] = 0.0
		fl_Velocity[1] = 0.0
		fl_Velocity[2] = 0.0
	}

	Entvars_Set_Vector(victim, EV_VEC_velocity, fl_Velocity) //<- this from vexd_utilities
}

public drag_end(id) // drags end function
{
	g_hooked[id] = 0
	beam_remove(id)
	remove_task(id)
	g_lastHook[id] = get_gametime()
}

public smoker_death() // if smoker dies drag off
{
	new id = read_data(2)
	if (g_hooked[id])
		drag_end(id)
}

public fw_TakeDamage(victim, inflictor, attacker, Float:damage, damage_type) // if take damage drag off
{
	if (victim == attacker || !is_user_connected(attacker)) {
		if (damage > 25) {
			drag_end(victim)
			return HAM_IGNORED;
		}
	}
	
	if (get_user_team(attacker) != get_user_team(victim)) {
		if (damage > get_pcvar_num(cvar_dmg2stop)) {
			drag_end(victim)
			return HAM_IGNORED;
		}
	}
	
	return HAM_IGNORED;
}

public client_disconnect(id) // if client disconnects drag off
{
	if (id <= 0 || id > 32)
		return
	
	if (g_hooked[id])
		drag_end(id)
}

public harpoon_target(parm[]) // set beam (ex. tongue:) if target is player
{
	new id = parm[0]
	new hooktarget = parm[1]

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(8)	// TE_BEAMENTS
	write_short(id)
	write_short(hooktarget)
	write_short(g_Line)	// sprite index
	write_byte(0)	// start frame
	write_byte(0)	// framerate
	write_byte(200)	// life
	write_byte(8)	// width
	write_byte(1)	// noise
	write_byte(155)	// r, g, b
	write_byte(155)	// r, g, b
	write_byte(55)	// r, g, b
	write_byte(90)	// brightness
	write_byte(10)	// speed
	message_end()
}

public noTarget(id) // set beam if target isn't player
{
	new endorigin[3]

	get_user_origin(id, endorigin, 3)

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte( TE_BEAMENTPOINT ); // TE_BEAMENTPOINT
	write_short(id)
	write_coord(endorigin[0])
	write_coord(endorigin[1])
	write_coord(endorigin[2])
	write_short(g_Line) // sprite index
	write_byte(0)	// start frame
	write_byte(0)	// framerate
	write_byte(200)	// life
	write_byte(8)	// width
	write_byte(1)	// noise
	write_byte(155)	// r, g, b
	write_byte(155)	// r, g, b
	write_byte(55)	// r, g, b
	write_byte(75)	// brightness
	write_byte(0)	// speed
	message_end()
}

public beam_remove(id) // remove beam
{
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(99)	//TE_KILLBEAM
	write_short(id)	//entity
	message_end()
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1049\\ f0\\ fs16 \n\\ par }
*/
