// ------------------------------------------------------------------------------------------------
//
//  File: Colour.inl
//
//      Description     - Implementation of the inline Colour functions
//      Author          - Aidan Millott
//
//  Modifications:
//  --------------
//       July 30, 2009    - Initial creation.
//
// ------------------------------------------------------------------------------------------------

#if defined(_MSC_VER)
#pragma warning(push)
#pragma warning(disable : 4244)	// TODO: fix this properly so we don't get any "conversion from 'xxx' to 'yyy', possible loss of data" warnings
#endif

// Operator +
//
inline Colour Colour::operator + ( const Colour& rhs ) const
{
	return Colour((r + rhs.r), (g + rhs.g), (b + rhs.b),  a/*(s32)(a + rhs.a)*/ );
}

inline Colour Colour::operator + ( kf32 rhs ) const
{
	s32 val = (s32)rhs;
	if(rhs < 1.0f)
	{
		val = (s32)(rhs*255);
	}
	return Colour( (r + val), (g + val),( b + val),a/*(s32)(a + val)*/);
}

// Operator =
//
inline Colour Colour::operator = ( const Colour& rhs )
{
	a = rhs.a;
	r = rhs.r;
	g = rhs.g;
	b = rhs.b;
	return *this;
}

inline Colour Colour::operator = ( kf32 rhs )
{
	a = rhs;
	r = rhs;
	g = rhs;
	b = rhs;
	return *this;
}

// Operator -
//
inline Colour Colour::operator - ( const Colour& rhs ) const
{
	return Colour((r - rhs.r), (g - rhs.g),( b - rhs.b), a /*(s32)(a - rhs.a)*/ );
}

inline Colour Colour::operator - ( kf32 rhs ) const
{
	s32 val = (s32)rhs;
	if(rhs < 1.0f)
	{
		val = (s32)(rhs*255);
	}
	return Colour(( r - val), (g - val),( b - val),a/*(s32)(a - val)*/);
}



// Operator *
//
inline Colour Colour::operator * ( const kf32& rhs ) const
{
	return	Colour
		(
		( r* rhs ),
		( g* rhs ),
		( b* rhs ),
		//(s32)( a* rhs )
		a
		);
}

inline Colour Colour::operator / ( const kf32& rhs ) const
{
	return	Colour
		(
		( r/ rhs ),
		( g/ rhs ),
		( b/ rhs ),
		//(s32)( a/ rhs )
		a
		);
}



// Operator +=
//
inline Colour& Colour::operator += (const Colour& rhs )
{
	r += rhs.r;
	g += rhs.g;
	b += rhs.b;
	//a += rhs.a;

	return *this;
}

inline Colour& Colour::operator += (const kf32 rhs )
{
	s32 val = (s32)rhs;
	if(rhs < 1.0f)
	{
		val = (s32)(rhs*255);
	}


	r += val;
	g += val;
	b += val;
	//a += val;

	return *this;
}

// Operator -=
//
inline Colour& Colour::operator -= ( const Colour& rhs )
{
	r -= rhs.r;
	g -= rhs.g;
	b -= rhs.b;
	//a -= rhs.a;

	return *this;
}

inline Colour& Colour::operator -= ( const kf32 rhs )
{
	s32 val = (s32)rhs;
	if(rhs < 1.0f)
	{
		val = (s32)(rhs*255);
	}


	r -= val;
	g -= val;
	b -= val;
	//a -= val;

	return *this;
}


// Operator *=
//
inline Colour& Colour::operator *= ( const kf32 val )
{
	r = ( r* val );
	g = ( g* val );
	b = ( b* val );
	//a = ( a* val );

	return *this;
}

// Operator /=
inline Colour& Colour::operator /= ( const kf32 val )
{
	r = ( r/ val );
	g = ( g/ val );
	b = ( b/ val );
	//a = ( a/ val );

	return *this;
}


// Operator ==
inline bool Colour::operator == (const Colour &v) const
{
	return (element == v.element);
}


// Operator !=
inline bool Colour::operator != (const Colour &v) const
{
	return (element != v.element);
}

#if defined(_MSC_VER)
#pragma warning(pop)
#endif
