// ------------------------------------------------------------------------------------------------
//
//  File: DeviceResource.inl
//
//      Description		- Implements the static functions that enumerate through all resources
//						  informing them of a specific event.
//      Author			- Grant Peters
//
//  Modifications:
//  --------------
//      Sept 8, 2009	- Grant: Copied from my private engine.
//
// ------------------------------------------------------------------------------------------------

namespace Mortar
{
	template<typename DeviceType>
	void DeviceResource<DeviceType>::TriggerDeviceLost(DeviceType *device)
	{
		for(DeviceResource *resource = HeadInstance(); resource != NULL; resource = resource->NextInstance())
		{
			resource->DeviceLost(device);
		}
	}

	template<typename DeviceType>
	void DeviceResource<DeviceType>::TriggerDeviceReset(DeviceType *device)
	{
		for(DeviceResource *resource = HeadInstance(); resource != NULL; resource = resource->NextInstance())
		{
			resource->DeviceReset(device);
		}
	}
}
