// ------------------------------------------------------------------------------------------------
//
// Matrix.inl
//
// ------------------------------------------------------------------------------------------------

template<class T>
const _Matrix44<T> _Matrix44<T>::Identity(
	1,0,0,0,
	0,1,0,0,
	0,0,1,0,
	0,0,0,1);



template<class T> void _Matrix33<T>::Copy33To43(_Matrix43<T> &dest) const
{
	for(int i =0;i<9;i++)
		dest.a[i]=a[i];
	dest._30 = 0;
	dest._31 = 0;
	dest._32 = 0;
}

template<class T> void _Matrix33<T>::Copy33To44(_Matrix44<T> &dest) const
{
	dest._00 = _00;
	dest._01 = _01;
	dest._02 = _02;
	dest._03 = 0;
	dest._10 = _10;
	dest._11 = _11;
	dest._12 = _12;
	dest._13 = 0;
	dest._20 = _20;
	dest._21 = _21;
	dest._22 = _22;
	dest._23 = 0;
	dest._30 = 0;
	dest._31 = 0;
	dest._32 = 0;
	dest._33 = 1.0f;
}

template<class T> void _Matrix43<T>::Copy43To33(_Matrix33<T> &dest) const
{
	for(int i =0;i<9;i++)
		dest.a[i]=a[i];
}

template<class T> void _Matrix43<T>::Copy43To44(_Matrix44<T> &dest) const
{
	dest._00 = _00;
	dest._01 = _01;
	dest._02 = _02;
	dest._03 = 0;
	dest._10 = _10;
	dest._11 = _11;
	dest._12 = _12;
	dest._13 = 0;
	dest._20 = _20;
	dest._21 = _21;
	dest._22 = _22;
	dest._23 = 0;
	dest._30 = _30;
	dest._31 = _31;
	dest._32 = _32;
	dest._33 = 1.0f;
}

template<class T> void _Matrix44<T>::Copy44To33(_Matrix33<T> &dest) const
{
	dest._00 = _00;
	dest._01 = _01;
	dest._02 = _02;
	dest._10 = _10;
	dest._11 = _11;
	dest._12 = _12;
	dest._20 = _20;
	dest._21 = _21;
	dest._22 = _22;
}

template<class T> void _Matrix44<T>::Copy44To43(_Matrix43<T> &dest) const
{
	dest._00 = _00;
	dest._01 = _01;
	dest._02 = _02;
	dest._10 = _10;
	dest._11 = _11;
	dest._12 = _12;
	dest._20 = _20;
	dest._21 = _21;
	dest._22 = _22;
	dest._30 = _30;
	dest._31 = _31;
	dest._32 = _32;
}