// ------------------------------------------------------------------------------------------------
//
//  File: MatrixStack.inl
//
//      Description     - Implementation of the inline MatrixStack functions
//      Author          - Aidan Millott
//
//  Modifications:
//  --------------
//      August 4, 2009   - Initial creation.
//
// ------------------------------------------------------------------------------------------------


// Push the current Matrix onto the stack
inline void MatrixStack::Push()
{
	ASSERT(m_currentStackIndex < MAX_STACK_SIZE);


	m_mtxStack[m_currentStackIndex] = m_currentMtx;
	
	m_currentStackIndex++;
}

// Pop the required amount of matricies off the stack
inline void MatrixStack::Pop(u8 num)
{
	ASSERT(m_currentStackIndex >= num);

	m_currentStackIndex = (u8)(m_currentStackIndex - num);

	m_currentMtx = m_mtxStack[m_currentStackIndex];
	version++;
}

// copy the current matrix to the desired area of the stack
inline void MatrixStack::Store(u8 num)
{
	ASSERT(num < MAX_STACK_SIZE);

	m_mtxStack[num] = m_currentMtx;
}

// restores a previously stored Matrix
inline void MatrixStack::Restore(u8 num)
{
	ASSERT(num < MAX_STACK_SIZE);

	m_currentMtx = m_mtxStack[num];
	version++;

}

// reset the matrix stack to the default values
inline void MatrixStack::Reset()
{
	m_currentStackIndex = 0;
	m_mtxStack[m_currentStackIndex] = Mtx44::Identity;
	m_currentMtx = Mtx44::Identity;
	version++;

}

inline void MatrixStack::Translate(Vector3 amount)
{
	m_currentMtx.GlobalTranslate44(amount.x, amount.y, amount.z);
	version++;

}

inline void MatrixStack::Translate2D(Vector2 amount)
{
	//m_currentMtx._20 = amount.x * m_currentMtx._00 + amount.y * m_currentMtx._10;
	//m_currentMtx._21 = amount.x * m_currentMtx._01 + amount.y * m_currentMtx._11;
	m_currentMtx._20 += amount.x;
	m_currentMtx._21 += amount.y;
	version++;

}

inline void MatrixStack::TranslateLocal(Vector3 amount)
{
	m_currentMtx.LocalTranslate44(amount.x, amount.y, amount.z);
	version++;

}

inline void MatrixStack::Scale(Vector3 amount)
{
	m_currentMtx.Scale44(amount.x, amount.y, amount.z);
	version++;

}

inline void MatrixStack::RotX(dec32 amount)
{
	m_currentMtx.RotX44(Math::SinIdx(DEGREE_TO_IDX(amount)),Math::CosIdx(DEGREE_TO_IDX(amount)));
	version++;

}

inline void MatrixStack::RotY(dec32 amount)
{
	m_currentMtx.RotY44(Math::SinIdx(DEGREE_TO_IDX(amount)),Math::CosIdx(DEGREE_TO_IDX(amount)));
	version++;

}

inline void MatrixStack::RotZ(dec32 amount)
{
	m_currentMtx.RotZ44(Math::SinIdx(DEGREE_TO_IDX(amount)),Math::CosIdx(DEGREE_TO_IDX(amount)));
	version++;

}

inline void MatrixStack::MtxMul(Mtx44 mul)
{
	m_currentMtx.Mul44(mul);
	version++;

}