﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="filemanager.aspx.cs" Inherits="PPFOR.Admin.CustomView.filemanager" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head id="Head1" runat="server">
    <title>目录管理</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />    
    <link href="../Css/global.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="../JS/gridview.js"></script>   
    <script type="text/javascript" src="../JS/opopup.js"></script>     
    <script type="text/javascript" language="javascript">      
    function checkCurFolder(){
        var v=document.getElementById("PPFOR_currentPath").value;
        if(validatePath(v)==true){            
            return true;
        }else{
            showErrMsg("路径必须以/开头，并不允许包含以下任何字符之一：\\:<>?*\"|");
            return false;
        }
    }           
    function showErrMsg(msg){
        var obj=document.getElementById('PPFOR_errText');
        if(obj!=null) obj.innerHTML=msg;
        showDiv('divErr',"Error",300,100);
    };
    function createClick()
    {
        showDiv('divCreate',"新建目录",300,100);
    };        
    function renameClick() {
        if(CountSelected('<%= form1.ClientID %>')==1){            
            showDiv('divRename',"重命名",300,100);
        }else{
            showErrMsg("请选择一个目录或文件进行重命名操作");
        }
     };
    function deleteClick() {
        if(CountSelected('<%= form1.ClientID %>')>0){
            showDiv('divDelete',"删除文件",300,100);
        }else{
            showErrMsg("请至少选择一个目录或文件进行删除操作");
        }
    };  
    function validatePath(v){
        var regStr=/^[/][^\\<>*?:\"|]{0,100}$/;
        return regStr.test(v);
    };
    function showDiv(id,title,width,height)
    {
        popup_show(title,id,width,height);
    }
    function closePopup()
    {
        popup_close();
    }
    function selectFile(path)
    {
        var objs=window.parent.document.getElementsByTagName('input');
        var rid=document.getElementById("PPFOR_rid").value;
        if(objs!=null && rid!='')
        {                
            for(var i=0;i<objs.length;i++)
            {                
                if(objs[i].getAttribute('rtype')!=null && objs[i].getAttribute('rtype')=='file' && objs[i].getAttribute("rid")!=null && objs[i].getAttribute("rid")==rid){
                    objs[i].value=path;    
                    if(document.all)
                    {
                        objs[i].fireEvent("onchange");
                    }
                    else
                    {
                        var evt = document.createEvent('HTMLEvents');   
                        evt.initEvent('change',true,true);   
                        objs[i].dispatchEvent(evt);   
                    }                    
                    break;
                }
            }
        }
        parent.popup_close();
    }
    </script>
</head>
<body>
<form id="form1" runat="server" class="customview">
   <div id="menu">
    <ul>
        <li><a href="filemanager.aspx"><img title="刷新" alt="刷新" src="../Images/ico/refresh.gif"/> 刷新</a></li>
        <li><a onclick="createClick();" id="create" ><img title="新建目录" alt="新建目录" src="../Images/ico/folder_new.gif"/> 新建目录</a></li>
        <li><a onclick="renameClick();" id="rename"><img title="重命名" alt="重命名" src="../Images/ico/rename.gif" /> 重命名</a></li>
        <li><a onclick="deleteClick();" id="delete"><img title="删除" alt="删除" src="../Images/ico/delete.gif" /> 删除</a></li>
    </ul>
   </div>   
<div id="popupClass" class="popup_class" style="visibility: hidden; display: none;">
   <iframe id="popupIFrame" class="iframe_for_hide" frameborder="0"></iframe>
   <div class="menu_form_header" id="popupDrag">
		<img alt="" class="menu_form_exit" id="popupExit" src="../Images/close.png" />
		<label id="popupTitle">标题</label>
	</div>
   <div id="divCreate" class="menu_form_body" style="display:none;">
       名称：<asp:TextBox ID="PPFOR_newName" runat="server" AutoCompleteType="None"></asp:TextBox><br />
       <asp:Button ID="PPFOR_btnCreateFolder" runat="server" Text="确定" OnClick="PPFOR_btnCreateFolder_Click" />
       <input type="button" value="取消" onclick="closePopup();" /><br />
   </div>   
   <div id="divRename" class="menu_form_body" style="display:none;">
       新名称：<asp:TextBox ID="PPFOR_reName" runat="server"></asp:TextBox><br />
       <asp:Button ID="PPFOR_btnRename" runat="server" Text="确定" OnClick="PPFOR_btnRename_Click" />
       <input type="button" value="取消" onclick="closePopup();" /><br />
   </div>   
   <div id="divDelete" class="menu_form_body" style="display:none;">
       <p>确定删除选中的目录或文件吗？<br /><br />
       <asp:Button ID="PPFOR_btnDelete" runat="server" Text="确定" OnClick="PPFOR_btnDelete_Click" />
       <input type="button" value="取消" onclick="closePopup();" /></p>
   </div>   
   <div id="divErr" class="menu_form_body" style="display:none;">
       <p><asp:Label ID="PPFOR_errText" Text="Err" Font-Bold="true" runat="server" Font-Names="Verdana" Font-Size="12px"></asp:Label><br /><br />
       <input type="button" value="确定" onclick="closePopup();" /></p>
   </div>
</div>
   <div style="padding:5px;" >
        <table width="100%" border="0" cellpadding="0" cellspacing="0" class="fortable">
        <tr>        
        <td style="width:60px" align="right" valign="middle">当前目录：</td>
        <td valign="middle" align="center">
            <asp:TextBox ID="PPFOR_currentPath" runat="server" Font-Names="Verdana" Font-Size="12px" Width="98%" MaxLength="255"></asp:TextBox><br />
            <asp:HiddenField ID="PPFOR_rid" runat="server"></asp:HiddenField>
        </td>
        <td valign="middle" align="center" style="width:85px"><asp:Button runat="server" ID="PPFOR_selectCurFolder" CssClass="inputbutton" Text="打开" Width="80px" OnClientClick="return checkCurFolder();" OnClick="PPFOR_selectCurFolderClick" /></td>
        </tr>
        </table>
    </div>
    <div style="padding:5px;">
        <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" Width="100%" OnRowCommand="GridView1_RowCommand" Font-Names="Verdana" Font-Size="12px" OnRowDataBound="GridView1_RowDataBound" CellPadding="0" BackColor="White" BorderColor="#CCCCCC" BorderStyle="None" BorderWidth="0px" CssClass="forgridview" EmptyDataText="目录不存在或无文件">
            <Columns>
                <asp:TemplateField>
                    <ItemTemplate>
                        <asp:CheckBox ID="PPFOR_selectFolder" runat="server" />
                    </ItemTemplate>
                    <HeaderTemplate>
                        <asp:CheckBox ID="PPFOR_selectFolder" runat="server" />
                    </HeaderTemplate>
                    <ItemStyle Wrap="False" HorizontalAlign="Center" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="名称">
                    <ItemTemplate>
                        <asp:LinkButton ID="LinkButton1" runat="server" CommandArgument='<%# Eval("FullName") %>' Text='<%# Eval("Name") %>'></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="Type" HeaderText="类型">
                    <ItemStyle HorizontalAlign="Center" Wrap="False" />
                </asp:BoundField>
                <asp:BoundField DataField="CreationDate" HeaderText="创建日期" >
                    <ItemStyle HorizontalAlign="Center" Wrap="False" />
                </asp:BoundField>
                <asp:BoundField DataField="FileCount" HeaderText="文件数">
                    <ItemStyle HorizontalAlign="Center" Wrap="False" />
                </asp:BoundField>
            </Columns>
            <FooterStyle BackColor="White" ForeColor="#000066" />
            <RowStyle ForeColor="#000066" />
            <PagerStyle BackColor="White" ForeColor="#000066" HorizontalAlign="Left" />
            <SelectedRowStyle BackColor="#669999" Font-Bold="True" ForeColor="White" />
            <HeaderStyle BackColor="#006699" Font-Bold="True" ForeColor="White" />
        </asp:GridView>
    </div>
</form>
</body>
</html>