﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="brandOptions.aspx.cs" Inherits="PPFOR.Admin.DesignCenter.Label.brandOptions" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" /> 
    <script src="/ckeditor/ckeditor.js" type="text/javascript" ></script>
    <script src="../../JS/label.js" type="text/javascript"></script>   
    <link href="../../Css/global.css" rel="stylesheet" type="text/css" />
    <script language="javascript" type="text/javascript">
    function saveContent()
    {
        var fStr=",<br />&nbsp;";
        var data=formatContent("[PPFOR:Loop","") + fStr + formatContent("PPFOR:Class","Brands");
        
        var type=getRadioValue("brandListType");
        if(type!=null && type!="")
        {
            data+=fStr + formatContent("PPFOR:Type",type);
        } 
        
        var objLoopNumber= document.getElementById("PPFOR_loopNumber");
        if(objLoopNumber!=null && objLoopNumber.value!="")
        {
            data+=fStr + formatContent("PPFOR:LoopNumber",objLoopNumber.value);
        }
            
        var objOutFormat= document.getElementById("outFormat");
        if(objOutFormat!=null)
        {
            data+=fStr + formatContent("PPFOR:Format",objOutFormat.value!='' ? objOutFormat.value : "Table");
        }   
        
        var objNewsColumnNumber= document.getElementById("PPFOR_BrandColumnNumber");
        if(objNewsColumnNumber!=null && objNewsColumnNumber.value!="")
        {
            data+=fStr + formatContent("PPFOR:ColumnNumber",objNewsColumnNumber.value);
        }
        
        var objTitleNumber= document.getElementById("PPFOR_BrandTitleNumber");
        if(objTitleNumber!=null && objTitleNumber.value!="")
        {
            data+=fStr + formatContent("PPFOR:TitleNumber",objTitleNumber.value);
        }  
        
        data+=formatContent("]","") + "<br />" + ckEditor.getData() + "<br />" + formatContent("[/PPFOR:Loop]","");
        
        parent.window.resetHTML(data);
        if(document.all)
        {
            parent.document.getElementById("popupExit").fireEvent("onclick");
        }
        else
        {
            var evt = document.createEvent('HTMLEvents');   
            evt.initEvent('click',true,true);   
            parent.document.getElementById("popupExit").dispatchEvent(evt);   
        }
    }
    function getRadioValue(name)
    {
        var radioes = document.getElementsByName(name); 
        for(var i=0;i<radioes.length;i++)
        {
             if(radioes[i].checked){
                return radioes[i].value;
             }
        }
        return "";
    }
    function changeNumberOption()
    {
        var rValue=getRadioValue("brandListType");
        if(rValue=="List")
        {
            document.getElementById("listNumber").style.display="none";
            document.getElementById("listNumberPerPage").style.display="";
        }
        else
        {
            document.getElementById("listNumberPerPage").style.display="none";
            document.getElementById("listNumber").style.display="";
        } 
    }
    </script>
    <title>品牌列表参数设置</title>
</head>
<body>
    <form id="form1" runat="server" onsubmit="saveContent();return false;">
    <table width="98%" cellpadding="0" cellspacing="0" class="fortable" style="margin:6px;">
    <thead>
      <tr>
        <td colspan="2" align="center">选择标签参数--品牌列表</td>
      </tr>     
    </thead>      
       <tr>
        <td align="right">列表类型：</td>
        <td>
           <input type="radio" value="Rec" name="brandListType" onclick="changeNumberOption();"/>推荐
           <input type="radio" value="List" name="brandListType" checked="checked" onclick="changeNumberOption();"/>品牌列表
       </td>
      </tr>
      <tr>
        <td align="right" style="width:15%">循环<span id="listNumber" style="display:<%=PPFOR_displayListNumberOption %>">条数</span><span id="listNumberPerPage" style="display:<%=PPFOR_displayListNumberPerPageOption %>">每页条数</span>：</td>
        <td><asp:TextBox Text="8" MaxLength="10" ID="PPFOR_loopNumber" runat="server" Width="150px"/>
            <select id="outFormat">               
                <option value="" selected="selected">--选择输出格式--</option>
                <option value="Table">Table(默认)</option>                
                <option value="None">无格式</option>
            </select>
            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" ControlToValidate="PPFOR_loopNumber" runat="server" Display="Dynamic" SetFocusOnError="true"><br />循环条数必须填写</asp:RequiredFieldValidator>
            <asp:RangeValidator ID="RangeValidator1" ControlToValidate="PPFOR_loopNumber" runat="server"  Display="Dynamic" SetFocusOnError="true" MinimumValue="1" MaximumValue="2147483647" Type="Integer"><br />循环条数必须填写正整数</asp:RangeValidator>            
        </td>
      </tr>
      <tr>
        <td align="right">列表参数：</td>
        <td align="left">
            <select id="BrandParam" style="width:150px;" onchange="appenHTML(this.value);this.selectedIndex=0;">
            <option value="">01.&nbsp;选择基本参数</option>            
            <option value="&lt;a href=&quot;{#URL}&quot; title=&quot;{#Title}&quot;&gt;{#Title}&lt;/a&gt;">02.&nbsp;品牌名称</option>            
            <option value="{#ID}">03.&nbsp;品牌ID</option>     
            <option value="&lt;img border='0' title='{#Title}' src='{#Logo}' &gt;">04.&nbsp;品牌LOGO</option>  
            <option value="{#WebURL}">05.&nbsp;品牌网址</option>       
            </select>
            <asp:DropDownList ID="PPFOR_subLabelList" runat="server">
            <asp:ListItem Text="--选择二级标签--" Value=""></asp:ListItem>
            </asp:DropDownList>
            <br />
            <asp:TextBox ID="PPFOR_BrandOptionContent" runat="server" TextMode="MultiLine" Rows="5" Width="98%"></asp:TextBox>
           <script type="text/javascript">
            var ckEditor=CKEDITOR.replace("PPFOR_BrandOptionContent", {
             toolbar:'EditLabelOptions',
             height:'100'
            });
            function appenHTML(text)
            {
                ckEditor.insertHtml(text);
            }
            </script>
         </td>
      </tr>
      <tr>
        <td align="right">每行显示品牌条数：</td>
        <td><asp:TextBox ID="PPFOR_BrandColumnNumber" runat="server" Width="150px" />
            <asp:RangeValidator ID="RangeValidator5" ControlToValidate="PPFOR_BrandColumnNumber" runat="server"  Display="Dynamic" SetFocusOnError="true" MinimumValue="1" MaximumValue="2147483647" Type="Integer">品牌条数必须填写正整数</asp:RangeValidator>            
        </td>
      </tr>      
      <tr>
        <td align="right">品牌名称显示字数：</td>
        <td><asp:TextBox ID="PPFOR_BrandTitleNumber" runat="server" Width="150px" />
            <asp:RangeValidator ID="RangeValidator2" ControlToValidate="PPFOR_BrandTitleNumber" runat="server"  Display="Dynamic" SetFocusOnError="true" MinimumValue="1" MaximumValue="1000" Type="Integer">品牌名称显示字数必须填写1至1000之间的整数</asp:RangeValidator>            
        </td>
      </tr>          
      <tr style="display:none">
        <td align="center" colspan="2" valign="middle" style="height:50px">            
            <asp:Button ID="PPFOR_setBrandOptions" CssClass="inputbutton" runat="server" Text="确定" OnClick="PPFOR_setBrandOptionsClick"/>
            <input id="reset1" name="reset" type="reset" class="inputbutton" onmouseover="this.className='inputbutton_hover'" onmouseout="this.className='inputbutton'" value="重置" />
             <script type="text/javascript"> 
                parent.popup_clearButtons();
                parent.popup_addButton(document.getElementById('PPFOR_setBrandOptions'));
                parent.popup_addButton(document.getElementById('reset1'));
             </script>
        </td>
      </tr>
    </table>
    </form>
</body>
</html>
