﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MainPage.Master" AutoEventWireup="true"
    Codebehind="MenuEdit.aspx.cs" Inherits="PPFOR.Admin.DesignCenter.Menu.MenuEdit" Title="修改栏目" %>

<asp:Content ID="Content1" ContentPlaceHolderID="PPFOR_mainContent" runat="server">
    <script type="text/javascript" src="/ckeditor/ckeditor.js"></script>
    <script src="../../JS/popup.js" type="text/javascript"></script>  
    <script language="javascript" type="text/javascript">
    function $ID(id){
        return document.getElementById(id);
    }
    function openModelFilesForSelect(id)
    {
        popup_show("选择模板文件","<iframe id='fileFrame' src='/Admin/CustomView/filemanager.aspx?rid=" + $ID(id).getAttribute("rid") + "' scrolling='yes' width='100%' height='100%' frameborder='0' ></iframe>",520,360);
    }
    function show(obj){
        if(obj!=null && obj.type=='checkbox')
        {
            var target1=$ID('divSeo1');
            var target2=$ID('divSeo2');
            target1.style.display=(obj.checked==true)?'':'none';  
            target2.style.display=(obj.checked==true)?'':'none'; 
        }
    }
    function readable(obj,targetid){
        var target=$ID(targetid);
        if(obj!=null && obj.type=='checkbox' && target!=null)
        {
            target.readOnly=obj.checked;
            if(!obj.checked)
            {
                target.select();
            }
        }
    }
    function showSubModel(obj)
    {
        var model=obj.options[obj.selectedIndex].getAttribute('model');
        var titleList='&nbsp;';
        var titleDetail='&nbsp;';
        var displayList='';
        var displayDetail='';
        switch(model.toLowerCase())
        {
            case 'news':
                titleList="新闻类型模板：";
                titleDetail="新闻详细页模板：";
                break;
            case 'products':
                titleList="产品类型模板：";
                titleDetail="产品详细页模板：";
                break;
            case 'pages':
                titleDetail="单页面模板：";
                displayList='none';
                break;
            case 'pictures':
                titleList="图片类型模板：";
                titleDetail="图片详细页模板：";
                break;
            case "downloads":
                titleList="下载类型模板：";
                titleDetail="下载详细页模板：";
                break;
            case 'comments':
                titleList="评论组模板：";
                displayDetail='none';
                break;
            case 'jobs':
                titleList="招聘类型模板：";
                titleDetail="招聘职位模板：";
                break;
        }
        $ID('displaySubListTemplate').style.display=displayList;
        $ID('subListTemplate').innerHTML=titleList;
        if(displayList=='none')
        {
            $ID('<%=PPFOR_subListTemplate.ClientID %>').value='';
        }
        $ID('displaySubDetailTemplate').style.display=displayDetail;
        $ID('subDetailTemplate').innerHTML=titleDetail;
        if(displayDetail=='none')
        {
            $ID('<%=PPFOR_subDetailTemplate.ClientID %>').value='';
        }
    }
    </script>
<form action="MenuEdit.aspx" method="post" id="form1" runat="server">
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="fortable">
        <thead>
            <tr>
                <td colspan="2" align="center">修改栏目</td>
            </tr>   
        </thead>            
        <tr>
            <td style="width:15%" align="right">栏目名称：</td>
            <td>
                <asp:TextBox ID="PPFOR_menuName" runat="server" Width="150px" MaxLength="30"></asp:TextBox> *                
                <asp:Label ID="PPFOR_menuId" runat="server" Enabled="false" Visible="false"></asp:Label>
                <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" SetFocusOnError="true" ValidationExpression="^[^<>\x22]{2,30}$" Display="Dynamic" ControlToValidate="PPFOR_menuName"><br />栏目名称长度必须在2至30个字符之间，且不能包含以下字符之一：<，>，"</asp:RegularExpressionValidator>
              <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" SetFocusOnError="true" Display="Dynamic" ControlToValidate="PPFOR_menuName"><br />栏目名称不能为空</asp:RequiredFieldValidator>
            </td>
        </tr>     
        <tr>
            <td align="right">静态文件名：</td>
            <td style="white-space:normal;">
                <asp:Label ID="PPFOR_htmlName" runat="server"></asp:Label>&nbsp;
            </td>
        </tr>
        <tr>
            <td align="right">所属语言：</td>
            <td>
                <asp:DropDownList ID="PPFOR_languageList" runat="server" Width="150px">
                </asp:DropDownList>
            </td>
        </tr>
            <tr>
                <td align="right">所属功能模块：</td>
                <td>
                    <asp:DropDownList ID="PPFOR_modleList" runat="server" Width="150px">
                    </asp:DropDownList>
                </td>
            </tr>            
            <tr>
                <td align="right">栏目介绍：</td>
                <td>
                    <asp:TextBox ID="PPFOR_menuIntroduction" runat="server" TextMode="MultiLine" Height="84px" Width="502px"></asp:TextBox>
                    <script type="text/javascript">
                        var ckEditor=CKEDITOR.replace("<%=PPFOR_menuIntroduction.ClientID%>");           
                    </script>
                </td>
            </tr>
            <tr>
                <td align="right">栏目模板文件：</td>
                <td>
                    <asp:TextBox ID="PPFOR_menuTemplate" runat="server" Width="300px" MaxLength="255"></asp:TextBox>
                    <input type="button" value="选择模板" class="inputbutton" onmouseover="this.className='inputbutton_hover'" onmouseout="this.className='inputbutton'" onclick="openModelFilesForSelect('<%=PPFOR_menuTemplate.ClientID %>');" />
                    <asp:RegularExpressionValidator ID="RegularExpressionValidator3" runat="server" SetFocusOnError="true" ValidationExpression='^[/][^\\<>*?:|\"]{3,254}$' Display="Dynamic" ControlToValidate="PPFOR_menuTemplate"><br />模板文件路径必须以“/”开头，且长度必须在4至255个字符之间，且不能包含以下字符之一： \ < > | " ? : *</asp:RegularExpressionValidator>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator2" ControlToValidate="PPFOR_menuTemplate" runat="server" ErrorMessage="模板文件路径不能为空" Display="Dynamic" SetFocusOnError="true"></asp:RequiredFieldValidator>
                </td>
            </tr>  
            <tr id="displaySubListTemplate">
                <td align="right" id="subListTemplate">子列表模板：</td>
                <td>
                    <asp:TextBox ID="PPFOR_subListTemplate" runat="server" Width="300px" MaxLength="255"></asp:TextBox>
                    <input type="button" value="选择模板" class="inputbutton" onmouseover="this.className='inputbutton_hover'" onmouseout="this.className='inputbutton'" onclick="openModelFilesForSelect('<%=PPFOR_subListTemplate.ClientID %>');" />
                    <asp:RegularExpressionValidator ID="RegularExpressionValidator4" runat="server" SetFocusOnError="true" ValidationExpression='^[/][^\\<>*?:|\"]{3,254}$' Display="Dynamic" ControlToValidate="PPFOR_subListTemplate"><br />模板文件路径必须以“/”开头，且长度必须在4至255个字符之间，且不能包含以下字符之一： \ < > | " ? : *</asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr id="displaySubDetailTemplate">
                <td align="right" id="subDetailTemplate">子详细页模板：</td>
                <td>
                    <asp:TextBox ID="PPFOR_subDetailTemplate" runat="server" Width="300px" MaxLength="255"></asp:TextBox>
                    <input type="button" value="选择模板" class="inputbutton" onmouseover="this.className='inputbutton_hover'" onmouseout="this.className='inputbutton'" onclick="openModelFilesForSelect('<%=PPFOR_subDetailTemplate.ClientID %>');" />
                    <asp:RegularExpressionValidator ID="RegularExpressionValidator5" runat="server" SetFocusOnError="true" ValidationExpression='^[/][^\\<>*?:|\"]{3,254}$' Display="Dynamic" ControlToValidate="PPFOR_subDetailTemplate"><br />模板文件路径必须以“/”开头，且长度必须在4至255个字符之间，且不能包含以下字符之一： \ < > | " ? : *</asp:RegularExpressionValidator>
                </td>
            </tr>          
            <tr>
                <td align="right">打开方式：</td>
                <td>
                    <asp:RadioButton ID="PPFOR_menuOpenAsSelf" runat="server" GroupName="MenuOpenType" Text="在原窗口中打开" Checked="true" />
                    &nbsp; &nbsp;&nbsp;
                    <asp:RadioButton ID="PPFOR_menuOpenAsNew" runat="server" GroupName="MenuOpenType" Text="在新窗口中打开" Width="135px" />
                </td>
            </tr>
            <tr>
                <td align="right">排序：</td>
                <td>
                    <asp:TextBox ID="PPFOR_sort" runat="server" Text="0" MaxLength="4"></asp:TextBox>
                    <asp:RangeValidator ID="RangeValidator1" runat="server" ControlToValidate="PPFOR_sort" Display="Dynamic" SetFocusOnError="true" Type="Integer" MinimumValue="-999" MaximumValue="9999">排序顺序只能填写-999至9999之间的整数</asp:RangeValidator>
                </td>
            </tr>
            <tr>
                <td align="right">是否显示：</td>
                <td>
                    <asp:RadioButton ID="PPFOR_menuShow" runat="server" GroupName="MenuSort" Text="是" Checked="true" />&nbsp;&nbsp;&nbsp;
                    <asp:RadioButton ID="PPFOR_menuHide" runat="server" GroupName="MenuSort" Text="否" Width="135px" />
                </td>
            </tr>
            <tr>
                <td colspan="2" style="background-color: #f2f2f2" align="left">                
                    <input type="checkbox" id="PPFOR_ckeSeo" runat="server" onclick="show(this)" />Seo 优化设置 & 其它
                </td>
            </tr>     
            <tr id="divSeo1">
                <td align="right">Meta关键字：</td>
                <td>
                    <asp:TextBox ID="PPFOR_menuKeyWord" runat="server" Width="98%" MaxLength="255"></asp:TextBox><br />
                    <input type="checkbox" id="PPFOR_menuKeyWordAuto" runat="server" checked="checked" />自动获取
                </td>
            </tr>
            <tr id="divSeo2">
                <td align="right">Meta描述：</td>
                <td>
                    <asp:TextBox ID="PPFOR_menuDescription" runat="server" Width="98%" MaxLength="255"></asp:TextBox><br />
                    <input type="checkbox" id="PPFOR_menuDescriptionAuto" runat="server" checked="checked" />自动获取
                </td>                  
            </tr> 
            <tr>
                <td colspan="2" style="width:100%; height:50px; display:none;" align="center" valign="middle">
                    <asp:Button ID="PPFOR_updateMenu" CssClass="inputbutton" runat="server" Text="提交" OnClick="PPFOR_updateMenuClick"/>
                    <input name="reset" type="reset" id="reset1" class="inputbutton" onmouseover="this.className='inputbutton_hover'" onmouseout="this.className='inputbutton'" value="重置" />
                    <script type="text/javascript">
                        addButtonArray("<%= PPFOR_updateMenu.ClientID %>","reset1");
                    </script>
                </td>
            </tr>           
        </table>
    </form>
</asp:Content>
