﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MainPage.Master" AutoEventWireup="true"
    Codebehind="AreaList.aspx.cs" Inherits="PPFOR.Admin.Sys.WebConfig.AreaList"
    Title="地区列表" %>
<asp:Content ID="Content1" ContentPlaceHolderID="PPFOR_mainContent" runat="server">
<script src="../../JS/ajax.js" type="text/javascript"></script> 
<script type="text/javascript">
    function showLoadingMsg()
    {
        var objMsg=docEle('msg');
        if(objMsg)
        {
             objMsg.style.display='';
             var _scrollTop = Math.max(document.body.scrollTop,document.documentElement.scrollTop);
             var _scrollLeft= Math.max(document.body.scrollLeft,document.documentElement.scrollLeft);
             objMsg.style.margin=(_scrollTop - 60) + "px 0 0 " + (_scrollLeft - 142) + "px";   
        }   
    }     
    function hideLoadingMsg()
    {
        var objMsg=docEle('msg');
        if(objMsg)
        {
            objMsg.style.display='none';
        }        
    } 
    function checkOrderNumber(obj)
    {
        if(obj!=null && obj.type=="text")
        {
            var r=/[^-\d]*([-]?[\d]*)[\D]*/; 
            var value=obj.value;
            var P=value.match(r);
            obj.value=(P[1]==null || P[1]=='-' || P[1]=='')?'0':P[1];
        }        
    }
    function showChildAreaList(objImage,aId)
    {
        var objTarget=docEle("child_" + aId);
        if(objImage.getAttribute("statue")!=null && objImage.getAttribute("statue")=="expand"){
            objImage.setAttribute("statue","collapse");
            objImage.src="/Admin/Images/collapse.gif"; 
            if(objTarget){
                objTarget.style.display='';
            }else{
                showLoadingMsg();
                DoAjax("GetAreaList.aspx?type=1&bid=" + aId,"GET",null,fetchChildAreaList,aId);
            }
        } else {
            objImage.setAttribute("statue","expand");
            objImage.src="/Admin/Images/expand.gif"; 
            if(objTarget){
                objTarget.style.display='none';
            }
        }
    }
    function fetchChildAreaList(xmlHttp,bId)
    {
        if(xmlHttp.responseText!=null)
        {  
            var objParentRow=docEle('area_' + bId);             
            var newRow=objParentRow.parentNode.parentNode.insertRow(objParentRow.rowIndex+1); 
           
            newRow.id="child_" + bId;
            var objNewTd=newRow.insertCell(0);
            objNewTd.colSpan=5;
            objNewTd.innerHTML=xmlHttp.responseText;            
        }
        setTimeout("hideLoadingMsg()",300);
    }
    function deleteArea(aid)
    {
        if(confirm('删除地区将同时删除该地区的所有子地区，确定要删除吗？'))
        {
            location.href="AreaList.aspx?action=delete&aid=" + aid;
        }
    }
    function checkOrderChanged()
    {
        var orders=document.getElementsByName('AreaOrderValues');
        var ids=docEle('AreaOrderChangeIds');
        if(orders!=null && ids && orders.length>0){
            for(var i=0;i<orders.length; i++){  
                if(orders[i].type=='text'){
                    if(orders[i].value!=orders[i].defaultValue){
                        ids.value += ',' + orders[i].id.replace('order_','') + ':' + (orders[i].value=='' ? '0' : orders[i].value);                                
                    }
                }
            }
        }
        return true;
    } 
</script>
<form id="form1" action="AreaList.aspx" method="post" runat="server" onsubmit="return checkOrderChanged();">
	<div class="table-ppfor">
		<i></i><u></u>
		<ul>
		  <li><asp:Label ID="PPFOR_goForAddArea" runat="server" ></asp:Label></li>
		</ul>
	</div>   
	<table id="showAreaList" style="margin:0;" border="0" cellpadding="0" cellspacing="0" class="forarea">	    
	<tbody>
	    <tr>
	        <th class="thstart">地区名称</th>
	        <th class="ths">排列顺序</th>
	        <th class="ths">添加子地区</th>
	        <th class="ths">编辑</th><th>删除</th>	        
	    </tr>		    
	    <%=PPFOR_showAreaList %>
	    <tr>
            <td colspan="6" align="center" style="height:30px; display:none">
                <asp:Button ID="PPFOR_updateBatch" runat="server" CssClass="inputbutton" Text="更新排序" OnClick="PPFOR_updateBatchClick" />
                <input type="reset" id="reset1" value="重置" class="inputbutton" onmouseover="this.className='inputbutton_hover'" onmouseout="this.className='inputbutton'"/><br />                
                <script type="text/javascript">              
                  addButtonArray("<%= PPFOR_updateBatch.ClientID %>","reset1");
                </script> 
            </td>
        </tr> 
	</tbody>
	</table>   
	<input type="hidden" value="" name="AreaOrderChangeIds" id="AreaOrderChangeIds" />
</form>        
<div id="msg" style="position: absolute; z-index: 300; height: 120px; width: 284px; left: 50%; top: 50%; margin-left: -150px; margin-top: -80px; display:none;">
	<div id="Layer2" style="position: absolute; z-index: 300; width: 270px; height: 90px; background-color: #ffffff; border: 1px solid #79BDD3; font-size: 14px;">
		<div id="Layer4" style="height: 26px; background: none repeat scroll 0% 0% rgb(241, 245, 250); line-height: 26px; padding: 0px 3px; font-weight: bold; color:#0099CC">正在加载...</div>
		<div id="Layer5" style="height: 64px; line-height: 150%; padding: 0px 3px; text-align:center"><br/><img src="/Admin/Images/loading.gif" alt=""/><br/></div>
	</div>
	<div id="Layer3" style="position: absolute; width: 270px; height: 90px; z-index: 299; left: 4px; top: 5px; background-color: rgb(232, 232, 232);"></div>
</div>
</asp:Content>
