﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MainPage.Master" AutoEventWireup="true" CodeBehind="waterImage.aspx.cs" Inherits="PPFOR.Admin.Sys.WebConfig.Config.waterImage" Title="水印设置" %>
<asp:Content ID="Content1" ContentPlaceHolderID="PPFOR_mainContent" runat="server">
<script src="/Admin/JS/color.js" type="text/javascript"></script>
<script type="text/javascript" src="/ckfinder/ckfinder.js"></script>
<script language="javascript" type="text/javascript">
function BrowseServer()
{
	var finder = new CKFinder() ;
	finder.BasePath = '/ckfinder/';
	finder.SelectFunction = SetFileField;
	finder.RememberLastFolder=true;
	finder.PrintWaterImage=false;
	finder.ResourceType="Images";
	finder.Popup();
}
function SetFileField( fileUrl )
{
    var obj=document.getElementById( "<%= PPFOR_waterImageFile.ClientID %>" );
	obj.value = fileUrl ;
    if(document.all)
    {
        obj.fireEvent("onchange");
    }
    else
    {
        var evt = document.createEvent('HTMLEvents');   
         evt.initEvent('change',true,true);   
         obj.dispatchEvent(evt);   
    }       
}
function changeDisplay(type)
{
    var fdisplay='none';
    var idisplay='none';
    clearButtonList();
    switch(type)
    {
        case "Font": 
            fdisplay=''; 
            document.getElementById("<%= PPFOR_waterTypeFont.ClientID %>").checked=true;
            addButtonArray("<%=PPFOR_updateWaterFont.ClientID %>","reset1");
            break;
        case "Image": 
            idisplay='';
            document.getElementById("<%= PPFOR_waterTypeImage.ClientID %>").checked=true;
            addButtonArray("<%=PPFOR_updateWaterImage.ClientID %>","reset1");
            break;
        default:
            document.getElementById("<%= PPFOR_waterTypeNone.ClientID %>").checked=true;
            addButtonArray("<%=PPFOR_updateWater.ClientID %>","reset1");
            break;
    }
    document.getElementById("displayWaterFontText").style.display=fdisplay;
    document.getElementById("displayWaterFontFamily").style.display=fdisplay;
    document.getElementById("displayWaterFontStyle").style.display=fdisplay;
    document.getElementById("displayWaterFontSize").style.display=fdisplay;
    document.getElementById("displayWaterFontColor").style.display=fdisplay;
    document.getElementById("displayWaterFontBorderSize").style.display=fdisplay;
    document.getElementById("displayWaterFontBorderColor").style.display=fdisplay;
    document.getElementById("displayWaterFontBackColor").style.display=fdisplay;
    document.getElementById("displayWaterFontAlpha").style.display=fdisplay;
    document.getElementById("displayWaterFontStartPos").style.display=fdisplay; 
    document.getElementById("displayUpdateWaterFont").style.display=fdisplay;
           
    document.getElementById("displayWaterImageFile").style.display=idisplay;
    document.getElementById("displayWaterImageWidth").style.display=idisplay;
    document.getElementById("displayWaterImageHeight").style.display=idisplay;
    document.getElementById("displayWaterImageOpacity").style.display=idisplay;
    document.getElementById("displayWaterImageStartPos").style.display=idisplay; 
    document.getElementById("displayWaterImageStartPos").style.display=idisplay; 
    document.getElementById("displayUpdateWaterImage").style.display=idisplay;
    
    if(fdisplay==idisplay && idisplay=='none')
    {
        document.getElementById("displayUpdateWater").style.display='';
    }
    else
    {
        document.getElementById("displayUpdateWater").style.display='none';
        checkDisplayFontBorderColor(document.getElementById("<%=PPFOR_waterFontBorderSize.ClientID %>").value)
    }
}
function setListValue(value,forId)
{
    var obj=document.getElementById(forId);
    if(obj)
    {
        obj.value=value;
    }
}
function changeWaterFontDemo()
{
        
}
function checkDisplayFontBorderColor(value)
{
    var bsObj=document.getElementById("displayWaterFontBorderSize");
    var bcObj=document.getElementById("displayWaterFontBorderColor");
    if(bsObj && bsObj.style.display!='none' && value>0)
    {
        bcObj.style.display='';
    }
    else
    {
        bcObj.style.display='none';
    }
}

function getRadioValue(name)
{
    var radioes = document.getElementsByName(name); 
    for(var i=0;i<radioes.length;i++)
    {
         if(radioes[i].checked){
            return radioes[i].value;
         }
    }
    return "";
}
</script>
<form id="form1" runat="server">
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="fortable">
    <thead>
        <tr>
            <td colspan="2" align="center">水印设置</td>
        </tr>
    </thead>
    <tr>
      <td style="width:15%" align="right">水印类型：</td>
      <td>
        <asp:RadioButton GroupName="waterType" ID="PPFOR_waterTypeNone" runat="server" Checked="true" Text="无水印"/>
        <asp:RadioButton GroupName="waterType" ID="PPFOR_waterTypeFont" runat="server" Text="文字水印"/>
        <asp:RadioButton GroupName="waterType" ID="PPFOR_waterTypeImage" runat="server" Text="图片水印"/>
        </td>
    </tr>
    <tr id="displayWaterFontText" style="display:none;">
        <td align="right">水印文字：</td>
        <td valign="middle"><asp:TextBox ID="PPFOR_waterFontText" runat="server" MaxLength="255"></asp:TextBox>
            <asp:RequiredFieldValidator ValidationGroup="WaterFont" ID="RequiredFieldValidator2" ControlToValidate="PPFOR_waterFontText" runat="server" Display="Dynamic" SetFocusOnError="true">水印文字内容不允许为空</asp:RequiredFieldValidator>
            <asp:RegularExpressionValidator ValidationGroup="WaterFont" ID="RegularExpressionValidator1" ControlToValidate="PPFOR_waterFontText" runat="server" Display="Dynamic" SetFocusOnError="true" ValidationExpression="^.{1,255}$">水印文字字数不能超过255个字符</asp:RegularExpressionValidator>
            </td>
    </tr>
    <tr id="displayWaterFontFamily" style="display:none;; height:auto;">
        <td align="right">文字字体：</td>
        <td><asp:DropDownList ID="PPFOR_waterFontFamilyList" runat="server">           
        </asp:DropDownList>        
            </td>
    </tr>
    <tr id="displayWaterFontStyle" style="display:none;">
        <td align="right">字体样式：</td>
        <td><asp:DropDownList ID="PPFOR_waterFontStyleList" runat="server">
            <asp:ListItem Text="正常" Value="Regular"></asp:ListItem>
            <asp:ListItem Text="加粗" Value="Bold"></asp:ListItem>
            <asp:ListItem Text="倾斜" Value="Italic"></asp:ListItem>
            <asp:ListItem Text="删除线" Value="Strikeout"></asp:ListItem>
            <asp:ListItem Text="下划线" Value="Underline"></asp:ListItem>
        </asp:DropDownList>
            </td>
    </tr>      
    <tr id="displayWaterFontSize" style="display:none;">
        <td align="right">文字大小：</td>
        <td><asp:TextBox ID="PPFOR_waterFontSize" runat="server" Text="18"></asp:TextBox>
            <asp:DropDownList ID="PPFOR_waterFontSizeList" runat="server">
            <asp:ListItem Text="选择大小" Value=""></asp:ListItem>
            <asp:ListItem Text="8" Value="8"></asp:ListItem>
            <asp:ListItem Text="9" Value="9"></asp:ListItem>
            <asp:ListItem Text="10" Value="10"></asp:ListItem>
            <asp:ListItem Text="12" Value="12"></asp:ListItem>
            <asp:ListItem Text="14" Value="14"></asp:ListItem>
            <asp:ListItem Text="16" Value="16"></asp:ListItem>
            <asp:ListItem Text="18" Value="18"></asp:ListItem>
            <asp:ListItem Text="20" Value="20"></asp:ListItem>
            <asp:ListItem Text="22" Value="22"></asp:ListItem>
            <asp:ListItem Text="24" Value="24"></asp:ListItem>
            <asp:ListItem Text="26" Value="26"></asp:ListItem>
            <asp:ListItem Text="28" Value="28"></asp:ListItem>
            <asp:ListItem Text="36" Value="36"></asp:ListItem>
            <asp:ListItem Text="48" Value="48"></asp:ListItem>
            <asp:ListItem Text="64" Value="64"></asp:ListItem>
            <asp:ListItem Text="72" Value="72"></asp:ListItem>    
            </asp:DropDownList>
            <asp:RangeValidator ValidationGroup="WaterFont" ID="RangeValidator1" ControlToValidate="PPFOR_waterFontSize" Type="Integer" MinimumValue="1" MaximumValue="72" runat="server" Display="Dynamic" SetFocusOnError="true"><br />字体大小必须为1-72之间的整数</asp:RangeValidator>
            </td>
    </tr>
    <tr id="displayWaterFontColor"  style="display:none;">
        <td align="right">文字颜色：</td>
        <td><asp:TextBox ID="PPFOR_waterFontColor" runat="server" MaxLength="7" Text="#000000"></asp:TextBox>   
        <span onclick="showColorBoard('<%= PPFOR_waterFontColor.ClientID%>','<%= PPFOR_waterFontColor.ClientID%>');" style="cursor:pointer">选择颜色</span>
        <asp:RegularExpressionValidator ValidationGroup="WaterFont" ID="RegularExpressionValidator3" ControlToValidate="PPFOR_waterFontColor" runat="server" Display="Dynamic" SetFocusOnError="true" ValidationExpression="^#[0-9a-fA-F]{1,6}$"><br />颜色值必须以“#”开头，此外只能填写数字和字母a-fA-F，且长度必须为1至6位</asp:RegularExpressionValidator>
        <br />        
           </td>
    </tr> 
    <tr id="displayWaterFontBorderSize" style="display:none;">
        <td align="right">文字边框大小：</td>
        <td><asp:TextBox ID="PPFOR_waterFontBorderSize" runat="server" Text="0"></asp:TextBox>
            <asp:DropDownList ID="PPFOR_waterFontBorderSizeList" runat="server">
            <asp:ListItem Text="选择大小" Value=""></asp:ListItem>
            <asp:ListItem Text="0-无边框" Value="0"></asp:ListItem>
            <asp:ListItem Text="1" Value="1"></asp:ListItem>
            <asp:ListItem Text="2" Value="2"></asp:ListItem>
            <asp:ListItem Text="4" Value="4"></asp:ListItem>
            <asp:ListItem Text="8" Value="8"></asp:ListItem>
            <asp:ListItem Text="16" Value="16"></asp:ListItem>
            </asp:DropDownList>&nbsp;设置为空或为0时没有边框
            <asp:RangeValidator ValidationGroup="WaterFont" ID="RangeValidator2" ControlToValidate="PPFOR_waterFontBorderSize" Type="Integer" MinimumValue="0" MaximumValue="20" runat="server" Display="Dynamic" SetFocusOnError="true"><br />文字边框大小必须为0-20之间的整数</asp:RangeValidator>
            </td>
    </tr>
    <tr id="displayWaterFontBorderColor" style="display:none;">
        <td align="right">文字边框颜色：</td>
        <td><asp:TextBox ID="PPFOR_waterFontBorderColor" runat="server" MaxLength="7" Text="#000000"></asp:TextBox>
            <span onclick="showColorBoard('<%= PPFOR_waterFontBorderColor.ClientID%>','<%= PPFOR_waterFontBorderColor.ClientID%>');" style="cursor:pointer">选择颜色</span>
            <asp:RegularExpressionValidator ValidationGroup="WaterFont" ID="RegularExpressionValidator2" ControlToValidate="PPFOR_waterFontBorderColor" runat="server" Display="Dynamic" SetFocusOnError="true" ValidationExpression="^#[0-9a-fA-F]{1,6}$"><br />颜色值必须以“#”开头，此外只能填写数字和字母a-fA-F，且长度必须为1至6位</asp:RegularExpressionValidator>
        </td>
    </tr> 
    <tr id="displayWaterFontBackColor" style="display:none;">
        <td align="right">文字背景颜色：</td>
        <td><asp:TextBox ID="PPFOR_waterFontBackColor" runat="server" MaxLength="7" Text=""></asp:TextBox>
            <span onclick="showColorBoard('<%= PPFOR_waterFontBackColor.ClientID%>','<%= PPFOR_waterFontBackColor.ClientID%>');" style="cursor:pointer">选择颜色</span>&nbsp;&nbsp;若不需设置背景颜色，则设置为空值
            <asp:RegularExpressionValidator ValidationGroup="WaterFont" ID="RegularExpressionValidator7" ControlToValidate="PPFOR_waterFontBackColor" runat="server" Display="Dynamic" SetFocusOnError="true" ValidationExpression="^#[0-9a-fA-F]{1,6}$"><br />颜色值必须以“#”开头，此外只能填写数字和字母a-fA-F，且长度必须为1至6位</asp:RegularExpressionValidator>
        </td>
    </tr>     
    <tr id="displayWaterFontAlpha" style="display:none;">
        <td align="right">文字透明度：</td>
        <td valign="middle"><asp:TextBox ID="PPFOR_waterFontAlpha" Text="80"  runat="server" MaxLength="3"></asp:TextBox> 0为完全透明，255为完全不透明        
            <asp:RangeValidator ValidationGroup="WaterImage" ID="RangeValidator4" ControlToValidate="PPFOR_waterFontAlpha" runat="server" Display="Dynamic" SetFocusOnError="true" MinimumValue="0" MaximumValue="255" Type="Integer"><br />文字透明度必须为0至255的数值</asp:RangeValidator></td>
    </tr>     
    <tr id="displayWaterFontStartPos" style="display:none;">
        <td align="right">文字坐标位置：</td>
        <td><asp:RadioButtonList CssClass="innertable" ID="PPFOR_waterFontStartPos" runat="server" RepeatColumns="3" RepeatDirection="Horizontal">
            <asp:ListItem Text="左上" Value="1"></asp:ListItem>
            <asp:ListItem Text="中上" Value="2"></asp:ListItem>
            <asp:ListItem Text="右上" Value="3"></asp:ListItem>
            <asp:ListItem Text="左中" Value="4"></asp:ListItem>
            <asp:ListItem Text="正中" Value="5"></asp:ListItem>
            <asp:ListItem Text="右中" Value="6"></asp:ListItem>
            <asp:ListItem Text="左下" Value="7"></asp:ListItem>
            <asp:ListItem Text="中下" Value="8" Selected="True"></asp:ListItem>
            <asp:ListItem Text="右下" Value="9"></asp:ListItem>
            </asp:RadioButtonList>       
       </td>
    </tr>   
    <tr id="displayWaterImageFile" style="display:none;">
        <td align="right">图片路径：</td>
        <td valign="middle"><asp:TextBox ID="PPFOR_waterImageFile" runat="server" MaxLength="255"></asp:TextBox>&nbsp;
        <input type="button" value="浏览" onclick="BrowseServer();" class="inputbutton" onmouseover="this.className='inputbutton_hover'" onmouseout="this.className='inputbutton'"/>
            <asp:RequiredFieldValidator ValidationGroup="WaterImage" ID="RequiredFieldValidator1" ControlToValidate="PPFOR_waterImageFile" runat="server" Display="Dynamic" SetFocusOnError="true"><br />水印图片文件路径不允许为空</asp:RequiredFieldValidator>
        <asp:RegularExpressionValidator ValidationGroup="WaterImage" ID="RegularExpressionValidator4" ControlToValidate="PPFOR_waterImageFile" runat="server" Display="Dynamic" SetFocusOnError="true" ValidationExpression='^[/][^\\<>*?:|\"]{3,254}$'><br />水印图片文件路径必须以“/”开头，且长度不能超过255个字符，且不能包含以下字符之一： \ < > | " ? : *</asp:RegularExpressionValidator>
            </td>
    </tr>
    <tr id="displayWaterImageWidth" style="display:none;">
        <td align="right">图片宽度：</td>
        <td valign="middle"><asp:TextBox ID="PPFOR_waterImageWidth" Text="100%" runat="server" MaxLength="8"></asp:TextBox> 填写百分比（如：100%）或像素值（如：100px）    
       <asp:RegularExpressionValidator ValidationGroup="WaterImage" ID="RegularExpressionValidator6" ControlToValidate="PPFOR_waterImageWidth" runat="server" Display="Dynamic" SetFocusOnError="true" ValidationExpression="^(((100)|([1-9][0-9]?))[%])|([1-9][0-9]{0,3}([ ]?[pP][xX])?)$"><br />宽度值不符合</asp:RegularExpressionValidator></td>
    </tr>
    <tr id="displayWaterImageHeight" style="display:none;">
        <td align="right">图片高度：</td>
        <td valign="middle"><asp:TextBox ID="PPFOR_waterImageHeight" Text="100%"  runat="server" MaxLength="8"></asp:TextBox> 填写百分比（如：100%）或像素值（如：100px）    
            <asp:RegularExpressionValidator ValidationGroup="WaterImage" ID="RegularExpressionValidator5" ControlToValidate="PPFOR_waterImageHeight" runat="server" Display="Dynamic" SetFocusOnError="true" ValidationExpression="^(((100)|([1-9][0-9]?))[%])|([1-9][0-9]{0,3}([ ]?[pP][xX])?)$"><br />高度值不符合</asp:RegularExpressionValidator></td>
    </tr>    
    <tr id="displayWaterImageOpacity" style="display:none;">
        <td align="right">图片透明度：</td>
        <td valign="middle"><asp:TextBox ID="PPFOR_waterImageOpacity" Text="30"  runat="server" MaxLength="3"></asp:TextBox> 0为完全透明，100为完全不透明        
            <asp:RangeValidator ValidationGroup="WaterImage" ID="RangeValidator3" ControlToValidate="PPFOR_waterImageOpacity" runat="server" Display="Dynamic" SetFocusOnError="true" MinimumValue="0" MaximumValue="100" Type="Integer"><br />透明度必须为0至100的数值</asp:RangeValidator></td>
    </tr>    
    <tr id="displayWaterImageStartPos" style="display:none;">
        <td align="right">图片坐标位置：</td>
        <td><asp:RadioButtonList CssClass="innertable" ID="PPFOR_waterImageStartPos" runat="server" RepeatColumns="3" RepeatDirection="Horizontal">
            <asp:ListItem Text="左上" Value="1"></asp:ListItem>
            <asp:ListItem Text="中上" Value="2"></asp:ListItem>
            <asp:ListItem Text="右上" Value="3"></asp:ListItem>
            <asp:ListItem Text="左中" Value="4"></asp:ListItem>
            <asp:ListItem Text="正中" Value="5"></asp:ListItem>
            <asp:ListItem Text="右中" Value="6"></asp:ListItem>
            <asp:ListItem Text="左下" Value="7"></asp:ListItem>
            <asp:ListItem Text="中下" Value="8"></asp:ListItem>
            <asp:ListItem Text="右下" Value="9" Selected="True"></asp:ListItem>
            </asp:RadioButtonList>       
            </td>
    </tr>   
    <tr>
        <td colspan="2" width="100%" align="center" valign="middle" style="height:50px;display:none">
            <span id="displayUpdateWater"><asp:Button ID="PPFOR_updateWater" CssClass="inputbutton" CommandArgument="None"  runat="server" Text="保存设置" OnClick="PPFOR_updateWaterImageClick"/></span>
            <span id="displayUpdateWaterFont" style="display:none;"><asp:Button ID="PPFOR_updateWaterFont" CommandArgument="Font" CssClass="inputbutton" runat="server" Text="保存设置" OnClick="PPFOR_updateWaterImageClick" ValidationGroup="WaterFont"/></span>
            <span id="displayUpdateWaterImage" style="display:none;"><asp:Button ID="PPFOR_updateWaterImage" CommandArgument="Image"  CssClass="inputbutton" runat="server" Text="保存设置" OnClick="PPFOR_updateWaterImageClick" ValidationGroup="WaterImage"/></span>
                <input id="reset1" name="reset" type="reset" class="inputbutton" onmouseover="this.className='inputbutton_hover'" onmouseout="this.className='inputbutton'" value="重置" />
        </td>
    </tr> 
    </table>    
</form>
<br />
</asp:Content>
