﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MainPage.Master" AutoEventWireup="true"
    Codebehind="MoneyEdit.aspx.cs" Inherits="PPFOR.Admin.Sys.WebConfig.MoneyEdit" Title="修改货币" %>

<asp:Content ID="Content1" ContentPlaceHolderID="PPFOR_mainContent" runat="server">
<script type="text/javascript">
function setDefault(isDefault,isSelect)
{
    var obj=document.getElementById("<%=PPFOR_moneyRate.ClientID %>");
    if(isDefault){
        obj.readOnly=true;
        obj.value='1';
    }else{
        obj.readOnly=false;
        obj.value='';
        if(isSelect) {        
            obj.select();
        }
    }
}
function changeMoneyName(obj)
{
    var moneyName=obj.options[obj.selectedIndex].getAttribute('moneyName');
    if(moneyName!=null)
    {
        var objName=document.getElementById("<%=PPFOR_moneyName.ClientID %>"); 
        objName.value=moneyName;
        if(document.all)
        {
            objName.fireEvent("onchange");
        }
        else
        {
            var evt = document.createEvent('HTMLEvents');   
            evt.initEvent('change',true,true);   
            objName.dispatchEvent(evt);   
        }      
    }
}
</script>
    <form action="MoneyAdd.aspx" method="post" id="form1" runat="server">
        <table width="100%" border="0" cellpadding="0" cellspacing="0" class="fortable">
        <thead>
            <tr>
                <td colspan="2" align="center">修改货币</td>
            </tr>
        </thead>
        <tr>
          <td style="width:15%" align="right">货币名称：</td>
          <td><asp:TextBox ID="PPFOR_moneyName" runat="server" TextMode="SingleLine" Maxlength="20" Width="150px"></asp:TextBox>
              <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" SetFocusOnError="true" ValidationExpression="^[^<>\x22\x27]{2,20}$" Display="Dynamic" ControlToValidate="PPFOR_moneyName"><br />货币名称长度必须在2至20个字符之间，且不能包含以下字符之一：<，>，'，"</asp:RegularExpressionValidator>
              <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" SetFocusOnError="true" Display="Dynamic" ControlToValidate="PPFOR_moneyName"><br />货币名称不能为空</asp:RequiredFieldValidator>
              <asp:Label ID="PPFOR_moneyID" runat="server" Enabled="false" Visible="false"></asp:Label>
          </td>
        </tr> 
         <tr>
            <td align="right">货币代码：</td>
            <td>
                <asp:DropDownList ID="PPFOR_moneyCode" runat="server"></asp:DropDownList>                
            </td>
        </tr>
        <tr>
            <td align="right">货币符号：</td>
            <td>
                <asp:TextBox ID="PPFOR_moneySign" runat="server" Width="150px" MaxLength="8"></asp:TextBox> 
                <asp:RegularExpressionValidator ID="RegularExpressionValidator2" runat="server" SetFocusOnError="true" ValidationExpression="^[^0-9<>\x22\x27]{1,8}$" Display="Dynamic" ControlToValidate="PPFOR_moneySign"><br />货币符号长度必须在1至8个字符之间，且不能包含数字0-9及以下字符之一：<，>，'，"</asp:RegularExpressionValidator>
                <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" SetFocusOnError="true" Display="Dynamic" ControlToValidate="PPFOR_moneySign"><br />货币符号不能为空</asp:RequiredFieldValidator>
            </td>
        </tr>
        <tr>
            <td align="right">相对汇率：</td>
            <td>
                <asp:TextBox ID="PPFOR_moneyRate" runat="server" Width="150px"  MaxLength="11"></asp:TextBox> 当前货币与默认货币之间的兑换比率<br /> （例：默认货币为人民币，当前货币为美元，则相对汇率大约为0.1465）
                <asp:RangeValidator ID="RangeValidator1" runat="server" Display="Dynamic" Type="Double" ControlToValidate="PPFOR_moneyRate" SetFocusOnError="true" MinimumValue="0.0001" MaximumValue="999999.9999">相对汇率必须在0.0001至999999.9999之间</asp:RangeValidator>
                <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" SetFocusOnError="true" Display="Dynamic" ControlToValidate="PPFOR_moneyRate"><br />相对汇率不能为空</asp:RequiredFieldValidator>
            </td>
        </tr>
        <tr>
            <td align="right">是否启用：</td>
            <td>
               <asp:CheckBox runat="server" ID="PPFOR_isEnable" Text="使用此货币" Checked="false" />
            </td>
        </tr>
        <tr>
            <td align="right">是否默认货币：</td>
            <td>
               <asp:CheckBox runat="server" ID="PPFOR_isDefault" Text="设为默认货币" Checked="false" /> （如果是默认货币，相对汇率必须为1）
            </td>
        </tr>
        <tr>
            <td align="right">排列顺序：</td>
            <td>
               <asp:TextBox runat="server" ID="PPFOR_order" MaxLength="4" Width="150px"></asp:TextBox>
                <asp:RangeValidator ID="RangeValidator2" runat="server" Display="Dynamic" Type="Integer" ControlToValidate="PPFOR_order" SetFocusOnError="true" MinimumValue="-999" MaximumValue="9999">排列顺序必须为-999至9999之间的整数</asp:RangeValidator>
            </td>
        </tr>
        <tr>
            <td colspan="2" style="width:100%; height:50px; display:none;" align="center" valign="middle">
                <asp:Button ID="PPFOR_modifyMoney" CssClass="inputbutton" runat="server" Text="修改" OnClick="PPFOR_modifyMoneyClick"/>
                <input name="reset" id="reset1" type="reset" class="inputbutton" onmouseover="this.className='inputbutton_hover'" onmouseout="this.className='inputbutton'" value="重置" />
                <script type="text/javascript">
                    addButtonArray("<%= PPFOR_modifyMoney.ClientID %>","reset1");
                </script>
            </td>
        </tr>
        </table>
    </form>
</asp:Content>
