﻿<%@ Page Language="C#"  AutoEventWireup="true"  Codebehind="CheckOut.aspx.cs" Inherits="PPFOR.CustomAction.CheckOut" Title="购物结算" %>
<%@ Register Src="~/User/UserCenter/PopupMessage.ascx" TagName="popupMessage" TagPrefix="popup" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head id="Head1" runat="server">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />  

<link type="text/css" href="/CustomAction/goods/Css/cart.css" rel="stylesheet" />
<link href="calendar/css/calendar.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="JS/doAjax.js"></script>
<script src="calendar/js/calendar.js" type="text/javascript" ></script>
<title>购物车</title>
<script type="text/javascript">
var moneySign="<%=PPFOR_moneySign %>";
var deliverySelectedId=0;
var deliveryPrice=0;
var paymentSelectedId=0;
var paymentPrice=0;
var paymentRate=0;
var protectablePrice=0;
var cashType=0;
function showOrHideTime(value)
{
    var obj=document.getElementById("displayDatetime");
    var boo=value!=null && value==-1;
    if(obj!=null){
        obj.style.display=boo?'':'none';
    }    
}
function checkInput(){    
    var msg='';
    var objArea=document.getElementById('<%=PPFOR_areaSelected.ClientID %>');
    if(objArea!=null && objArea.value<=0){
        msg+='<%=languageMessage.GetMessage("orderAreaError", "请选择完整的地区")%>'+'\n';
    }
    var objTel=document.getElementById('<%=PPFOR_userTelephone.ClientID %>');   
    var objPhone=document.getElementById('<%=PPFOR_userPhone.ClientID %>');   
    if((objTel==null || objTel.value.replace(/(^\s*)|(\s*$)/g,"")=='')&&(objPhone==null || objPhone.value.replace(/(^\s*)|(\s*$)/g,"")=='')){
        msg+='<%=languageMessage.GetMessage("orderPhoneError", "请填写 电话 或 手机 其中一种联系方式")%>'+'\n';
    }
    var objPS=document.getElementById('<%=PPFOR_orderPS.ClientID %>');   
    if(objPS!=null && objPS.value.length>255){
        msg+='<%=languageMessage.GetMessage("orderPSError", "订单附言的内容长度需在255字符以内")%>'+'\n';     
    }    
    var boo=false;   
    var objSelTime=document.getElementById('<%=PPFOR_deliveryDay.ClientID %>');   
    if(objSelTime!=null && objSelTime.value=='-1'){ 
        var objTime=document.getElementById('<%=PPFOR_seleteDate.ClientID %>');       
        if(objTime!=null){
            var tm=new Date(objTime.value);
            var now=new Date();
            if(tm.getFullYear()>=now.getFullYear() && tm.getMonth()>=now.getMonth() && tm.getDate()>=now.getDate()){
               boo=true;
            }
        }
    }else{
        boo=true;
    }
    if(!boo){
        msg+='<%=languageMessage.GetMessage("orderDayError", "请正确填写送货日期")%>'+'\n';
    }
    if(!checkRadioIsChecked('deliveryIdList')){
        msg+='<%=languageMessage.GetMessage("orderDeliveryNone", "请选择配送方式")%>'+'\n';
    }
    if(!checkRadioIsChecked('paymentIdList')){
        msg+='<%=languageMessage.GetMessage("orderPaymentNone", "请选择支付方式")%>'+'\n';
    }
    boo=msg=='';
    if(!boo){
        alert(msg);
    }
    return boo;
}
function checkRadioIsChecked(name){
    var objs=document.getElementsByName(name);
    var retValue=false;
    if(objs!=null && objs.length>0){
        for(var i=0; i<objs.length; i++){
            if(objs[i].checked==true){
                retValue=true;
                break;
            }
        }
    }else{
        retValue=true;
    }
    return retValue;
}
function showChildAreaList(aid,degree)
{
    if(aid<=0){
        hideChildAreaList(degree);
    }
    DoAjax('JScript.aspx?action=getarea&aid='+aid+'&degree='+degree,'GET',null,appendAreaList,aid,degree);
}
function showDeliveryList(areaId)
{
    deliverySelectedId=0;
    deliveryPrice=0;
    protectablePrice=0;
    cashType=0;
    changeMoney();
    DoAjax('JScript.aspx?action=getdelivery&aid='+areaId+'&money=<%=orderTotalMoney%>&weight=<%=orderTotalWeight%>','GET',null,appendDeliveryList);       
}
function showPaymentList()
{
    paymentSelectedId=0;
    paymentPrice=0;   
    paymentRate=0; 
    var code='';
    var obj=document.getElementById('<%=PPFOR_moneyTypeList.ClientID %>');
    if(obj!=null && obj.selectedIndex>-1){
        code=obj.options[obj.selectedIndex].getAttribute('code')||''; 
    }
    var money=parseFloat('<%=orderTotalMoney%>');  
    if(deliverySelectedId>0){      
        money+=parseFloat(deliveryPrice)+parseFloat(protectablePrice);       
    }
    DoAjax('JScript.aspx?action=getpayment&money='+money+'&cashtype='+cashType+'&code='+code,'GET',null,appendPaymentList);       
}
function setAreaSelected(areaId)
{
    var obj=document.getElementById('<%=PPFOR_areaSelected.ClientID %>');
    obj.value=areaId;    
    showDeliveryList(areaId);
    if(areaId>0){
        var objAddress=document.getElementById('<%=PPFOR_userAddress.ClientID %>');   
        if(objAddress!=null&&objAddress.value.replace(/(^\s*)|(\s*$)/g,"")==''){
            var objArea=document.getElementById('areaListOf_1');
            var addressText='';
            var d=1;
            while(objArea!=null && objArea.options.length>0 && objArea.selectedIndex>-1){
                addressText+=objArea.options[objArea.selectedIndex].text+' ';
                d++;
                objArea=document.getElementById('areaListOf_'+d);
            }
            objAddress.value=addressText;
        }        
    }
}
function appendDeliveryList(xmlHttp){
    if(xmlHttp.responseText!=null){  
        var objDelivery=document.getElementById('deliveryList');
        if(objDelivery!=null){
            objDelivery.innerHTML=xmlHttp.responseText;
        }
    }
}
function appendPaymentList(xmlHttp){
    if(xmlHttp.responseText!=null){  
        var objPayment=document.getElementById('paymentList');
        if(objPayment!=null){
            objPayment.innerHTML=xmlHttp.responseText;
        }
    }
}
function hideChildAreaList(degree)
{
    var objs=document.getElementsByTagName('span');
    if(objs!=null && objs.length>0){
        for(var i=0;i<objs.length;i++){               
            if(objs[i].getAttribute('name')!=null && objs[i].getAttribute('degree')!=null && objs[i].getAttribute('name')=='areaSelected'){                      
                var dg=objs[i].getAttribute('degree'); 
                if(dg>=degree){
                    objs[i].style.display='none';
                }
            }
        }
    }
}
function appendAreaList(xmlHttp,areaId,degree){
    if(xmlHttp.responseText!=null && xmlHttp.responseText!=''){  
        var objSelect=document.getElementById('selectArea');
        if(objSelect!=null){
            var newArea =null;  
            var objs=document.getElementsByTagName('span');
            if(objs!=null && objs.length>0){
                for(var i=0;i<objs.length;i++){               
                    if(objs[i].getAttribute('name')!=null && objs[i].getAttribute('degree')!=null && objs[i].getAttribute('name')=='areaSelected'){                      
                        var dg=objs[i].getAttribute('degree'); 
                        if(dg>degree){
                            objs[i].style.display='none';
                        }else if (dg==degree){                            
                            objs[i].style.display='';
                            newArea=objs[i];
                        }
                    }
                }
            }
            if(newArea==null){
                newArea = document.createElement("span");
                newArea.setAttribute('name','areaSelected');
                newArea.setAttribute('degree',degree);
                objSelect.appendChild(newArea); 
            }
            
            newArea.innerHTML=xmlHttp.responseText;      
            var objArea=document.getElementById('areaListOf_'+degree);   
            if(objArea!=null&&objArea.options.length>0){
                if(objArea.options[0].value==-1){
                    objArea.options[0].text='<%=languageMessage.GetMessage("orderSelectArea", "请选择..")%>';
                }
            }     
        }
        setAreaSelected(-1);
    }else{
        setAreaSelected(areaId);
    }   
}
function changePayment(obj)
{
    if(obj.type=='radio'){        
        if(obj.checked){
            if(paymentSelectedId!=obj.value){
                var objInner=document.getElementById('payment_inner'+paymentSelectedId);
                if(objInner!=null){
                    objInner.style.display='none';
                } 
                var price=obj.getAttribute('price')||'0'; 
                var rate=obj.getAttribute('rate')||'0'; 
                paymentPrice=parseFloat(price);     
                paymentRate=parseFloat(rate);               
                paymentSelectedId=obj.value; 
                objInner=document.getElementById('payment_inner'+paymentSelectedId);
                if(objInner!=null){
                    objInner.style.display='';
                }                                         
            }
        }
        changeMoney();
    }
}
function changeDelivery(obj)
{
    if(obj.type=='radio'){
        if(obj.checked){
            if(deliverySelectedId!=obj.value){
                var price=obj.getAttribute('price')||0;               
                var cash=obj.getAttribute('cashType')||0; 
                resetAllProtectable(); 
                deliverySelectedId=obj.value; 
                deliveryPrice=parseFloat(price);    
                if(cash!=cashType){
                    cashType=cash;  
                    showPaymentList();                                         
                }                                 
            }
        }
        changeMoney();
    }
}
function resetAllProtectable()
{
    protectablePrice=0;
    var objs=document.getElementsByName('isProtectable');           
    if(objs!=null && objs.length>0){
        for(var i=0;i<objs.length;i++){
            objs[i].checked=false;
        }
    } 
}
function changeProtectable(obj)
{
    if(obj.type=='checkbox'){  
        if(deliverySelectedId==obj.value){   
            if(obj.checked){
                var price=obj.getAttribute('price')||'0';            
                protectablePrice=parseFloat(price);                
            }else{
                protectablePrice=0;
            }            
            changeMoney();
        }else{
            obj.checked=false;
        }
    }
}
function changeMoney()
{ 
    var money_sign='<%=PPFOR_moneySign %>';
    var sign=money_sign;
    var total_money=parseFloat('<%=orderTotalMoney%>')+parseFloat(deliveryPrice)+parseFloat(protectablePrice);
    var pay_money=total_money*paymentRate+paymentPrice;
    total_money+=pay_money;
    var objMoneyList=document.getElementById("<%=PPFOR_moneyTypeList.ClientID %>");
    var objOrderMoney=document.getElementById("<%=PPFOR_orderMoney.ClientID %>");
    var objMoneyRate=document.getElementById("<%=PPFOR_moneyRate.ClientID %>");  
    var rate=1;
    if(objOrderMoney!=null && objMoneyList!=null && objMoneyList.selectedIndex>-1){
        var option=objMoneyList.options[objMoneyList.selectedIndex];      
        rate=option.getAttribute('rate');       
        if(rate!=null){
            if(objMoneyRate!=null){
                objMoneyRate.innerHTML=rate;
            }            
            if(option.getAttribute('sign')!=null){
                sign=option.getAttribute('sign');          
            }          
        }else{
            rate=-1;
        }                   
    }       
    var objRow=document.getElementById('displayDeliveryMoney');
    var objMoney=document.getElementById('deliveryMoney');
    if(objRow!=null){
       objRow.style.display=deliverySelectedId>0?'':'none';
    }
    if(objMoney!=null){
        objMoney.innerHTML=formatMoney(deliveryPrice,money_sign);
    }
    objRow=document.getElementById('displayProtectMoney');
    objMoney=document.getElementById('protectMoney');
    if(objRow!=null){
       objRow.style.display=protectablePrice>0?'':'none';
    }
    if(objMoney!=null){
        objMoney.innerHTML=formatMoney(protectablePrice,money_sign);
    }
    objRow=document.getElementById('displayPaymentMoney');
    objMoney=document.getElementById('paymentMoney');
    if(objRow!=null){
       objRow.style.display=paymentSelectedId>0?'':'none';
    }    
    if(objMoney!=null){
        objMoney.innerHTML=formatMoney(pay_money,money_sign);
    }   
    if(rate>0){    
        objOrderMoney.innerHTML=formatMoney(total_money*rate,sign,0.01);   
    }else{
        objOrderMoney.innerHTML=formatMoney(total_money,money_sign,0.01);   
    }
} 
function formatMoney(money,sign,minValue){    
    if(minValue!=null){
        if(minValue>money){
            money=minValue;
        }
    }
    var moneyStr=''+money; 
    if(moneyStr.indexOf('.')<0){    
        moneyStr=moneyStr+'.00'; 
    }else if(moneyStr.indexOf('.')==moneyStr.length-1){
        moneyStr=moneyStr+'00';    
    }else if(moneyStr.indexOf('.')==moneyStr.length-2){
        moneyStr=moneyStr+'0';    
    }else if(moneyStr.indexOf('.')<moneyStr.length-3){ 
        moneyStr=''+(money+0.005);
        moneyStr=moneyStr.substr(0,moneyStr.indexOf('.')+3);  
    }
    return sign+moneyStr;
}
</script>
</head>
<body>
<form runat="server" action="CheckOut.aspx" onsubmit="return checkInput();">
<popup:popupMessage ID="PPFOR_popupMessage" runat="server" />    
<div class="tableco">
    <span class="chkouttitle"><%=languageMessage.GetMessage("orderRecipientArea", "填写收货人信息")%></span>   
    <table class="tableco">
        <tr>
            <td align="right" style="width:15%"><%=languageMessage.GetMessage("orderDeliveryArea", "收货地区：")%><asp:HiddenField ID="PPFOR_areaSelected" Value="-1" runat="server" /></td>
            <td align="left" id="selectArea"></td>
        </tr>
        <tr>
            <td align="right" style="width:15%"><%=languageMessage.GetMessage("orderDeliveryAddress", "地址：")%></td>
            <td align="left"><asp:TextBox ID="PPFOR_userAddress" runat="server" MaxLength="255" Width="400px"></asp:TextBox>
                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" ControlToValidate="PPFOR_userAddress" runat="server" Display="Dynamic" SetFocusOnError="true"><br /><%=languageMessage.GetMessage("orderAddressEmptyError", "地址不能为空")%></asp:RequiredFieldValidator>
            </td>
        </tr>
         <tr>
            <td align="right" style="width:15%"><%=languageMessage.GetMessage("orderZipCode", "邮编：")%></td>
            <td align="left"><asp:TextBox ID="PPFOR_userZipCode" runat="server" MaxLength="15" Width="200px"></asp:TextBox>
            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" ControlToValidate="PPFOR_userZipCode" runat="server" Display="Dynamic" SetFocusOnError="true"><br /><%=languageMessage.GetMessage("orderZipCodeEmptyError", "邮编不能为空")%></asp:RequiredFieldValidator>
            </td>
        </tr>
           <tr>
            <td align="right" style="width:15%"><%=languageMessage.GetMessage("orderRecipientName", "收货人姓名：")%></td>
            <td align="left"><asp:TextBox ID="PPFOR_userRealName" runat="server" MaxLength="100" Width="200px"></asp:TextBox><%=languageMessage.GetMessage("orderNameInfo", "请填写真实姓名，以免延误收货")%>
            <asp:RequiredFieldValidator ID="RequiredFieldValidator3" ControlToValidate="PPFOR_userRealName" runat="server" Display="Dynamic" SetFocusOnError="true"><br /><%=languageMessage.GetMessage("orderNameEmptyError", "收货人姓名不能为空")%></asp:RequiredFieldValidator>
            </td>
        </tr>
          <tr>
            <td align="right" style="width:15%"><%=languageMessage.GetMessage("userEmail", "电子邮箱：")%></td>
            <td align="left"><asp:TextBox ID="PPFOR_userEmail" runat="server" MaxLength="100" Width="200px"></asp:TextBox>
            <asp:RequiredFieldValidator ID="RequiredFieldValidator4" ControlToValidate="PPFOR_userEmail" runat="server" Display="Dynamic" SetFocusOnError="true"><br /><%=languageMessage.GetMessage("userEmailEmptyError", "电子邮箱地址不能为空")%></asp:RequiredFieldValidator>
            <asp:RegularExpressionValidator ID="RegularExpressionValidator2" runat="server" Display="Dynamic" SetFocusOnError="true" ControlToValidate="PPFOR_userEmail" ValidationExpression="^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$"><br /><%=languageMessage.GetMessage("userEmailFormatError", "电子邮箱地址格式不对")%></asp:RegularExpressionValidator>
            </td>
        </tr>
        <tr>
            <td align="right" style="width:15%"><%=languageMessage.GetMessage("userTelephone", "联系电话：")%></td>
            <td align="left"><asp:TextBox ID="PPFOR_userTelephone" runat="server" MaxLength="15" Width="200px"></asp:TextBox><%=languageMessage.GetMessage("orderPhoneInfo", "手机和电话填写一项即可")%></td>
        </tr>
         <tr>
            <td align="right" style="width:15%"><%=languageMessage.GetMessage("userPhone", "联系手机：")%></td>
            <td align="left"><asp:TextBox ID="PPFOR_userPhone" runat="server" MaxLength="15" Width="200px"></asp:TextBox></td>
        </tr>
    </table>   
    <table class="tableco">
        <tr>
            <td align="right" style="width:15%"><%=languageMessage.GetMessage("orderDeliveryDay", "送货日期：")%></td>
            <td align="left" style="width:35%"><asp:DropDownList ID="PPFOR_deliveryDay" runat="server">            
            </asp:DropDownList>
            <span id="displayDatetime" style="display:none; margin-left:5px;">
                <asp:TextBox ID="PPFOR_seleteDate" runat="server" CssClass="datetime" Width="150px"></asp:TextBox><br /><%=languageMessage.GetMessage("orderDayInfo", "请勿选择默认日期之前的时间")%>
            </span>
            </td>
            <td align="right" style="width:15%"><%=languageMessage.GetMessage("orderDeliveryTime", "时间：")%></td>
            <td align="left" style="width:35%"><asp:DropDownList ID="PPFOR_deliveryTime" runat="server">        
            </asp:DropDownList></td>
        </tr>
        <tr>
            <td align="right" style="width:15%"><%=languageMessage.GetMessage("orderPS", "订单附言：")%></td>
            <td align="left" colspan="3"><asp:TextBox TextMode="MultiLine" MaxLength="255" Width="400px" runat="server" ID="PPFOR_orderPS"></asp:TextBox></td>
        </tr>
    </table> 
    <div style="display:<%=PPFOR_displayDeliveryTypeOption %>">
     <span class="chkouttitle"><%=languageMessage.GetMessage("orderDeliveryArea", "选择配送方式")%></span>      
     <table class="tableco">
     <tr>        
        <td align="left" id="deliveryList"><%=languageMessage.GetMessage("orderDeliveryTip", "请先在“收货人信息”中选择“收货地区”")%></td>
     </tr>   
    </table>
    </div>  
    <div style="display:<%=PPFOR_displayMoneyTypeOption %>">
     <span class="chkouttitle"><%=languageMessage.GetMessage("orderPayArea", "选择支付方式")%></span> - 
     <span class="chkouttitle"><%=languageMessage.GetMessage("orderPayCurrency", "货币类型：")%><asp:DropDownList ID="PPFOR_moneyTypeList" runat="server"></asp:DropDownList></span>
     <table class="tableco">
     <tr>        
        <td align="left" id="paymentList"></td>
     </tr>   
    </table>
    </div>
    <span class="chkouttitle"><%=languageMessage.GetMessage("orderGoodsArea", "购买的商品")%></span>       
        <asp:GridView ID="PPFOR_showGoodsList" CssClass="listtable" runat="server" OnRowDataBound="PPFOR_gridViewRowDataBound" AllowPaging="false" AutoGenerateColumns="False"  DataKeyNames="Id"  Width="100%" CellPadding="0" BackColor="White" BorderColor="#CCCCCC" BorderStyle="None" BorderWidth="0px">
           <Columns>  
             <asp:BoundField HeaderStyle-CssClass="title" ItemStyle-Width="40%" HeaderStyle-Font-Bold="false"/> 
             <asp:BoundField HeaderStyle-CssClass="title" HeaderStyle-Font-Bold="false"/>              
             <asp:BoundField HeaderStyle-CssClass="title" ItemStyle-Font-Strikeout="true" HeaderStyle-Font-Bold="false"/> 
             <asp:BoundField HeaderStyle-CssClass="title" HeaderStyle-Font-Bold="false"/> 
             <asp:BoundField HeaderStyle-CssClass="title" HeaderStyle-Font-Bold="false"/>                
             <asp:BoundField HeaderStyle-CssClass="title" HeaderStyle-Font-Bold="false"/>                      
            </Columns>            
             <FooterStyle BackColor="#990000" ForeColor="White" /> 
             <RowStyle Font-Bold="false" BackColor="#ffffff"/> 
             <HeaderStyle BackColor="#F5F5F5" Font-Bold="false" ForeColor="#000000" />
             <AlternatingRowStyle BackColor="#F5F5F5" />
        </asp:GridView>         
       <table width="100%" cellpadding="0" cellspacing="0" border="0" class="listtable">
        <tr>     
            <td style="width:80%; text-align:right;">  
              <%=languageMessage.GetMessage("orderTotalMoney", "商品总额：")%>
            </td>
            <td>
              <asp:Label ID="PPFOR_totalMoney" CssClass="cart_yellow" runat="server"></asp:Label>
            </td>
        </tr>   
        <tr id='displayDeliveryMoney' style="display:none;">     
            <td style="width:80%; text-align:right;">  
              <%=languageMessage.GetMessage("orderDeliveryMoney", "配送费用：")%>
            </td>
            <td>
              <span id="deliveryMoney" class="cart_yellow"></span>
            </td>
        </tr>   
        <tr id='displayProtectMoney' style="display:none;">     
            <td style="width:80%; text-align:right;">  
              <%=languageMessage.GetMessage("orderDeliveryProtect", "保价：")%>
            </td>
            <td>
              <span id="protectMoney" class="cart_yellow"></span>
            </td>
        </tr> 
        <tr id='displayPaymentMoney' style="display:none;">     
            <td style="width:80%; text-align:right;">  
              <%=languageMessage.GetMessage("orderPaymentMoney", "支付费用：(客户承担支付手续费)")%>
            </td>
            <td>
              <span id="paymentMoney" class="cart_yellow"></span>
            </td>
        </tr>   
         <tr style="display:<%=PPFOR_displayMoneyTypeOption %>">
            <td style="width:80%; text-align:right;">  
                <%=languageMessage.GetMessage("orderMoneyRate", "货币汇率：")%>
             </td>
             <td>
                <asp:Label ID="PPFOR_moneyRate" CssClass="cart_yellow" runat="server"></asp:Label>                      
            </td>
        </tr>
        <tr style="display:<%=PPFOR_displayMoneyTypeOption %>">
            <td style="width:80%; text-align:right;">  
                <%=languageMessage.GetMessage("orderPayMoney", "货币结算金额：")%>
             </td>
             <td>
                <asp:Label ID="PPFOR_orderMoney" CssClass="cart_yellow" runat="server"></asp:Label>                      
            </td>
        </tr>        
        <tr>
            <td colspan="2">
                <div style="text-align:left; width:40%; float:left"><asp:Button ID="PPFOR_backShoppingCart"  CssClass="blueinput" runat="server" OnClientClick="location.href='cart.aspx';return false;" /></div>                          
                <div style="text-align:right; width:40%; float:right"><asp:Button ID="PPFOR_saveOrder" CssClass="blueinput" runat="server" OnClick="PPFOR_saveOrderClick" /></div>
            </td>
        </tr>
     </table>     
</div>
</form>
</body>
</html>
