<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output 
		  method="html" 
		  version="4.0" 
		  encoding="UTF-8" 
		  omit-xml-declaration="yes" 
		  indent="yes"/>
		  
	<xsl:template match="/">
		<html>
			<head>
				<meta HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=UTF-8">
				<title>Report</title>
			</head>
			<body>
    		<table border="0" width="100%">
          <tr>
            <td colspan="3">
              <h3>QT_TRANSLATE_NOOP("QObject", "Volume") <xsl:value-of select="Root/VolumeInfo/Label"/> <xsl:value-of select="Root/VolumeInfo/Drive"/></h3>
            </td>
			    </tr>
          <tr>
            <td colspan="3">
              <hr>
            </td>
			    </tr>
    		  <tr>
				    <td align="right"><b><nobr>QT_TRANSLATE_NOOP("QObject", "Volume Size:")</nobr></b></td>
				    <td><nobr><xsl:value-of select="Root/VolumeInfo/VolumeSize"/></nobr></td>
            <td width="100%"/>
			    </tr>
    		  <tr>
				    <td align="right"><b>QT_TRANSLATE_NOOP("QObject", "Cluster size:")</b></td>
				    <td><xsl:value-of select="Root/VolumeInfo/ClusterSize"/></td>
            <td width="100%"/>
			    </tr>
    		  <tr>
				    <td align="right"><b>QT_TRANSLATE_NOOP("QObject", "Free Space:")</b></td>
				    <td><xsl:value-of select="Root/VolumeInfo/FreeSpace"/></td>
            <td width="100%"/>
			    </tr>
    		  <tr>
				    <td align="right"><b>QT_TRANSLATE_NOOP("QObject", "Used Space:")</b></td>
				    <td><xsl:value-of select="Root/VolumeInfo/UsedSpace"/></td>
            <td width="100%"/>
			    </tr>
        </table>

        <table border="0" width="100%">
          <tr>
            <td colspan="3">
              <br/><h3>QT_TRANSLATE_NOOP("QObject", "Free space fragmentation")</h3>
            </td>
			    </tr>
          <tr>
            <td colspan="3">
              <hr>
            </td>
			    </tr>
          <xsl:choose>
            <xsl:when test="number(Root/VolumeInfo/FreeSpaceInBytes) = 0">
              <tr>
                <td colspan="3">QT_TRANSLATE_NOOP("QObject", "There is no free space on this volume.")</td>
              </tr>
            </xsl:when>
            <xsl:otherwise>
              <tr>
                <td align="right"><nobr><b>QT_TRANSLATE_NOOP("QObject", "Total Fragments:")</b></nobr></td>
                <td><nobr><xsl:value-of select="Root/VolumeInfo/FragFreeSpace"/></nobr></td>
                <td width="100%"/>
              </tr>
              
              <tr>
                <td align="right"><nobr><b>QT_TRANSLATE_NOOP("QObject", "Fragmentation:")</b></nobr></td>
                <td><nobr><xsl:value-of select="Root/VolumeInfo/FreeSpaceFragmentation"/>%</nobr></td>
                <td width="100%"/>
              </tr>
              
            </xsl:otherwise>
          </xsl:choose>
        </table>
        
    		<table border="0" width="100%">
          <tr>
            <td colspan="3">
              <br/><h3>QT_TRANSLATE_NOOP("QObject", "Bad clusters fragmentation")</h3>
            </td>
			    </tr>
          <tr>
            <td colspan="3">
              <hr>
            </td>
			    </tr>
          <xsl:choose>
            <xsl:when test="number(Root/VolumeInfo/BadSpaceInBytes) = 0">
              <tr>
                <td colspan="3">QT_TRANSLATE_NOOP("QObject", "No bad blocks found.")</td>
              </tr>
            </xsl:when>
            <xsl:otherwise>
              <tr>
                <td align="right"><b><nobr>QT_TRANSLATE_NOOP("QObject", "Fragments Size:")</nobr></b></td>
                <td><nobr><xsl:value-of select="Root/VolumeInfo/BadSpace"/></nobr></td>
                <td width="100%"/>
              </tr>
              <tr>
                <td align="right"><b><nobr>QT_TRANSLATE_NOOP("QObject", "Total Fragments:")</nobr></b></td>
                <td><nobr><xsl:value-of select="Root/VolumeInfo/BadSpaceFragments"/></nobr></td>
                <td width="100%"/>
              </tr>
            </xsl:otherwise>
          </xsl:choose>
        </table>

    		<table border="0" width="100%">
          <tr>
            <td colspan="3">
              <br/><h3>QT_TRANSLATE_NOOP("QObject", "Files fragmentation")</h3>
            </td>
			    </tr>
          <tr>
            <td colspan="3">
              <hr>
            </td>
			    </tr>
    		  <tr>
				    <td align="right"><b><nobr>QT_TRANSLATE_NOOP("QObject", "Total Files:")</nobr></b></td>
				    <td><nobr><xsl:value-of select="Root/FilesInfo/FilesTotal"/></nobr></td>
            <td width="100%"/>
			    </tr>
    		  <tr>
				    <td align="right"><b><nobr>QT_TRANSLATE_NOOP("QObject", "Fragmented Files:")</nobr></b></td>
				    <td><nobr><xsl:value-of select="Root/FilesInfo/FilesFragmented"/></nobr></td>
            <td width="100%"/>
			    </tr>
        </table>

    		<table border="0" width="100%">
          <tr>
            <td colspan="3">
              <br/><h3>QT_TRANSLATE_NOOP("QObject", "Folders fragmentation")</h3>
            </td>
			    </tr>
          <tr>
            <td colspan="3">
              <hr>
            </td>
			    </tr>
    		  <tr>
				    <td align="right"><b><nobr>QT_TRANSLATE_NOOP("QObject", "Total Folders:")</nobr></b></td>
				    <td><nobr><xsl:value-of select="Root/FilesInfo/FoldersTotal"/></nobr></td>
            <td width="100%"/>
			    </tr>
    		  <tr>
				    <td align="right"><b><nobr>QT_TRANSLATE_NOOP("QObject", "Fragmented Folders:")</nobr></b></td>
				    <td><nobr><xsl:value-of select="Root/FilesInfo/FoldersFragmented"/></nobr></td>
            <td width="100%"/>
			    </tr>
        </table>

			  <xsl:if test="number(Root/MFTInfo/UsedMFTRecords) != 0">
          <table border="0" width="100%">
          <tr>
            <td colspan="3">
              <br/><h3>QT_TRANSLATE_NOOP("QObject", "MFT fragmentation")</h3>
            </td>
			    </tr>
          <tr>
            <td colspan="3">
              <hr>
            </td>
			    </tr>
            <tr>
              <td align="right"><b><nobr>QT_TRANSLATE_NOOP("QObject", "Total MFT Size:")</nobr></b></td>
              <td><nobr><xsl:value-of select="Root/MFTInfo/MFTSize"/></nobr></td>
              <td width="100%"/>
            </tr>
            <tr>
              <td align="right"><b><nobr>QT_TRANSLATE_NOOP("QObject", "MFT Records in Use:")</nobr></b></td>
              <td><nobr><xsl:value-of select="Root/MFTInfo/UsedMFTRecords"/></nobr></td>
              <td width="100%"/>
            </tr>
            <tr>
              <td align="right"><b><nobr>QT_TRANSLATE_NOOP("QObject", "MFT Fragments:")</nobr></b></td>
              <td><nobr><xsl:value-of select="Root/MFTInfo/MFTFragments"/></nobr></td>
              <td width="100%"/>
            </tr>
          </table>
        </xsl:if>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
