/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears;

import com.sun.jna.Native;
import hu.belicza.andras.sc2gears.Consts;
import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.logger.Log;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.services.InstanceMonitor;
import hu.belicza.andras.sc2gears.services.plugins.PluginManager;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.WelcomeFrame;
import hu.belicza.andras.sc2gears.util.CliHandler;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.io.File;
import javax.swing.UIManager;

public class Sc2gears {
    private Sc2gears() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Sc2gears.checkFolders();
        Settings.loadProperties();
        boolean bl = CliHandler.checkCliMode(stringArray);
        if (!bl) {
            InstanceMonitor.checkRunningInstance(stringArray);
            Log.init();
        }
        if (!bl) {
            Sc2gears.installExtraLAFs();
            GuiUtils.setLAF(Settings.getString("settings.laf"));
        }
        if (Settings.doesSettingsFileExist()) {
            Language.loadLanguage(Settings.getString("settings.language"));
        } else if (!bl) {
            WelcomeFrame welcomeFrame;
            WelcomeFrame welcomeFrame2 = welcomeFrame = new WelcomeFrame();
            synchronized (welcomeFrame2) {
                try {
                    welcomeFrame.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        Language.applyDateTimeFormats();
        Settings.completeDefaultPropertiesInitialization();
        GuiUtils.initFileFilters();
        Sc2gears.checkAndPerformPostUpdate();
        try {
            Class.forName(ReplayUtils.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        if (bl) {
            System.exit(CliHandler.handleArguments(stringArray));
        } else {
            if (GeneralUtils.isWindows()) {
                try {
                    Class.forName(Native.class.getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
            PluginManager.loadPlugins();
            new MainFrame(stringArray);
        }
    }

    private static void checkFolders() {
        String[] stringArray = Consts.USER_CONTENT_FOLDERS;
        int n = Consts.USER_CONTENT_FOLDERS.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            ++n2;
        }
    }

    public static boolean checkAndPerformPostUpdate() {
        File file = new File(Consts.LIB_UPDATER_FOLDER, "Sc2gearsUpdater2.jar").getAbsoluteFile();
        if (file.exists()) {
            System.out.println("Performing post-update...");
            File file2 = new File(Consts.LIB_UPDATER_FOLDER, "Sc2gearsUpdater.jar").getAbsoluteFile();
            int n = 0;
            while (n < 20) {
                if (!file2.exists() || file2.delete()) {
                    if (file.renameTo(file2)) {
                        Sc2gears.performPostUpdateTasks();
                        System.out.println("Post-update completed.");
                        return true;
                    }
                    System.err.println("Could not rename file: " + file.getAbsolutePath());
                    System.err.println("\tto: " + file2.getAbsolutePath());
                    System.err.println("Post-update could not be performed!");
                    return false;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                ++n;
            }
            System.err.println("Could not delete file: " + file2.getAbsolutePath());
            System.err.println("Post-update could not be performed!");
            return false;
        }
        return true;
    }

    private static void performPostUpdateTasks() {
        String string;
        String string2;
        String string3;
        String string4 = Settings.getString("settings.misc.repAutoSaveNameTemplate");
        if ("/D./e".equals(string4)) {
            Settings.set("settings.misc.repAutoSaveNameTemplate", Settings.getDefaultString("settings.misc.repAutoSaveNameTemplate"));
        }
        if ((string4 = Settings.getString("settings.misc.repAutoSaveNameTemplate")) != null) {
            Settings.set("settings.misc.repAutoSaveNameTemplate", string4.replace("/P", "/p").replace("/Q", "/q"));
        }
        if ((string3 = Settings.getString("module.repSearch.results.renameTemplate")) != null) {
            Settings.set("module.repSearch.results.renameTemplate", string3.replace("/P", "/p").replace("/Q", "/q"));
        }
        if ((string2 = Settings.getString(Settings.PredefinedList.REP_AUTO_SAVE_TEMPLATE.settingsKey)) != null) {
            Settings.set(Settings.PredefinedList.REP_AUTO_SAVE_TEMPLATE.settingsKey, string2.replace("/P", "/p").replace("/Q", "/q"));
        }
        if ((string = Settings.getString(Settings.PredefinedList.REP_RENAME_TEMPLATE.settingsKey)) != null) {
            Settings.set(Settings.PredefinedList.REP_RENAME_TEMPLATE.settingsKey, string.replace("/P", "/p").replace("/Q", "/q"));
        }
        Settings.rebuildPredefinedLists();
        Settings.remove("module.repAnalyzer.charts.mapView.hotAreasCount");
        Settings.remove("module.repAnalyzer.charts.mapView.iconSizesCS");
        string4 = Settings.getString(Settings.PredefinedList.REP_ANAL_FILTER.settingsKey);
        if (string4 != null) {
            if (string4.contains("battlecuriser")) {
                Settings.set(Settings.PredefinedList.REP_ANAL_FILTER.settingsKey, string4.replace("battlecuriser", "battlecruiser"));
            }
            Settings.rebuildPredefinedLists();
        }
        if ("Napkin".equals(Settings.getString("settings.laf"))) {
            Settings.remove("settings.laf");
        }
        Settings.saveProperties();
    }

    private static void installExtraLAFs() {
        UIManager.installLookAndFeel("EaSynthLookAndFeel", "com.easynth.lookandfeel.EaSynthLookAndFeel");
        UIManager.installLookAndFeel("Office 2003", "org.fife.plaf.Office2003.Office2003LookAndFeel");
        UIManager.installLookAndFeel("Office XP", "org.fife.plaf.OfficeXP.OfficeXPLookAndFeel");
        UIManager.installLookAndFeel("Visual Studio 2005", "org.fife.plaf.VisualStudio2005.VisualStudio2005LookAndFeel");
        UIManager.installLookAndFeel("Squareness", "net.beeger.squareness.SquarenessLookAndFeel");
    }
}

