/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.language;

import hu.belicza.andras.sc2gears.Consts;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.util.LeetTranslator;
import hu.belicza.andras.sc2gears.util.Pair;
import java.io.File;
import java.io.FilenameFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Language {
    private String language;
    private String languageFileVersion;
    private String languageFileSubversion;
    private String translatorFirstName;
    private String translatorLastName;
    private final String defaultDateFormatPattern;
    private final String defaultTimeFormatPattern;
    private final String defaultDateTimeFormatPattern;
    private final SimpleDateFormat DATE_FORMAT;
    private final SimpleDateFormat DATE_TIME_FORMAT;
    private final SimpleDateFormat TIME_FORMAT;
    private boolean personNameFormatFirstNameFirst;
    private final Map<String, String> textMap = new HashMap<String, String>();
    private static final LeetTranslator.LeetnessLevel LEETNESS_LEVEL;
    private static final Language DEFAULT_LANGUAGE;
    private static Language loadedLanguage;

    static {
        Object object;
        try {
            object = LeetTranslator.LeetnessLevel.values()[Settings.getInt("settings.language.leetnessLevel")];
        }
        catch (Exception exception) {
            object = LeetTranslator.LeetnessLevel.values()[Settings.getDefaultInt("settings.language.leetnessLevel")];
        }
        LEETNESS_LEVEL = object;
        object = null;
        try {
            object = new Language("English");
        }
        catch (Exception exception) {
            System.err.println("Failed to load the default language file, program will exit now!");
            System.exit(0);
        }
        loadedLanguage = DEFAULT_LANGUAGE = object;
    }

    private Language(String string) throws Exception {
        try {
            this.language = string;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            Document document = documentBuilderFactory.newDocumentBuilder().parse(new File("Languages", String.valueOf(string) + ".xml"));
            Element element = document.getDocumentElement();
            this.languageFileVersion = element.getAttribute("version");
            if (!"7.0.1".equals(this.languageFileVersion)) {
                System.out.println("The language file (" + string + ") version (" + this.languageFileVersion + ") does not match the application language version (" + "7.0.1" + ").");
                if ("English".equals(string)) {
                    System.out.println("The default language file (English) version MUST match the application language version!");
                    if (!Consts.DEVELOPER_MODE) {
                        System.exit(0);
                    }
                } else {
                    System.out.println("Some texts might be displayed in the default language.");
                }
            }
            this.languageFileSubversion = element.getAttribute("subversion");
            this.translatorFirstName = element.getAttribute("translatorFirstName");
            this.translatorLastName = element.getAttribute("translatorLastName");
            NodeList nodeList = element.getElementsByTagName("dateFormat");
            this.defaultDateFormatPattern = ((Element)nodeList.item(0)).getTextContent();
            this.DATE_FORMAT = new SimpleDateFormat(this.defaultDateFormatPattern);
            nodeList = element.getElementsByTagName("dateTimeFormat");
            this.defaultDateTimeFormatPattern = ((Element)nodeList.item(0)).getTextContent();
            this.DATE_TIME_FORMAT = new SimpleDateFormat(this.defaultDateTimeFormatPattern);
            nodeList = element.getElementsByTagName("timeFormat");
            this.defaultTimeFormatPattern = ((Element)nodeList.item(0)).getTextContent();
            this.TIME_FORMAT = new SimpleDateFormat(this.defaultTimeFormatPattern);
            nodeList = element.getElementsByTagName("personNameFormat");
            String string2 = ((Element)nodeList.item(0)).getTextContent();
            if (!"firstName lastName".equals(string2) && !"lastName firstName".equals(string2)) {
                throw new Exception("Invalid person name format!");
            }
            this.personNameFormatFirstNameFirst = "firstName lastName".equals(string2);
            nodeList = element.getElementsByTagName("text");
            if (DEFAULT_LANGUAGE != null) {
                this.textMap.putAll(Language.DEFAULT_LANGUAGE.textMap);
            }
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Element element2 = (Element)nodeList.item(n2);
                this.textMap.put(element2.getAttribute("key"), element2.getTextContent());
                ++n2;
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to load language file: " + string);
            exception.printStackTrace(System.err);
            throw exception;
        }
    }

    public static boolean loadLanguage(String string) {
        try {
            loadedLanguage = Language.DEFAULT_LANGUAGE.language.equals(string) ? DEFAULT_LANGUAGE : new Language(string);
            Language.updateUIManagerTexts();
            return true;
        }
        catch (Exception exception) {
            System.err.println("Failed to load language file: " + string);
            return false;
        }
    }

    private static void updateUIManagerTexts() {
        UIManager.put("InternalFrameTitlePane.closeButtonText", Language.getText("internalFrame.menu.close"));
        UIManager.put("InternalFrameTitlePane.minimizeButtonText", Language.getText("internalFrame.menu.minimize"));
        UIManager.put("InternalFrameTitlePane.restoreButtonText", Language.getText("internalFrame.menu.restore"));
        UIManager.put("InternalFrameTitlePane.maximizeButtonText", Language.getText("internalFrame.menu.maximize"));
        UIManager.put("InternalFrameTitlePane.moveButtonText", Language.getText("internalFrame.menu.move"));
        UIManager.put("InternalFrameTitlePane.sizeButtonText", Language.getText("internalFrame.menu.size"));
        UIManager.put("InternalFrame.closeButtonToolTip", Language.getText("internalFrame.toolTip.close"));
        UIManager.put("InternalFrame.iconButtonToolTip", Language.getText("internalFrame.toolTip.minimize"));
        UIManager.put("InternalFrame.restoreButtonToolTip", Language.getText("internalFrame.toolTip.restore"));
        UIManager.put("InternalFrame.maxButtonToolTip", Language.getText("internalFrame.toolTip.maximize"));
        UIManager.put("FileChooser.openDialogTitleText", Language.getText("fileChooser.openDialogTitle"));
        UIManager.put("FileChooser.saveDialogTitleText", Language.getText("fileChooser.saveDialogTitle"));
        UIManager.put("FileChooser.lookInLabelText", Language.getText("fileChooser.lookInLabel"));
        UIManager.put("FileChooser.filesOfTypeLabelText", Language.getText("fileChooser.filesOfTypeLabel"));
        UIManager.put("FileChooser.fileNameLabelText", Language.getText("fileChooser.fileNameLabel"));
        UIManager.put("FileChooser.upFolderToolTipText", Language.getText("fileChooser.upFolderToolTip"));
        UIManager.put("FileChooser.homeFolderToolTipText", Language.getText("fileChooser.homeFolderToolTip"));
        UIManager.put("FileChooser.newFolderToolTipText", Language.getText("fileChooser.newFolderToolTip"));
        UIManager.put("FileChooser.listViewButtonToolTipText", Language.getText("fileChooser.listViewButtonToolTip"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", Language.getText("fileChooser.detailsViewButtonToolTip"));
        UIManager.put("FileChooser.saveButtonText", Language.getText("fileChooser.saveButton"));
        UIManager.put("FileChooser.openButtonText", Language.getText("fileChooser.openButton"));
        UIManager.put("FileChooser.cancelButtonText", Language.getText("fileChooser.cancelButton"));
        UIManager.put("FileChooser.updateButtonText", Language.getText("fileChooser.updateButton"));
        UIManager.put("FileChooser.helpButtonText", Language.getText("fileChooser.helpButton"));
        UIManager.put("FileChooser.saveButtonToolTipText", Language.getText("fileChooser.saveButtonToolTip"));
        UIManager.put("FileChooser.openButtonToolTipText", Language.getText("fileChooser.openButtonToolTip"));
        UIManager.put("FileChooser.cancelButtonToolTipText", Language.getText("fileChooser.cancelButtonToolTip"));
        UIManager.put("FileChooser.updateButtonToolTipText", Language.getText("fileChooser.updateButtonToolTip"));
        UIManager.put("FileChooser.helpButtonToolTipText", Language.getText("fileChooser.helpButtonToolTip"));
        UIManager.put("FileChooser.acceptAllFileFilterText", Language.getText("fileChooser.acceptAllFileFilter"));
        UIManager.put("ColorChooser.previewText", Language.getText("colorChooser.preview"));
        UIManager.put("ColorChooser.swatchesRecentText", Language.getText("colorChooser.recent"));
        UIManager.put("ColorChooser.sampleText", Language.getText("colorChooser.sampleText"));
    }

    public static void applyDateTimeFormats() {
        String string = Settings.getString("settings.misc.customDateFormat");
        String string2 = Settings.getString("settings.misc.customTimeFormat");
        String string3 = Settings.getString("settings.misc.customDateTimeFormat");
        try {
            Language.loadedLanguage.DATE_FORMAT.applyPattern(string.length() == 0 ? Language.loadedLanguage.defaultDateFormatPattern : string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        try {
            Language.loadedLanguage.TIME_FORMAT.applyPattern(string2.length() == 0 ? Language.loadedLanguage.defaultTimeFormatPattern : string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        try {
            Language.loadedLanguage.DATE_TIME_FORMAT.applyPattern(string3.length() == 0 ? Language.loadedLanguage.defaultDateTimeFormatPattern : string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
    }

    public static String getLanguageName() {
        return Language.loadedLanguage.language;
    }

    public static String getTranslatorName() {
        return Language.formatPersonName(Language.loadedLanguage.translatorFirstName, Language.loadedLanguage.translatorLastName);
    }

    public static String getLanguageFileVersion() {
        return Language.loadedLanguage.languageFileVersion;
    }

    public static String getLanguageFileSubversion() {
        return Language.loadedLanguage.languageFileSubversion;
    }

    public static String getDefaultLanguageFileVersion() {
        return Language.DEFAULT_LANGUAGE.languageFileVersion;
    }

    public static String getDefaultLanguageFileSubversion() {
        return Language.DEFAULT_LANGUAGE.languageFileSubversion;
    }

    public static String[] getAvailableLanguages() {
        String[] stringArray = new File("Languages").list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".xml");
            }
        });
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = stringArray[n].substring(0, stringArray[n].lastIndexOf(46));
            ++n;
        }
        Arrays.sort(stringArray2, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return "English".equals(string) ? -1 : ("English".equals(string2) ? 1 : string.compareTo(string2));
            }
        });
        return stringArray2;
    }

    public static String getText(String string) {
        return LeetTranslator.translate(Language.loadedLanguage.textMap.get(string), LEETNESS_LEVEL);
    }

    public static String getOriginalText(String string) {
        return Language.loadedLanguage.textMap.get(string);
    }

    public static String getDefaultText(String string) {
        return LeetTranslator.translate(Language.DEFAULT_LANGUAGE.textMap.get(string), LEETNESS_LEVEL);
    }

    public static String getText(String string, Object ... objectArray) {
        String string2 = Language.loadedLanguage.textMap.get(string);
        int n = 0;
        while (n < objectArray.length) {
            string2 = string2.replace("$" + n, objectArray[n].toString());
            ++n;
        }
        return LeetTranslator.translate(string2, LEETNESS_LEVEL);
    }

    public static Pair<String, Character> getTextAndMnemonic(String string, Object ... objectArray) {
        Character c;
        String string2 = Language.loadedLanguage.textMap.get(string);
        int n = string2.indexOf(95);
        if (n < 0) {
            c = null;
        } else {
            string2 = string2.replace("_", "");
            c = Character.valueOf(string2.charAt(n));
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            string2 = string2.replace("$" + n2, objectArray[n2].toString());
            ++n2;
        }
        return new Pair<String, Character>(LeetTranslator.translate(string2, LEETNESS_LEVEL), c);
    }

    public static String formatDate(Date date) {
        return Language.loadedLanguage.DATE_FORMAT.format(date);
    }

    public static String formatDateTime(Date date) {
        return Language.loadedLanguage.DATE_TIME_FORMAT.format(date);
    }

    public static String formatTime(Date date) {
        return Language.loadedLanguage.TIME_FORMAT.format(date);
    }

    public static String formatPersonName(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        if (Language.loadedLanguage.personNameFormatFirstNameFirst) {
            return String.valueOf(string) + ' ' + string2;
        }
        return String.valueOf(string2) + ' ' + string;
    }

    public static Date parseDate(String string) {
        try {
            return Language.loadedLanguage.DATE_FORMAT.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
    }

    public static Date parseDateTime(String string, boolean bl) {
        try {
            return Language.loadedLanguage.DATE_TIME_FORMAT.parse(string);
        }
        catch (ParseException parseException) {
            if (!bl) {
                parseException.printStackTrace();
            }
            return null;
        }
    }
}

