/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sc2replay;

import java.nio.ByteBuffer;

public class BitBufferView {
    private static final int[] LOW_BIT_MASKS;
    private final ByteBuffer wrapper;
    private int cache;
    public final byte initialBits;
    private final int lowBitMask;
    private final int highBitMask;
    private final int byteBoundary;
    private final int byteBoundarySupplement;

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        LOW_BIT_MASKS = nArray;
    }

    public BitBufferView(ByteBuffer byteBuffer, int n) {
        this.wrapper = byteBuffer;
        this.byteBoundary = n;
        this.byteBoundarySupplement = 8 - n;
        this.lowBitMask = LOW_BIT_MASKS[n];
        this.highBitMask = 255 - this.lowBitMask;
        this.cache = byteBuffer.get() & 0xFF;
        this.initialBits = (byte)((this.cache & this.lowBitMask) << this.byteBoundarySupplement);
    }

    public int get() {
        int n = this.cache & this.highBitMask;
        this.cache = this.wrapper.get() & 0xFF;
        return n | this.cache & this.lowBitMask;
    }

    public short get2Bytes() {
        int n = (this.cache & this.highBitMask) << this.byteBoundarySupplement | this.wrapper.get() & 0xFF;
        this.cache = this.wrapper.get() & 0xFF;
        return (short)(n << this.byteBoundary | this.cache & this.lowBitMask);
    }

    public int getInt() {
        int n = (this.cache & this.highBitMask) << this.byteBoundarySupplement | this.wrapper.get() & 0xFF;
        n = n << 8 | this.wrapper.get() & 0xFF;
        n = n << 8 | this.wrapper.get() & 0xFF;
        this.cache = this.wrapper.get() & 0xFF;
        return Integer.reverseBytes(n << this.byteBoundary | this.cache & this.lowBitMask);
    }

    public int getRemainder() {
        return this.cache & this.highBitMask;
    }
}

