/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sc2replay;

import hu.belicza.andras.sc2gears.sc2replay.AbilityCodes;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PlayerSelectionTracker {
    public final List<Short> currentSelection = new ArrayList<Short>();
    public final List<Short>[] hotkeySelectionLists = new List[10];

    public PlayerSelectionTracker() {
        int n = this.hotkeySelectionLists.length - 1;
        while (n >= 0) {
            this.hotkeySelectionLists[n] = new ArrayList<Short>();
            --n;
        }
    }

    public void processSelectAction(GameEvents.SelectAction selectAction) {
        int n;
        int n2;
        if (selectAction.deselectionBitsCount != 0) {
            if (selectAction.deselectionBitsCount < 0) {
                this.currentSelection.clear();
            } else {
                n2 = 0;
                boolean s = false;
                n = 0;
                while (n < selectAction.deselectionBitsCount) {
                    int n3;
                    if ((n & 7) == 0) {
                        n3 = selectAction.deselectionUnitBitmap[n >> 3] & 0xFF;
                    }
                    if ((n3 & 0x80) != 0) {
                        if (n - n2 >= this.currentSelection.size()) break;
                        this.currentSelection.remove(n - n2++);
                    }
                    n3 <<= 1;
                    ++n;
                }
            }
        }
        if (selectAction.unitTypes != null) {
            n2 = 0;
            while (n2 < selectAction.unitTypes.length) {
                short s = selectAction.unitTypes[n2];
                n = selectAction.unitsOfTypeCounts[n2];
                while (n > 0) {
                    this.currentSelection.add(s);
                    --n;
                }
                ++n2;
            }
        }
    }

    public void processHotkeyAction(GameEvents.HotkeyAction hotkeyAction) {
        List<Short> list = this.hotkeySelectionLists[hotkeyAction.getNumber()];
        if (hotkeyAction.isSelect()) {
            this.currentSelection.clear();
            this.currentSelection.addAll(list);
        } else {
            list.clear();
            list.addAll(this.currentSelection);
        }
    }

    public static boolean isSelectionMacro(List<Short> list, AbilityCodes abilityCodes) {
        return abilityCodes.MACRO_UNIT_TYPE_SET.containsAll(list);
    }

    public static String getSelectionString(List<Short> list, Map<Short, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            short s = list.get(n2++);
            int n3 = 1;
            while (n2 < n && list.get(n2) == s) {
                ++n3;
                ++n2;
            }
            String string = map.get(s);
            if (string == null) {
                stringBuilder.append("Unknown[").append(Integer.toHexString(s)).append(']');
            } else {
                stringBuilder.append(string);
            }
            if (n3 <= 1) continue;
            stringBuilder.append(" x").append(n3);
        }
        return stringBuilder.toString();
    }
}

