/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sc2replay;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.awt.Color;
import java.util.EnumSet;
import java.util.Set;

public class ReplayConsts {
    public static final byte MAX_PLAYERS = 15;
    public static final int FRAME_BITS_IN_SECOND = 6;
    public static final int FRAMES_IN_SECOND = 64;
    public static final float ENERGY_REGENERATION_RATE = 0.5625f;
    public static final float ENERGY_REGENERATION_FRAME_RATE = 0.0087890625f;
    public static final int LARVA_SPAWNING_DURATION = 2560;

    private ReplayConsts() {
    }

    public static enum AbilityGroup {
        STOP,
        MOVE,
        PATROL,
        HOLD_POSITION,
        RETURN_CARGO,
        ATTACK,
        CANCEL,
        GATHER_TERRAN,
        GATHER_ZERG,
        GATHER_PROTOSS,
        BURROW,
        UNBURROW,
        ROOT,
        UPROOT,
        SET_RALLY_POINT,
        SET_WORKER_RALLY_POINT,
        CALLDOWN_MULE("Calldown MULE"),
        CALLDOWN_EXTRA_SUPPLIES,
        LIFT_OFF,
        LAND,
        SCANNER_SWEEP,
        SPAWN_CREEP_TUMOR,
        GENERATE_CREEP,
        STOP_GENERATING_CREEP,
        REPAIR,
        LOAD,
        UNLOAD_ALL,
        CHRONO_BOOST,
        LOWER,
        RAISE,
        TANK_MODE,
        SIEGE_MODE,
        TRANSFUSION,
        FORCE_FIELD,
        GUARDIAN_SHIELD,
        UPGRADE_TO_WARP_GATE,
        MUTATE_INTO_A_GATEWAY,
        SALVAGE,
        UPGRADE_TO_ORBITAL_COMMAND,
        CHARGE,
        BLINK,
        SPAWN_CHANGELING,
        FEEDBACK,
        PSIONIC_STORM,
        MORPH_TO_BANELING,
        EXPLODE,
        HEAL,
        CORRUPTION,
        MORPH_TO_BROOD_LORD,
        TRAIN_AN_INTERCEPTOR,
        T250MM_STRIKE_CANNONS,
        CLOAK,
        DECLOAK,
        INFESTED_TERRAN,
        NEURAL_PARASITE,
        UPGRADE_TO_PLANETARY_FORTRESS,
        MUTATE_INTO_HIVE,
        FUNGAL_GROWTH,
        MORPH_TO_OVERSEER,
        STIMPACK,
        MUTATE_INTO_GREATER_SPIRE,
        MUTATE_INTO_LAIR,
        ARM_SILO_WITH_NUKE,
        PHASING_MODE,
        TRANSPORT_MODE,
        ARCHON_WARP,
        TAC_NUCLEAR_STRIKE,
        HOLD_FIRE,
        EMP_ROUND,
        SNIPER_ROUND,
        BUILD_AUTO_TURRET,
        BUILD_POINT_DEFENSE_DRONE,
        SEEKER_MISSILE,
        ASSAULT_MODE,
        FIGHTER_MODE,
        YAMATO_CANNON,
        VORTEX,
        GRAVITON_BEAM,
        MASS_RECALL,
        SPAWN_LARVA,
        ATTACK_STRUCTURE,
        CONTAMINATE,
        WEAPONS_FREE;

        public final String stringValue;

        private AbilityGroup() {
            this.stringValue = GeneralUtils.convertConstNameToNormal(this.name());
        }

        private AbilityGroup(String string2) {
            this.stringValue = string2;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum ActionType {
        SELECT("sc2.actionType.select"),
        BUILD("sc2.actionType.build"),
        TRAIN("sc2.actionType.train"),
        RESEARCH("sc2.actionType.research"),
        UPGRADE("sc2.actionType.upgrade"),
        OTHER("sc2.actionType.other"),
        INACTION("sc2.actionType.inaction");

        public final String textKey;
        public final String stringValue;

        private ActionType(String string2) {
            this.textKey = string2;
            this.stringValue = Language.getText(string2);
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum BnetLanguage {
        ENGLISH("general.language.english", "en"),
        CHINESE_TW("general.language.chineseTw", "zh"),
        FRENCH("general.language.french", "fr"),
        GERMAN("general.language.german", "de"),
        ITALIAN("general.language.italian", "it"),
        KOREAN("general.language.korean", "ko"),
        POLISH("general.language.polish", "pl"),
        PORTUGUESE_BR("general.language.portugueseBr", "pt"),
        RUSSIAN("general.language.russian", "ru"),
        SPANISH_MX("general.language.spanishMx", "es");

        public final String textKey;
        public final String stringValue;
        public final String languageCode;

        private BnetLanguage(String string2, String string3) {
            this.textKey = string2;
            this.stringValue = Language.getText(string2);
            this.languageCode = string3;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum Building {
        COMMAND_CENTER(5, 5),
        SUPPLY_DEPOT(2, 2),
        REFINERY(3, 3),
        BARRACKS(3, 3),
        ENGINEERING_BAY(3, 3),
        MISSILE_TURRET(2, 2),
        BUNKER(3, 3),
        SENSOR_TOWER(1, 1),
        GHOST_ACADEMY(3, 3),
        FACTORY(3, 3),
        STARPORT(3, 3),
        ARMORY(3, 3),
        FUSION_CORE(3, 3),
        TECH_LAB_BARRACKS(2, 2, "Tech Lab (Barracks)"),
        REACTOR_BARRACKS(2, 2, "Reactor (Barracks)"),
        TECH_LAB_FACTORY(2, 2, "Tech Lab (Factory)"),
        TECH_LAB_STARPORT(2, 2, "Tech Lab (Starport)"),
        REACTOR_FACTORY(2, 2, "Reactor (Factory)"),
        REACTOR_STARPORT(2, 2, "Reactor (Starport)"),
        ORBITAL_COMMAND(5, 5),
        PLANETARY_FORTRESS(5, 5),
        HATCHERY(5, 5),
        CREEP_TUMOR(1, 1),
        EXTRACTOR(3, 3),
        SPAWNING_POOL(3, 3),
        EVOLUTION_CHAMBER(3, 3),
        HYDRALISK_DEN(3, 3),
        SPIRE(2, 2),
        ULTRALISK_CAVERN(3, 3),
        INFESTATION_PIT(3, 3),
        NYDUS_NETWORK(3, 3),
        BANELING_NEST(3, 3),
        ROACH_WARREN(3, 3),
        SPINE_CRAWLER(2, 2),
        SPORE_CRAWLER(2, 2),
        LAIR(5, 5),
        HIVE(5, 5),
        NYDUS_WORM(3, 3),
        NEXUS(5, 5),
        PYLON(2, 2),
        ASSIMILATOR(3, 3),
        GATEWAY(3, 3),
        FORGE(3, 3),
        FLEET_BEACON(3, 3),
        TWILIGHT_COUNCIL(3, 3),
        PHOTON_CANNON(2, 2),
        STARGATE(3, 3),
        TEMPLAR_ARCHIVES(3, 3),
        DARK_SHRINE(2, 2),
        ROBOTICS_BAY(3, 3),
        ROBOTICS_FACILITY(3, 3),
        CYBERNETICS_CORE(3, 3),
        WARP_GATE(3, 3),
        OBELISK(2, 2);

        public final int width;
        public final int height;
        public final String stringValue;

        private Building(int n2, int n3) {
            this.width = n2;
            this.height = n3;
            this.stringValue = GeneralUtils.convertConstNameToNormal(this.name());
        }

        private Building(int n2, int n3, String string2) {
            this.width = n2;
            this.height = n3;
            this.stringValue = string2;
        }

        public Race raceOfBuilding() {
            if (this.compareTo(PLANETARY_FORTRESS) < 1) {
                return Race.TERRAN;
            }
            if (this.compareTo(NEXUS) > -1) {
                return Race.PROTOSS;
            }
            return Race.ZERG;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum BuildingAbility {
        CALLDOWN_MULE(AbilityGroup.CALLDOWN_MULE, "Calldown MULE"),
        SET_RALLY_POINT(AbilityGroup.SET_RALLY_POINT),
        SET_WORKER_RALLY_POINT(AbilityGroup.SET_WORKER_RALLY_POINT),
        CALLDOWN_EXTRA_SUPPLIES(AbilityGroup.CALLDOWN_EXTRA_SUPPLIES),
        CHRONO_BOOST(AbilityGroup.CHRONO_BOOST),
        SCANNER_SWEEP(AbilityGroup.SCANNER_SWEEP),
        CANCEL_AN_ADDON(AbilityGroup.CANCEL, "Cancel an Addon"),
        MUTATE_INTO_LAIR(AbilityGroup.MUTATE_INTO_LAIR, "Mutate into Lair"),
        CANCEL_LAIR_UPGRADE(AbilityGroup.CANCEL),
        MUTATE_INTO_HIVE(AbilityGroup.MUTATE_INTO_HIVE, "Mutate into Hive"),
        CANCEL_HIVE_UPGRADE(AbilityGroup.CANCEL),
        MUTATE_INTO_GREATER_SPIRE(AbilityGroup.MUTATE_INTO_GREATER_SPIRE, "Mutate into Greater Spire"),
        CANCEL_GREATER_SPIRE_UPGRADE(AbilityGroup.CANCEL),
        UPGRADE_TO_PLANETARY_FORTRESS(AbilityGroup.UPGRADE_TO_PLANETARY_FORTRESS, "Upgrade to Planetary Fortress"),
        CANCEL_PLANETARY_FORTRESS_UPGRADE(AbilityGroup.CANCEL),
        UPGRADE_TO_ORBITAL_COMMAND(AbilityGroup.UPGRADE_TO_ORBITAL_COMMAND, "Upgrade to Orbital Command"),
        CANCEL_ORBITAL_COMMAND_UPGRADE(AbilityGroup.CANCEL),
        UPGRADE_TO_WARP_GATE(AbilityGroup.UPGRADE_TO_WARP_GATE, "Upgrade to Warp Gate"),
        CANCEL_WARP_GATE_UPGRADE(AbilityGroup.CANCEL),
        MUTATE_INTO_A_GATEWAY(AbilityGroup.MUTATE_INTO_A_GATEWAY, "Mutate into a Gateway"),
        CANCEL_GATEWAY_MUTATION(AbilityGroup.CANCEL),
        LOAD(AbilityGroup.LOAD),
        UNLOAD_ALL(AbilityGroup.UNLOAD_ALL),
        UNLOAD_ALL_AT(AbilityGroup.UNLOAD_ALL),
        UNLOAD_UNIT(null),
        LOAD_ALL(null),
        LIFT_OFF(AbilityGroup.LIFT_OFF),
        LAND(AbilityGroup.LAND),
        SALVAGE(AbilityGroup.SALVAGE),
        BURROW(AbilityGroup.BURROW),
        UPROOT(AbilityGroup.UPROOT),
        ROOT(AbilityGroup.ROOT),
        BUILD_CREEP_TUMOR(AbilityGroup.SPAWN_CREEP_TUMOR),
        LOWER(AbilityGroup.LOWER, "Lower Supply Depot"),
        RAISE(AbilityGroup.RAISE, "Raiser Supply Depot"),
        ARM_SILO_WITH_NUKE(AbilityGroup.ARM_SILO_WITH_NUKE, "Arm Silo with Nuke");

        public final String stringValue;
        public final AbilityGroup abilityGroup;

        private BuildingAbility(AbilityGroup abilityGroup) {
            this.abilityGroup = abilityGroup;
            this.stringValue = GeneralUtils.convertConstNameToNormal(this.name());
        }

        private BuildingAbility(AbilityGroup abilityGroup, String string2) {
            this.abilityGroup = abilityGroup;
            this.stringValue = string2;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum Difficulty {
        VERY_EASY("yEyV", "sc2.difficulty.veryEasy"),
        EASY("ysaE", "sc2.difficulty.easy"),
        MEDIUM("ideM", "sc2.difficulty.medium"),
        HARD("draH", "sc2.difficulty.hard"),
        VERY_HARD("dHyV", "sc2.difficulty.veryHard"),
        INSANE("asnI", "sc2.difficulty.insane"),
        UNKNOWN("", "general.unknown");

        public final String binaryValue;
        public final String stringValue;

        private Difficulty(String string2, String string3) {
            this.binaryValue = string2;
            this.stringValue = Language.getText(string3);
        }

        public static Difficulty fromBinaryValue(String string) {
            Difficulty[] difficultyArray = Difficulty.values();
            int n = difficultyArray.length;
            int n2 = 0;
            while (n2 < n) {
                Difficulty difficulty = difficultyArray[n2];
                if (difficulty.binaryValue.equals(string)) {
                    return difficulty;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum Format {
        ONE_VS_ONE("1v1", "1v1", 1),
        TWO_VS_TWO("2v2", "2v2", 2),
        THREE_VS_THREE("3v3", "3v3", 3),
        FOUR_VS_FOUR("4v4", "4v4", 4),
        FREE_FOR_ALL("AFF", "FFA", 1),
        UNKNOWN("", null, 1);

        public final String binaryValue;
        public final String stringValue;
        public final int teamSize;

        private Format(String string2, String string3, int n2) {
            this.binaryValue = string2;
            this.stringValue = string3 == null ? Language.getText("general.unknown") : string3;
            this.teamSize = n2;
        }

        public static Format fromBinaryValue(String string) {
            Format[] formatArray = Format.values();
            int n = formatArray.length;
            int n2 = 0;
            while (n2 < n) {
                Format format = formatArray[n2];
                if (format.binaryValue.equals(string)) {
                    return format;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum GameSpeed {
        SLOWER("rolS", "sc2.gameSpeed.slower", 60),
        SLOW("wolS", "sc2.gameSpeed.slow", 45),
        NORMAL("mroN", "sc2.gameSpeed.normal", 36),
        FAST("tsaF", "sc2.gameSpeed.fast", 30),
        FASTER("rsaF", "sc2.gameSpeed.faster", 26),
        UNKNOWN("", "general.unknown", 36);

        public final String binaryValue;
        public final String stringValue;
        private final int relativeSpeed;

        private GameSpeed(String string2, String string3, int n2) {
            this.binaryValue = string2;
            this.stringValue = Language.getText(string3);
            this.relativeSpeed = n2;
        }

        public static GameSpeed fromBinaryValue(String string) {
            GameSpeed[] gameSpeedArray = GameSpeed.values();
            int n = gameSpeedArray.length;
            int n2 = 0;
            while (n2 < n) {
                GameSpeed gameSpeed = gameSpeedArray[n2];
                if (gameSpeed.binaryValue.equals(string)) {
                    return gameSpeed;
                }
                ++n2;
            }
            int n3 = string.charAt(0) - 48;
            if (n3 >= 0 && n3 <= 4) {
                return GameSpeed.values()[n3];
            }
            return UNKNOWN;
        }

        public int convertToRealTime(int n) {
            return this == NORMAL ? n : n * this.relativeSpeed / GameSpeed.NORMAL.relativeSpeed;
        }

        public int convertToGameTime(int n) {
            return this == NORMAL ? n : n * GameSpeed.NORMAL.relativeSpeed / this.relativeSpeed;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum GameType {
        PRIVATE("virP", "sc2.gameType.private"),
        PUBLIC("buP", "sc2.gameType.public"),
        AMM("mmA", "sc2.gameType.amm"),
        SINGLE_PLAYER("", "sc2.gameType.singlePlayer"),
        UNKNOWN("", "general.unknown");

        public final String binaryValue;
        public final String stringValue;

        private GameType(String string2, String string3) {
            this.binaryValue = string2;
            this.stringValue = Language.getText(string3);
        }

        public static GameType fromBinaryValue(String string) {
            GameType[] gameTypeArray = GameType.values();
            int n = gameTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GameType gameType = gameTypeArray[n2];
                if (gameType.binaryValue.equals(string)) {
                    return gameType;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum Gateway {
        AMERICA("US", "sc2.gateway.america", "http://usb.depot.battle.net:1119/", "http://us.battle.net/", BnetLanguage.ENGLISH, EnumSet.of(BnetLanguage.ENGLISH, BnetLanguage.SPANISH_MX, BnetLanguage.PORTUGUESE_BR)),
        ASIA("KR", "sc2.gateway.asia", "http://krb.depot.battle.net:1119/", "http://kr.battle.net/", BnetLanguage.KOREAN, EnumSet.of(BnetLanguage.KOREAN, BnetLanguage.CHINESE_TW)),
        CHINA("CN", "sc2.gateway.china", "http://cnb.depot.battle.net:1119/", "http://www.battlenet.com.cn/", BnetLanguage.CHINESE_TW, EnumSet.of(BnetLanguage.CHINESE_TW)),
        EUROPE("EU", "sc2.gateway.europe", "http://eub.depot.battle.net:1119/", "http://eu.battle.net/", BnetLanguage.ENGLISH, EnumSet.of(BnetLanguage.ENGLISH, new BnetLanguage[]{BnetLanguage.GERMAN, BnetLanguage.FRENCH, BnetLanguage.SPANISH_MX, BnetLanguage.RUSSIAN, BnetLanguage.ITALIAN, BnetLanguage.POLISH})),
        SOUTHEAST_ASIA("SG", "sc2.gateway.southeastAsia", "http://sg.depot.battle.net:1119/", "http://sea.battle.net/", BnetLanguage.ENGLISH, EnumSet.of(BnetLanguage.ENGLISH)),
        PUBLIC_TEST("XX", "sc2.gateway.publicTest", "http://xx.depot.battle.net:1119/", "http://us.battle.net/", BnetLanguage.ENGLISH, EnumSet.of(BnetLanguage.ENGLISH)),
        UNKNOWN("", "general.unknown", "", "", null, EnumSet.noneOf(BnetLanguage.class));

        public final String binaryValue;
        public final String stringValue;
        public final String depotServerUrl;
        public final String bnetUrl;
        public final BnetLanguage defaultLanguage;
        public final Set<BnetLanguage> availableLanguageSet;

        private Gateway(String string2, String string3, String string4, String string5, BnetLanguage bnetLanguage, Set<BnetLanguage> set) {
            this.binaryValue = string2;
            this.stringValue = Language.getText(string3);
            this.depotServerUrl = string4;
            this.bnetUrl = string5;
            this.defaultLanguage = bnetLanguage;
            this.availableLanguageSet = set;
        }

        public static Gateway fromBinaryValue(String string) {
            Gateway[] gatewayArray = Gateway.values();
            int n = gatewayArray.length;
            int n2 = 0;
            while (n2 < n) {
                Gateway gateway = gatewayArray[n2];
                if (gateway.binaryValue.equals(string)) {
                    return gateway;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum MatchResult {
        WIN("sc2.matchResult.win", "sc2.matchResult.win.letter"),
        LOSS("sc2.matchResult.loss", "sc2.matchResult.loss.letter"),
        UNKNOWN("general.unknown", "sc2.matchResult.unknown.letter");

        public final String stringValue;
        public final char letter;

        private MatchResult(String string2, String string3) {
            this.stringValue = Language.getText(string2);
            this.letter = Character.toUpperCase(Language.getText(string3).charAt(0));
        }

        public String toString() {
            return this.stringValue;
        }

        public static String getDescription() {
            StringBuilder stringBuilder = new StringBuilder();
            MatchResult[] matchResultArray = MatchResult.values();
            int n = matchResultArray.length;
            int n2 = 0;
            while (n2 < n) {
                MatchResult matchResult = matchResultArray[n2];
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(matchResult.letter).append(" = ").append(matchResult.stringValue);
                ++n2;
            }
            return stringBuilder.toString();
        }
    }

    public static enum PlayerColor {
        RED("10ct", "sc2.color.red", new Color(180, 20, 30)),
        BLUE("20ct", "sc2.color.blue", new Color(0, 66, 255)),
        TEAL("30ct", "sc2.color.teal", new Color(28, 167, 234)),
        PURPLE("40ct", "sc2.color.purple", new Color(84, 0, 129)),
        YELLOW("50ct", "sc2.color.yellow", new Color(235, 225, 41)),
        ORANGE("60ct", "sc2.color.orange", new Color(254, 138, 14)),
        GREEN("70ct", "sc2.color.green", new Color(22, 128, 0)),
        LIGHT_PINK("80ct", "sc2.color.lightPink", new Color(204, 166, 252)),
        VIOLET("90ct", "sc2.color.violet", new Color(31, 1, 201)),
        LIGHT_GRAY("01ct", "sc2.color.lightGray", new Color(82, 84, 148)),
        DARK_GREEN("11ct", "sc2.color.darkGreen", new Color(16, 98, 70)),
        BROWN("21ct", "sc2.color.brown", new Color(78, 42, 4)),
        LIGHT_GREEN("31ct", "sc2.color.lightGreen", new Color(150, 255, 145)),
        DARK_GRAY("41ct", "sc2.color.darkGray", new Color(35, 35, 35)),
        PINK("51ct", "sc2.color.pink", new Color(229, 91, 176)),
        UNKNOWN("", "general.unknown", null);

        public final String binaryValue;
        public final String stringValue;
        public final Color color;

        private PlayerColor(String string2, String string3, Color color) {
            this.binaryValue = string2;
            this.stringValue = Language.getText(string3);
            this.color = color;
        }

        public static PlayerColor fromBinaryValue(String string) {
            PlayerColor[] playerColorArray = PlayerColor.values();
            int n = playerColorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PlayerColor playerColor = playerColorArray[n2];
                if (playerColor.binaryValue.equals(string)) {
                    return playerColor;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum PlayerType {
        HUMAN("nmuH", "sc2.playerType.human"),
        COMPUTER("pmoC", "sc2.playerType.computer"),
        OPEN("nepO", ""),
        UNKNOWN("", "general.unknown");

        public final String binaryValue;
        public final String stringValue;

        private PlayerType(String string2, String string3) {
            this.binaryValue = string2;
            this.stringValue = Language.getText(string3);
        }

        public static PlayerType fromBinaryValue(String string) {
            PlayerType[] playerTypeArray = PlayerType.values();
            int n = playerTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PlayerType playerType = playerTypeArray[n2];
                if (playerType.binaryValue.equals(string)) {
                    return playerType;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum Race {
        PROTOSS("protoss", "torP", "sc2.race.protoss", "sc2.race.protoss.letter", true, GeneralUtils.assembleHashSet("Protoss", "\ud504\ub85c\ud1a0\uc2a4", "\u795e\u65cf", "\u041f\u0440\u043e\u0442\u043e\u0441\u0441", "Protosi", "\u661f\u7075")),
        TERRAN("terran", "rreT", "sc2.race.terran", "sc2.race.terran.letter", true, GeneralUtils.assembleHashSet("Terran", "Terraner", "Terrano", "\ud14c\ub780", "\u4eba\u985e", "\u0422\u0435\u0440\u0440\u0430\u043d", "Terrani", "\u4eba\u7c7b")),
        ZERG("zerg", "greZ", "sc2.race.zerg", "sc2.race.zerg.letter", true, GeneralUtils.assembleHashSet("Zerg", "\uc800\uadf8", "\u87f2\u65cf", "\u0417\u0435\u0440\u0433", "Zergi", "\u5f02\u866b")),
        RANDOM("random", "DNAR", "sc2.race.random", "sc2.race.random.letter", false, null),
        ANY("", "*", null, "sc2.race.any.letter", false, null),
        UNKNOWN("", "", "general.unknown", "sc2.race.unknown.letter", false, null);

        public final String bnetString;
        public final String binaryValue;
        public final String stringValue;
        public final char letter;
        public final boolean isConcrete;
        public final Set<String> localizedValueSet;

        private Race(String string2, String string3, String string4, String string5, boolean bl, Set<String> set) {
            this.bnetString = string2;
            this.binaryValue = string3;
            this.stringValue = string4 == null ? null : Language.getText(string4);
            this.letter = Character.toUpperCase(Language.getText(string5).charAt(0));
            this.isConcrete = bl;
            this.localizedValueSet = set;
        }

        public static Race fromLetter(char c) {
            Race[] raceArray = Race.values();
            int n = raceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Race race = raceArray[n2];
                if (race.letter == c) {
                    return race;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public static Race fromBinaryValue(String string) {
            Race[] raceArray = Race.values();
            int n = raceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Race race = raceArray[n2];
                if (race.binaryValue.equals(string)) {
                    return race;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public static Race fromLocalizedValue(String string) {
            if (Race.ZERG.localizedValueSet.contains(string)) {
                return ZERG;
            }
            if (Race.PROTOSS.localizedValueSet.contains(string)) {
                return PROTOSS;
            }
            if (Race.TERRAN.localizedValueSet.contains(string)) {
                return TERRAN;
            }
            if (string.startsWith("Pr")) {
                return PROTOSS;
            }
            if (string.startsWith("Te")) {
                return TERRAN;
            }
            if (string.startsWith("Ze")) {
                return ZERG;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum Region {
        NORTH_AMERICA("sc2.region.northAmerica", "us"),
        LATIN_AMERICA("sc2.region.latinAmerica", "la"),
        CHINA("sc2.region.china", "cn"),
        EUROPE("sc2.region.europe", "eu"),
        RUSSIA("sc2.region.russia", "ru"),
        KOREA("sc2.region.korea", "kr"),
        TAIWAN("sc2.region.taiwan", "tw"),
        SOUTHEAST_ASIA("sc2.region.southeastAsia", "sea"),
        UNKNOWN("general.unknown", "");

        public final String stringValue;
        public final String sc2ranksId;

        private Region(String string2, String string3) {
            this.stringValue = Language.getText(string2);
            this.sc2ranksId = string3;
        }

        public static Region getFromGatewayAndSubId(Gateway gateway, int n) {
            switch (gateway) {
                case AMERICA: {
                    return n == 2 ? LATIN_AMERICA : NORTH_AMERICA;
                }
                case CHINA: {
                    return CHINA;
                }
                case EUROPE: {
                    return n == 2 ? RUSSIA : EUROPE;
                }
                case ASIA: {
                    return n == 2 ? TAIWAN : KOREA;
                }
                case SOUTHEAST_ASIA: {
                    return SOUTHEAST_ASIA;
                }
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum Research {
        TERRAN_NITRO_PACKS,
        TERRAN_STIMPACK,
        TERRAN_COMBAT_SHIELD,
        TERRAN_CONCUSSIVE_SHELLS,
        TERRAN_SIEGE_TECH,
        TERRAN_INFERNAL_PRE_IGNITER("Terran Infernal Pre-Igniter"),
        TERRAN_CLOAKING_FIELD,
        TERRAN_CADUCEUS_REACTOR,
        TERRAN_CORVID_REACTOR,
        TERRAN_SEEKER_MISSILE,
        TERRAN_DURABLE_MATERIALS,
        TERRAN_PERSONAL_CLOAKING,
        TERRAN_MOEBIUS_REACTOR,
        TERRAN_WEAPON_REFIT,
        TERRAN_BEHEMOTH_REACTOR,
        TERRAN_250MM_STRIKE_CANNONS,
        ZERG_BURROW,
        ZERG_PNEUMATIZED_CARAPACE,
        ZERG_VENTRAL_SACKS,
        ZERG_ADRENAL_GLANDS,
        ZERG_METALIC_BOOST,
        ZERG_GROOVED_SNIPES,
        ZERG_PATHOGEN_GLANDS,
        ZERG_NEURAL_PARASITE,
        ZERG_CENTRIFUGAL_HOOKS,
        ZERG_GLIAL_RECONSTITUTION,
        ZERG_TUNNELING_CLAWS,
        ZERG_CHITINOUS_PLATING,
        PROTOSS_GRAVITIC_BOOSTER,
        PROTOSS_GRAVITIC_DRIVE,
        PROTOSS_EXTENDED_THERMAL_LANCE,
        PROTOSS_KHAYDARIN_AMULET,
        PROTOSS_PSIONIC_STORM,
        PROTOSS_WARP_GATE,
        PROTOSS_HALLUCINATION,
        PROTOSS_CHARGE,
        PROTOSS_BLINK,
        PROTOSS_FLUX_VANES,
        PROTOSS_GRAVITON_CATAPULT;

        public final String stringValue;

        private Research() {
            this.stringValue = GeneralUtils.convertConstNameToNormal(this.name());
        }

        private Research(String string2) {
            this.stringValue = string2;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum Unit {
        SCV(null, "SCV"),
        MARINE(UnitTier.TIER_1),
        REAPER(UnitTier.TIER_1_5),
        GHOST(UnitTier.TIER_2),
        MARAUDER(UnitTier.TIER_1_5),
        SIEGE_TANK(UnitTier.TIER_2_5),
        THOR(UnitTier.TIER_3),
        HELLION(UnitTier.TIER_2),
        MEDIVAC(UnitTier.TIER_2_5),
        BANSHEE(UnitTier.TIER_2_5),
        RAVEN(UnitTier.TIER_3),
        BATTLECRUISER(UnitTier.TIER_3),
        VIKING(UnitTier.TIER_2_5),
        MULE(null, "MULE"),
        NUCLEAR_MISSILE(null),
        EGG(null),
        DRONE(null),
        ZERGLING(UnitTier.TIER_1),
        OVERLORD(null),
        HYDRALISK(UnitTier.TIER_2),
        MUTALISK(UnitTier.TIER_2),
        ULTRALISK(UnitTier.TIER_3),
        ROACH(UnitTier.TIER_1_5),
        INFESTOR(UnitTier.TIER_2),
        CORRUPTOR(UnitTier.TIER_2),
        BROOD_LORD(UnitTier.TIER_3),
        BROODLING(null),
        QUEEN(null),
        BANELING(UnitTier.TIER_1_5),
        OVERSEER(UnitTier.TIER_2),
        CHANGELING(null),
        INFESTED_TERRAN(null),
        ZEALOT(UnitTier.TIER_1),
        STALKER(UnitTier.TIER_1_5),
        HIGH_TEMPLAR(UnitTier.TIER_3),
        DARK_TEMPLAR(UnitTier.TIER_3),
        SENTRY(UnitTier.TIER_1_5),
        PHOENIX(UnitTier.TIER_2),
        CARRIER(UnitTier.TIER_3),
        VOID_RAY(UnitTier.TIER_2),
        WARP_PRISM(UnitTier.TIER_2),
        OBSERVER(UnitTier.TIER_2),
        COLOSSUS(UnitTier.TIER_3),
        IMMORTAL(UnitTier.TIER_2),
        PROBE(null),
        MOTHERSHIP(UnitTier.TIER_3),
        ARCHON(null);

        public final UnitTier unitTier;
        public final String stringValue;

        private Unit(UnitTier unitTier) {
            this.unitTier = unitTier;
            this.stringValue = GeneralUtils.convertConstNameToNormal(this.name());
        }

        private Unit(UnitTier unitTier, String string2) {
            this.unitTier = unitTier;
            this.stringValue = string2;
        }

        public Race raceOfUnit() {
            if (this.compareTo(NUCLEAR_MISSILE) < 1) {
                return Race.TERRAN;
            }
            if (this.compareTo(ZEALOT) > -1) {
                return Race.PROTOSS;
            }
            return Race.ZERG;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum UnitAbility {
        CORRUPTION(AbilityGroup.CORRUPTION),
        EXPLODE(AbilityGroup.EXPLODE),
        FUNGAL_GROWTH(AbilityGroup.FUNGAL_GROWTH),
        GUARDIAN_SHIELD(AbilityGroup.GUARDIAN_SHIELD),
        REPAIR(AbilityGroup.REPAIR),
        ACTIVATE_DEACTIVATE_AUTO_REPAIR(AbilityGroup.REPAIR, "Activate/Deactivate Auto-repair"),
        FEEDBACK(AbilityGroup.FEEDBACK),
        MASS_RECALL(AbilityGroup.MASS_RECALL),
        BUILD_POINT_DEFENSE_DRONE(AbilityGroup.BUILD_POINT_DEFENSE_DRONE),
        SEEKER_MISSILE(AbilityGroup.SEEKER_MISSILE),
        GRAVITON_BEAM(AbilityGroup.GRAVITON_BEAM),
        SPAWN_CHANGELING(AbilityGroup.SPAWN_CHANGELING),
        DISGUISE(null),
        DISGUISE_AS_ZEALOT(null),
        DISGUISE_AS_MARINE_WITH_SHIELD(null),
        DISGUISE_AS_MARINE_WITHOUT_SHIELD(null),
        DISGUISE_AS_ZERGLING_WITH_WINGS(null),
        DISGUISE_AS_ZERGLING_WITHOUT_WINGS(null),
        INFESTED_TERRAN(AbilityGroup.INFESTED_TERRAN),
        NEURAL_PARASITE(AbilityGroup.NEURAL_PARASITE),
        SPAWN_LARVA(AbilityGroup.SPAWN_LARVA),
        STIMPACK(AbilityGroup.STIMPACK),
        T250MM_STRIKE_CANNONS(AbilityGroup.T250MM_STRIKE_CANNONS, "250mm Strike Cannons"),
        GATHER_RESOURCES_TERRAN(AbilityGroup.GATHER_TERRAN),
        GATHER_RESOURCES_PROTOSS(AbilityGroup.GATHER_PROTOSS),
        GATHER_RESOURCES_ZERG(AbilityGroup.GATHER_ZERG),
        RETURN_CARGO(AbilityGroup.RETURN_CARGO),
        BUILD_AUTO_TURRET(AbilityGroup.BUILD_AUTO_TURRET),
        CLOAK(AbilityGroup.CLOAK),
        DECLOAK(AbilityGroup.DECLOAK),
        SNIPER_ROUND(AbilityGroup.SNIPER_ROUND),
        HEAL(AbilityGroup.HEAL),
        ACTIVATE_DEACTIVATE_AUTO_HEAL(AbilityGroup.HEAL, "Activate/Deactivate Auto-heal"),
        SIEGE_MODE(AbilityGroup.SIEGE_MODE),
        TANK_MODE(AbilityGroup.TANK_MODE),
        LOAD(AbilityGroup.LOAD),
        UNLOAD_ALL(AbilityGroup.UNLOAD_ALL),
        UNLOAD_ALL_AT(AbilityGroup.UNLOAD_ALL),
        UNLOAD_UNIT(null),
        LOAD_ALL(null),
        YAMATO_CANNON(AbilityGroup.YAMATO_CANNON),
        ASSAULT_MODE(AbilityGroup.ASSAULT_MODE),
        FIGHTER_MODE(AbilityGroup.FIGHTER_MODE),
        PSIONIC_STORM(AbilityGroup.PSIONIC_STORM),
        TRAIN_AN_INTERCEPTOR(AbilityGroup.TRAIN_AN_INTERCEPTOR, "Train an Interceptor"),
        MORPH_TO_BROOD_LORD(AbilityGroup.MORPH_TO_BROOD_LORD, "Morph to Brood Lord", Unit.BROOD_LORD),
        CANCEL_BROOD_LORD_MORPHING(AbilityGroup.CANCEL),
        BURROW(AbilityGroup.BURROW),
        UNBURROW(AbilityGroup.UNBURROW),
        MORPH_TO_BANELING(AbilityGroup.MORPH_TO_BANELING, "Morph to Baneling", Unit.BANELING),
        CANCEL_BANELING_MORPHING(AbilityGroup.CANCEL),
        BLINK(AbilityGroup.BLINK),
        MORPH_TO_OVERSEER(AbilityGroup.MORPH_TO_OVERSEER, "Morph to Overseer", Unit.OVERSEER),
        CANCEL_OVERSEER_MORPHING(AbilityGroup.CANCEL),
        FORCE_FIELD(AbilityGroup.FORCE_FIELD),
        PHASING_MODE(AbilityGroup.PHASING_MODE),
        TRANSPORT_MODE(AbilityGroup.TRANSPORT_MODE),
        TAC_NUCLEAR_STRIKE(AbilityGroup.TAC_NUCLEAR_STRIKE),
        CANCEL_TAC_NUCLEAR_STRIKE(AbilityGroup.CANCEL),
        EMP_ROUND(AbilityGroup.EMP_ROUND, "EMP Round"),
        VORTEX(AbilityGroup.VORTEX),
        TRANSFUSION(AbilityGroup.TRANSFUSION),
        ATTACK(AbilityGroup.ATTACK),
        STOP(AbilityGroup.STOP),
        GENERATE_CREEP(AbilityGroup.GENERATE_CREEP),
        STOP_GENERATING_CREEP(AbilityGroup.STOP_GENERATING_CREEP),
        SPAWN_CREEP_TUMOR(AbilityGroup.SPAWN_CREEP_TUMOR),
        CHARGE(AbilityGroup.CHARGE),
        ATTACK_STRUCTURE(AbilityGroup.ATTACK_STRUCTURE),
        ACTIVATE_DEACTIVATE_AUTO_ATTACK_STRUCTURE(AbilityGroup.ATTACK_STRUCTURE, "Activate/Deactivate Auto-attack Structure"),
        CONTAMINATE(AbilityGroup.CONTAMINATE),
        WEAPONS_FREE(AbilityGroup.WEAPONS_FREE);

        public final String stringValue;
        public final AbilityGroup abilityGroup;
        public final Unit transformationTargetUnit;

        private UnitAbility(AbilityGroup abilityGroup) {
            this.abilityGroup = abilityGroup;
            this.stringValue = GeneralUtils.convertConstNameToNormal(this.name());
            this.transformationTargetUnit = null;
        }

        private UnitAbility(AbilityGroup abilityGroup, String string2) {
            this.abilityGroup = abilityGroup;
            this.stringValue = string2;
            this.transformationTargetUnit = null;
        }

        private UnitAbility(AbilityGroup abilityGroup, String string2, Unit unit) {
            this.abilityGroup = abilityGroup;
            this.stringValue = string2;
            this.transformationTargetUnit = unit;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum UnitTier {
        TIER_1("sc2.unitTier.tier1"),
        TIER_1_5("sc2.unitTier.tier1.5"),
        TIER_2("sc2.unitTier.tier2"),
        TIER_2_5("sc2.unitTier.tier2.5"),
        TIER_3("sc2.unitTier.tier3");

        public final String textKey;
        public final String stringValue;
        public final Color color;
        public final String htmlColor;

        private UnitTier(String string2) {
            this.textKey = string2;
            this.stringValue = Language.getText(string2);
            int[] nArray = new int[5];
            nArray[0] = 1;
            nArray[1] = 6;
            nArray[2] = 4;
            nArray[3] = 5;
            this.color = PlayerColor.values()[nArray[this.ordinal()]].color;
            this.htmlColor = GeneralUtils.toHtmlColorString(this.color);
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum Upgrade {
        TERRAN_HI_SEC_AUTO_TRACKING("Terran Hi-sec Auto Tracking"),
        TERRAN_BUILDING_ARMOR,
        TERRAN_INFANTRY_WEAPONS_1,
        TERRAN_INFANTRY_WEAPONS_2,
        TERRAN_INFANTRY_WEAPONS_3,
        TERRAN_INFANTRY_ARMOR_1,
        TERRAN_INFANTRY_ARMOR_2,
        TERRAN_INFANTRY_ARMOR_3,
        TERRAN_NEOSTEEL_FRAME,
        TERRAN_VEHICLE_PLATING_1,
        TERRAN_VEHICLE_PLATING_2,
        TERRAN_VEHICLE_PLATING_3,
        TERRAN_VEHICLE_WEAPONS_1,
        TERRAN_VEHICLE_WEAPONS_2,
        TERRAN_VEHICLE_WEAPONS_3,
        TERRAN_SHIP_PLATING_1,
        TERRAN_SHIP_PLATING_2,
        TERRAN_SHIP_PLATING_3,
        TERRAN_SHIP_WEAPONS_1,
        TERRAN_SHIP_WEAPONS_2,
        TERRAN_SHIP_WEAPONS_3,
        ZERG_MELEE_ATTACKS_1,
        ZERG_MELEE_ATTACKS_2,
        ZERG_MELEE_ATTACKS_3,
        ZERG_GROUND_CARAPACE_1,
        ZERG_GROUND_CARAPACE_2,
        ZERG_GROUND_CARAPACE_3,
        ZERG_MISSILE_ATTACKS_1,
        ZERG_MISSILE_ATTACKS_2,
        ZERG_MISSILE_ATTACKS_3,
        ZERG_FLYER_ATTACKS_1,
        ZERG_FLYER_ATTACKS_2,
        ZERG_FLYER_ATTACKS_3,
        ZERG_FLYER_CARAPACE_1,
        ZERG_FLYER_CARAPACE_2,
        ZERG_FLYER_CARAPACE_3,
        PROTOSS_GROUND_WEAPONS_1,
        PROTOSS_GROUND_WEAPONS_2,
        PROTOSS_GROUND_WEAPONS_3,
        PROTOSS_GROUND_ARMOR_1,
        PROTOSS_GROUND_ARMOR_2,
        PROTOSS_GROUND_ARMOR_3,
        PROTOSS_SHIELD_1,
        PROTOSS_SHIELD_2,
        PROTOSS_SHIELD_3,
        PROTOSS_AIR_WEAPONS_1,
        PROTOSS_AIR_WEAPONS_2,
        PROTOSS_AIR_WEAPONS_3,
        PROTOSS_AIR_ARMOR_1,
        PROTOSS_AIR_ARMOR_2,
        PROTOSS_AIR_ARMOR_3;

        public final String stringValue;

        private Upgrade() {
            this.stringValue = GeneralUtils.convertConstNameToNormal(this.name());
        }

        private Upgrade(String string2) {
            this.stringValue = string2;
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

