/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sc2replay;

import hu.belicza.andras.sc2gears.mpq.MpqParser;
import hu.belicza.andras.sc2gears.mpq.model.UserData;
import hu.belicza.andras.sc2gears.sc2map.MapParser;
import hu.belicza.andras.sc2gears.sc2replay.Parser;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayParser;
import hu.belicza.andras.sc2gears.sc2replay.ReplayParserV10;
import hu.belicza.andras.sc2gears.sc2replay.ReplayParserV11;
import hu.belicza.andras.sc2gears.sc2replay.ReplayParserV133;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.importing.ReplaySpecification;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.InitData;
import hu.belicza.andras.sc2gears.sc2replay.model.MessageEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ReplayFactory {
    public static final String VERSION = "1.3.4.1";
    public static final Set<ReplayContent> ALL_CONTENT = EnumSet.allOf(ReplayContent.class);
    public static final Set<ReplayContent> GENERAL_INFO_CONTENT = EnumSet.of(ReplayContent.INIT_DATA, ReplayContent.DETAILS, ReplayContent.ATTRIBUTES_EVENTS);
    public static final Set<ReplayContent> GENERAL_DATA_CONTENT = EnumSet.of(ReplayContent.INIT_DATA, ReplayContent.DETAILS, ReplayContent.ATTRIBUTES_EVENTS, ReplayContent.GAME_EVENTS, ReplayContent.MESSAGE_EVENTS);

    private ReplayFactory() {
    }

    public static Replay parseReplay(String string, Set<ReplayContent> set) {
        MpqParser mpqParser = null;
        try {
            ReplayParser replayParser;
            mpqParser = new MpqParser(string);
            UserData userData = mpqParser.getUserData();
            Parser parser = new Parser();
            parser.setWrapper(userData.userData, ByteOrder.BIG_ENDIAN);
            ByteBuffer byteBuffer = parser.wrapper;
            byteBuffer.getInt();
            byteBuffer.getInt();
            parser.readStringWithLength(parser.readValueStrut());
            byteBuffer.getShort();
            byteBuffer.get();
            byteBuffer.getShort();
            parser.readValueStrut();
            int[] nArray = new int[4];
            int n = 0;
            while (n < 4) {
                byteBuffer.getShort();
                nArray[n] = parser.readValueStrut();
                ++n;
            }
            if (ReplayUtils.AbilityCodesRepository.getForVersion(nArray) == null) {
                System.out.println("Unsupported replay version: " + ReplayUtils.convertBuildNumbersToString(nArray) + " (" + string + ")!");
                return null;
            }
            Replay replay = new Replay();
            replay.setBuildNumbers(nArray);
            byteBuffer.getShort();
            parser.readValueStrut();
            byteBuffer.getShort();
            parser.readValueStrut();
            byteBuffer.getShort();
            replay.setGameDuration(parser.readValueStrut() << 2);
            VersionCompatibility versionCompatibility = VersionCompatibility.fromBuildNumbers(replay.buildNumbers);
            switch (versionCompatibility) {
                case V_1_3_3: {
                    replayParser = new ReplayParserV133(replay, versionCompatibility);
                    break;
                }
                case V_1_2: 
                case V_1_1: {
                    replayParser = new ReplayParserV11(replay, versionCompatibility);
                    break;
                }
                case V_1_0: {
                    replayParser = new ReplayParserV10(replay, versionCompatibility);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled version compatibility!");
                }
            }
            if (set.contains((Object)ReplayContent.INIT_DATA)) {
                replayParser.parseInitData(mpqParser.getFile(ReplayContent.INIT_DATA.hash1, ReplayContent.INIT_DATA.hash2, ReplayContent.INIT_DATA.hash3));
            }
            if (set.contains((Object)ReplayContent.DETAILS)) {
                replayParser.parseDetails(mpqParser.getFile(ReplayContent.DETAILS.hash1, ReplayContent.DETAILS.hash2, ReplayContent.DETAILS.hash3));
            }
            if (set.contains((Object)ReplayContent.ATTRIBUTES_EVENTS)) {
                replayParser.parseAttributesEvents(mpqParser.getFile(ReplayContent.ATTRIBUTES_EVENTS.hash1, ReplayContent.ATTRIBUTES_EVENTS.hash2, ReplayContent.ATTRIBUTES_EVENTS.hash3));
            }
            if (replay.details != null) {
                Details.Player[] playerArray = replay.details.players;
                int n2 = replay.details.players.length;
                int n3 = 0;
                while (n3 < n2) {
                    Details.Player object = playerArray[n3];
                    object.finalRace = object.race.isConcrete ? object.race : ReplayConsts.Race.fromLocalizedValue(object.raceString);
                    ++n3;
                }
            }
            if (replay.initData != null) {
                replay.converterGameSpeed = Settings.getBoolean("settings.misc.useRealTimeMeasurement") ? replay.initData.gameSpeed : ReplayConsts.GameSpeed.NORMAL;
            }
            for (ReplayContent replayContent : set) {
                byte[] byArray = mpqParser.getFile(replayContent.hash1, replayContent.hash2, replayContent.hash3);
                switch (replayContent) {
                    case GAME_EVENTS: {
                        replayParser.parseGameEvents(byArray);
                        break;
                    }
                    case MESSAGE_EVENTS: {
                        replayParser.parseMessageEvents(byArray);
                        break;
                    }
                    case MAP_INFO: {
                        MapParser.parseMapInfo(replay);
                    }
                }
            }
            Replay replay2 = replay;
            return replay2;
        }
        catch (Exception exception) {
            System.out.println("Error parsing replay: " + string);
            exception.printStackTrace();
            return null;
        }
        finally {
            if (mpqParser != null) {
                mpqParser.close();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Replay constructReplay(ReplaySpecification var0) {
        block43: {
            var1_1 = new Replay();
            var1_1.setBuildNumbers(var0.version);
            var2_2 = var1_1.excludedInitialFrames = Settings.getInt("settings.misc.initialTimeToExcludeFromApm") << 6;
            var3_3 = var1_1.initData = new InitData();
            var3_3.gameSpeed = var0.gameSpeed;
            var3_3.clientNames = new String[var0.playerSpecifications.length];
            var4_4 = 0;
            while (var4_4 < var0.playerSpecifications.length) {
                var3_3.clientNames[var4_4] = var0.playerSpecifications[var4_4].name;
                ++var4_4;
            }
            var4_5 = var1_1.details = new Details();
            var4_5.players = new Details.Player[var0.playerSpecifications.length];
            var5_6 = var4_5.players;
            var6_7 = 0;
            while (var6_7 < var0.playerSpecifications.length) {
                var7_9 = var0.playerSpecifications[var6_7];
                var8_10 = new Details.Player();
                var8_10.playerId.name = var7_9.name;
                var8_10.team = var7_9.team;
                var8_10.type = ReplayConsts.PlayerType.HUMAN;
                var8_10.finalRace = var8_10.race = ReplayConsts.Race.UNKNOWN;
                var8_10.raceString = var8_10.finalRace.stringValue;
                var8_10.playerColor = ReplayConsts.PlayerColor.values()[var6_7];
                var8_10.argbColor[0] = var8_10.playerColor.color.getAlpha();
                var8_10.argbColor[1] = var8_10.playerColor.color.getRed();
                var8_10.argbColor[2] = var8_10.playerColor.color.getGreen();
                var8_10.argbColor[3] = var8_10.playerColor.color.getBlue();
                var5_6[var6_7] = var8_10;
                ++var6_7;
            }
            var4_5.originalMapName = "";
            var4_5.mapName = "";
            var4_5.saveTime = new Date().getTime();
            var1_1.converterGameSpeed = Settings.getBoolean("settings.misc.useRealTimeMeasurement") != false ? var1_1.initData.gameSpeed : ReplayConsts.GameSpeed.NORMAL;
            var6_8 = ReplayUtils.AbilityCodesRepository.getForVersion(var1_1.buildNumbers);
            var7_9 = new HashMap<K, V>();
            for (Map.Entry<Integer, Object[]> var8_10 : var6_8.COMMON_BASE_ABILITY_CODES.entrySet()) {
                var7_9.put((String)var8_10.getValue()[0], var8_10);
            }
            var8_10 = GeneralUtils.reverseMap(var6_8.UNIT_TYPE_NAME);
            var1_1.gameEvents = new GameEvents(var1_1, var6_8);
            var9_11 = var1_1.gameEvents;
            var10_12 = 0;
            var11_13 = new ArrayList<GameEvents.CustomAction>();
            var12_14 = 0;
            while (var12_14 < var0.playerSpecifications.length) {
                block44: {
                    var13_16 = var0.playerSpecifications[var12_14];
                    var14_18 = var5_6[var12_14];
                    var15_19 = new LineNumberReader(new StringReader(var13_16.buildOrderText));
                    var16_22 = 0;
                    var17_23 = 0;
                    try {
                        try lbl-1000:
                        // 3 sources

                        {
                            while (true) {
                                if ((var18_24 = var15_19.readLine()) == null) break;
                                if (var18_24.length() <= 0) continue;
                                var19_26 /* !! */  = null;
                                try {
                                    block46: {
                                        block54: {
                                            block53: {
                                                block52: {
                                                    block51: {
                                                        block50: {
                                                            block49: {
                                                                block48: {
                                                                    block47: {
                                                                        block45: {
                                                                            var20_27 = new StringTokenizer(var18_24, ",");
                                                                            if (!var20_27.hasMoreTokens()) continue;
                                                                            var17_23 = var16_22 = Integer.parseInt(var20_27.nextToken());
                                                                            var21_29 = 11;
                                                                            var22_30 = var20_27.nextToken();
                                                                            if (!var22_30.startsWith("U.")) break block45;
                                                                            var23_31 = ReplayConsts.Unit.valueOf(var22_30.substring(2));
                                                                            v0 = var9_11;
                                                                            v0.getClass();
                                                                            var19_26 /* !! */  = (GameEvents)v0.new GameEvents.TrainAction(var23_31);
                                                                            break block46;
                                                                        }
                                                                        if (!var22_30.startsWith("B.")) break block47;
                                                                        var23_32 = ReplayConsts.Building.valueOf(var22_30.substring(2));
                                                                        v1 = var9_11;
                                                                        v1.getClass();
                                                                        var19_26 /* !! */  = (GameEvents)v1.new GameEvents.BuildAction(var23_32);
                                                                        break block46;
                                                                    }
                                                                    if (!var22_30.startsWith("UA.")) break block48;
                                                                    var23_33 = ReplayConsts.UnitAbility.valueOf(var22_30.substring(3));
                                                                    var24_42 = ReplayConsts.Unit.valueOf(var20_27.nextToken().substring(2));
                                                                    v2 = var9_11;
                                                                    v2.getClass();
                                                                    var19_26 /* !! */  = (GameEvents)v2.new GameEvents.UseUnitAbilityAction(var23_33, (ReplayConsts.Unit)var24_42);
                                                                    break block46;
                                                                }
                                                                if (!var22_30.startsWith("BA.")) break block49;
                                                                var23_34 = ReplayConsts.BuildingAbility.valueOf(var22_30.substring(3));
                                                                var24_42 = ReplayConsts.Building.valueOf(var20_27.nextToken().substring(2));
                                                                v3 = var9_11;
                                                                v3.getClass();
                                                                var19_26 /* !! */  = (GameEvents)v3.new GameEvents.UseBuildingAbilityAction(var23_34, (ReplayConsts.Building)var24_42);
                                                                break block46;
                                                            }
                                                            if (!var22_30.startsWith("R.")) break block50;
                                                            var23_35 = ReplayConsts.Research.valueOf(var22_30.substring(2));
                                                            v4 = var9_11;
                                                            v4.getClass();
                                                            var19_26 /* !! */  = (GameEvents)v4.new GameEvents.ResearchAction(var23_35);
                                                            break block46;
                                                        }
                                                        if (!var22_30.startsWith("UP.")) break block51;
                                                        var23_36 = ReplayConsts.Upgrade.valueOf(var22_30.substring(3));
                                                        v5 = var9_11;
                                                        v5.getClass();
                                                        var19_26 /* !! */  = (GameEvents)v5.new GameEvents.UpgradeAction(var23_36);
                                                        break block46;
                                                    }
                                                    if (!var22_30.startsWith("HU.")) break block52;
                                                    var23_37 = ReplayConsts.Unit.valueOf(var22_30.substring(3));
                                                    v6 = var9_11;
                                                    v6.getClass();
                                                    var19_26 /* !! */  = (GameEvents)v6.new GameEvents.TrainHallucinatedAction(var23_37);
                                                    break block46;
                                                }
                                                if (!var22_30.startsWith("WU.")) break block53;
                                                var23_38 = ReplayConsts.Unit.valueOf(var22_30.substring(3));
                                                v7 = var9_11;
                                                v7.getClass();
                                                var19_26 /* !! */  = (GameEvents)v7.new GameEvents.WarpAction(var23_38);
                                                break block46;
                                            }
                                            if (!var22_30.equals("SELECT")) break block54;
                                            var23_39 = 0;
                                            var24_42 = new ArrayList<E>(4);
                                            var25_43 = new ArrayList<E>(4);
                                            var26_44 = new ArrayList<Integer>(4);
                                            if (true) ** GOTO lbl241
                                        }
                                        if (var22_30.startsWith("\"")) {
                                            var23_40 = var22_30.substring(1, var22_30.length() - 1);
                                            var24_42 = (Map.Entry)var7_9.get(var23_40);
                                            if (var24_42 != null) {
                                                v8 = var9_11;
                                                v8.getClass();
                                                var19_26 /* !! */  = (GameEvents)v8.new GameEvents.BaseUseAbilityAction((String)((Object[])var24_42.getValue())[0], (ReplayConsts.AbilityGroup)((Object[])var24_42.getValue())[1], (Boolean)((Object[])var24_42.getValue())[2]);
                                            } else if ("Right click".equals(var23_40)) {
                                                v9 = var9_11;
                                                v9.getClass();
                                                var19_26 /* !! */  = (GameEvents)v9.new GameEvents.BaseUseAbilityAction("Right click", null, Boolean.FALSE);
                                            }
                                        }
                                    }
lbl154:
                                    // 2 sources

                                    while (var19_26 /* !! */  != null) {
                                        var19_26 /* !! */ .opCode = (byte)var21_29;
                                        if (!(var19_26 /* !! */  instanceof GameEvents.BaseUseAbilityAction)) break block43;
                                        var23_41 = (GameEvents.BaseUseAbilityAction)var19_26 /* !! */ ;
                                        if (var20_27.hasMoreTokens()) {
                                            var24_42 = var20_27.nextToken();
                                            if ("TU".equals(var24_42)) {
                                                var23_41.targetIsUnit = true;
                                                var25_43 = var20_27.nextToken();
                                                var26_45 = var25_43.indexOf(91);
                                                if (var26_45 >= 0) {
                                                    var23_41.targetP1 = Integer.parseInt(var25_43.substring(var26_45 + 1, var25_43.length() - 1));
                                                    var25_43 = var25_43.substring(0, var26_45);
                                                }
                                                var23_41.targetP2 = (var27_46 = (Short)var8_10.get(var25_43)) == null ? 0 : var27_46.shortValue();
                                            }
                                            if ("TL".equals(var24_42)) {
                                                var23_41.targetIsUnit = false;
                                                var23_41.targetP1 = (int)(Float.parseFloat(var20_27.nextToken()) * 65536.0f);
                                                var23_41.targetP2 = (int)(Float.parseFloat(var20_27.nextToken()) * 65536.0f);
                                            }
                                        } else {
                                            var23_41.targetP1 = 256;
                                            var23_41.targetP2 = 256;
                                        }
                                        if ((var24_42 = var23_41.getEntityParams()) != null) {
                                            var17_23 += var24_42.time << 6;
                                        }
                                        break block43;
                                    }
                                    break block43;
                                }
                                catch (Exception var20_28) {
                                    // empty catch block
                                }
                                break block43;
                                break;
                            }
                        }
                        catch (IOException var18_25) {
                            var18_25.printStackTrace();
                            try {
                                var15_19.close();
                            }
                            catch (IOException var36_55) {}
                            break block44;
                        }
                    }
                    catch (Throwable var35_58) {
                        try {
                            var15_19.close();
                            throw var35_58;
                        }
                        catch (IOException var36_56) {
                            // empty catch block
                        }
                        throw var35_58;
                    }
                    try {
                        var15_19.close();
                    }
                    catch (IOException var36_57) {
                        // empty catch block
                    }
                }
                ++var12_14;
            }
            var9_11.actions = var11_13.toArray(new GameEvents.Action[var11_13.size()]);
            var12_15 = var9_11.actions;
            Arrays.sort(var9_11.actions, ReplayUtils.ACTION_FRAME_COMPARATOR);
            var13_17 = var12_15.length;
            var15_20 = 0;
            if (true) ** GOTO lbl283
            do {
                if ((var28_47 = (var27_46 = var20_27.nextToken()).indexOf(42)) < 0) {
                    var29_48 = 1;
                    var30_49 = var27_46;
                } else {
                    var29_48 = Byte.parseByte(var27_46.substring(0, var28_47));
                    var30_49 = var27_46.substring(var28_47 + 1);
                }
                var31_50 = var30_49.indexOf(91);
                if (var31_50 >= 0) {
                    var32_51 = new StringTokenizer(var30_49.substring(var31_50 + 1, var30_49.length() - 1), ";");
                    var30_49 = var30_49.substring(0, var31_50);
                } else {
                    var32_51 = null;
                }
                var23_39 += var29_48;
                var33_52 = (Short)var8_10.get(var30_49);
                var24_42.add(var33_52 == null ? 0 : var33_52);
                var25_43.add((byte)var29_48);
                var34_53 = 0;
                while (var34_53 < var29_48) {
                    if (var32_51 == null) {
                        var26_44.add(0);
                    } else {
                        var26_44.add(Integer.parseInt(var32_51.nextToken()));
                    }
                    ++var34_53;
                }
lbl241:
                // 2 sources

            } while (var20_27.hasMoreTokens());
            var27_46 = var9_11.new GameEvents.SelectAction();
            var19_26 /* !! */  = var27_46;
            var27_46.deselectionBitsCount = -1;
            var27_46.unitTypes = GeneralUtils.toArray((List<Short>)var24_42);
            var27_46.unitsOfTypeCounts = GeneralUtils.toArray((List<Byte>)var25_43);
            var27_46.unitIds = GeneralUtils.toArray(var26_44);
            var21_29 = -84;
            ** GOTO lbl154
        }
        if (var19_26 /* !! */  == null) {
            v10 = var9_11;
            v10.getClass();
            var19_26 /* !! */  = (GameEvents)v10.new GameEvents.CustomAction("<Parse error in line: " + var15_19.getLineNumber() + ">");
            var19_26 /* !! */ .opCode = 0;
        }
        var19_26 /* !! */ .player = (byte)var12_14;
        var19_26 /* !! */ .frame = var16_22;
        if (var19_26 /* !! */ .type != ReplayConsts.ActionType.INACTION) {
            var14_18.lastActionFrame = var16_22;
            ++var14_18.actionsCount;
            if (var16_22 < var2_2) {
                ++var14_18.excludedActionsCount;
            }
        }
        var11_13.add(var19_26 /* !! */ );
        if (var10_12 >= var17_23) ** GOTO lbl-1000
        var10_12 = var17_23;
        ** while (true)
        do {
            var16_22 = 0;
            while (var16_22 < var13_17) {
                var14_18 = var12_15[var16_22];
                if (var14_18.player == var15_20 && var14_18 instanceof GameEvents.TrainAction) {
                    var5_6[var15_20].finalRace = var5_6[var15_20].race = ((GameEvents.TrainAction)var14_18).unit.raceOfUnit();
                    var5_6[var15_20].raceString = var5_6[var15_20].finalRace.stringValue;
                    break;
                }
                ++var16_22;
            }
            ++var15_20;
lbl283:
            // 2 sources

        } while (var15_20 < var5_6.length);
        var1_1.setGameDuration(var10_12 + 640);
        var15_21 = var1_1.messageEvents = new MessageEvents();
        var15_21.messages = new MessageEvents.Message[0];
        return var1_1;
    }

    public static enum ReplayContent {
        INIT_DATA("replay.initData", -750801643, 1518242780, -14336164),
        DETAILS("replay.details", 620083690, -746339684, -281006446),
        ATTRIBUTES_EVENTS("replay.attributes.events", 1306016990, 497594575, -1563492568),
        GAME_EVENTS("replay.game.events", 496563520, -1430084277, -193582187),
        MESSAGE_EVENTS("replay.message.events", 1089231967, 831857289, 1784674979),
        MAP_INFO("MapInfo", 456326858, 2000504491, 1514959542),
        MAP_OBJECTS("Objects", 602486196, -842158972, 1775018687),
        MINIMAP_TGA("Minimap.tga", -1658863222, -1379586317, 1671265210);

        public final String fileName;
        public final int hash1;
        public final int hash2;
        public final int hash3;

        private ReplayContent(String string2, int n2, int n3, int n4) {
            this.fileName = string2;
            this.hash1 = n2;
            this.hash2 = n3;
            this.hash3 = n4;
        }
    }

    public static final class VersionCompatibility
    extends Enum<VersionCompatibility> {
        public static final /* enum */ VersionCompatibility V_1_3_3 = new VersionCompatibility(new int[]{1, 3, 3}, new int[0]);
        public static final /* enum */ VersionCompatibility V_1_2 = new VersionCompatibility(new int[]{1, 2}, new int[]{1, 3, 2});
        public static final /* enum */ VersionCompatibility V_1_1 = new VersionCompatibility(new int[]{1, 1}, new int[]{1, 1});
        public static final /* enum */ VersionCompatibility V_1_0;
        public final int[] minVersion;
        public final int[] maxVersion;
        private static final /* synthetic */ VersionCompatibility[] ENUM$VALUES;

        static {
            int[] nArray = new int[2];
            nArray[1] = 19;
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            V_1_0 = new VersionCompatibility(nArray, nArray2);
            ENUM$VALUES = new VersionCompatibility[]{V_1_3_3, V_1_2, V_1_1, V_1_0};
        }

        private VersionCompatibility(int[] nArray, int[] nArray2) {
            this.minVersion = nArray;
            this.maxVersion = nArray2;
        }

        public static VersionCompatibility fromBuildNumbers(int[] nArray) {
            VersionCompatibility[] versionCompatibilityArray = VersionCompatibility.values();
            int n = versionCompatibilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                VersionCompatibility versionCompatibility = versionCompatibilityArray[n2];
                if (ReplayUtils.compareVersions(nArray, versionCompatibility.minVersion) >= 0 && (versionCompatibility.maxVersion.length == 0 || ReplayUtils.compareVersions(nArray, versionCompatibility.maxVersion) <= 0)) {
                    return versionCompatibility;
                }
                ++n2;
            }
            return null;
        }

        public static VersionCompatibility[] values() {
            VersionCompatibility[] versionCompatibilityArray = ENUM$VALUES;
            int n = versionCompatibilityArray.length;
            VersionCompatibility[] versionCompatibilityArray2 = new VersionCompatibility[n];
            System.arraycopy(ENUM$VALUES, 0, versionCompatibilityArray2, 0, n);
            return versionCompatibilityArray2;
        }

        public static VersionCompatibility valueOf(String string) {
            return Enum.valueOf(VersionCompatibility.class, string);
        }
    }
}

