/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sc2replay;

import hu.belicza.andras.sc2gears.sc2replay.AbilityCodes;
import hu.belicza.andras.sc2gears.sc2replay.BitBufferView;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayFactory;
import hu.belicza.andras.sc2gears.sc2replay.ReplayParser;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;

class ReplayParserV11
extends ReplayParser {
    public ReplayParserV11(Replay replay, ReplayFactory.VersionCompatibility versionCompatibility) {
        super(replay, versionCompatibility);
    }

    @Override
    protected GameEvents.HotkeyAction readHotkeyAction() {
        GameEvents.HotkeyAction hotkeyAction = this.replay.gameEvents.new GameEvents.HotkeyAction();
        int n = this.wrapper.get() & 0xFF;
        hotkeyAction.flag = (byte)(n & 3);
        if (hotkeyAction.flag == 2) {
            hotkeyAction.type = ReplayConsts.ActionType.SELECT;
        }
        if (n < 16 && (n & 8) == 8) {
            this.wrapper.position((this.wrapper.get() & 0xF) + this.wrapper.position());
        } else if (n > 4) {
            if (n < 8) {
                int n2 = this.wrapper.get() & 0xFF;
                if ((n2 & 7) > 4) {
                    this.wrapper.get();
                }
                if ((n2 & 8) != 0) {
                    this.wrapper.get();
                }
            } else {
                int n3 = this.wrapper.get() & 0xFF;
                this.wrapper.position(this.wrapper.position() + (n >> 3) + ((n3 & 0xF) > 4 ? 1 : 0) + ((n3 & 0xF) > 12 ? 1 : 0));
            }
        }
        return hotkeyAction;
    }

    @Override
    protected void readCustomSelectAction(GameEvents.SelectAction selectAction) {
        int n;
        int n2;
        int n3;
        this.wrapper.get();
        BitBufferView bitBufferView = new BitBufferView(this.wrapper, 2);
        switch (bitBufferView.initialBits) {
            case 0: {
                break;
            }
            case 64: {
                selectAction.deselectionBitsCount = bitBufferView.get();
                selectAction.deselectionUnitBitmap = new byte[selectAction.deselectionBitsCount + 7 >> 3];
                n3 = 0;
                while (n3 < selectAction.deselectionUnitBitmap.length - 1) {
                    selectAction.deselectionUnitBitmap[n3] = (byte)bitBufferView.get();
                    ++n3;
                }
                n3 = selectAction.deselectionBitsCount & 7;
                if (n3 == 0) {
                    selectAction.deselectionUnitBitmap[selectAction.deselectionUnitBitmap.length - 1] = (byte)bitBufferView.get();
                    break;
                }
                if (n3 <= 6) {
                    selectAction.deselectionUnitBitmap[selectAction.deselectionUnitBitmap.length - 1] = (byte)((bitBufferView.get() & 0xFC) << 6 - n3);
                    this.wrapper.position(this.wrapper.position() - (n3 == 6 ? 2 : 2));
                    bitBufferView = new BitBufferView(this.wrapper, 2 + n3);
                    break;
                }
                n2 = bitBufferView.get();
                selectAction.deselectionUnitBitmap[selectAction.deselectionUnitBitmap.length - 1] = (byte)(n2 & 0xFC | (n2 & 1) << 1);
                this.wrapper.position(this.wrapper.position() - 1);
                bitBufferView = new BitBufferView(this.wrapper, 1);
                break;
            }
            case -128: 
            case -64: {
                selectAction.deselectionBitsCount = -1;
                n2 = bitBufferView.get();
                n = 0;
                while (n < n2) {
                    bitBufferView.get();
                    ++n;
                }
                break;
            }
        }
        n3 = bitBufferView.get();
        if (n3 > 0) {
            selectAction.unitTypes = new short[n3];
            selectAction.unitsOfTypeCounts = new byte[n3];
            n2 = 0;
            while (n2 < n3) {
                selectAction.unitTypes[n2] = bitBufferView.get2Bytes();
                bitBufferView.get();
                selectAction.unitsOfTypeCounts[n2] = (byte)bitBufferView.get();
                ++n2;
            }
        }
        if ((n2 = bitBufferView.get()) > 0) {
            selectAction.unitIds = new int[n2];
            n = 0;
            while (n < n2) {
                selectAction.unitIds[n] = bitBufferView.getInt();
                selectAction.unitIds[n] = (selectAction.unitIds[n] & 0xFF00) >> 8 | (selectAction.unitIds[n] & 0xFF) << 8 | (selectAction.unitIds[n] & 0xFF000000) >>> 8 | (selectAction.unitIds[n] & 0xFF0000) << 8;
                ++n;
            }
        }
    }

    @Override
    protected GameEvents.BaseUseAbilityAction readUseAbilityAction(AbilityCodes abilityCodes) {
        GameEvents.BaseUseAbilityAction baseUseAbilityAction;
        int n = this.wrapper.get() & 0xFF;
        int n2 = this.wrapper.get() & 0xFF;
        int n3 = this.wrapper.get() & 0xFF;
        int n4 = ((this.wrapper.get() & 0xFF) << 16) + ((this.wrapper.get() & 0xFF) << 8) + (n3 & 0x3F);
        ReplayConsts.Unit unit = null;
        ReplayConsts.Building building = null;
        ReplayConsts.Upgrade upgrade = null;
        ReplayConsts.Research research = null;
        GameEvents gameEvents = this.replay.gameEvents;
        Object[] objectArray = abilityCodes.COMMON_BASE_ABILITY_CODES.get(n4);
        if (objectArray != null) {
            GameEvents gameEvents2 = gameEvents;
            gameEvents2.getClass();
            baseUseAbilityAction = gameEvents2.new GameEvents.BaseUseAbilityAction((String)objectArray[0], (ReplayConsts.AbilityGroup)((Object)objectArray[1]), (Boolean)objectArray[2]);
        } else {
            unit = abilityCodes.TRAIN_ABILITY_CODES.get(n4);
            if (unit != null) {
                GameEvents gameEvents3 = gameEvents;
                gameEvents3.getClass();
                baseUseAbilityAction = gameEvents3.new GameEvents.TrainAction(unit);
            } else {
                building = abilityCodes.BUILD_ABILITY_CODES.get(n4);
                if (building != null) {
                    GameEvents gameEvents4 = gameEvents;
                    gameEvents4.getClass();
                    baseUseAbilityAction = gameEvents4.new GameEvents.BuildAction(building);
                } else {
                    objectArray = abilityCodes.USE_UNIT_ABILITY.get(n4);
                    if (objectArray != null) {
                        GameEvents gameEvents5 = gameEvents;
                        gameEvents5.getClass();
                        baseUseAbilityAction = gameEvents5.new GameEvents.UseUnitAbilityAction((ReplayConsts.UnitAbility)((Object)objectArray[0]), (ReplayConsts.Unit)((Object)objectArray[1]));
                    } else {
                        objectArray = abilityCodes.USE_BUILDING_ABILITY.get(n4);
                        if (objectArray != null) {
                            GameEvents gameEvents6 = gameEvents;
                            gameEvents6.getClass();
                            baseUseAbilityAction = gameEvents6.new GameEvents.UseBuildingAbilityAction((ReplayConsts.BuildingAbility)((Object)objectArray[0]), (ReplayConsts.Building)((Object)objectArray[1]));
                        } else {
                            unit = abilityCodes.WARP_ABILITY_CODES.get(n4);
                            if (unit != null) {
                                GameEvents gameEvents7 = gameEvents;
                                gameEvents7.getClass();
                                baseUseAbilityAction = gameEvents7.new GameEvents.WarpAction(unit);
                            } else {
                                unit = abilityCodes.TRAIN_HALLU_ABILITY_CODES.get(n4);
                                if (unit != null) {
                                    GameEvents gameEvents8 = gameEvents;
                                    gameEvents8.getClass();
                                    baseUseAbilityAction = gameEvents8.new GameEvents.TrainHallucinatedAction(unit);
                                } else {
                                    upgrade = abilityCodes.UPGRADE_ABILITY_CODES.get(n4);
                                    if (upgrade != null) {
                                        GameEvents gameEvents9 = gameEvents;
                                        gameEvents9.getClass();
                                        baseUseAbilityAction = gameEvents9.new GameEvents.UpgradeAction(upgrade);
                                    } else {
                                        research = abilityCodes.RESEARCH_ABILITY_CODES.get(n4);
                                        if (research != null) {
                                            GameEvents gameEvents10 = gameEvents;
                                            gameEvents10.getClass();
                                            baseUseAbilityAction = gameEvents10.new GameEvents.ResearchAction(research);
                                        } else if (n2 == 32 || n2 == 34) {
                                            baseUseAbilityAction = gameEvents.new GameEvents.BaseUseAbilityAction();
                                        } else {
                                            GameEvents gameEvents11 = gameEvents;
                                            gameEvents11.getClass();
                                            baseUseAbilityAction = gameEvents11.new GameEvents.BaseUseAbilityAction("Right click", null, Boolean.FALSE);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        baseUseAbilityAction.abilityCode = n4;
        baseUseAbilityAction.targetP1 = 256;
        baseUseAbilityAction.targetP2 = 256;
        if (n == 25 || n == 41) {
            this.wrapper.getInt();
        } else if (n2 == 32 || n2 == 34) {
            if ((n3 & 0x3F) > 7) {
                boolean bl = baseUseAbilityAction.targetIsUnit = (n3 & 0x20) != 0;
                if (baseUseAbilityAction.targetIsUnit) {
                    this.wrapper.getShort();
                    baseUseAbilityAction.targetP1 = this.wrapper.getInt();
                    baseUseAbilityAction.targetP1 = (baseUseAbilityAction.targetP1 & 0xFF000000) >> 8 | (baseUseAbilityAction.targetP1 & 0xFF0000) << 8 | (baseUseAbilityAction.targetP1 & 0xF00) << 4 | (baseUseAbilityAction.targetP1 & 0xF000) >> 10 | (baseUseAbilityAction.targetP1 & 0x3F) << 6 | (baseUseAbilityAction.targetP1 & 0xC0) >> 6;
                    baseUseAbilityAction.targetP2 = (this.wrapper.get() - 1) * 64 + (this.wrapper.get() & 0xFF);
                    this.wrapper.position(this.wrapper.position() + 10);
                } else {
                    baseUseAbilityAction.targetP1 = (n3 & 0xC0) << 16 | (this.wrapper.get() & 0xFF) << 14 | (this.wrapper.get() & 0xFF) << 6;
                    baseUseAbilityAction.targetP2 = (this.wrapper.get() & 0xFF) << 16 | (this.wrapper.get() & 0xFF) << 10 | (this.wrapper.get() & 0xFF) << 2;
                    this.wrapper.getInt();
                }
            }
        } else if (n2 == 72 || n2 == 74) {
            baseUseAbilityAction.targetP1 = n4 & 0xFFFF00;
            baseUseAbilityAction.targetP2 = n3 << 16 | (this.wrapper.get() & 0xFF) << 9;
            this.wrapper.position(this.wrapper.position() + 6);
        } else if (n2 == 136 || n2 == 138) {
            baseUseAbilityAction.targetIsUnit = true;
            this.wrapper.position(this.wrapper.position() - 2);
            baseUseAbilityAction.targetP1 = this.wrapper.getInt();
            baseUseAbilityAction.targetP1 = baseUseAbilityAction.targetP1 & 0xFF00FF00 | (baseUseAbilityAction.targetP1 & 0xFF0000) >> 16 | (baseUseAbilityAction.targetP1 & 0xFF) << 16;
            this.wrapper.get();
            baseUseAbilityAction.targetP2 = ((this.wrapper.get() & 0xFF) << 8) + (this.wrapper.get() & 0xFF);
            this.wrapper.position(this.wrapper.position() + 10);
        }
        return baseUseAbilityAction;
    }
}

