/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sc2replay;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.AbilityCodes;
import hu.belicza.andras.sc2gears.sc2replay.EntityParams;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.GameEvents;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public class ReplayUtils {
    public static final char[] DECIMAL_TABLE = new char[256];
    public static final Comparator<GameEvents.Action> ACTION_FRAME_COMPARATOR;
    public static final Comparator<ReplayConsts.Unit> UNIT_TIER_REVERSE_COMPARATOR;
    public static final AbilityCodes CURRENT_ABILITY_CODES;

    static {
        int n = 0;
        while (n < 256) {
            ReplayUtils.DECIMAL_TABLE[n] = (char)(48 + (n * 10 >> 8));
            ++n;
        }
        ACTION_FRAME_COMPARATOR = new Comparator<GameEvents.Action>(){

            @Override
            public int compare(GameEvents.Action action, GameEvents.Action action2) {
                return action.frame - action2.frame;
            }
        };
        UNIT_TIER_REVERSE_COMPARATOR = new Comparator<ReplayConsts.Unit>(){

            @Override
            public int compare(ReplayConsts.Unit unit, ReplayConsts.Unit unit2) {
                if (unit.unitTier == null ^ unit2.unitTier == null) {
                    return unit.unitTier == null ? -1 : 1;
                }
                if (unit.unitTier == null && unit2.unitTier == null) {
                    return unit2.compareTo(unit);
                }
                int n = unit2.unitTier.compareTo(unit.unitTier);
                return n == 0 ? unit2.compareTo(unit) : n;
            }
        };
        CURRENT_ABILITY_CODES = AbilityCodesRepository.getCurrentAbilityCodes();
    }

    public static int calculatePlayerApm(Replay replay, Details.Player player) {
        return ReplayUtils.calculateApm(player.actionsCount - player.excludedActionsCount, replay.converterGameSpeed.convertToRealTime(player.lastActionFrame - replay.excludedInitialFrames));
    }

    public static int calculateApm(int n, int n2) {
        if (n2 <= 0) {
            return 0;
        }
        return (int)((long)n * 3840L / (long)n2);
    }

    public static String formatFrames(int n, ReplayConsts.GameSpeed gameSpeed) {
        return ReplayUtils.formatMs(n * 125 >> 3, gameSpeed);
    }

    public static String formatMs(int n, ReplayConsts.GameSpeed gameSpeed) {
        n = gameSpeed.convertToRealTime(n);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(0, 0, 0, 0, 0, 0);
        ((Calendar)gregorianCalendar).add(14, n);
        return Language.formatTime(gregorianCalendar.getTime());
    }

    public static String formatFramesShort(int n, ReplayConsts.GameSpeed gameSpeed) {
        n = gameSpeed.convertToRealTime(n);
        int n2 = n >> 6;
        int n3 = 0;
        int n4 = 0;
        if (n2 >= 3600) {
            n3 = n2 / 3600;
            n2 %= 3600;
        }
        if (n2 >= 60) {
            n4 = n2 / 60;
            n2 %= 60;
        }
        return n3 > 0 ? String.valueOf(n3) + (n4 < 10 ? ":0" : ":") + n4 + (n2 < 10 ? ":0" : ":") + n2 : String.valueOf(n4) + (n2 < 10 ? ":0" : ":") + n2;
    }

    public static String formatFramesDecimal(int n, ReplayConsts.GameSpeed gameSpeed) {
        n = gameSpeed.convertToRealTime(n);
        return String.valueOf(n >> 6) + "." + DECIMAL_TABLE[(n & 0x3F) << 2];
    }

    public static String formatCoordinate(int n) {
        return String.valueOf(n >> 16) + "." + DECIMAL_TABLE[n >> 8 & 0xFF];
    }

    public static ImageIcon parseTgaImage(byte[] byArray) {
        int n = byArray[12] & 0xFF | (byArray[13] & 0xFF) << 8;
        int n2 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        int n3 = 18;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MIN_VALUE;
        int n7 = Integer.MIN_VALUE;
        int n8 = 0;
        while (n8 < n2) {
            int n9 = 0;
            while (n9 < n) {
                int n10 = (byArray[n3 + 2] & 0xFF) << 16 | (byArray[n3 + 1] & 0xFF) << 8 | byArray[n3] & 0xFF;
                if (n10 != 0) {
                    bufferedImage.setRGB(n9, n8, n10);
                    if (n9 < n4) {
                        n4 = n9;
                    }
                    if (n9 > n6) {
                        n6 = n9;
                    }
                    if (n8 < n5) {
                        n5 = n8;
                    }
                    if (n8 > n7) {
                        n7 = n8;
                    }
                }
                n3 += 3;
                ++n9;
            }
            ++n8;
        }
        return new ImageIcon(bufferedImage.getSubimage(n4, n5, n6 - n4 + 1, n7 - n5 + 1));
    }

    public static String convertBuildNumbersToString(int[] nArray) {
        return String.valueOf(nArray[0]) + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] parseVersion(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            ArrayList<Integer> arrayList = new ArrayList<Integer>(4);
            while (stringTokenizer.hasMoreTokens()) {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                if (n < 0) {
                    return null;
                }
                arrayList.add(n);
            }
            int[] nArray = new int[arrayList.size()];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = (Integer)arrayList.get(n);
                ++n;
            }
            return nArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int compareVersions(int[] nArray, int[] nArray2) {
        int n = 0;
        while (n < nArray.length && n < nArray2.length) {
            if (nArray[n] != nArray2[n]) {
                return nArray[n] - nArray2[n];
            }
            ++n;
        }
        return 0;
    }

    private static AbilityCodes loadAbilityCodes(String string) {
        AbilityCodes abilityCodes = new AbilityCodes();
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new InputStreamReader(ReplayUtils.class.getResourceAsStream(string)));
            while ((string2 = bufferedReader.readLine()) != null) {
                EntityParams entityParams;
                Object object;
                Number number;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                String string3 = stringTokenizer.nextToken();
                if (string3.length() == 4) {
                    number = Short.valueOf(string3, 16);
                    abilityCodes.UNIT_TYPE_NAME.put((Short)number, stringTokenizer.nextToken());
                    if (!"A".equals(stringTokenizer.nextToken())) continue;
                    abilityCodes.MACRO_UNIT_TYPE_SET.add((Short)number);
                    continue;
                }
                number = Integer.valueOf(string3, 16);
                String string4 = stringTokenizer.nextToken();
                if (string4.charAt(0) == '\"') {
                    object = stringTokenizer.nextToken();
                    String string5 = stringTokenizer.nextToken();
                    abilityCodes.COMMON_BASE_ABILITY_CODES.put((Integer)number, new Object[]{string4.substring(1, string4.length() - 1), "null".equals(object) ? null : ReplayConsts.AbilityGroup.valueOf(object.substring(object.indexOf(46) + 1)), "A".equals(string5)});
                    entityParams = ReplayUtils.readEntityParams(stringTokenizer);
                    if (entityParams == null) continue;
                    abilityCodes.COMMON_ABILITY_PARAMS.put((Integer)number, entityParams);
                    continue;
                }
                if (string4.startsWith("U.")) {
                    object = ReplayConsts.Unit.valueOf(string4.substring(2));
                    abilityCodes.TRAIN_ABILITY_CODES.put((Integer)number, (ReplayConsts.Unit)((Object)object));
                    entityParams = ReplayUtils.readEntityParams(stringTokenizer);
                    if (entityParams == null) continue;
                    abilityCodes.UNIT_PARAMS.put((ReplayConsts.Unit)((Object)object), entityParams);
                    continue;
                }
                if (string4.startsWith("B.")) {
                    object = ReplayConsts.Building.valueOf(string4.substring(2));
                    abilityCodes.BUILD_ABILITY_CODES.put((Integer)number, (ReplayConsts.Building)((Object)object));
                    entityParams = ReplayUtils.readEntityParams(stringTokenizer);
                    if (entityParams == null) continue;
                    abilityCodes.BUILDING_PARAMS.put((ReplayConsts.Building)((Object)object), entityParams);
                    continue;
                }
                if (string4.startsWith("UA.")) {
                    object = ReplayConsts.UnitAbility.valueOf(string4.substring(3));
                    abilityCodes.USE_UNIT_ABILITY.put((Integer)number, new Object[]{object, ReplayConsts.Unit.valueOf(stringTokenizer.nextToken().substring(2))});
                    entityParams = ReplayUtils.readEntityParams(stringTokenizer);
                    if (entityParams == null) continue;
                    abilityCodes.UNIT_ABILITY_PARAMS.put((ReplayConsts.UnitAbility)((Object)object), entityParams);
                    continue;
                }
                if (string4.startsWith("BA.")) {
                    object = ReplayConsts.BuildingAbility.valueOf(string4.substring(3));
                    abilityCodes.USE_BUILDING_ABILITY.put((Integer)number, new Object[]{object, ReplayConsts.Building.valueOf(stringTokenizer.nextToken().substring(2))});
                    entityParams = ReplayUtils.readEntityParams(stringTokenizer);
                    if (entityParams == null) continue;
                    abilityCodes.BUILDING_ABILITY_PARAMS.put((ReplayConsts.BuildingAbility)((Object)object), entityParams);
                    continue;
                }
                if (string4.startsWith("R.")) {
                    object = ReplayConsts.Research.valueOf(string4.substring(2));
                    abilityCodes.RESEARCH_ABILITY_CODES.put((Integer)number, (ReplayConsts.Research)((Object)object));
                    entityParams = ReplayUtils.readEntityParams(stringTokenizer);
                    if (entityParams == null) continue;
                    abilityCodes.RESEARCH_PARAMS.put((ReplayConsts.Research)((Object)object), entityParams);
                    continue;
                }
                if (string4.startsWith("UP.")) {
                    object = ReplayConsts.Upgrade.valueOf(string4.substring(3));
                    abilityCodes.UPGRADE_ABILITY_CODES.put((Integer)number, (ReplayConsts.Upgrade)((Object)object));
                    entityParams = ReplayUtils.readEntityParams(stringTokenizer);
                    if (entityParams == null) continue;
                    abilityCodes.UPGRADE_PARAMS.put((ReplayConsts.Upgrade)((Object)object), entityParams);
                    continue;
                }
                if (string4.startsWith("HU.")) {
                    object = ReplayConsts.Unit.valueOf(string4.substring(3));
                    abilityCodes.TRAIN_HALLU_ABILITY_CODES.put((Integer)number, (ReplayConsts.Unit)((Object)object));
                    continue;
                }
                if (!string4.startsWith("WU.")) continue;
                object = ReplayConsts.Unit.valueOf(string4.substring(3));
                abilityCodes.WARP_ABILITY_CODES.put((Integer)number, (ReplayConsts.Unit)((Object)object));
                entityParams = ReplayUtils.readEntityParams(stringTokenizer);
                if (entityParams == null) continue;
                abilityCodes.WARPED_UNIT_PARAMS.put((ReplayConsts.Unit)((Object)object), entityParams);
            }
            AbilityCodes abilityCodes2 = abilityCodes;
            return abilityCodes2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Internal error: failed to load ability codes!");
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static EntityParams readEntityParams(StringTokenizer stringTokenizer) {
        if (stringTokenizer.hasMoreTokens()) {
            EntityParams entityParams = new EntityParams();
            entityParams.minerals = Integer.parseInt(stringTokenizer.nextToken());
            entityParams.gas = Integer.parseInt(stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                entityParams.time = Integer.parseInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    entityParams.supply = Integer.parseInt(stringTokenizer.nextToken());
                }
            }
            return entityParams;
        }
        return null;
    }

    public static void applyFavoredPlayerListSetting(Details details) {
        List<String> list = GeneralUtils.getFavoredPlayerList();
        details.rearrangePlayers(list);
    }

    public static enum AbilityCodesRepository {
        V_1_3_3("ability_codes_1.3.3-"),
        V_1_3__1_3_2("ability_codes_1.3-1.3.2"),
        V_1_2__1_2("ability_codes_1.2-1.2"),
        V_1_1__1_1("ability_codes_1.1-1.1"),
        V_0_19__1_0("ability_codes_0.19-1.0");

        public final String fileName;
        public final int[] minVersion;
        public final int[] maxVersion;
        private AbilityCodes abilityCodes;

        private AbilityCodesRepository(String string2) {
            this.fileName = string2;
            String string3 = string2.substring(string2.lastIndexOf(95) + 1, string2.indexOf(45));
            String string4 = string2.substring(string2.indexOf(45) + 1);
            this.minVersion = ReplayUtils.parseVersion(string3);
            this.maxVersion = ReplayUtils.parseVersion(string4);
        }

        public AbilityCodes getAbilityCodes() {
            if (this.abilityCodes == null) {
                this.abilityCodes = ReplayUtils.loadAbilityCodes(this.fileName);
            }
            return this.abilityCodes;
        }

        public static AbilityCodes getForVersion(int[] nArray) {
            AbilityCodesRepository[] abilityCodesRepositoryArray = AbilityCodesRepository.values();
            int n = abilityCodesRepositoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbilityCodesRepository abilityCodesRepository = abilityCodesRepositoryArray[n2];
                if (ReplayUtils.compareVersions(nArray, abilityCodesRepository.minVersion) >= 0 && (abilityCodesRepository.maxVersion.length == 0 || ReplayUtils.compareVersions(nArray, abilityCodesRepository.maxVersion) <= 0)) {
                    return abilityCodesRepository.getAbilityCodes();
                }
                ++n2;
            }
            return null;
        }

        public static AbilityCodes getCurrentAbilityCodes() {
            return AbilityCodesRepository.values()[0].getAbilityCodes();
        }
    }
}

