/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sc2replay.model;

import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import java.awt.Color;
import java.awt.Point;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class Details {
    public Player[] players;
    public String mapName;
    public String originalMapName;
    public String mapPreviewFileName;
    public long saveTime;
    public float saveTimeZone;
    private int[] teamOrderPlayerIndices;

    public String getPlayerNames() {
        int[] nArray = this.getTeamOrderPlayerIndices();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.players[nArray[n]].playerId.name);
            ++n;
        }
        return stringBuilder.toString();
    }

    public String getPlayerNamesGrouped() {
        int[] nArray = this.getTeamOrderPlayerIndices();
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.players[nArray[0]].team;
        boolean bl = true;
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            Player player = this.players[n4];
            if (player.team != n) {
                stringBuilder.append(" vs ");
                n = player.team;
                bl = true;
            }
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(player.playerId.name);
            ++n3;
        }
        return stringBuilder.toString();
    }

    public String getRaceMatchup() {
        int[] nArray = this.getTeamOrderPlayerIndices();
        StringBuilder stringBuilder = new StringBuilder();
        int n = nArray.length == 0 ? -1 : this.players[nArray[0]].team;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = this.players[nArray[n2]].team;
            if (n3 != n) {
                stringBuilder.append('v');
                n = n3;
            }
            stringBuilder.append(this.players[nArray[n2]].raceLetter());
            ++n2;
        }
        return stringBuilder.toString();
    }

    public int[] getTeamOrderPlayerIndices() {
        return this.getTeamOrderPlayerIndices(new Comparator<int[]>(){

            @Override
            public int compare(int[] nArray, int[] nArray2) {
                return nArray[0] - nArray2[0];
            }
        });
    }

    public int[] getTeamOrderPlayerIndices(Comparator<int[]> comparator) {
        if (this.teamOrderPlayerIndices == null) {
            int[][] nArrayArray = new int[this.players.length][];
            int n = 0;
            while (n < nArrayArray.length) {
                nArrayArray[n] = new int[]{this.players[n].team, n};
                ++n;
            }
            Arrays.sort(nArrayArray, comparator);
            this.teamOrderPlayerIndices = new int[this.players.length];
            n = 0;
            while (n < nArrayArray.length) {
                this.teamOrderPlayerIndices[n] = nArrayArray[n][1];
                ++n;
            }
        }
        return this.teamOrderPlayerIndices;
    }

    public void rearrangePlayers(final List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        final ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
        block0: for (String string : list) {
            Player[] playerArray = this.players;
            int n = this.players.length;
            int n2 = 0;
            while (n2 < n) {
                Player player = playerArray[n2];
                if (player.playerId.name.equals(string)) {
                    if (arrayList.contains(player.team)) continue block0;
                    arrayList.add(player.team);
                    continue block0;
                }
                ++n2;
            }
        }
        this.teamOrderPlayerIndices = null;
        this.getTeamOrderPlayerIndices(new Comparator<int[]>(){

            @Override
            public int compare(int[] nArray, int[] nArray2) {
                if (nArray[0] == nArray2[0]) {
                    int n = list.indexOf(Details.this.players[nArray[1]].playerId.name);
                    int n2 = list.indexOf(Details.this.players[nArray2[1]].playerId.name);
                    if (n < 0 && n2 >= 0) {
                        return 1;
                    }
                    if (n >= 0 && n2 < 0) {
                        return -1;
                    }
                    if (n >= 0 && n2 >= 0) {
                        return n - n2;
                    }
                    return 0;
                }
                int n = arrayList.indexOf(nArray[0]);
                int n3 = arrayList.indexOf(nArray2[0]);
                if (n < 0 && n3 >= 0) {
                    return 1;
                }
                if (n >= 0 && n3 < 0) {
                    return -1;
                }
                if (n >= 0 && n3 >= 0 && n != n3) {
                    return n - n3;
                }
                return nArray[0] - nArray2[0];
            }
        });
    }

    public void setTeamIsWinner(int n, Boolean bl) {
        Player[] playerArray = this.players;
        int n2 = this.players.length;
        int n3 = 0;
        while (n3 < n2) {
            Player player = playerArray[n3];
            if (player.team == n && player.isWinner == null) {
                player.isWinner = bl;
            }
            ++n3;
        }
    }

    public static class Player {
        public static final int TEAM_UNKNOWN = Integer.MAX_VALUE;
        public PlayerId playerId = new PlayerId();
        public String raceString;
        public final int[] argbColor = new int[4];
        public int lastActionFrame;
        public int actionsCount;
        public int excludedActionsCount;
        public ReplayConsts.PlayerType type = ReplayConsts.PlayerType.UNKNOWN;
        public ReplayConsts.Race race = ReplayConsts.Race.UNKNOWN;
        public ReplayConsts.Race finalRace;
        public int team = Integer.MAX_VALUE;
        public Point startLocation;
        public ReplayConsts.Difficulty difficulty = ReplayConsts.Difficulty.UNKNOWN;
        public ReplayConsts.PlayerColor playerColor = ReplayConsts.PlayerColor.UNKNOWN;
        public int handicap = 100;
        public Boolean isWinner;

        public String raceString() {
            if (this.race == ReplayConsts.Race.RANDOM) {
                return (Object)((Object)ReplayConsts.Race.RANDOM) + " (" + this.finalRace.stringValue + ")";
            }
            return this.finalRace.stringValue;
        }

        public char raceLetter() {
            return this.finalRace.isConcrete ? this.finalRace.letter : (this.race == ReplayConsts.Race.RANDOM ? ReplayConsts.Race.RANDOM.letter : ReplayConsts.Race.UNKNOWN.letter);
        }

        public Color getColor() {
            return new Color(this.argbColor[1], this.argbColor[2], this.argbColor[3]);
        }

        public Color getDarkerColor() {
            return new Color(this.argbColor[1] >> 1, this.argbColor[2] >> 1, this.argbColor[3] >> 1);
        }

        public Color getBrighterColor() {
            return new Color(127 + (this.argbColor[1] >> 1), 127 + (this.argbColor[2] >> 1), 127 + (this.argbColor[3] >> 1));
        }

        public String getColorName() {
            return String.valueOf(this.playerColor == ReplayConsts.PlayerColor.UNKNOWN ? "(" : String.valueOf(this.playerColor.stringValue) + " (") + this.argbColor[1] + "," + this.argbColor[2] + "," + this.argbColor[3] + ")";
        }
    }

    public static class PlayerId {
        public String name;
        public int battleNetId;
        public int battleNetSubid;
        public ReplayConsts.Gateway gateway = ReplayConsts.Gateway.UNKNOWN;

        public String getBnetProfileUrl(ReplayConsts.BnetLanguage bnetLanguage) {
            try {
                ReplayConsts.BnetLanguage bnetLanguage2 = this.gateway.availableLanguageSet.contains((Object)bnetLanguage) ? bnetLanguage : this.gateway.defaultLanguage;
                String string = this.gateway == ReplayConsts.Gateway.ASIA && bnetLanguage2 == ReplayConsts.BnetLanguage.CHINESE_TW ? "http://tw.battle.net/" : this.gateway.bnetUrl;
                return String.valueOf(string) + "sc2/" + bnetLanguage2.languageCode + "/profile/" + this.battleNetId + "/" + this.battleNetSubid + "/" + URLEncoder.encode(this.name, "UTF-8") + "/";
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                return "";
            }
        }

        public String getSc2ranksProfileUrl() {
            try {
                return "http://sc2ranks.com/" + this.getRegion().sc2ranksId + "/" + this.battleNetId + "/" + URLEncoder.encode(this.name, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                return "";
            }
        }

        public ReplayConsts.Region getRegion() {
            return ReplayConsts.Region.getFromGatewayAndSubId(this.gateway, this.battleNetSubid);
        }

        public String toString() {
            return this.getFullName();
        }

        public String getFullName() {
            return String.valueOf(this.name) + "/" + this.gateway.binaryValue + "/" + this.battleNetSubid + "/" + this.battleNetId;
        }

        public static PlayerId parse(String string) {
            String[] stringArray = string.split("/");
            if (stringArray.length < 4) {
                return null;
            }
            PlayerId playerId = new PlayerId();
            playerId.name = stringArray[0];
            playerId.gateway = ReplayConsts.Gateway.fromBinaryValue(stringArray[1]);
            try {
                playerId.battleNetSubid = Integer.parseInt(stringArray[2]);
                playerId.battleNetId = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return playerId;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof PlayerId)) {
                return false;
            }
            PlayerId playerId = (PlayerId)object;
            return this.battleNetId == playerId.battleNetId && this.battleNetSubid == playerId.battleNetSubid && this.gateway == playerId.gateway && this.name.equals(playerId.name);
        }

        public int hashCode() {
            return (String.valueOf(this.battleNetId) + "-" + this.battleNetSubid + "-" + this.gateway.ordinal() + "-" + this.name).hashCode();
        }
    }
}

