/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.sc2replay.model;

import hu.belicza.andras.sc2gears.sc2replay.AbilityCodes;
import hu.belicza.andras.sc2gears.sc2replay.EntityParams;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.sc2replay.ReplayUtils;
import hu.belicza.andras.sc2gears.sc2replay.model.Details;
import hu.belicza.andras.sc2gears.sc2replay.model.Replay;

public class GameEvents {
    public String[] playerNames;
    public boolean displayInSeconds;
    public Action[] actions;
    public final AbilityCodes abilityCodes;
    private final Replay replay;

    public GameEvents(Replay replay, AbilityCodes abilityCodes) {
        this.replay = replay;
        Details.Player[] playerArray = replay.details.players;
        int n = 0;
        Details.Player[] playerArray2 = playerArray;
        int n2 = playerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Details.Player player = playerArray2[n3];
            if (n < player.playerId.name.length()) {
                n = player.playerId.name.length();
            }
            ++n3;
        }
        this.playerNames = new String[playerArray.length];
        int n4 = 0;
        while (n4 < this.playerNames.length) {
            this.playerNames[n4] = String.format("  %-" + n + "s  ", playerArray[n4].playerId.name);
            ++n4;
        }
        this.abilityCodes = abilityCodes;
    }

    public class Action {
        public int frame;
        public byte player;
        public byte opCode;
        public ReplayConsts.ActionType type = ReplayConsts.ActionType.OTHER;

        protected String toStringTemplate() {
            return String.valueOf(GameEvents.this.displayInSeconds ? ReplayUtils.formatFramesShort(this.frame, ((GameEvents)GameEvents.this).replay.converterGameSpeed) : String.format("%6d", this.frame)) + GameEvents.this.playerNames[this.player];
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder(GameEvents.this.displayInSeconds ? ReplayUtils.formatFramesShort(this.frame, ((GameEvents)GameEvents.this).replay.converterGameSpeed) : String.format("%6d", this.frame));
            stringBuilder.append(GameEvents.this.playerNames[this.player]);
            this.customToString(stringBuilder);
            return stringBuilder.toString();
        }

        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("0x").append(Integer.toHexString(this.opCode & 0xFF));
        }

        public boolean isMacro() {
            return false;
        }
    }

    public class AllianceAction
    extends Action {
        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Set Alliance");
        }
    }

    public class BaseUseAbilityAction
    extends Action {
        public int abilityCode;
        public String abilityName;
        public ReplayConsts.AbilityGroup abilityGroup;
        public boolean targetIsUnit;
        public int targetP1;
        public int targetP2;
        public final Boolean macro;

        public BaseUseAbilityAction() {
            this.macro = null;
        }

        public BaseUseAbilityAction(String string, ReplayConsts.AbilityGroup abilityGroup, Boolean bl) {
            this.abilityName = string;
            this.abilityGroup = abilityGroup;
            this.macro = bl;
        }

        @Override
        protected final void customToString(StringBuilder stringBuilder) {
            this.customAbilToString(stringBuilder);
            if (this.targetIsUnit) {
                stringBuilder.append("; target: ");
                String string = GameEvents.this.abilityCodes.UNIT_TYPE_NAME.get((short)this.targetP2);
                if (string == null) {
                    stringBuilder.append("Unknown[").append(Integer.toHexString(this.targetP2)).append(']');
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(" (").append(Integer.toHexString(this.targetP1)).append(')');
            } else if (this.targetP1 != 256 || this.targetP2 != 256) {
                stringBuilder.append("; target: ");
                stringBuilder.append("x=").append(ReplayUtils.formatCoordinate(this.targetP1)).append(",y=").append(ReplayUtils.formatCoordinate(this.targetP2));
            }
        }

        protected void customAbilToString(StringBuilder stringBuilder) {
            if (this.abilityName == null) {
                stringBuilder.append("Use ability ").append(String.format("%6x", this.abilityCode));
            } else {
                stringBuilder.append(this.abilityName);
            }
        }

        public boolean hasTargetPoint() {
            return !this.targetIsUnit && (this.targetP1 != 256 || this.targetP2 != 256);
        }

        public EntityParams getEntityParams() {
            return GameEvents.this.abilityCodes.COMMON_ABILITY_PARAMS.get(this.abilityCode);
        }

        @Override
        public boolean isMacro() {
            if (this.macro != null) {
                return this.macro;
            }
            EntityParams entityParams = this.getEntityParams();
            if (entityParams == null) {
                return false;
            }
            return entityParams.minerals != 0 || entityParams.gas != 0;
        }

        public ReplayConsts.UnitTier getUnitTier() {
            return null;
        }
    }

    public class BuildAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.Building building;

        public BuildAction(ReplayConsts.Building building) {
            this.type = ReplayConsts.ActionType.BUILD;
            this.building = building;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Build ").append(this.building.stringValue);
        }

        @Override
        public EntityParams getEntityParams() {
            return GameEvents.this.abilityCodes.BUILDING_PARAMS.get((Object)this.building);
        }
    }

    public class CancelResRequestAction
    extends Action {
        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Cancel resources request");
        }

        @Override
        public boolean isMacro() {
            return true;
        }
    }

    public class CustomAction
    extends Action {
        public final String actionName;

        public CustomAction(String string) {
            this.actionName = string;
            this.type = ReplayConsts.ActionType.INACTION;
        }

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append(this.actionName);
        }
    }

    public class DecreaseGameSpeedAction
    extends Action {
        public DecreaseGameSpeedAction() {
            this.type = ReplayConsts.ActionType.INACTION;
        }

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Decrease Game Speed");
        }
    }

    public class HotkeyAction
    extends Action {
        public static final byte FLAG_OVERWRITE_SELECTION = 0;
        public static final byte FLAG_ADD_SELECTION = 1;
        public static final byte FLAG_SELECT_GROUP = 2;
        public byte flag;

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Hotkey ").append(this.flag == 2 ? "Select " : "Assign ").append((this.opCode & 0xFF) >> 4);
            if (this.flag == 1) {
                stringBuilder.append(" (add selection)");
            }
        }

        public int getNumber() {
            return (this.opCode & 0xFF) >> 4;
        }

        public boolean isSelect() {
            return this.flag == 2;
        }

        @Override
        public boolean isMacro() {
            throw new UnsupportedOperationException("Whether a hotkey action is macro depends on previous actions!");
        }
    }

    public class IncreaseGameSpeedAction
    extends Action {
        public IncreaseGameSpeedAction() {
            this.type = ReplayConsts.ActionType.INACTION;
        }

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Increase Game Speed");
        }
    }

    public class LeaveGameAction
    extends Action {
        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Leave game");
        }
    }

    public class MoveScreenAction
    extends Action {
        public int x;
        public int y;
        public boolean zooming;
        public boolean rotating;

        public MoveScreenAction() {
            this.type = ReplayConsts.ActionType.INACTION;
        }

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Move screen x=").append(this.x >> 8).append('.').append(ReplayUtils.DECIMAL_TABLE[this.x & 0xFF]).append(",y=").append(this.y >> 8).append('.').append(ReplayUtils.DECIMAL_TABLE[this.y & 0xFF]);
            if (this.zooming) {
                stringBuilder.append(", Zoom camera");
            }
            if (this.rotating) {
                stringBuilder.append(", Rotate camera");
            }
        }
    }

    public class RequestResoucesAction
    extends Action {
        public int minRequested;
        public int gasRequested;

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Request resources; minerals: ").append(this.minRequested).append(", gas: ").append(this.gasRequested);
        }

        @Override
        public boolean isMacro() {
            return true;
        }
    }

    public class ResearchAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.Research research;

        public ResearchAction(ReplayConsts.Research research) {
            this.type = ReplayConsts.ActionType.RESEARCH;
            this.research = research;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Research ").append(this.research.stringValue);
        }

        @Override
        public EntityParams getEntityParams() {
            return GameEvents.this.abilityCodes.RESEARCH_PARAMS.get((Object)this.research);
        }
    }

    public class SelectAction
    extends Action {
        public boolean automatic;
        public int deselectionBitsCount;
        public byte[] deselectionUnitBitmap;
        public short[] unitTypes;
        public byte[] unitsOfTypeCounts;
        public int[] unitIds;

        public SelectAction() {
            this.type = ReplayConsts.ActionType.SELECT;
        }

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            if (this.automatic) {
                stringBuilder.append("Selection auto-update ");
            }
            int n = 0;
            if (this.unitTypes != null) {
                int n2 = 0;
                while (n2 < this.unitTypes.length) {
                    stringBuilder.append(n2 == 0 ? "Select " : ", ");
                    String string = GameEvents.this.abilityCodes.UNIT_TYPE_NAME.get(this.unitTypes[n2]);
                    if (string == null) {
                        stringBuilder.append("Unknown[").append(Integer.toHexString(this.unitTypes[n2])).append(']');
                    } else {
                        stringBuilder.append(string);
                    }
                    int n3 = this.unitsOfTypeCounts[n2];
                    if (n3 > 1) {
                        stringBuilder.append(" x").append(this.unitsOfTypeCounts[n2]);
                    }
                    stringBuilder.append(" (");
                    int n4 = n3;
                    while (n4 > 0) {
                        stringBuilder.append(Integer.toHexString(this.unitIds[n])).append(',');
                        --n4;
                        ++n;
                    }
                    stringBuilder.setCharAt(stringBuilder.length() - 1, ')');
                    ++n2;
                }
            }
            if (this.deselectionBitsCount != 0) {
                if (this.unitTypes != null && this.unitTypes.length > 0) {
                    stringBuilder.append(", ");
                }
                if (this.deselectionBitsCount < 0) {
                    stringBuilder.append("Deselect all");
                } else {
                    stringBuilder.append("Deselect ").append(this.deselectionBitsCount).append(this.deselectionBitsCount == 1 ? " unit" : " units");
                }
            }
        }

        @Override
        public boolean isMacro() {
            throw new UnsupportedOperationException("Whether a select action is macro depends on previous actions!");
        }
    }

    public class SendResourcesAction
    extends Action {
        public int targetPlayer;
        public int minSent;
        public int gasSent;

        @Override
        protected void customToString(StringBuilder stringBuilder) {
            stringBuilder.append("Send resources to ").append(((GameEvents)GameEvents.this).replay.details.players[this.targetPlayer].playerId.name).append("; minerals: ").append(this.minSent).append(", gas: ").append(this.gasSent);
        }

        @Override
        public boolean isMacro() {
            return true;
        }
    }

    public class TrainAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.Unit unit;

        public TrainAction(ReplayConsts.Unit unit) {
            this.type = ReplayConsts.ActionType.TRAIN;
            this.unit = unit;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Train ").append(this.unit.stringValue);
        }

        @Override
        public EntityParams getEntityParams() {
            return GameEvents.this.abilityCodes.UNIT_PARAMS.get((Object)this.unit);
        }

        @Override
        public ReplayConsts.UnitTier getUnitTier() {
            return this.unit.unitTier;
        }
    }

    public class TrainHallucinatedAction
    extends TrainAction {
        public TrainHallucinatedAction(ReplayConsts.Unit unit) {
            super(unit);
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Train ").append(this.unit.stringValue).append(" Hallucination (Sentry)");
        }

        @Override
        public EntityParams getEntityParams() {
            return null;
        }

        @Override
        public ReplayConsts.UnitTier getUnitTier() {
            return null;
        }
    }

    public class UpgradeAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.Upgrade upgrade;

        public UpgradeAction(ReplayConsts.Upgrade upgrade) {
            this.type = ReplayConsts.ActionType.UPGRADE;
            this.upgrade = upgrade;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Upgrade ").append(this.upgrade.stringValue);
        }

        @Override
        public EntityParams getEntityParams() {
            return GameEvents.this.abilityCodes.UPGRADE_PARAMS.get((Object)this.upgrade);
        }
    }

    public class UseBuildingAbilityAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.BuildingAbility buildingAbility;
        public final ReplayConsts.Building building;

        public UseBuildingAbilityAction(ReplayConsts.BuildingAbility buildingAbility, ReplayConsts.Building building) {
            this.buildingAbility = buildingAbility;
            this.building = building;
            this.abilityGroup = buildingAbility.abilityGroup;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append(this.buildingAbility.stringValue).append(" (").append(this.building.stringValue).append(')');
        }

        @Override
        public EntityParams getEntityParams() {
            return GameEvents.this.abilityCodes.BUILDING_ABILITY_PARAMS.get((Object)this.buildingAbility);
        }
    }

    public class UseUnitAbilityAction
    extends BaseUseAbilityAction {
        public final ReplayConsts.UnitAbility unitAbility;
        public final ReplayConsts.Unit unit;

        public UseUnitAbilityAction(ReplayConsts.UnitAbility unitAbility, ReplayConsts.Unit unit) {
            this.unitAbility = unitAbility;
            this.unit = unit;
            this.abilityGroup = unitAbility.abilityGroup;
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append((Object)this.unitAbility).append(" (").append(this.unit.stringValue).append(')');
        }

        @Override
        public EntityParams getEntityParams() {
            return GameEvents.this.abilityCodes.UNIT_ABILITY_PARAMS.get((Object)this.unitAbility);
        }

        @Override
        public ReplayConsts.UnitTier getUnitTier() {
            return this.unitAbility.transformationTargetUnit == null ? null : this.unitAbility.transformationTargetUnit.unitTier;
        }
    }

    public class WarpAction
    extends TrainAction {
        public WarpAction(ReplayConsts.Unit unit) {
            super(unit);
        }

        @Override
        protected void customAbilToString(StringBuilder stringBuilder) {
            stringBuilder.append("Train ").append(this.unit.stringValue).append(" (Warp gate)");
        }

        @Override
        public EntityParams getEntityParams() {
            return GameEvents.this.abilityCodes.WARPED_UNIT_PARAMS.get((Object)this.unit);
        }
    }
}

