/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.services;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.sc2replay.ReplayConsts;
import hu.belicza.andras.sc2gears.services.MousePrintRecorder;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.sound.Sounds;
import hu.belicza.andras.sc2gears.util.ControlledThread;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.ObjectRegistry;
import hu.belicza.andras.sc2gearspluginapi.api.enums.GameStatus;
import hu.belicza.andras.sc2gearspluginapi.api.listener.GameStatusListener;
import java.util.Date;

public class ApmAlert
extends ControlledThread {
    private static final ObjectRegistry<GameStatusListener> gameStatusListenerRegistry = new ObjectRegistry();
    public static final boolean supported = GeneralUtils.isWindows();
    public static final Object[] APM_ALERT_REPETITION_INTERVALS = new Object[]{Language.getText("miscSettings.never"), 3, 5, 10, 15, 20, 30, 60, 90, 120};
    public static final int GAME_STATUS_UNKNOWN = -1;
    public static final int GAME_STATUS_NO_GAME = 0;
    public static final int GAME_STATUS_STARTED = 1;
    private int gameStatus = -1;
    private Long warmUpTimeStart;
    private boolean apmOk;
    private long lastApmAlertTime;

    public static void addGameStatusListener(GameStatusListener gameStatusListener) {
        gameStatusListenerRegistry.add(gameStatusListener);
    }

    public static void removeGameStatusListener(GameStatusListener gameStatusListener) {
        gameStatusListenerRegistry.remove(gameStatusListener);
    }

    public ApmAlert() {
        super("APM alert");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.requestedToCancel) {
            try {
                Object object;
                Integer n = ApmAlert.getGameStatus();
                if (n != null) {
                    if (this.gameStatus != 1 && n == 1) {
                        if (this.gameStatus == 0) {
                            this.warmUpTimeStart = new Date().getTime();
                            if (Settings.getBoolean("settings.misc.alertOnGameStart") && Settings.getBoolean("settings.enableVoiceNotifications")) {
                                Sounds.playSoundSample("game_started", false);
                            }
                            try {
                                MousePrintRecorder.onGameStart();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        } else {
                            this.warmUpTimeStart = null;
                        }
                        this.apmOk = true;
                    }
                    if (this.gameStatus == 1 && n == 0) {
                        if (Settings.getBoolean("settings.misc.alertOnGameEnd") && Settings.getBoolean("settings.enableVoiceNotifications")) {
                            Sounds.playSoundSample("game_ended", false);
                        }
                        try {
                            MousePrintRecorder.onGameEnd();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (this.gameStatus != n) {
                        ObjectRegistry<GameStatusListener> objectRegistry = gameStatusListenerRegistry;
                        synchronized (objectRegistry) {
                            object = gameStatusListenerRegistry.iterator();
                            while (object.hasNext()) {
                                GameStatusListener gameStatusListener = (GameStatusListener)object.next();
                                try {
                                    GameStatus gameStatus;
                                    switch (n) {
                                        case 0: {
                                            gameStatus = GameStatus.NO_GAME;
                                            break;
                                        }
                                        case 1: {
                                            gameStatus = GameStatus.STARTED;
                                            break;
                                        }
                                        default: {
                                            gameStatus = GameStatus.UNKNOWN;
                                        }
                                    }
                                    gameStatusListener.gameStatusChanged(gameStatus);
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            }
                        }
                    }
                    this.gameStatus = n;
                }
                long l = new Date().getTime();
                if (this.gameStatus == 1 && (this.warmUpTimeStart == null || l > this.warmUpTimeStart + (long)(Settings.getInt("settings.misc.apmWarmupTime") * 1000)) && (object = ApmAlert.getNormalizedApm()) != null) {
                    if ((Integer)object > Settings.getInt("settings.misc.apmAlertLevel")) {
                        if (!this.apmOk) {
                            if (Settings.getBoolean("settings.misc.alertWhenApmIsBackToNormal") && Settings.getBoolean("settings.enableVoiceNotifications")) {
                                Sounds.playSoundSample("apm_ok", false);
                            }
                            this.apmOk = true;
                        }
                    } else if (this.apmOk) {
                        this.lastApmAlertTime = l;
                        if (Settings.getBoolean("settings.enableVoiceNotifications")) {
                            Sounds.playSoundSample("low_apm", false);
                        }
                        this.apmOk = false;
                    } else {
                        int n2 = Settings.getInt("settings.misc.apmAlertRepetitionIntervalSec");
                        if (n2 > 0 && l > this.lastApmAlertTime + (long)((Integer)APM_ALERT_REPETITION_INTERVALS[n2] * 1000)) {
                            this.lastApmAlertTime = l;
                            if (Settings.getBoolean("settings.enableVoiceNotifications")) {
                                Sounds.playSoundSample("low_apm", false);
                            }
                        }
                    }
                }
                ApmAlert.sleep(Settings.getInt("settings.misc.apmCheckIntervalSec") * 1000);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static Integer getGameStatus() {
        try {
            return Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)"Software\\Razer\\Starcraft2", (String)"StartModule");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Integer getNormalizedApm() {
        Integer n = ApmAlert.getApm();
        if (n != null) {
            if (n >= 600) {
                n = n - 500;
            }
            if (Settings.getBoolean("settings.misc.useRealTimeMeasurement")) {
                n = ReplayConsts.GameSpeed.FASTER.convertToGameTime(n);
            }
        }
        return n;
    }

    private static Integer getApm() {
        try {
            return Integer.valueOf(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)"Software\\Razer\\Starcraft2", (String)"APMValue"));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

