/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.services;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.util.ControlledThread;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gearspluginapi.api.listener.DownloaderCallback;
import hu.belicza.andras.sc2gearspluginapi.api.ui.IDownloader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JProgressBar;

public class Downloader
extends ControlledThread
implements IDownloader {
    private final String url;
    private final File destination;
    private final DownloaderCallback callback;
    private final JProgressBar progressBar;

    public Downloader(String string, File file, boolean bl, DownloaderCallback downloaderCallback) {
        super("Downloader");
        this.url = string;
        this.destination = file;
        this.callback = downloaderCallback;
        JProgressBar jProgressBar = this.progressBar = bl ? new JProgressBar() : null;
        if (this.progressBar != null) {
            this.progressBar.setString("");
            this.progressBar.setStringPainted(true);
        }
    }

    @Override
    public void run() {
        InputStream inputStream = null;
        File file = null;
        OutputStream outputStream = null;
        try {
            int n;
            URLConnection uRLConnection = new URL(this.url).openConnection();
            int n2 = uRLConnection.getContentLength();
            if (this.progressBar != null) {
                if (n2 < 0) {
                    this.progressBar.setString(Language.getText("general.downloadingSizeUnknown"));
                } else {
                    this.progressBar.setString(null);
                    this.progressBar.setMaximum(n2);
                }
            }
            inputStream = uRLConnection.getInputStream();
            file = File.createTempFile("Sc2gears", null);
            file.deleteOnExit();
            outputStream = new FileOutputStream(file);
            int n3 = 0;
            byte[] byArray = new byte[8192];
            while (!this.requestedToCancel && (n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
                n3 += n;
                if (this.progressBar == null || n2 <= 0) continue;
                this.progressBar.setValue(n3);
            }
            outputStream.flush();
            if (this.progressBar != null && !this.requestedToCancel && n2 < 0) {
                this.progressBar.setValue(this.progressBar.getMaximum());
                this.progressBar.setString(null);
            }
            if (this.requestedToCancel) {
                this.callback.downloadFinished(false);
                return;
            }
            try {
                this.callback.downloadFinished(GeneralUtils.copyFile(file, this.destination.getParentFile(), byArray, this.destination.getName()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.callback.downloadFinished(false);
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (file != null) {
                file.delete();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    @Override
    public void startDownload() {
        this.start();
    }
}

