/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.services;

import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.smpd.SmpdUtil;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.ui.dialogs.MiscSettingsDialog;
import hu.belicza.andras.sc2gears.ui.dialogs.ProgressDialog;
import hu.belicza.andras.sc2gears.ui.icons.Icons;
import hu.belicza.andras.sc2gears.util.ControlledThread;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.NormalThread;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Locale;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;

public class MousePrintRecorder {
    public static final String[] OUTPUT_FORMATS = new String[]{"PNG", "JPG", "GIF"};
    private static volatile Recorder recorder;
    private static volatile RecorderFrame recorderFrame;

    private MousePrintRecorder() {
    }

    public static synchronized boolean isRecording() {
        return recorder != null && !recorder.isCancelRequested();
    }

    public static synchronized void startRecording() {
        if (recorder != null && !recorder.isCancelRequested()) {
            return;
        }
        recorder = new Recorder();
        recorder.start();
        MousePrintRecorder.updateRecorderFrame();
    }

    public static synchronized void stopRecording() {
        if (recorder == null || recorder.isCancelRequested()) {
            return;
        }
        recorder.requestToCancel();
        try {
            recorder.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        MousePrintRecorder.updateRecorderFrame();
    }

    public static synchronized void onGameStart() {
        if (Settings.getBoolean("settings.misc.saveMousePrints")) {
            MousePrintRecorder.startRecording();
        }
    }

    public static synchronized void onGameEnd() {
        if (Settings.getBoolean("settings.misc.saveMousePrints")) {
            MousePrintRecorder.stopRecording();
            if (recorder != null) {
                recorder.save();
            }
            if (Settings.getBoolean("settings.misc.storeMousePrints")) {
                final String string = Settings.getString("settings.misc.authorizationKey");
                if (string.length() == 0) {
                    System.out.println("Failed to store mouse print in the Sc2gears Database: no Authorization key is set: " + recorder.sourceFileName);
                } else {
                    new NormalThread("Mouse print auto-storer"){

                        @Override
                        public void run() {
                            try {
                                MainFrame.registerBackgroundJob();
                                GeneralUtils.storeMousePrint(new File(recorder.sourceFileName), string);
                            }
                            finally {
                                MainFrame.removeBackgroundJob();
                            }
                        }
                    }.start();
                }
            }
        }
    }

    private static void updateRecorderFrame() {
        RecorderFrame recorderFrame = MousePrintRecorder.recorderFrame;
        if (recorderFrame != null) {
            recorderFrame.updateControls();
            recorderFrame.getContentPane().validate();
            recorderFrame.getContentPane().repaint();
            recorderFrame.updateMousePrint();
        }
    }

    public static synchronized void showFrame() {
        RecorderFrame recorderFrame = MousePrintRecorder.recorderFrame;
        if (recorderFrame != null) {
            if (recorderFrame.getExtendedState() == 1) {
                recorderFrame.setExtendedState(0);
            }
            recorderFrame.toFront();
            return;
        }
        MousePrintRecorder.recorderFrame = new RecorderFrame();
        MousePrintRecorder.recorderFrame.updateMousePrint();
    }

    public static synchronized JFrame getRecorderFrame() {
        return recorderFrame;
    }

    private static void storeMousePrints(final File[] fileArray) {
        final String string = GeneralUtils.checkKeyBeforeStoringOrDownloading(recorderFrame);
        if (string == null) {
            return;
        }
        final ProgressDialog progressDialog = new ProgressDialog("mousePrintRecorder.storingMousePrints", Icons.SERVER_NETWORK, fileArray.length);
        new NormalThread("Mouse print storer"){

            @Override
            public void run() {
                File[] fileArray2 = fileArray;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray2[n2];
                    if (progressDialog.isAborted()) break;
                    if (!GeneralUtils.storeMousePrint(file, string)) {
                        progressDialog.incrementFailed();
                    }
                    progressDialog.incrementProcessed();
                    progressDialog.updateProgressBar();
                    ++n2;
                }
                progressDialog.taskFinished();
            }
        }.start();
    }

    private static class Recorder
    extends ControlledThread {
        public static final Integer[] RECORDER_REFRESH_RATES = new Integer[]{1, 2, 4, 8, 16};
        private volatile int recorderFrameRefreshPeriod = 200;
        private SmpdUtil.DataCompression savedWithCompression;
        private final WhatToSave whatToSave;
        private final int screenResolution;
        private final Color backgroundColor = GeneralUtils.getColorSetting(null, "settings.misc.mousePrintBackgroundColor");
        private final Color color = GeneralUtils.getColorSetting(null, "settings.misc.mousePrintColor");
        private final Color shadowColor = new Color(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 128);
        private final BufferedImage buffer;
        private Date startTime;
        private volatile Date endTime;
        private final long samplingTime;
        private final boolean useAntialiasing = Settings.getBoolean("settings.misc.mousePrintUseAntialiasing");
        private final int pourInkMouseIdleTime = Settings.getInt("settings.misc.mousePrintPourInkIdleTime") * 1000;
        private final int inkFlowRate = Settings.getInt("settings.misc.mousePrintIdleInkFlowRate");
        private final int mouseWarmupTime = Settings.getInt("settings.misc.mouseWarmupTime") * 1000;
        private volatile int samplesCount;
        private volatile double totalMouseDistance;
        private final ByteArrayOutputStream dataStream;
        private volatile Boolean saved;
        private volatile boolean loaded;
        private String sourceFileName;

        public Recorder() {
            super("Mouse Print Recorder");
            WhatToSave whatToSave;
            try {
                whatToSave = WhatToSave.values()[Settings.getInt("settings.misc.mousePrintWhatToSave")];
            }
            catch (IllegalArgumentException illegalArgumentException) {
                whatToSave = WhatToSave.values()[Settings.getDefaultInt("settings.misc.mousePrintWhatToSave")];
            }
            this.whatToSave = whatToSave;
            this.samplingTime = Settings.getInt("settings.misc.mousePrintSamplingTime");
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.screenResolution = toolkit.getScreenResolution();
            Dimension dimension = toolkit.getScreenSize();
            this.buffer = new BufferedImage(dimension.width, dimension.height, 1);
            this.dataStream = this.whatToSave.saveBinaryData ? new ByteArrayOutputStream(100000) : null;
            this.setRecorderFrameRefreshRate(RECORDER_REFRESH_RATES[Settings.getInt("mousePrint.refreshRate")]);
        }

        public Recorder(File file) {
            super("Mouse Print Recorder");
            WhatToSave whatToSave;
            try {
                whatToSave = WhatToSave.values()[Settings.getInt("settings.misc.mousePrintWhatToSave")];
            }
            catch (IllegalArgumentException illegalArgumentException) {
                whatToSave = WhatToSave.values()[Settings.getDefaultInt("settings.misc.mousePrintWhatToSave")];
            }
            this.whatToSave = whatToSave;
            DataInputStream dataInputStream = null;
            Graphics graphics = null;
            try {
                try {
                    dataInputStream = new DataInputStream(new FileInputStream(file));
                    byte[] byArray = new byte[4];
                    dataInputStream.read(byArray);
                    if (!Arrays.equals(byArray, SmpdUtil.SMPD_MAGIC)) {
                        throw new Exception("Invalid SMPD magic!");
                    }
                    short s = dataInputStream.readShort();
                    if (s != 256) {
                        throw new Exception("Unsupported SMPD version: " + SmpdUtil.getVersionString(s));
                    }
                    int n = dataInputStream.readInt();
                    if (n < 41) {
                        throw new Exception("Header length too small, should be at least 41!");
                    }
                    this.startTime = new Date(dataInputStream.readLong());
                    this.endTime = new Date(dataInputStream.readLong());
                    int n2 = dataInputStream.readInt();
                    int n3 = dataInputStream.readInt();
                    this.buffer = new BufferedImage(n2, n3, 1);
                    this.screenResolution = dataInputStream.readInt();
                    this.samplingTime = dataInputStream.readInt();
                    this.samplesCount = dataInputStream.readInt();
                    this.dataStream = new ByteArrayOutputStream(dataInputStream.readInt());
                    this.savedWithCompression = SmpdUtil.DataCompression.values()[dataInputStream.read()];
                    if (n != 41) {
                        dataInputStream.skipBytes(n - 41);
                    }
                    InputStream inputStream = null;
                    switch (this.savedWithCompression) {
                        case NO_COMPRESSION: {
                            inputStream = dataInputStream;
                            break;
                        }
                        case DEFLATE: {
                            inputStream = new InflaterInputStream(dataInputStream);
                            break;
                        }
                        case BZIP2: {
                            inputStream = new CBZip2InputStream(dataInputStream);
                        }
                    }
                    graphics = this.createAndInitGraphics();
                    int n4 = this.samplesCount;
                    Point point = null;
                    Point point2 = null;
                    int n5 = 0;
                    while (n4-- > 0) {
                        int n6 = SmpdUtil.readEncodedValue(inputStream);
                        if (n6 == Integer.MAX_VALUE) {
                            break;
                        }
                        n5 += n6;
                        int n7 = SmpdUtil.readEncodedValue(inputStream);
                        int n8 = SmpdUtil.readEncodedValue(inputStream);
                        if (point == null) {
                            point = new Point(n7, n8);
                            this.handleFirstSample(n6, point);
                            point2 = new Point(point);
                            continue;
                        }
                        point.x += n7;
                        point.y += n8;
                        this.handleSample(n5, n6, point, point2, (Graphics2D)graphics);
                        point2.x = point.x;
                        point2.y = point.y;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new RuntimeException();
                }
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                }
                if (dataInputStream != null) {
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.requestToCancel();
            this.sourceFileName = file.getAbsolutePath();
            this.setRecorderFrameRefreshRate(RECORDER_REFRESH_RATES[Settings.getInt("mousePrint.refreshRate")]);
            this.loaded = true;
        }

        @Override
        public void run() {
            Graphics2D graphics2D = this.createAndInitGraphics();
            this.startTime = new Date();
            long l = this.startTime.getTime();
            RecorderFrame recorderFrame = recorderFrame;
            recorderFrame = recorderFrame;
            if (recorderFrame != null) {
                recorderFrame.updateMousePrint();
            }
            Point point = null;
            long l2 = l;
            long l3 = l2 + (long)this.recorderFrameRefreshPeriod;
            boolean bl = false;
            while (!this.requestedToCancel) {
                Point point2 = this.getMouseLocation();
                long l4 = new Date().getTime();
                if (point2 != null) {
                    if (point == null) {
                        this.handleFirstSample((int)(l4 - l2), point2);
                        point = point2;
                        l2 = l4;
                        bl = true;
                    } else if (!point.equals(point2)) {
                        this.handleSample((int)(l4 - l), (int)(l4 - l2), point2, point, graphics2D);
                        point = point2;
                        l2 = l4;
                        bl = true;
                    }
                }
                if (bl && l4 > l3 && (recorderFrame = recorderFrame) != null) {
                    l3 = l4 + (long)this.recorderFrameRefreshPeriod;
                    bl = false;
                    recorderFrame.updateMousePrint();
                }
                try {
                    Thread.sleep(this.samplingTime);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.endTime = new Date();
            recorderFrame = recorderFrame;
            if (recorderFrame != null) {
                recorderFrame.updateMousePrint();
            }
            graphics2D.dispose();
        }

        private Graphics2D createAndInitGraphics() {
            Graphics2D graphics2D = this.buffer.createGraphics();
            graphics2D.setColor(this.backgroundColor);
            graphics2D.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
            graphics2D.setColor(this.color);
            if (this.useAntialiasing) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            return graphics2D;
        }

        private Point getMouseLocation() {
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            if (pointerInfo == null) {
                return null;
            }
            Point point = pointerInfo.getLocation();
            if (point.x < -20000 || point.x > 20000 || point.y < -20000 || point.y > 20000) {
                return null;
            }
            return point;
        }

        private void handleFirstSample(int n, Point point) {
            if (this.dataStream != null) {
                this.writeSample(n, point.x, point.y);
            }
        }

        private void handleSample(int n, int n2, Point point, Point point2, Graphics2D graphics2D) {
            int n3 = point.x - point2.x;
            int n4 = point.y - point2.y;
            if (this.dataStream != null) {
                this.writeSample(n2, n3, n4);
            }
            this.totalMouseDistance = n3 == 0 ? (this.totalMouseDistance += (double)(n4 < 0 ? -n4 : n4)) : (n4 == 0 ? (this.totalMouseDistance += (double)(n3 < 0 ? -n3 : n3)) : (this.totalMouseDistance += Math.sqrt(n3 * n3 + n4 * n4)));
            if (n2 > this.pourInkMouseIdleTime && n > this.mouseWarmupTime) {
                int n5 = (int)Math.sqrt(0.0012732395447351628 * (double)(n2 - this.pourInkMouseIdleTime) * (double)this.inkFlowRate);
                graphics2D.setColor(this.shadowColor);
                graphics2D.fillOval(point2.x - n5, point2.y - n5, n5 << 1, n5 << 1);
                graphics2D.setColor(this.color);
                graphics2D.fillOval(point2.x - (n5 >> 1), point2.y - (n5 >> 1), n5, n5);
            }
            graphics2D.drawLine(point2.x, point2.y, point.x, point.y);
        }

        private void writeSample(int n, int n2, int n3) {
            try {
                SmpdUtil.writeEncodedValue(n, this.dataStream);
                SmpdUtil.writeEncodedValue(n2, this.dataStream);
                SmpdUtil.writeEncodedValue(n3, this.dataStream);
                ++this.samplesCount;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public synchronized void save() {
            Object object;
            Object object2;
            File file = new File(Settings.getString("settings.folders.mousePrintOutput"));
            if (!file.exists() && !file.mkdirs()) {
                System.out.println("Failed to create mouse print output folder: " + file.getAbsolutePath());
                return;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yy-MM-dd HH-mm-ss");
            String string = simpleDateFormat.format(new Date());
            if (this.whatToSave.saveBinaryData) {
                block28: {
                    try {
                        this.savedWithCompression = SmpdUtil.DataCompression.values()[Settings.getInt("settings.misc.mousePrintDataCompression")];
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.savedWithCompression = SmpdUtil.DataCompression.values()[Settings.getDefaultInt("settings.misc.mousePrintDataCompression")];
                    }
                    object2 = new File(file, String.valueOf(string) + "." + "smpd");
                    object = null;
                    try {
                        try {
                            object = new DataOutputStream(new FileOutputStream((File)object2));
                            ((FilterOutputStream)object).write(SmpdUtil.SMPD_MAGIC);
                            ((DataOutputStream)object).writeShort(256);
                            ((DataOutputStream)object).writeInt(41);
                            ((DataOutputStream)object).writeLong(this.startTime.getTime());
                            ((DataOutputStream)object).writeLong(this.endTime.getTime());
                            ((DataOutputStream)object).writeInt(this.buffer.getWidth());
                            ((DataOutputStream)object).writeInt(this.buffer.getHeight());
                            ((DataOutputStream)object).writeInt(this.screenResolution);
                            ((DataOutputStream)object).writeInt((int)this.samplingTime);
                            ((DataOutputStream)object).writeInt(this.samplesCount);
                            ((DataOutputStream)object).writeInt(this.dataStream.size());
                            ((DataOutputStream)object).write(this.savedWithCompression.ordinal());
                            switch (this.savedWithCompression) {
                                case NO_COMPRESSION: {
                                    this.dataStream.writeTo((OutputStream)object);
                                    break;
                                }
                                case DEFLATE: {
                                    DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)object);
                                    this.dataStream.writeTo(deflaterOutputStream);
                                    deflaterOutputStream.finish();
                                    break;
                                }
                                case BZIP2: {
                                    CBZip2OutputStream cBZip2OutputStream = new CBZip2OutputStream((OutputStream)object);
                                    this.dataStream.writeTo(cBZip2OutputStream);
                                    cBZip2OutputStream.finish();
                                }
                            }
                            ((DataOutputStream)object).flush();
                            ((FilterOutputStream)object).close();
                            System.out.println("Successfully saved mouse print binary data to: " + ((File)object2).getAbsolutePath());
                        }
                        catch (IOException iOException) {
                            this.saved = false;
                            System.out.println("Failed to save mouse print image: " + ((File)object2).getAbsolutePath());
                            iOException.printStackTrace();
                            if (object != null) {
                                try {
                                    ((FilterOutputStream)object).close();
                                }
                                catch (IOException iOException2) {}
                            }
                            break block28;
                        }
                    }
                    catch (Throwable throwable) {
                        if (object != null) {
                            try {
                                ((FilterOutputStream)object).close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (object != null) {
                        try {
                            ((FilterOutputStream)object).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                this.sourceFileName = ((File)object2).getAbsolutePath();
                this.saved = true;
            }
            if (this.whatToSave.saveImage) {
                object2 = OUTPUT_FORMATS[Settings.getInt("settings.misc.mousePrintImageOutputFormat")];
                object = new File(file, String.valueOf(string) + "." + ((String)object2).toLowerCase());
                try {
                    ImageIO.write((RenderedImage)this.buffer, (String)object2, (File)object);
                    System.out.println("Successfully saved mouse print image to: " + ((File)object).getAbsolutePath());
                }
                catch (IOException iOException) {
                    if (this.saved == null) {
                        this.saved = false;
                    }
                    System.out.println("Failed to save mouse print image: " + ((File)object).getAbsolutePath());
                    iOException.printStackTrace();
                }
                if (this.saved == null) {
                    this.saved = true;
                }
            }
            MousePrintRecorder.updateRecorderFrame();
        }

        public void setRecorderFrameRefreshRate(int n) {
            this.recorderFrameRefreshPeriod = 1000 / n;
        }
    }

    private static class RecorderFrame
    extends JFrame {
        private static final int MAX_ZOOM = 3;
        private static final Dictionary<Integer, JComponent> LABEL_DICTIONARY = new Hashtable<Integer, JComponent>();
        private final JButton startStopRecordingButton = new JButton();
        private final JButton saveMousePrintButton = new JButton(Icons.DISK);
        private final JButton loadMousePrintButton = new JButton(Icons.FOLDER_OPEN);
        private final JButton storeMousePrintButton = new JButton(Icons.SERVER_NETWORK);
        private final JPanel mousePrintCanvas;
        private final JLabel statusLabel = new JLabel();
        private final JTable infoTable = GuiUtils.createNonEditableTable();

        static {
            int n = 0;
            while (n <= 3) {
                LABEL_DICTIONARY.put(n, new JLabel(n == 0 ? "1x" : "1/" + (1 << n) + "x"));
                ++n;
            }
        }

        public RecorderFrame() {
            super(Language.getText("mousePrintRecorder.title", "Sc2gears"));
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    Class<MousePrintRecorder> clazz = MousePrintRecorder.class;
                    synchronized (MousePrintRecorder.class) {
                        recorderFrame.dispose();
                        MousePrintRecorder.recorderFrame = null;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
            this.setIconImage(Icons.FINGERPRINT.getImage());
            Box box = Box.createVerticalBox();
            Box box2 = Box.createHorizontalBox();
            this.startStopRecordingButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (recorder == null || recorder.isCancelRequested()) {
                        MousePrintRecorder.startRecording();
                    } else {
                        MousePrintRecorder.stopRecording();
                    }
                }
            });
            box2.add(this.startStopRecordingButton);
            box2.add(Box.createHorizontalStrut(5));
            GuiUtils.updateButtonText(this.saveMousePrintButton, "mousePrintRecorder.saveMousePrintButton", new Object[0]);
            this.saveMousePrintButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    recorder.save();
                }
            });
            box2.add(this.saveMousePrintButton);
            box2.add(Box.createHorizontalStrut(5));
            GuiUtils.updateButtonText(this.storeMousePrintButton, "mousePrintRecorder.storeMousePrintButton", new Object[0]);
            this.storeMousePrintButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MousePrintRecorder.storeMousePrints(new File[]{new File(recorder.sourceFileName)});
                }
            });
            box2.add(this.storeMousePrintButton);
            box2.add(Box.createHorizontalStrut(5));
            GuiUtils.updateButtonText(this.loadMousePrintButton, "mousePrintRecorder.loadMousePrintButton", new Object[0]);
            this.loadMousePrintButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Recorder recorder = recorder;
                    if (recorder != null && !recorder.isCancelRequested()) {
                        return;
                    }
                    boolean bl = true;
                    boolean bl2 = bl;
                    if (!bl2) return;
                    JFileChooser jFileChooser = new JFileChooser(Settings.getString("settings.folders.mousePrintOutput"));
                    jFileChooser.setDialogTitle(Language.getText("mousePrintRecorder.loadMousePrintTitle"));
                    jFileChooser.setFileFilter(GuiUtils.MOUSE_PRINT_DATA_FILE_FILTER);
                    jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                    if (jFileChooser.showOpenDialog(RecorderFrame.this) != 0) return;
                    File file = jFileChooser.getSelectedFile();
                    boolean bl3 = false;
                    Class<MousePrintRecorder> clazz = MousePrintRecorder.class;
                    synchronized (MousePrintRecorder.class) {
                        recorder = recorder;
                        if (recorder == null || recorder.isCancelRequested()) {
                            try {
                                MousePrintRecorder.recorder = new Recorder(file);
                            }
                            catch (Exception exception) {
                                bl3 = true;
                            }
                        }
                        // ** MonitorExit[var7_7] (shouldn't be in output)
                        if (bl3) {
                            GuiUtils.showErrorDialog(Language.getText("mousePrintRecorder.failedToLoadMousePrint"), RecorderFrame.this);
                            return;
                        } else {
                            MousePrintRecorder.updateRecorderFrame();
                        }
                        return;
                    }
                }
            });
            box2.add(this.loadMousePrintButton);
            box.add(GuiUtils.wrapInPanel(box2));
            box2 = Box.createHorizontalBox();
            JButton jButton = new JButton(Icons.SERVER_NETWORK);
            GuiUtils.updateButtonText(jButton, "mousePrintRecorder.selectMousePrintsToStoreButton", new Object[0]);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser(Settings.getString("settings.folders.mousePrintOutput"));
                    jFileChooser.setDialogTitle(Language.getText("mousePrintRecorder.selectMousePrintsToStore"));
                    jFileChooser.setMultiSelectionEnabled(true);
                    jFileChooser.setFileFilter(GuiUtils.MOUSE_PRINT_DATA_FILE_FILTER);
                    jFileChooser.setFileView(GuiUtils.SC2GEARS_FILE_VIEW);
                    if (jFileChooser.showOpenDialog(recorderFrame) == 0) {
                        MousePrintRecorder.storeMousePrints(jFileChooser.getSelectedFiles());
                    }
                }
            });
            box2.add(jButton);
            box2.add(Box.createHorizontalStrut(15));
            box2.add(MiscSettingsDialog.createLinkLabelToSettings(MiscSettingsDialog.SettingsTab.MOUSE_PRINT, this));
            box2.add(Box.createHorizontalStrut(15));
            box2.add(new JLabel(Language.getText("mousePrintRecorder.refreshRate")));
            final JComboBox jComboBox = GuiUtils.createComboBox(Recorder.RECORDER_REFRESH_RATES, "mousePrint.refreshRate");
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Recorder recorder = recorder;
                    if (recorder != null) {
                        recorder.setRecorderFrameRefreshRate((Integer)jComboBox.getSelectedItem());
                    }
                }
            });
            box2.add(jComboBox);
            box2.add(new JLabel(Language.getText("mousePrintRecorder.fps")));
            box.add(GuiUtils.wrapInPanel(box2));
            this.updateControls();
            box.add(GuiUtils.wrapInPanel(this.statusLabel));
            this.getContentPane().add((Component)GuiUtils.wrapInPanel(box), "North");
            JTabbedPane jTabbedPane = new JTabbedPane();
            Box box3 = Box.createHorizontalBox();
            JPanel jPanel = new JPanel(new BorderLayout());
            box3.add(new JLabel(Language.getText("mousePrintRecorder.tab.image.zoom")));
            final JSlider jSlider = new JSlider(0, 3, Settings.getInt("mousePrint.imageZoom"));
            jSlider.setPaintLabels(true);
            jSlider.setPaintTicks(true);
            jSlider.setSnapToTicks(true);
            jSlider.setMajorTickSpacing(1);
            jSlider.setLabelTable(LABEL_DICTIONARY);
            jSlider.setPreferredSize(new Dimension(150, jSlider.getPreferredSize().height));
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (jSlider.getValueIsAdjusting()) {
                        return;
                    }
                    Settings.set("mousePrint.imageZoom", jSlider.getValue());
                    RecorderFrame.this.mousePrintCanvas.invalidate();
                    RecorderFrame.this.getContentPane().validate();
                    RecorderFrame.this.getContentPane().repaint();
                }
            });
            box3.add(jSlider);
            jPanel.add((Component)GuiUtils.wrapInPanel(box3), "North");
            this.mousePrintCanvas = new JPanel(new BorderLayout()){

                @Override
                public void paint(Graphics graphics) {
                    Recorder recorder = recorder;
                    if (recorder == null) {
                        super.paint(graphics);
                    } else {
                        Graphics2D graphics2D = (Graphics2D)graphics;
                        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        int n = recorder.buffer.getWidth();
                        int n2 = recorder.buffer.getHeight();
                        int n3 = jSlider.getValue();
                        int n4 = n >> n3;
                        int n5 = n2 >> n3;
                        int n6 = 0;
                        int n7 = 0;
                        if (n4 < this.getWidth() || n5 < this.getHeight()) {
                            graphics2D.setColor(this.getBackground());
                            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                            n6 = this.getWidth() - n4 >> 1;
                            n7 = this.getHeight() - n5 >> 1;
                        }
                        graphics2D.drawImage(recorder.buffer, n6, n7, n6 + n4, n7 + n5, 0, 0, n, n2, null);
                    }
                }

                @Override
                public Dimension getPreferredSize() {
                    Recorder recorder = recorder;
                    int n = jSlider.getValue();
                    return recorder == null ? super.getPreferredSize() : new Dimension(recorder.buffer.getWidth() >> n, recorder.buffer.getHeight() >> n);
                }
            };
            this.mousePrintCanvas.add(new JLabel(Language.getText("mousePrintRecorder.noDisplayableMousePrint"), 0));
            GuiUtils.makeComponentDragScrollable(this.mousePrintCanvas);
            jPanel.add((Component)new JScrollPane(this.mousePrintCanvas), "Center");
            GuiUtils.addNewTab(Language.getText("mousePrintRecorder.tab.image.title"), Icons.IMAGE, false, jTabbedPane, jPanel, null);
            Object[][] objectArray = new Object[18][];
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = Language.getText("mousePrintRecorder.tab.info.fileName");
            objectArray[0] = objectArray2;
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = Language.getText("mousePrintRecorder.tab.info.recordingLength");
            objectArray[1] = objectArray3;
            Object[] objectArray4 = new Object[2];
            objectArray4[0] = Language.getText("mousePrintRecorder.tab.info.recordingStartTime");
            objectArray[2] = objectArray4;
            Object[] objectArray5 = new Object[2];
            objectArray5[0] = Language.getText("mousePrintRecorder.tab.info.recordingEndTime");
            objectArray[3] = objectArray5;
            Object[] objectArray6 = new Object[2];
            objectArray6[0] = Language.getText("mousePrintRecorder.tab.info.imageWidth");
            objectArray[4] = objectArray6;
            Object[] objectArray7 = new Object[2];
            objectArray7[0] = Language.getText("mousePrintRecorder.tab.info.imageHeight");
            objectArray[5] = objectArray7;
            Object[] objectArray8 = new Object[2];
            objectArray8[0] = Language.getText("mousePrintRecorder.tab.info.imageResolution");
            objectArray[6] = objectArray8;
            objectArray[7] = new Object[2];
            Object[] objectArray9 = new Object[2];
            objectArray9[0] = Language.getText("mousePrintRecorder.tab.info.samplingTime");
            objectArray[8] = objectArray9;
            Object[] objectArray10 = new Object[2];
            objectArray10[0] = Language.getText("mousePrintRecorder.tab.info.totalMouseDistance");
            objectArray[9] = objectArray10;
            objectArray[10] = new Object[2];
            objectArray[11] = new Object[2];
            Object[] objectArray11 = new Object[2];
            objectArray11[0] = Language.getText("mousePrintRecorder.tab.info.averageMouseSpeed");
            objectArray[12] = objectArray11;
            objectArray[13] = new Object[2];
            objectArray[14] = new Object[2];
            Object[] objectArray12 = new Object[2];
            objectArray12[0] = Language.getText("mousePrintRecorder.tab.info.numberOfSamples");
            objectArray[15] = objectArray12;
            Object[] objectArray13 = new Object[2];
            objectArray13[0] = Language.getText("mousePrintRecorder.tab.info.uncompressedDataSize");
            objectArray[16] = objectArray13;
            Object[] objectArray14 = new Object[2];
            objectArray14[0] = Language.getText("mousePrintRecorder.tab.info.savedWithCompression");
            objectArray[17] = objectArray14;
            ((DefaultTableModel)this.infoTable.getModel()).setDataVector(objectArray, new Object[]{Language.getText("mousePrintRecorder.tab.info.property"), Language.getText("mousePrintRecorder.tab.info.value")});
            GuiUtils.addNewTab(Language.getText("mousePrintRecorder.tab.info.title"), Icons.INFORMATION_BALLOON, false, jTabbedPane, new JScrollPane(this.infoTable), null);
            this.getContentPane().add((Component)jTabbedPane, "Center");
            this.setSize(950, 730);
            GuiUtils.centerWindow(this);
            this.setVisible(true);
        }

        protected void updateControls() {
            Recorder recorder = recorder;
            boolean bl = recorder == null || recorder.isCancelRequested();
            GuiUtils.updateButtonText(this.startStopRecordingButton, bl ? "mousePrintRecorder.startRecordingButton" : "mousePrintRecorder.stopRecordingButton", new Object[0]);
            this.startStopRecordingButton.setIcon(bl ? Icons.CONTROL_RECORD : Icons.CONTROL_STOP_SQUARE);
            this.startStopRecordingButton.invalidate();
            this.saveMousePrintButton.setEnabled(recorder != null && bl);
            this.storeMousePrintButton.setEnabled(recorder != null && bl && recorder.sourceFileName != null);
            this.loadMousePrintButton.setEnabled(bl);
            if (this.mousePrintCanvas != null) {
                this.mousePrintCanvas.invalidate();
            }
            if (recorder == null) {
                this.statusLabel.setText(Language.getText("mousePrintRecorder.noRecordingInProgress"));
            } else if (recorder.saved != null) {
                this.statusLabel.setText(Language.getText(recorder.saved != false ? "mousePrintRecorder.recordingSaved" : "mousePrintRecorder.recordingSavedFailed"));
            } else if (recorder.loaded) {
                this.statusLabel.setText(Language.getText("mousePrintRecorder.recordingLoaded"));
            } else if (bl) {
                this.statusLabel.setText(Language.getText("mousePrintRecorder.recordingStopped"));
            } else {
                this.statusLabel.setText(Language.getText("mousePrintRecorder.recordingInProgress"));
            }
        }

        protected void updateMousePrint() {
            this.mousePrintCanvas.repaint();
            Recorder recorder = recorder;
            if (recorder != null && recorder.startTime != null) {
                int n = 0;
                double d = (double)((recorder.endTime == null ? new Date() : recorder.endTime).getTime() - recorder.startTime.getTime()) / 1000.0;
                this.infoTable.setValueAt(recorder.sourceFileName, n++, 1);
                this.infoTable.setValueAt(GeneralUtils.formatLongSeconds((long)d), n++, 1);
                this.infoTable.setValueAt(Language.formatDateTime(recorder.startTime), n++, 1);
                this.infoTable.setValueAt(recorder.endTime == null ? null : Language.formatDateTime(recorder.endTime), n++, 1);
                this.infoTable.setValueAt(Language.getText("mousePrintRecorder.tab.info.imageWidthValue", recorder.buffer.getWidth()), n++, 1);
                this.infoTable.setValueAt(Language.getText("mousePrintRecorder.tab.info.imageHeightValue", recorder.buffer.getHeight()), n++, 1);
                this.infoTable.setValueAt(Language.getText("mousePrintRecorder.tab.info.imageResolutionValueInch", recorder.screenResolution), n++, 1);
                this.infoTable.setValueAt(Language.getText("mousePrintRecorder.tab.info.imageResolutionValueCm", recorder.screenResolution * 100 / 254), n++, 1);
                this.infoTable.setValueAt(Language.getText("mousePrintRecorder.tab.info.samplingTimeValue", recorder.samplingTime), n++, 1);
                double d2 = recorder.screenResolution == 0 ? 0.0 : recorder.totalMouseDistance / 12.0 / (double)recorder.screenResolution;
                double d3 = recorder.screenResolution == 0 ? 0.0 : 0.0254 * recorder.totalMouseDistance / (double)recorder.screenResolution;
                this.infoTable.setValueAt(Language.getText("mousePrintRecorder.tab.info.totalMouseDistanceValuePixel", (int)recorder.totalMouseDistance), n++, 1);
                this.infoTable.setValueAt(Language.getText("mousePrintRecorder.tab.info.totalMouseDistanceValueFoot", this.formatNumber(d2)), n++, 1);
                this.infoTable.setValueAt(Language.getText("mousePrintRecorder.tab.info.totalMouseDistanceValueMeter", this.formatNumber(d3)), n++, 1);
                this.infoTable.setValueAt(Language.getText("mousePrintRecorder.tab.info.avgMouseMovementSpeedValuePixel", this.formatNumber(d == 0.0 ? 0.0 : recorder.totalMouseDistance / d)), n++, 1);
                this.infoTable.setValueAt(Language.getText("mousePrintRecorder.tab.info.avgMouseMovementSpeedValueInch", this.formatNumber(d == 0.0 ? 0.0 : d2 * 12.0 / d)), n++, 1);
                this.infoTable.setValueAt(Language.getText("mousePrintRecorder.tab.info.avgMouseMovementSpeedValueCm", this.formatNumber(d == 0.0 ? 0.0 : d3 * 100.0 / d)), n++, 1);
                this.infoTable.setValueAt(Integer.toString(recorder.samplesCount), n++, 1);
                this.infoTable.setValueAt(recorder.dataStream == null ? null : Language.getText("mousePrintRecorder.tab.info.uncompressedDataSizeValue", recorder.dataStream.size()), n++, 1);
                this.infoTable.setValueAt(recorder.savedWithCompression == null ? " " : ((Recorder)recorder).savedWithCompression.stringValue, n++, 1);
            }
        }

        private String formatNumber(double d) {
            return String.format(Locale.US, "%.2f", d);
        }
    }

    public static enum WhatToSave {
        BINARY_DATA_AND_IMAGE("miscSettings.mousePrintWhatToSave.binaryAndImage", true, true),
        BINARY_DATA_ONLY("miscSettings.mousePrintWhatToSave.binaryOnly", true, false),
        IMAGE_ONLY("miscSettings.mousePrintWhatToSave.imageOnly", false, true);

        public final String stringValue;
        public final boolean saveBinaryData;
        public final boolean saveImage;

        private WhatToSave(String string2, boolean bl, boolean bl2) {
            this.stringValue = Language.getText(string2);
            this.saveBinaryData = bl;
            this.saveImage = bl2;
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

