/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.services;

import com.sun.jna.platform.FileMonitor;
import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.sound.Sounds;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.util.ControlledThread;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.NormalThread;
import hu.belicza.andras.sc2gears.util.ObjectRegistry;
import hu.belicza.andras.sc2gears.util.TemplateEngine;
import hu.belicza.andras.sc2gearspluginapi.api.listener.NewReplayListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ReplayAutoSaver
extends ControlledThread
implements FileFilter {
    private static final ObjectRegistry<NewReplayListener> newReplayListenerRegistry = new ObjectRegistry();
    public static final boolean fileMonitorSupported = GeneralUtils.isWindows();
    private static final DateFormat DEFAULT_AUTO_REPLAY_NAME_FORMAT = new SimpleDateFormat("yy-MM-dd HH-mm-ss");
    private volatile long previousReplayDate = new Date().getTime();
    private volatile File lastReplayFromMonitor;
    private FileMonitor fileMonitor;
    private List<File> watchedFileList;
    private FileMonitor.FileListener fileListener;

    public static void addNewReplayListener(NewReplayListener newReplayListener) {
        newReplayListenerRegistry.add(newReplayListener);
    }

    public static void removeNewReplayListener(NewReplayListener newReplayListener) {
        newReplayListenerRegistry.remove(newReplayListener);
    }

    public ReplayAutoSaver() {
        super("Replay auto-saver");
    }

    @Override
    public void run() {
        if (Settings.getInt("settings.misc.newReplayDetectionMethod") == NewFileDetectionMethod.EVENT_BASED.ordinal() && fileMonitorSupported) {
            this.setupFileMonitor();
        }
        while (!this.requestedToCancel) {
            try {
                File file = null;
                if (this.fileMonitor == null) {
                    for (File file2 : GeneralUtils.getAutoRepFolderList()) {
                        file = this.getLastReplay(file2);
                        if (file == null) {
                            continue;
                        }
                        break;
                    }
                } else if (this.lastReplayFromMonitor != null) {
                    file = this.lastReplayFromMonitor;
                    this.lastReplayFromMonitor = null;
                }
                if (file != null) {
                    ReplayAutoSaver.sleep(1500L);
                    if (file.lastModified() > this.previousReplayDate) {
                        this.handleNewReplay(file);
                    }
                }
                ReplayAutoSaver.sleep(Settings.getInt("settings.misc.newRepCheckIntervalSec") * 1000);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private File getLastReplay(File file) {
        File[] fileArray = file.listFiles(this);
        if (fileArray == null) {
            return null;
        }
        int n = fileArray.length - 1;
        while (n >= 0) {
            File file2 = fileArray[n];
            if (file2.isFile()) {
                return file2;
            }
            File file3 = this.getLastReplay(file2);
            if (file3 != null) {
                return file3;
            }
            --n;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewReplay(File file) throws InterruptedException {
        this.previousReplayDate = file.lastModified();
        File file2 = new File(Settings.getString("settings.folders.replayAutoSave"));
        if (!file2.exists() && !file2.mkdirs()) {
            System.out.println("Failed to create replay auto-save folder: " + file2.getAbsolutePath());
            if (Settings.getBoolean("settings.enableVoiceNotifications")) {
                Sounds.playSoundSample("replay_save_failed", false);
            }
        }
        if (file2.exists()) {
            File file3;
            String string = null;
            try {
                string = new TemplateEngine(Settings.getString("settings.misc.repAutoSaveNameTemplate")).applyToReplay(file, file2);
            }
            catch (Exception exception) {
                System.out.println("Failed to apply auto-save name template: " + Settings.getString("settings.misc.repAutoSaveNameTemplate"));
            }
            if (string == null || string.length() == 0) {
                string = String.valueOf(DEFAULT_AUTO_REPLAY_NAME_FORMAT.format(new Date(file.lastModified()))) + ".SC2Replay";
            }
            if (!string.toLowerCase().endsWith(".sc2replay")) {
                string = String.valueOf(string) + ".SC2Replay";
            }
            File file4 = GeneralUtils.generateUniqueName(new File(file2, string));
            string = file4.getName();
            File file5 = file4.getParentFile();
            if (!file5.exists() && !file5.mkdirs()) {
                System.out.println("Creating subfolders failed, auto-save will probably fail!");
            }
            boolean bl = GeneralUtils.copyFile(file, file5, null, string);
            ObjectRegistry<NewReplayListener> objectRegistry = newReplayListenerRegistry;
            synchronized (objectRegistry) {
                for (NewReplayListener object : newReplayListenerRegistry) {
                    try {
                        object.newReplayDetected(file);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            if (bl) {
                boolean bl2 = false;
                if (Settings.getBoolean("settings.misc.deleteAutoSavedReplays")) {
                    bl2 = file.delete();
                }
                System.out.println("Successfully " + (bl2 ? "moved" : "copied") + " last replay to: " + file4.getAbsolutePath());
                if (Settings.getBoolean("settings.enableVoiceNotifications")) {
                    Sounds.playSoundSample("replay_saved", false);
                }
            } else {
                System.out.println("Failed to copy last replay to: " + file5.getAbsolutePath());
                if (Settings.getBoolean("settings.enableVoiceNotifications")) {
                    Sounds.playSoundSample("replay_save_failed", false);
                }
            }
            File file6 = file3 = bl ? file4 : file;
            if (Settings.getBoolean("settings.misc.autoStoreNewReplays")) {
                final String string2 = Settings.getString("settings.misc.authorizationKey");
                if (string2.length() == 0) {
                    System.out.println("Failed to store replay in the Sc2gears Database: no Authorization key is set: " + file3.getAbsolutePath());
                } else {
                    new NormalThread("Replay auto-storer"){

                        @Override
                        public void run() {
                            try {
                                MainFrame.registerBackgroundJob();
                                GeneralUtils.storeReplay(file3, string2);
                            }
                            finally {
                                MainFrame.removeBackgroundJob();
                            }
                        }
                    }.start();
                }
            }
            if (Settings.getBoolean("settings.misc.autoOpenNewReplays")) {
                MainFrame.INSTANCE.openReplayFile(file3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setupFileMonitor() {
        Class<ReplayAutoSaver> clazz = ReplayAutoSaver.class;
        synchronized (ReplayAutoSaver.class) {
            if (this.fileMonitor == null) {
                this.fileMonitor = FileMonitor.getInstance();
                this.watchedFileList = new ArrayList<File>(5);
            }
            try {
                for (File file : GeneralUtils.getAutoRepFolderList()) {
                    this.fileMonitor.addWatch(file, 3, true);
                    this.watchedFileList.add(file);
                }
                this.fileListener = new FileMonitor.FileListener(){

                    public void fileChanged(FileMonitor.FileEvent fileEvent) {
                        File file;
                        if (fileEvent.getType() == 1 && (file = fileEvent.getFile()).isFile() && ReplayAutoSaver.this.accept(file)) {
                            ReplayAutoSaver.this.lastReplayFromMonitor = file;
                        }
                    }
                };
                this.fileMonitor.addFileListener(this.fileListener);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            catch (IOException iOException) {
                System.out.println("Failed to setup File monitor, reverting to polling...");
                iOException.printStackTrace();
                this.shutdownFileMonitor();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void shutdownFileMonitor() {
        Class<ReplayAutoSaver> clazz = ReplayAutoSaver.class;
        synchronized (ReplayAutoSaver.class) {
            if (this.fileMonitor != null) {
                if (this.fileListener != null) {
                    this.fileMonitor.removeFileListener(this.fileListener);
                }
                this.fileListener = null;
                for (File file : this.watchedFileList) {
                    this.fileMonitor.removeWatch(file);
                }
                this.fileMonitor.dispose();
                this.fileMonitor = null;
                this.watchedFileList = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean accept(File file) {
        return file.isDirectory() || file.lastModified() > this.previousReplayDate && file.getName().toLowerCase().endsWith(".sc2replay");
    }

    @Override
    public void requestToCancel() {
        this.shutdownFileMonitor();
        super.requestToCancel();
    }

    public static enum NewFileDetectionMethod {
        POLLING("miscSettings.newFileDetectionMethod.polling"),
        EVENT_BASED("miscSettings.newFileDetectionMethod.eventBased");

        public final String stringValue;

        private NewFileDetectionMethod(String string2) {
            this.stringValue = Language.getText(string2);
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

