/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.services;

import hu.belicza.andras.sc2gears.Sc2gears;
import hu.belicza.andras.sc2gears.language.Language;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gears.sound.Sounds;
import hu.belicza.andras.sc2gears.ui.GuiUtils;
import hu.belicza.andras.sc2gears.ui.MainFrame;
import hu.belicza.andras.sc2gears.util.GeneralUtils;
import hu.belicza.andras.sc2gears.util.NormalThread;
import java.awt.Frame;
import java.io.File;
import java.net.URL;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UpdateChecker
extends NormalThread {
    private final JMenuItem checkUpdatesMenuItem;

    public UpdateChecker(JMenuItem jMenuItem) {
        super("Update checker");
        this.checkUpdatesMenuItem = jMenuItem;
        jMenuItem.setEnabled(false);
        GuiUtils.updateButtonText(jMenuItem, "menu.help.checkUpdatesChecking", new Object[0]);
        this.start();
    }

    @Override
    public void run() {
        block25: {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setIgnoringComments(true);
                Document document = documentBuilderFactory.newDocumentBuilder().parse(new URL("https://sc2gearsdb.appspot.com/hosted/latest_version.xml").toURI().toString());
                Element element = document.getDocumentElement();
                String string = ((Element)element.getElementsByTagName("latestVersion").item(0)).getTextContent();
                if (!"7.0.1".equals(string)) {
                    if (Settings.getBoolean("settings.enableVoiceNotifications")) {
                        Sounds.playSoundSample("updates_available", false);
                    }
                    String string2 = Language.getText("updatesAvailable.updateButton");
                    int n = JOptionPane.showOptionDialog(MainFrame.INSTANCE, new Object[]{Language.getText("updatesAvailable.newVersionAvailable", string), GeneralUtils.createLinkLabel(Language.getText("updatesAvailable.viewVersionHistory"), "https://sites.google.com/site/sc2gears/version-history"), " ", Language.getText("updatesAvailable.whatToDo")}, Language.getText("updatesAvailable.title"), -1, 1, null, new Object[]{string2, Language.getText("updatesAvailable.dontUpdateButton")}, string2);
                    if (n == 0) {
                        if (!Sc2gears.checkAndPerformPostUpdate()) {
                            GuiUtils.showErrorDialog(new String[]{Language.getText("updatesAvailable.updaterCannotBeStarted", "Sc2gears Updater"), Language.getText("updatesAvailable.restart", "Sc2gears")}, new Frame[0]);
                            return;
                        }
                        String string3 = ((Element)element.getElementsByTagName("archiveUrl").item(0)).getTextContent();
                        String string4 = ((Element)element.getElementsByTagName("requiredMinUpdaterVer").item(0)).getTextContent();
                        String string5 = ((Element)element.getElementsByTagName("archiveSha256").item(0)).getTextContent();
                        MainFrame.INSTANCE.exit(true, string, string4, string3, string5);
                    }
                    break block25;
                }
                Element element2 = (Element)element.getElementsByTagName("languages").item(0);
                if (element2 == null) {
                    return;
                }
                try {
                    String string6 = Settings.getString("settings.language");
                    NodeList nodeList = element2.getElementsByTagName("language");
                    int n = nodeList.getLength();
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < n) {
                        boolean bl2;
                        Element element3 = (Element)nodeList.item(n2);
                        boolean bl3 = bl2 = string6.equals(element3.getAttribute("name")) && (!Language.getLanguageFileVersion().equals(element3.getAttribute("version")) || !Language.getLanguageFileSubversion().equals(element3.getAttribute("subversion")));
                        if (!"English".equals(string6)) {
                            bl2 |= "English".equals(element3.getAttribute("name")) && (!Language.getDefaultLanguageFileVersion().equals(element3.getAttribute("version")) || !Language.getDefaultLanguageFileSubversion().equals(element3.getAttribute("subversion")));
                        }
                        if (bl2) {
                            System.out.println("A new language file is available: " + element3.getAttribute("version") + " (" + element3.getAttribute("subversion") + ") (" + element3.getAttribute("name") + ")");
                            System.out.println("Updating language file...");
                            File file = new File("Languages", String.valueOf(element3.getAttribute("name")) + ".xml.temp");
                            if (GeneralUtils.downloadUrl(String.valueOf(element2.getAttribute("baseUrl")) + element3.getAttribute("file"), file)) {
                                if (GeneralUtils.calculateFileMd5(file).equals(element3.getAttribute("md5"))) {
                                    File file2 = new File("Languages", String.valueOf(element3.getAttribute("name")) + ".xml");
                                    if (file2.delete()) {
                                        if (file.renameTo(file2)) {
                                            System.out.println("Language file updated.");
                                            bl |= true;
                                        } else {
                                            System.out.println("Failed to update the language file (failed to rename " + file.getAbsolutePath() + " to " + file2.getAbsolutePath() + ")!");
                                        }
                                    } else {
                                        System.out.println("Failed to update the language file (failed to delete " + file2.getAbsolutePath() + ")!");
                                    }
                                } else {
                                    System.out.println("Failed to update the language file (MD5 check failed)!");
                                }
                            } else {
                                System.out.println("Failed to update the language file (failed to download the new language file)!");
                            }
                        }
                        ++n2;
                    }
                    if (bl) {
                        System.out.println("Please restart Sc2gears.");
                        if (Settings.getBoolean("settings.enableVoiceNotifications")) {
                            Sounds.playSoundSample("language_updated", false);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            finally {
                GuiUtils.updateButtonText(this.checkUpdatesMenuItem, "menu.help.checkUpdates", new Object[0]);
                this.checkUpdatesMenuItem.setEnabled(true);
            }
        }
    }
}

