/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.services.plugins;

import hu.belicza.andras.sc2gears.services.plugins.GeneralServicesImpl;
import hu.belicza.andras.sc2gears.services.plugins.PluginDescriptorImpl;
import hu.belicza.andras.sc2gears.services.plugins.PluginServicesImpl;
import hu.belicza.andras.sc2gears.util.NormalThread;
import hu.belicza.andras.sc2gearspluginapi.Plugin;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

public class PluginControl
implements Comparable<PluginControl> {
    public final PluginDescriptorImpl pluginDescriptor;
    public Class<? extends Plugin> loadedMainClass;
    public PluginServicesImpl pluginServices;
    public Plugin plugin;
    public boolean isEnabled;
    public Status status = Status.NOT_STARTED;

    public PluginControl(PluginDescriptorImpl pluginDescriptorImpl) {
        this.pluginDescriptor = pluginDescriptorImpl;
    }

    public synchronized boolean startPlugin() {
        if (this.plugin != null) {
            return true;
        }
        try {
            Object object;
            if (this.loadedMainClass == null) {
                object = this.pluginDescriptor.getPluginLibs();
                URL[] uRLArray = new URL[((File[])object).length];
                int n = 0;
                while (n < ((File[])object).length) {
                    uRLArray[n] = ((File)object[n]).toURI().toURL();
                    ++n;
                }
                this.loadedMainClass = new URLClassLoader(uRLArray).loadClass(this.pluginDescriptor.getMainClass()).asSubclass(Plugin.class);
            }
            this.plugin = this.loadedMainClass.newInstance();
            object = new NormalThread("Plugin starter"){

                @Override
                public void run() {
                    try {
                        if (PluginControl.this.pluginServices == null) {
                            PluginControl.this.pluginServices = new PluginServicesImpl(PluginControl.this);
                        }
                        PluginControl.this.plugin.init(PluginControl.this.pluginDescriptor, PluginControl.this.pluginServices, GeneralServicesImpl.getInstance());
                    }
                    catch (Throwable throwable) {
                        System.out.println("Failed to start plugin \"" + PluginControl.this.pluginDescriptor.getName() + "\"!");
                        throwable.printStackTrace();
                        PluginControl.this.disposePlugin();
                        PluginControl.this.status = Status.FAILED;
                    }
                }
            };
            ((Thread)object).start();
            ((Thread)object).join();
            this.status = Status.STARTED;
        }
        catch (Throwable throwable) {
            this.status = Status.FAILED;
            System.out.println("Failed to start plugin \"" + this.pluginDescriptor.getName() + "\"!");
            throwable.printStackTrace();
        }
        return this.status == Status.STARTED;
    }

    public synchronized void disposePlugin() {
        try {
            if (this.plugin == null) {
                return;
            }
            try {
                try {
                    this.plugin.destroy();
                }
                catch (Throwable throwable) {
                    this.plugin = null;
                }
            }
            finally {
                this.plugin = null;
            }
        }
        finally {
            this.status = Status.NOT_STARTED;
        }
    }

    @Override
    public int compareTo(PluginControl pluginControl) {
        return this.pluginDescriptor.getName().compareTo(pluginControl.pluginDescriptor.getName());
    }

    public String toString() {
        return this.pluginDescriptor.getName();
    }

    public static enum Status {
        NOT_STARTED,
        STARTED,
        FAILED;

    }
}

