/*
 * Decompiled with CFR 0.152.
 */
package hu.belicza.andras.sc2gears.services.plugins;

import hu.belicza.andras.sc2gears.services.plugins.PluginControl;
import hu.belicza.andras.sc2gears.services.plugins.PluginDescriptorImpl;
import hu.belicza.andras.sc2gears.settings.Settings;
import hu.belicza.andras.sc2gearspluginapi.api.SettingsApi;
import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PluginManager {
    private static final String PLUGIN_DESCRIPTOR_NAME = "Sc2gears-plugin.xml";
    private static final Map<String, PluginControl> pluginMap = new HashMap<String, PluginControl>();

    public static void loadPlugins() {
        File file = new File("Plugins");
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (fileArray == null) {
            System.out.println("Failed to load plugins, plugins folder does not exists (" + file.getAbsolutePath() + ") !");
            return;
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            PluginDescriptorImpl pluginDescriptorImpl;
            File file2 = fileArray2[n2];
            File file3 = new File(file2, PLUGIN_DESCRIPTOR_NAME);
            if (file3.exists() && (pluginDescriptorImpl = PluginManager.loadPluginDescriptor(new File(file2, PLUGIN_DESCRIPTOR_NAME))) != null) {
                String string = pluginDescriptorImpl.getName();
                String string2 = pluginDescriptorImpl.getMainClass();
                if (string2.endsWith(".xml")) {
                    System.out.println("Plugin \"" + string + "\" cannot be loaded, main class cannot end with '.xml'!");
                } else {
                    PluginControl pluginControl = pluginMap.get(string2);
                    if (pluginControl != null) {
                        System.out.println("Plugin \"" + string + "\" cannot be loaded, main class is already associated with plugin: \"" + pluginControl.pluginDescriptor.getName() + "\"");
                    } else {
                        File[] fileArray3 = file2.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                return file.getName().endsWith(".jar");
                            }
                        });
                        if (fileArray3 == null || fileArray3.length == 0) {
                            System.out.println("Plugin \"" + string + "\" will not be loaded, no libraries (*.jar) were found in the plugin folder!");
                        } else {
                            pluginDescriptorImpl.setPluginLibs(fileArray3);
                            PluginControl pluginControl2 = new PluginControl(pluginDescriptorImpl);
                            pluginControl2.isEnabled = Settings.getEnabledPluginSet().contains(string2);
                            pluginMap.put(string2, pluginControl2);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private static PluginDescriptorImpl loadPluginDescriptor(File file) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            Element element = document.getDocumentElement();
            PluginDescriptorImpl pluginDescriptorImpl = new PluginDescriptorImpl(file);
            pluginDescriptorImpl.setName(((Element)element.getElementsByTagName("name").item(0)).getTextContent());
            pluginDescriptorImpl.setAuthorFirstName(((Element)element.getElementsByTagName("authorFirstName").item(0)).getTextContent());
            pluginDescriptorImpl.setAuthorLastName(((Element)element.getElementsByTagName("authorLastName").item(0)).getTextContent());
            pluginDescriptorImpl.setAuthorEmail(((Element)element.getElementsByTagName("authorEmail").item(0)).getTextContent());
            pluginDescriptorImpl.setVersion(((Element)element.getElementsByTagName("version").item(0)).getTextContent());
            pluginDescriptorImpl.setReleaseDate(simpleDateFormat.parse(((Element)element.getElementsByTagName("releaseDate").item(0)).getTextContent()));
            pluginDescriptorImpl.setHomePage(((Element)element.getElementsByTagName("homePage").item(0)).getTextContent());
            pluginDescriptorImpl.setApiVersion(((Element)element.getElementsByTagName("apiVersion").item(0)).getTextContent());
            Element element2 = (Element)element.getElementsByTagName("description").item(0);
            pluginDescriptorImpl.setIsHtmlDescription("true".equals(element2.getAttribute("isHtml")));
            pluginDescriptorImpl.setDescription(element2.getTextContent());
            pluginDescriptorImpl.setMainClass(((Element)element.getElementsByTagName("mainClass").item(0)).getTextContent());
            return pluginDescriptorImpl;
        }
        catch (Exception exception) {
            System.out.println("Failed to load plugin descriptor from file: " + file.getAbsolutePath());
            exception.printStackTrace();
            return null;
        }
    }

    public static void startEnabledPlugins() {
        for (PluginControl pluginControl : pluginMap.values()) {
            if (!pluginControl.isEnabled) continue;
            pluginControl.startPlugin();
        }
    }

    public static void disposePlugins() {
        for (PluginControl pluginControl : pluginMap.values()) {
            pluginControl.disposePlugin();
        }
    }

    public static void savePluginSettings() {
        for (PluginControl pluginControl : pluginMap.values()) {
            SettingsApi settingsApi;
            SettingsApi settingsApi2 = settingsApi = pluginControl.pluginServices == null ? null : pluginControl.pluginServices.getSettingsWithoutCreating();
            if (settingsApi == null) continue;
            settingsApi.saveProperties();
        }
    }

    public static Vector<PluginControl> getPluginControlVector() {
        return new Vector<PluginControl>(pluginMap.values());
    }
}

